# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessPolicyEntry(_serialization.Model):
    """An identity that have access to the key vault. All identities in the array must use the same
    tenant ID as the key vault's tenant ID.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar object_id: The object ID of a user, service principal or security group in the Azure
     Active Directory tenant for the vault. The object ID must be unique for the list of access
     policies. Required.
    :vartype object_id: str
    :ivar application_id: Application ID of the client making request on behalf of a principal.
    :vartype application_id: str
    :ivar permissions: Permissions the identity has for keys, secrets and certificates. Required.
    :vartype permissions: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Permissions
    """

    _validation = {
        "tenant_id": {"required": True},
        "object_id": {"required": True},
        "permissions": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "permissions": {"key": "permissions", "type": "Permissions"},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        object_id: str,
        permissions: "_models.Permissions",
        application_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault. Required.
        :paramtype tenant_id: str
        :keyword object_id: The object ID of a user, service principal or security group in the Azure
         Active Directory tenant for the vault. The object ID must be unique for the list of access
         policies. Required.
        :paramtype object_id: str
        :keyword application_id: Application ID of the client making request on behalf of a principal.
        :paramtype application_id: str
        :keyword permissions: Permissions the identity has for keys, secrets and certificates.
         Required.
        :paramtype permissions: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Permissions
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.application_id = application_id
        self.permissions = permissions


class CheckNameAvailabilityResult(_serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: A boolean value that indicates whether the name is available for you to
     use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that a vault name could not be used. The Reason element is only
     returned if NameAvailable is false. Known values are: "AccountNameInvalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.Reason
    :ivar message: An error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudErrorBody(_serialization.Model):
    """An error response from Key Vault resource provider.

    :ivar code: Error code. This is a mnemonic that can be consumed programmatically.
    :vartype code: str
    :ivar message: User friendly error message. The message is typically localized and may vary
     with service version.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code. This is a mnemonic that can be consumed programmatically.
        :paramtype code: str
        :keyword message: User friendly error message. The message is typically localized and may vary
         with service version.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class DeletedManagedHsm(_serialization.Model):
    """DeletedManagedHsm.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the deleted managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :ivar properties: Properties of the deleted managed HSM.
    :vartype properties:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedManagedHsmProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DeletedManagedHsmProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeletedManagedHsmProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the deleted managed HSM.
        :paramtype properties:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedManagedHsmProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class DeletedManagedHsmListResult(_serialization.Model):
    """List of deleted managed HSM Pools.

    :ivar value: The list of deleted managed HSM Pools.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedManagedHsm]
    :ivar next_link: The URL to get the next set of deleted managed HSM Pools.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedManagedHsm]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DeletedManagedHsm"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of deleted managed HSM Pools.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedManagedHsm]
        :keyword next_link: The URL to get the next set of deleted managed HSM Pools.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeletedManagedHsmProperties(_serialization.Model):
    """Properties of the deleted managed HSM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mhsm_id: The resource id of the original managed HSM.
    :vartype mhsm_id: str
    :ivar location: The location of the original managed HSM.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar purge_protection_enabled: Purge protection status of the original managed HSM.
    :vartype purge_protection_enabled: bool
    :ivar tags: Tags of the original managed HSM.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "mhsm_id": {"readonly": True},
        "location": {"readonly": True},
        "deletion_date": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "purge_protection_enabled": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "mhsm_id": {"key": "mhsmId", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "deletion_date": {"key": "deletionDate", "type": "iso-8601"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "iso-8601"},
        "purge_protection_enabled": {"key": "purgeProtectionEnabled", "type": "bool"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mhsm_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.purge_protection_enabled = None
        self.tags = None


class DeletedVault(_serialization.Model):
    """Deleted vault information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID for the deleted key vault.
    :vartype id: str
    :ivar name: The name of the key vault.
    :vartype name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedVaultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DeletedVaultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeletedVaultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedVaultProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class DeletedVaultListResult(_serialization.Model):
    """List of vaults.

    :ivar value: The list of deleted vaults.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedVault]
    :ivar next_link: The URL to get the next set of deleted vaults.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedVault]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DeletedVault"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of deleted vaults.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedVault]
        :keyword next_link: The URL to get the next set of deleted vaults.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeletedVaultProperties(_serialization.Model):
    """Properties of the deleted vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vault_id: The resource id of the original vault.
    :vartype vault_id: str
    :ivar location: The location of the original vault.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar tags: Tags of the original vault.
    :vartype tags: dict[str, str]
    :ivar purge_protection_enabled: Purge protection status of the original vault.
    :vartype purge_protection_enabled: bool
    """

    _validation = {
        "vault_id": {"readonly": True},
        "location": {"readonly": True},
        "deletion_date": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "tags": {"readonly": True},
        "purge_protection_enabled": {"readonly": True},
    }

    _attribute_map = {
        "vault_id": {"key": "vaultId", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "deletion_date": {"key": "deletionDate", "type": "iso-8601"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
        "purge_protection_enabled": {"key": "purgeProtectionEnabled", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vault_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.tags = None
        self.purge_protection_enabled = None


class DimensionProperties(_serialization.Model):
    """Type of operation: get, read, delete, etc.

    :ivar name: Name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Property to specify whether the dimension should be exported
     for Shoebox.
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        :keyword to_be_exported_for_shoebox: Property to specify whether the dimension should be
         exported for Shoebox.
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class Error(_serialization.Model):
    """The server error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The inner error, contains a more specific error code.
    :vartype inner_error: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Error
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "inner_error": {"key": "innererror", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class IPRule(_serialization.Model):
    """A rule governing the accessibility of a vault from a specific ip address or ip range.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address)
     or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, **kwargs: Any) -> None:
        """
        :keyword value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP
         address) or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class LogSpecification(_serialization.Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of specification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagedHsmResource(_serialization.Model):
    """Managed HSM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :ivar location: The supported Azure location where the managed HSM Pool should be created.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "ManagedHsmSku"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the managed HSM Pool should be created.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.sku = sku
        self.tags = tags
        self.system_data = None


class ManagedHsm(ManagedHsmResource):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :ivar location: The supported Azure location where the managed HSM Pool should be created.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :ivar properties: Properties of the managed HSM.
    :vartype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "ManagedHsmSku"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ManagedHsmProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ManagedHsmProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the managed HSM Pool should be created.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the managed HSM.
        :paramtype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmProperties
        """
        super().__init__(location=location, sku=sku, tags=tags, **kwargs)
        self.properties = properties


class ManagedHsmError(_serialization.Model):
    """The error exception.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The server error.
    :vartype error: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Error
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class ManagedHsmListResult(_serialization.Model):
    """List of managed HSM Pools.

    :ivar value: The list of managed HSM Pools.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsm]
    :ivar next_link: The URL to get the next set of managed HSM Pools.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedHsm]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ManagedHsm"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of managed HSM Pools.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsm]
        :keyword next_link: The URL to get the next set of managed HSM Pools.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedHsmProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of the managed HSM Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the managed HSM pool.
    :vartype tenant_id: str
    :ivar initial_admin_object_ids: Array of initial administrators object ids for this managed hsm
     pool.
    :vartype initial_admin_object_ids: list[str]
    :ivar hsm_uri: The URI of the managed hsm pool for performing operations on keys.
    :vartype hsm_uri: str
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and
     is immutable.
    :vartype enable_soft_delete: bool
    :ivar soft_delete_retention_in_days: Soft deleted data retention days. When you delete an HSM
     or a key, it will remain recoverable for the configured retention period or for a default
     period of 90 days. It accepts values between 7 and 90.
    :vartype soft_delete_retention_in_days: int
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this managed HSM pool. Setting this property to true activates protection against purge for
     this managed HSM pool and its content - only the Managed HSM service may initiate a hard,
     irrecoverable deletion. Enabling this functionality is irreversible.
    :vartype enable_purge_protection: bool
    :ivar create_mode: The create mode to indicate whether the resource is being created or is
     being recovered from a deleted resource. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
    :ivar status_message: Resource Status Message.
    :vartype status_message: str
    :ivar provisioning_state: Provisioning state. Known values are: "Succeeded", "Provisioning",
     "Failed", "Updating", "Deleting", "Activated", "SecurityDomainRestore", and "Restoring".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.ProvisioningState
    :ivar network_acls: Rules governing the accessibility of the key vault from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMNetworkRuleSet
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     managed hsm pool.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpointConnectionItem]
    :ivar public_network_access: Control permission to the managed HSM from public networks. Known
     values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PublicNetworkAccess
    :ivar scheduled_purge_date: The scheduled purge date in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    """

    _validation = {
        "hsm_uri": {"readonly": True},
        "status_message": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "initial_admin_object_ids": {"key": "initialAdminObjectIds", "type": "[str]"},
        "hsm_uri": {"key": "hsmUri", "type": "str"},
        "enable_soft_delete": {"key": "enableSoftDelete", "type": "bool"},
        "soft_delete_retention_in_days": {"key": "softDeleteRetentionInDays", "type": "int"},
        "enable_purge_protection": {"key": "enablePurgeProtection", "type": "bool"},
        "create_mode": {"key": "createMode", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "network_acls": {"key": "networkAcls", "type": "MHSMNetworkRuleSet"},
        "private_endpoint_connections": {
            "key": "privateEndpointConnections",
            "type": "[MHSMPrivateEndpointConnectionItem]",
        },
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        initial_admin_object_ids: Optional[List[str]] = None,
        enable_soft_delete: bool = True,
        soft_delete_retention_in_days: int = 90,
        enable_purge_protection: bool = True,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        network_acls: Optional["_models.MHSMNetworkRuleSet"] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the managed HSM pool.
        :paramtype tenant_id: str
        :keyword initial_admin_object_ids: Array of initial administrators object ids for this managed
         hsm pool.
        :paramtype initial_admin_object_ids: list[str]
        :keyword enable_soft_delete: Property to specify whether the 'soft delete' functionality is
         enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and
         is immutable.
        :paramtype enable_soft_delete: bool
        :keyword soft_delete_retention_in_days: Soft deleted data retention days. When you delete an
         HSM or a key, it will remain recoverable for the configured retention period or for a default
         period of 90 days. It accepts values between 7 and 90.
        :paramtype soft_delete_retention_in_days: int
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this managed HSM pool. Setting this property to true activates protection against
         purge for this managed HSM pool and its content - only the Managed HSM service may initiate a
         hard, irrecoverable deletion. Enabling this functionality is irreversible.
        :paramtype enable_purge_protection: bool
        :keyword create_mode: The create mode to indicate whether the resource is being created or is
         being recovered from a deleted resource. Known values are: "recover" and "default".
        :paramtype create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
        :keyword network_acls: Rules governing the accessibility of the key vault from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMNetworkRuleSet
        :keyword public_network_access: Control permission to the managed HSM from public networks.
         Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.initial_admin_object_ids = initial_admin_object_ids
        self.hsm_uri = None
        self.enable_soft_delete = enable_soft_delete
        self.soft_delete_retention_in_days = soft_delete_retention_in_days
        self.enable_purge_protection = enable_purge_protection
        self.create_mode = create_mode
        self.status_message = None
        self.provisioning_state = None
        self.network_acls = network_acls
        self.private_endpoint_connections = None
        self.public_network_access = public_network_access
        self.scheduled_purge_date = None


class ManagedHsmSku(_serialization.Model):
    """SKU details.

    All required parameters must be populated in order to send to Azure.

    :ivar family: SKU Family of the managed HSM Pool. "B"
    :vartype family: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSkuFamily
    :ivar name: SKU of the managed HSM Pool. Required. Known values are: "Standard_B1",
     "Custom_B32", and "Custom_B6".
    :vartype name: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSkuName
    """

    _validation = {
        "family": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "family": {"key": "family", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        family: Union[str, "_models.ManagedHsmSkuFamily"] = "B",
        name: Union[str, "_models.ManagedHsmSkuName"],
        **kwargs: Any
    ) -> None:
        """
        :keyword family: SKU Family of the managed HSM Pool. "B"
        :paramtype family: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSkuFamily
        :keyword name: SKU of the managed HSM Pool. Required. Known values are: "Standard_B1",
         "Custom_B32", and "Custom_B6".
        :paramtype name: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSkuName
        """
        super().__init__(**kwargs)
        self.family = family
        self.name = name


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
    :vartype unit: str
    :ivar aggregation_type: The metric aggregation type. Possible values include: 'Average',
     'Count', 'Total'.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: The supported aggregation types for the metrics.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar lock_aggregation_type: The metric lock aggregation type.
    :vartype lock_aggregation_type: str
    :ivar dimensions: The dimensions of metric.
    :vartype dimensions: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DimensionProperties]
    :ivar fill_gap_with_zero: Property to specify whether to fill gap with zero.
    :vartype fill_gap_with_zero: bool
    :ivar internal_metric_name: The internal metric name.
    :vartype internal_metric_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "lock_aggregation_type": {"key": "lockAggregationType", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[DimensionProperties]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "internal_metric_name": {"key": "internalMetricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        lock_aggregation_type: Optional[str] = None,
        dimensions: Optional[List["_models.DimensionProperties"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        internal_metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
        :paramtype unit: str
        :keyword aggregation_type: The metric aggregation type. Possible values include: 'Average',
         'Count', 'Total'.
        :paramtype aggregation_type: str
        :keyword supported_aggregation_types: The supported aggregation types for the metrics.
        :paramtype supported_aggregation_types: list[str]
        :keyword supported_time_grain_types: The supported time grain types for the metrics.
        :paramtype supported_time_grain_types: list[str]
        :keyword lock_aggregation_type: The metric lock aggregation type.
        :paramtype lock_aggregation_type: str
        :keyword dimensions: The dimensions of metric.
        :paramtype dimensions:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DimensionProperties]
        :keyword fill_gap_with_zero: Property to specify whether to fill gap with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword internal_metric_name: The internal metric name.
        :paramtype internal_metric_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.lock_aggregation_type = lock_aggregation_type
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.internal_metric_name = internal_metric_name


class MHSMIPRule(_serialization.Model):
    """A rule governing the accessibility of a managed hsm pool from a specific ip address or ip
    range.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address)
     or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, **kwargs: Any) -> None:
        """
        :keyword value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP
         address) or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class MHSMNetworkRuleSet(_serialization.Model):
    """A set of rules governing the network accessibility of a managed hsm pool.

    :ivar bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
     'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
     "None".
    :vartype bypass: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleBypassOptions
    :ivar default_action: The default action when no rule from ipRules and from virtualNetworkRules
     match. This is only used after the bypass property has been evaluated. Known values are:
     "Allow" and "Deny".
    :vartype default_action: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleAction
    :ivar ip_rules: The list of IP address rules.
    :vartype ip_rules: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMIPRule]
    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMVirtualNetworkRule]
    """

    _attribute_map = {
        "bypass": {"key": "bypass", "type": "str"},
        "default_action": {"key": "defaultAction", "type": "str"},
        "ip_rules": {"key": "ipRules", "type": "[MHSMIPRule]"},
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[MHSMVirtualNetworkRule]"},
    }

    def __init__(
        self,
        *,
        bypass: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = None,
        ip_rules: Optional[List["_models.MHSMIPRule"]] = None,
        virtual_network_rules: Optional[List["_models.MHSMVirtualNetworkRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
         'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
         "None".
        :paramtype bypass: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleBypassOptions
        :keyword default_action: The default action when no rule from ipRules and from
         virtualNetworkRules match. This is only used after the bypass property has been evaluated.
         Known values are: "Allow" and "Deny".
        :paramtype default_action: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleAction
        :keyword ip_rules: The list of IP address rules.
        :paramtype ip_rules: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMIPRule]
        :keyword virtual_network_rules: The list of virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMVirtualNetworkRule]
        """
        super().__init__(**kwargs)
        self.bypass = bypass
        self.default_action = default_action
        self.ip_rules = ip_rules
        self.virtual_network_rules = virtual_network_rules


class MHSMPrivateEndpoint(_serialization.Model):
    """Private endpoint object properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class MHSMPrivateEndpointConnection(ManagedHsmResource):  # pylint: disable=too-many-instance-attributes
    """Private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :ivar location: The supported Azure location where the managed HSM Pool should be created.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "ManagedHsmSku"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "MHSMPrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "MHSMPrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        private_endpoint: Optional["_models.MHSMPrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.MHSMPrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the managed HSM Pool should be created.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Modified whenever there is a change in the state of private endpoint connection.
        :paramtype etag: str
        :keyword private_endpoint: Properties of the private endpoint object.
        :paramtype private_endpoint:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpoint
        :keyword private_link_service_connection_state: Approval state of the private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkServiceConnectionState
        :keyword provisioning_state: Provisioning state of the private endpoint connection. Known
         values are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
        :paramtype provisioning_state: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
        """
        super().__init__(location=location, sku=sku, tags=tags, **kwargs)
        self.etag = etag
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class MHSMPrivateEndpointConnectionItem(_serialization.Model):
    """Private endpoint connection item.

    :ivar id: Id of private endpoint connection.
    :vartype id: str
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "MHSMPrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "MHSMPrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        etag: Optional[str] = None,
        private_endpoint: Optional["_models.MHSMPrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.MHSMPrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of private endpoint connection.
        :paramtype id: str
        :keyword etag: Modified whenever there is a change in the state of private endpoint connection.
        :paramtype etag: str
        :keyword private_endpoint: Properties of the private endpoint object.
        :paramtype private_endpoint:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpoint
        :keyword private_link_service_connection_state: Approval state of the private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkServiceConnectionState
        :keyword provisioning_state: Provisioning state of the private endpoint connection. Known
         values are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
        :paramtype provisioning_state: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
        """
        super().__init__(**kwargs)
        self.id = id
        self.etag = etag
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class MHSMPrivateEndpointConnectionsListResult(_serialization.Model):
    """List of private endpoint connections associated with a managed HSM Pools.

    :ivar value: The private endpoint connection associated with a managed HSM Pools.
    :vartype value:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpointConnection]
    :ivar next_link: The URL to get the next set of managed HSM Pools.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MHSMPrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.MHSMPrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The private endpoint connection associated with a managed HSM Pools.
        :paramtype value:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpointConnection]
        :keyword next_link: The URL to get the next set of managed HSM Pools.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MHSMPrivateLinkResource(ManagedHsmResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :ivar location: The supported Azure location where the managed HSM Pool should be created.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "ManagedHsmSku"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the managed HSM Pool should be created.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword required_zone_names: Required DNS zone names of the the private link resource.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(location=location, sku=sku, tags=tags, **kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class MHSMPrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MHSMPrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.MHSMPrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class MHSMPrivateLinkServiceConnectionState(_serialization.Model):
    """An object that represents the approval state of the private link connection.

    :ivar status: Indicates whether the connection has been approved, rejected or removed by the
     key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval or rejection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. "None"
    :vartype actions_required: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.ActionsRequired
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "_models.ActionsRequired"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been approved, rejected or removed by the
         key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval or rejection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer. "None"
        :paramtype actions_required: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.ActionsRequired
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class MHSMVirtualNetworkRule(_serialization.Model):
    """A rule governing the accessibility of a managed hsm pool from a specific virtual network.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Full resource id of a vnet subnet, such as
         '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
         Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class NetworkRuleSet(_serialization.Model):
    """A set of rules governing the network accessibility of a vault.

    :ivar bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
     'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
     "None".
    :vartype bypass: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleBypassOptions
    :ivar default_action: The default action when no rule from ipRules and from virtualNetworkRules
     match. This is only used after the bypass property has been evaluated. Known values are:
     "Allow" and "Deny".
    :vartype default_action: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleAction
    :ivar ip_rules: The list of IP address rules.
    :vartype ip_rules: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.IPRule]
    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.VirtualNetworkRule]
    """

    _attribute_map = {
        "bypass": {"key": "bypass", "type": "str"},
        "default_action": {"key": "defaultAction", "type": "str"},
        "ip_rules": {"key": "ipRules", "type": "[IPRule]"},
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
    }

    def __init__(
        self,
        *,
        bypass: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = None,
        ip_rules: Optional[List["_models.IPRule"]] = None,
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
         'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
         "None".
        :paramtype bypass: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleBypassOptions
        :keyword default_action: The default action when no rule from ipRules and from
         virtualNetworkRules match. This is only used after the bypass property has been evaluated.
         Known values are: "Allow" and "Deny".
        :paramtype default_action: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleAction
        :keyword ip_rules: The list of IP address rules.
        :paramtype ip_rules: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.IPRule]
        :keyword virtual_network_rules: The list of virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.VirtualNetworkRule]
        """
        super().__init__(**kwargs)
        self.bypass = bypass
        self.default_action = default_action
        self.ip_rules = ip_rules
        self.virtual_network_rules = virtual_network_rules


class Operation(_serialization.Model):
    """Key Vault REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.keyvault.v2021_04_01_preview.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar is_data_action: Property to specify whether the action is a data action.
    :vartype is_data_action: bool
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.keyvault.v2021_04_01_preview.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword is_data_action: Property to specify whether the action is a data action.
        :paramtype is_data_action: bool
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.is_data_action = is_data_action
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Key Vault.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft Key Vault.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL
    link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Operation]
    :ivar next_link: The URL to get the next set of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Operation]
        :keyword next_link: The URL to get the next set of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Permissions(_serialization.Model):
    """Permissions the identity has for keys, secrets, certificates and storage.

    :ivar keys: Permissions to keys.
    :vartype keys: list[str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.KeyPermissions]
    :ivar secrets: Permissions to secrets.
    :vartype secrets: list[str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretPermissions]
    :ivar certificates: Permissions to certificates.
    :vartype certificates: list[str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.CertificatePermissions]
    :ivar storage: Permissions to storage accounts.
    :vartype storage: list[str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.StoragePermissions]
    """

    _attribute_map = {
        "keys": {"key": "keys", "type": "[str]"},
        "secrets": {"key": "secrets", "type": "[str]"},
        "certificates": {"key": "certificates", "type": "[str]"},
        "storage": {"key": "storage", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        keys: Optional[List[Union[str, "_models.KeyPermissions"]]] = None,
        secrets: Optional[List[Union[str, "_models.SecretPermissions"]]] = None,
        certificates: Optional[List[Union[str, "_models.CertificatePermissions"]]] = None,
        storage: Optional[List[Union[str, "_models.StoragePermissions"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword keys: Permissions to keys.
        :paramtype keys: list[str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.KeyPermissions]
        :keyword secrets: Permissions to secrets.
        :paramtype secrets: list[str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretPermissions]
        :keyword certificates: Permissions to certificates.
        :paramtype certificates: list[str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.CertificatePermissions]
        :keyword storage: Permissions to storage accounts.
        :paramtype storage: list[str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.StoragePermissions]
        """
        super().__init__(**kwargs)
        self.keys = keys
        self.secrets = secrets
        self.certificates = certificates
        self.storage = storage


class PrivateEndpoint(_serialization.Model):
    """Private endpoint object properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class Resource(_serialization.Model):
    """Key Vault resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class PrivateEndpointConnection(Resource):
    """Private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword etag: Modified whenever there is a change in the state of private endpoint connection.
        :paramtype etag: str
        :keyword private_endpoint: Properties of the private endpoint object.
        :paramtype private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Approval state of the private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkServiceConnectionState
        :keyword provisioning_state: Provisioning state of the private endpoint connection. Known
         values are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
        :paramtype provisioning_state: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionItem(_serialization.Model):
    """Private endpoint connection item.

    :ivar id: Id of private endpoint connection.
    :vartype id: str
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        etag: Optional[str] = None,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of private endpoint connection.
        :paramtype id: str
        :keyword etag: Modified whenever there is a change in the state of private endpoint connection.
        :paramtype etag: str
        :keyword private_endpoint: Properties of the private endpoint object.
        :paramtype private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Approval state of the private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkServiceConnectionState
        :keyword provisioning_state: Provisioning state of the private endpoint connection. Known
         values are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
        :paramtype provisioning_state: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
        """
        super().__init__(**kwargs)
        self.id = id
        self.etag = etag
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connections.

    :ivar value: The list of private endpoint connections.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnection]
    :ivar next_link: The URL to get the next set of private endpoint connections.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of private endpoint connections.
        :paramtype value:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnection]
        :keyword next_link: The URL to get the next set of private endpoint connections.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: Required DNS zone names of the the private link resource.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """An object that represents the approval state of the private link connection.

    :ivar status: Indicates whether the connection has been approved, rejected or removed by the
     key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval or rejection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. "None"
    :vartype actions_required: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.ActionsRequired
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "_models.ActionsRequired"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been approved, rejected or removed by the
         key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval or rejection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer. "None"
        :paramtype actions_required: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.ActionsRequired
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ResourceListResult(_serialization.Model):
    """List of vault resources.

    :ivar value: The list of vault resources.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Resource]
    :ivar next_link: The URL to get the next set of vault resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Resource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Resource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of vault resources.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Resource]
        :keyword next_link: The URL to get the next set of vault resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSpecification(_serialization.Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.LogSpecification]
    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MetricSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_specifications: Log specifications of operation.
        :paramtype log_specifications:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.LogSpecification]
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class Sku(_serialization.Model):
    """SKU details.

    All required parameters must be populated in order to send to Azure.

    :ivar family: SKU family name. "A"
    :vartype family: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.SkuFamily
    :ivar name: SKU name to specify whether the key vault is a standard vault or a premium vault.
     Required. Known values are: "standard" and "premium".
    :vartype name: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.SkuName
    """

    _validation = {
        "family": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "family": {"key": "family", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, family: Union[str, "_models.SkuFamily"] = "A", name: Union[str, "_models.SkuName"], **kwargs: Any
    ) -> None:
        """
        :keyword family: SKU family name. "A"
        :paramtype family: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.SkuFamily
        :keyword name: SKU name to specify whether the key vault is a standard vault or a premium
         vault. Required. Known values are: "standard" and "premium".
        :paramtype name: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.SkuName
        """
        super().__init__(**kwargs)
        self.family = family
        self.name = name


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the key vault resource.

    :ivar created_by: The identity that created the key vault resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the key vault resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.IdentityType
    :ivar created_at: The timestamp of the key vault resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the key vault resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the key vault resource.
     Known values are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.IdentityType
    :ivar last_modified_at: The timestamp of the key vault resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the key vault resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the key vault resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.IdentityType
        :keyword created_at: The timestamp of the key vault resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the key vault resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the key vault resource.
         Known values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.IdentityType
        :keyword last_modified_at: The timestamp of the key vault resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Vault(_serialization.Model):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar system_data: System metadata for the key vault.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "VaultProperties"},
    }

    def __init__(
        self,
        *,
        properties: "_models.VaultProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Azure location of the key vault resource.
        :paramtype location: str
        :keyword tags: Tags assigned to the key vault resource.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.properties = properties


class VaultAccessPolicyParameters(_serialization.Model):
    """Parameters for updating the access policy in a vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the access policy.
    :vartype id: str
    :ivar name: The resource name of the access policy.
    :vartype name: str
    :ivar type: The resource name of the access policy.
    :vartype type: str
    :ivar location: The resource type of the access policy.
    :vartype location: str
    :ivar properties: Properties of the access policy. Required.
    :vartype properties:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultAccessPolicyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "VaultAccessPolicyProperties"},
    }

    def __init__(self, *, properties: "_models.VaultAccessPolicyProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the access policy. Required.
        :paramtype properties:
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultAccessPolicyProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class VaultAccessPolicyProperties(_serialization.Model):
    """Properties of the vault access policy.

    All required parameters must be populated in order to send to Azure.

    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. Required.
    :vartype access_policies:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
    """

    _validation = {
        "access_policies": {"required": True},
    }

    _attribute_map = {
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
    }

    def __init__(self, *, access_policies: List["_models.AccessPolicyEntry"], **kwargs: Any) -> None:
        """
        :keyword access_policies: An array of 0 to 16 identities that have access to the key vault. All
         identities in the array must use the same tenant ID as the key vault's tenant ID. Required.
        :paramtype access_policies:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
        """
        super().__init__(**kwargs)
        self.access_policies = access_policies


class VaultCheckNameAvailabilityParameters(_serialization.Model):
    """The parameters used to check the availability of the vault name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The vault name. Required.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.KeyVault/vaults. Required. Default value is
     "Microsoft.KeyVault/vaults".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.KeyVault/vaults"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The vault name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class VaultCreateOrUpdateParameters(_serialization.Model):
    """Parameters for creating or updating a vault.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The supported Azure location where the key vault should be created. Required.
    :vartype location: str
    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProperties
    """

    _validation = {
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.VaultProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the key vault should be created.
         Required.
        :paramtype location: str
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class VaultListResult(_serialization.Model):
    """List of vaults.

    :ivar value: The list of vaults.
    :vartype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Vault]
    :ivar next_link: The URL to get the next set of vaults.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Vault]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Vault"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of vaults.
        :paramtype value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Vault]
        :keyword next_link: The URL to get the next set of vaults.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VaultPatchParameters(_serialization.Model):
    """Parameters for creating or updating a vault.

    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultPatchProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultPatchProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultPatchProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultPatchProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class VaultPatchProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of the vault.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault.
    :vartype tenant_id: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Sku
    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID.
    :vartype access_policies:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. Once set to true, it cannot be reverted to false.
    :vartype enable_soft_delete: bool
    :ivar enable_rbac_authorization: Property that controls how data actions are authorized. When
     true, the key vault will use Role Based Access Control (RBAC) for authorization of data
     actions, and the access policies specified in vault properties will be  ignored. When false,
     the key vault will use the access policies specified in vault properties, and any policy stored
     on Azure Resource Manager will be ignored. If null or not specified, the value of this property
     will not change.
    :vartype enable_rbac_authorization: bool
    :ivar soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
    :vartype soft_delete_retention_in_days: int
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :vartype enable_purge_protection: bool
    :ivar network_acls: A collection of rules governing the accessibility of the vault from
     specific network locations.
    :vartype network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleSet
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
        "enabled_for_deployment": {"key": "enabledForDeployment", "type": "bool"},
        "enabled_for_disk_encryption": {"key": "enabledForDiskEncryption", "type": "bool"},
        "enabled_for_template_deployment": {"key": "enabledForTemplateDeployment", "type": "bool"},
        "enable_soft_delete": {"key": "enableSoftDelete", "type": "bool"},
        "enable_rbac_authorization": {"key": "enableRbacAuthorization", "type": "bool"},
        "soft_delete_retention_in_days": {"key": "softDeleteRetentionInDays", "type": "int"},
        "create_mode": {"key": "createMode", "type": "str"},
        "enable_purge_protection": {"key": "enablePurgeProtection", "type": "bool"},
        "network_acls": {"key": "networkAcls", "type": "NetworkRuleSet"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        access_policies: Optional[List["_models.AccessPolicyEntry"]] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        enable_rbac_authorization: Optional[bool] = None,
        soft_delete_retention_in_days: Optional[int] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault.
        :paramtype tenant_id: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Sku
        :keyword access_policies: An array of 0 to 16 identities that have access to the key vault. All
         identities in the array must use the same tenant ID as the key vault's tenant ID.
        :paramtype access_policies:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
        :keyword enabled_for_deployment: Property to specify whether Azure Virtual Machines are
         permitted to retrieve certificates stored as secrets from the key vault.
        :paramtype enabled_for_deployment: bool
        :keyword enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
         permitted to retrieve secrets from the vault and unwrap keys.
        :paramtype enabled_for_disk_encryption: bool
        :keyword enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
         permitted to retrieve secrets from the key vault.
        :paramtype enabled_for_template_deployment: bool
        :keyword enable_soft_delete: Property to specify whether the 'soft delete' functionality is
         enabled for this key vault. Once set to true, it cannot be reverted to false.
        :paramtype enable_soft_delete: bool
        :keyword enable_rbac_authorization: Property that controls how data actions are authorized.
         When true, the key vault will use Role Based Access Control (RBAC) for authorization of data
         actions, and the access policies specified in vault properties will be  ignored. When false,
         the key vault will use the access policies specified in vault properties, and any policy stored
         on Azure Resource Manager will be ignored. If null or not specified, the value of this property
         will not change.
        :paramtype enable_rbac_authorization: bool
        :keyword soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and
         <=90.
        :paramtype soft_delete_retention_in_days: int
        :keyword create_mode: The vault's create mode to indicate whether the vault need to be
         recovered or not. Known values are: "recover" and "default".
        :paramtype create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this vault. Setting this property to true activates protection against purge for
         this vault and its content - only the Key Vault service may initiate a hard, irrecoverable
         deletion. The setting is effective only if soft delete is also enabled. Enabling this
         functionality is irreversible - that is, the property does not accept false as its value.
        :paramtype enable_purge_protection: bool
        :keyword network_acls: A collection of rules governing the accessibility of the vault from
         specific network locations.
        :paramtype network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleSet
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.enable_rbac_authorization = enable_rbac_authorization
        self.soft_delete_retention_in_days = soft_delete_retention_in_days
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls


class VaultProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of the vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar sku: SKU details. Required.
    :vartype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Sku
    :ivar access_policies: An array of 0 to 1024 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. When
     ``createMode`` is set to ``recover``\ , access policies are not required. Otherwise, access
     policies are required.
    :vartype access_policies:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
    :ivar vault_uri: The URI of the vault for performing operations on keys and secrets.
    :vartype vault_uri: str
    :ivar hsm_pool_resource_id: The resource id of HSM Pool.
    :vartype hsm_pool_resource_id: str
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. If it's not set to any value(true or false) when creating new key
     vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
    :vartype enable_soft_delete: bool
    :ivar soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
    :vartype soft_delete_retention_in_days: int
    :ivar enable_rbac_authorization: Property that controls how data actions are authorized. When
     true, the key vault will use Role Based Access Control (RBAC) for authorization of data
     actions, and the access policies specified in vault properties will be  ignored. When false,
     the key vault will use the access policies specified in vault properties, and any policy stored
     on Azure Resource Manager will be ignored. If null or not specified, the vault is created with
     the default value of false. Note that management actions are always authorized with RBAC.
    :vartype enable_rbac_authorization: bool
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :vartype enable_purge_protection: bool
    :ivar network_acls: Rules governing the accessibility of the key vault from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleSet
    :ivar provisioning_state: Provisioning state of the vault. Known values are: "Succeeded" and
     "RegisteringDns".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProvisioningState
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     key vault.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionItem]
    """

    _validation = {
        "tenant_id": {"required": True},
        "sku": {"required": True},
        "hsm_pool_resource_id": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
        "vault_uri": {"key": "vaultUri", "type": "str"},
        "hsm_pool_resource_id": {"key": "hsmPoolResourceId", "type": "str"},
        "enabled_for_deployment": {"key": "enabledForDeployment", "type": "bool"},
        "enabled_for_disk_encryption": {"key": "enabledForDiskEncryption", "type": "bool"},
        "enabled_for_template_deployment": {"key": "enabledForTemplateDeployment", "type": "bool"},
        "enable_soft_delete": {"key": "enableSoftDelete", "type": "bool"},
        "soft_delete_retention_in_days": {"key": "softDeleteRetentionInDays", "type": "int"},
        "enable_rbac_authorization": {"key": "enableRbacAuthorization", "type": "bool"},
        "create_mode": {"key": "createMode", "type": "str"},
        "enable_purge_protection": {"key": "enablePurgeProtection", "type": "bool"},
        "network_acls": {"key": "networkAcls", "type": "NetworkRuleSet"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_endpoint_connections": {
            "key": "privateEndpointConnections",
            "type": "[PrivateEndpointConnectionItem]",
        },
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        sku: "_models.Sku",
        access_policies: Optional[List["_models.AccessPolicyEntry"]] = None,
        vault_uri: Optional[str] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: bool = True,
        soft_delete_retention_in_days: int = 90,
        enable_rbac_authorization: bool = False,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        provisioning_state: Optional[Union[str, "_models.VaultProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault. Required.
        :paramtype tenant_id: str
        :keyword sku: SKU details. Required.
        :paramtype sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Sku
        :keyword access_policies: An array of 0 to 1024 identities that have access to the key vault.
         All identities in the array must use the same tenant ID as the key vault's tenant ID. When
         ``createMode`` is set to ``recover``\ , access policies are not required. Otherwise, access
         policies are required.
        :paramtype access_policies:
         list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
        :keyword vault_uri: The URI of the vault for performing operations on keys and secrets.
        :paramtype vault_uri: str
        :keyword enabled_for_deployment: Property to specify whether Azure Virtual Machines are
         permitted to retrieve certificates stored as secrets from the key vault.
        :paramtype enabled_for_deployment: bool
        :keyword enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
         permitted to retrieve secrets from the vault and unwrap keys.
        :paramtype enabled_for_disk_encryption: bool
        :keyword enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
         permitted to retrieve secrets from the key vault.
        :paramtype enabled_for_template_deployment: bool
        :keyword enable_soft_delete: Property to specify whether the 'soft delete' functionality is
         enabled for this key vault. If it's not set to any value(true or false) when creating new key
         vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
        :paramtype enable_soft_delete: bool
        :keyword soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and
         <=90.
        :paramtype soft_delete_retention_in_days: int
        :keyword enable_rbac_authorization: Property that controls how data actions are authorized.
         When true, the key vault will use Role Based Access Control (RBAC) for authorization of data
         actions, and the access policies specified in vault properties will be  ignored. When false,
         the key vault will use the access policies specified in vault properties, and any policy stored
         on Azure Resource Manager will be ignored. If null or not specified, the vault is created with
         the default value of false. Note that management actions are always authorized with RBAC.
        :paramtype enable_rbac_authorization: bool
        :keyword create_mode: The vault's create mode to indicate whether the vault need to be
         recovered or not. Known values are: "recover" and "default".
        :paramtype create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this vault. Setting this property to true activates protection against purge for
         this vault and its content - only the Key Vault service may initiate a hard, irrecoverable
         deletion. The setting is effective only if soft delete is also enabled. Enabling this
         functionality is irreversible - that is, the property does not accept false as its value.
        :paramtype enable_purge_protection: bool
        :keyword network_acls: Rules governing the accessibility of the key vault from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleSet
        :keyword provisioning_state: Provisioning state of the vault. Known values are: "Succeeded" and
         "RegisteringDns".
        :paramtype provisioning_state: str or
         ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProvisioningState
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.vault_uri = vault_uri
        self.hsm_pool_resource_id = None
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.soft_delete_retention_in_days = soft_delete_retention_in_days
        self.enable_rbac_authorization = enable_rbac_authorization
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls
        self.provisioning_state = provisioning_state
        self.private_endpoint_connections = None


class VirtualNetworkRule(_serialization.Model):
    """A rule governing the accessibility of a vault from a specific virtual network.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required.
    :vartype id: str
    :ivar ignore_missing_vnet_service_endpoint: Property to specify whether NRP will ignore the
     check if parent subnet has serviceEndpoints configured.
    :vartype ignore_missing_vnet_service_endpoint: bool
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ignore_missing_vnet_service_endpoint": {"key": "ignoreMissingVnetServiceEndpoint", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Full resource id of a vnet subnet, such as
         '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
         Required.
        :paramtype id: str
        :keyword ignore_missing_vnet_service_endpoint: Property to specify whether NRP will ignore the
         check if parent subnet has serviceEndpoints configured.
        :paramtype ignore_missing_vnet_service_endpoint: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint
