/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GrailsNameUtils {
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";

    private GrailsNameUtils() {
    }

    public static String getSetterName(String propertyName) {
        String suffix = GrailsNameUtils.getSuffixForGetterOrSetter(propertyName);
        return PROPERTY_SET_PREFIX + suffix;
    }

    public static String getGetterName(String propertyName) {
        String suffix = GrailsNameUtils.getSuffixForGetterOrSetter(propertyName);
        return PROPERTY_GET_PREFIX + suffix;
    }

    private static String getSuffixForGetterOrSetter(String propertyName) {
        Object suffix = propertyName.length() > 1 && Character.isLowerCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1)) ? propertyName : Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        return suffix;
    }

    public static String getClassName(String logicalName, String trailingName) {
        if (GrailsNameUtils.isBlank(logicalName)) {
            throw new IllegalArgumentException("Argument [logicalName] cannot be null or blank");
        }
        String className = logicalName.substring(0, 1).toUpperCase(Locale.ENGLISH) + logicalName.substring(1);
        if (trailingName != null) {
            className = className + trailingName;
        }
        return className;
    }

    public static String getFullClassName(Class cls) {
        String className = cls.getName();
        return GrailsNameUtils.getFullClassName(className);
    }

    public static String getFullClassName(String className) {
        int i = className.indexOf(36);
        if (i > -1) {
            className = className.substring(0, i);
        }
        return className;
    }

    public static String getClassName(String logicalName) {
        return GrailsNameUtils.getClassName(logicalName, "");
    }

    public static String getClassNameRepresentation(String name) {
        String[] tokens;
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String token1 : tokens = name.split("[^\\w\\d]")) {
            String token = token1.trim();
            int length = token.length();
            if (length <= 0) continue;
            buf.append(token.substring(0, 1).toUpperCase(Locale.ENGLISH));
            if (length <= 1) continue;
            buf.append(token.substring(1));
        }
        return buf.toString();
    }

    private static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        String[] tokens;
        if (GrailsNameUtils.isBlank(name)) {
            return name;
        }
        if (name.indexOf(45) == -1) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        StringBuilder buf = new StringBuilder();
        for (String token : tokens = name.split("-")) {
            if (token == null || token.length() == 0) continue;
            buf.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
        }
        return buf.toString();
    }

    public static String getLogicalName(Class<?> clazz, String trailingName) {
        return GrailsNameUtils.getLogicalName(clazz.getName(), trailingName);
    }

    public static String getLogicalName(String name, String trailingName) {
        if (GrailsNameUtils.isBlank(trailingName)) {
            return name;
        }
        String shortName = GrailsNameUtils.getShortName(name);
        if (shortName.indexOf(trailingName) == -1) {
            return name;
        }
        return shortName.substring(0, shortName.length() - trailingName.length());
    }

    public static String getLogicalPropertyName(String className, String trailingName) {
        if (!GrailsNameUtils.isBlank(className) && !GrailsNameUtils.isBlank(trailingName) && className.length() == trailingName.length() + 1 && className.endsWith(trailingName)) {
            return className.substring(0, 1).toLowerCase();
        }
        return GrailsNameUtils.getLogicalName(GrailsNameUtils.getPropertyName(className), trailingName);
    }

    public static String getPropertyName(String name) {
        return GrailsNameUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class<?> clazz) {
        return GrailsNameUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyNameRepresentation(Class<?> targetClass) {
        return GrailsNameUtils.getPropertyNameRepresentation(GrailsNameUtils.getShortName(targetClass));
    }

    public static String getPropertyNameRepresentation(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        if (name.isEmpty()) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        Object propertyName = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        if (((String)propertyName).indexOf(32) > -1) {
            propertyName = ((String)propertyName).replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String name) {
        return GrailsNameUtils.getPropertyName(GrailsNameUtils.getClassNameForLowerCaseHyphenSeparatedName(name));
    }

    public static String getShortName(Class<?> targetClass) {
        return GrailsNameUtils.getShortName(targetClass.getName());
    }

    public static String getShortName(String className) {
        int i = className.lastIndexOf(".");
        if (i > -1) {
            className = className.substring(i + 1, className.length());
        }
        return className;
    }

    public static String getPackageName(String className) {
        int i = className.lastIndexOf(".");
        String packageName = "";
        if (i > -1) {
            packageName = className.substring(0, i);
        }
        return packageName;
    }

    public static String getScriptName(Class<?> clazz) {
        return clazz == null ? null : GrailsNameUtils.getScriptName(clazz.getName());
    }

    public static String getScriptName(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(".groovy")) {
            name = name.substring(0, name.length() - 7);
        }
        return GrailsNameUtils.getNaturalName(name).replaceAll("\\s", "-").toLowerCase();
    }

    public static String getNameFromScript(String scriptName) {
        return GrailsNameUtils.getClassNameForLowerCaseHyphenSeparatedName(scriptName);
    }

    public static String getPluginName(String descriptorName) {
        if (descriptorName == null || descriptorName.length() == 0) {
            return descriptorName;
        }
        if (!descriptorName.endsWith("GrailsPlugin.groovy")) {
            throw new IllegalArgumentException("Plugin descriptor name is not valid: " + descriptorName);
        }
        return GrailsNameUtils.getScriptName(descriptorName.substring(0, descriptorName.indexOf("GrailsPlugin.groovy")));
    }

    public static String getNaturalName(String name) {
        name = GrailsNameUtils.getShortName(name);
        ArrayList<Object> words = new ArrayList<Object>();
        int i = 0;
        char[] chars = name.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            String w;
            char c = chars[j];
            if (i >= words.size()) {
                w = "";
                words.add(i, w);
            } else {
                w = (String)words.get(i);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    c = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    w = "";
                    words.add(++i, w);
                }
                words.set(i, w + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1)) && Character.isUpperCase(chars[j - 1])) {
                words.set(i, w + c);
                continue;
            }
            words.add(++i, String.valueOf(c));
        }
        StringBuilder buf = new StringBuilder();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            String word = (String)j.next();
            buf.append(word);
            if (!j.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String getPropertyNameConvention(Object object) {
        String suffix = "";
        return GrailsNameUtils.getPropertyNameConvention(object, suffix);
    }

    public static boolean isValidJavaPackage(String packageName) {
        String[] parts;
        if (GrailsNameUtils.isBlank(packageName)) {
            return false;
        }
        for (String part : parts = packageName.split("\\.")) {
            if (GrailsNameUtils.isValidJavaIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String name) {
        if (GrailsNameUtils.isBlank(name)) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (char c : chars) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static String getPropertyNameConvention(Object object, String suffix) {
        if (object != null) {
            Class<?> type = object.getClass();
            if (type.isArray()) {
                return GrailsNameUtils.getPropertyName(type.getComponentType()) + suffix + "Array";
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                if (coll.isEmpty()) {
                    return "emptyCollection";
                }
                Object first = coll.iterator().next();
                if (coll instanceof List) {
                    return GrailsNameUtils.getPropertyName(first.getClass()) + suffix + "List";
                }
                if (coll instanceof Set) {
                    return GrailsNameUtils.getPropertyName(first.getClass()) + suffix + "Set";
                }
                return GrailsNameUtils.getPropertyName(first.getClass()) + suffix + "Collection";
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return "emptyMap";
                }
                Object entry = map.values().iterator().next();
                if (entry != null) {
                    return GrailsNameUtils.getPropertyName(entry.getClass()) + suffix + "Map";
                }
            } else {
                return GrailsNameUtils.getPropertyName(object.getClass()) + suffix;
            }
        }
        return null;
    }

    public static String getPropertyForGetter(String getterName) {
        return GrailsNameUtils.getPropertyForGetter(getterName, Boolean.TYPE);
    }

    public static String getPropertyForGetter(String getterName, Class returnType) {
        return GrailsNameUtils.getPropertyForGetter(getterName, returnType.getName());
    }

    public static String getPropertyForGetter(String getterName, String returnType) {
        if (getterName == null || getterName.length() == 0) {
            return null;
        }
        if (getterName.startsWith(PROPERTY_GET_PREFIX)) {
            String prop = getterName.substring(3);
            return GrailsNameUtils.convertValidPropertyMethodSuffix(prop);
        }
        if (getterName.startsWith("is") && returnType.equals("boolean")) {
            String prop = getterName.substring(2);
            return GrailsNameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return null;
    }

    static String convertValidPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return null;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0)) ? suffix.toLowerCase() : null;
        }
        if (Character.isUpperCase(suffix.charAt(1))) {
            return suffix;
        }
        if (Character.isUpperCase(suffix.charAt(0))) {
            return Character.toLowerCase(suffix.charAt(0)) + suffix.substring(1);
        }
        if ('_' == suffix.charAt(0)) {
            return suffix;
        }
        return null;
    }

    @Deprecated
    public static boolean isGetter(String name, Class<?>[] args) {
        return GrailsNameUtils.isGetter(name, Boolean.TYPE, args);
    }

    public static boolean isGetter(String name, Class returnType, Class<?>[] args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith(PROPERTY_GET_PREFIX) ? GrailsNameUtils.isPropertyMethodSuffix(name = name.substring(3)) : name.startsWith("is") && returnType == Boolean.TYPE && GrailsNameUtils.isPropertyMethodSuffix(name = name.substring(2));
    }

    protected static boolean isPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return false;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0));
        }
        return Character.isUpperCase(suffix.charAt(0)) || Character.isUpperCase(suffix.charAt(1));
    }

    public static String getPropertyForSetter(String setterName) {
        if (setterName == null || setterName.length() == 0) {
            return null;
        }
        if (setterName.startsWith(PROPERTY_SET_PREFIX)) {
            String prop = setterName.substring(3);
            return GrailsNameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return null;
    }
}

