/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Stroke;

public class StyleRange {
    public static final int STYLE_STRIKE_THROUGH = 1;
    public static final int STYLE_DOUBLE_STRIKE_THROUGH = 2;
    public static final int STYLE_WAVED = 4;
    public static final int STYLE_UNDERLINED = 8;
    public static final int STYLE_DOTTED = 16;
    public static final int STYLE_SUPERSCRIPT = 32;
    public static final int STYLE_SUBSCRIPT = 64;
    private final int _fontStyle;
    private final Color _fontColor;
    private final Color _backgroundColor;
    private final Color _lineColor;
    private final Stroke _lineStroke;
    private final int _additionalStyle;
    private int _start;
    private int _length;
    private float _fontShrinkRatio = 1.5f;

    public StyleRange(int fontStyle) {
        this(0, -1, fontStyle, null, 0, null, null);
    }

    public StyleRange(Color fontColor) {
        this(0, -1, -1, fontColor, 0, null, null);
    }

    public StyleRange(int fontStyle, Color fontColor) {
        this(0, -1, fontStyle, fontColor, 0, null, null);
    }

    public StyleRange(int fontStyle, int additionalStyle) {
        this(0, -1, fontStyle, null, additionalStyle, null, null);
    }

    public StyleRange(int fontStyle, int additionalStyle, float fontShrinkRatio) {
        this(0, -1, fontStyle, null, additionalStyle, null, null, fontShrinkRatio);
    }

    public StyleRange(int start, int length, int fontStyle) {
        this(start, length, fontStyle, null, 0, null, null);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor) {
        this(start, length, fontStyle, fontColor, 0, null, null);
    }

    public StyleRange(int start, int length, Color fontColor) {
        this(start, length, 0, fontColor, 0, null, null);
    }

    public StyleRange(int start, int length, int fontStyle, int additionalStyle) {
        this(start, length, fontStyle, null, additionalStyle, null, null);
    }

    public StyleRange(int start, int length, int fontStyle, int additionalStyle, float fontShrinkRatio) {
        this(start, length, fontStyle, null, additionalStyle, null, null, fontShrinkRatio);
    }

    public StyleRange(int fontStyle, Color fontColor, int additionalStyle, Color lineColor) {
        this(0, -1, fontStyle, fontColor, additionalStyle, lineColor, null);
    }

    public StyleRange(int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor) {
        this(0, -1, fontStyle, fontColor, backgroundColor, additionalStyle, lineColor, null);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, int additionalStyle) {
        this(start, length, fontStyle, fontColor, additionalStyle, null, null);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle) {
        this(start, length, fontStyle, fontColor, backgroundColor, additionalStyle, null, null);
    }

    public StyleRange(int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke) {
        this(0, -1, fontStyle, fontColor, additionalStyle, lineColor, lineStroke);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, int additionalStyle, Color lineColor) {
        this(start, length, fontStyle, fontColor, additionalStyle, lineColor, null);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor) {
        this(start, length, fontStyle, fontColor, backgroundColor, additionalStyle, lineColor, null);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke) {
        this(start, length, fontStyle, fontColor, additionalStyle, lineColor, lineStroke, 1.5f);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor, Stroke lineStroke) {
        this(start, length, fontStyle, fontColor, backgroundColor, additionalStyle, lineColor, lineStroke, 1.5f);
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke, float fontShrinkRatio) {
        this(start, length, fontStyle, fontColor, null, additionalStyle, lineColor, lineStroke, fontShrinkRatio);
    }

    public StyleRange(StyleRange range) {
        this(range.getStart(), range.getLength(), range.getFontStyle(), range.getFontColor(), range.getBackgroundColor(), range.getAdditionalStyle(), range.getLineColor(), range.getLineStroke(), range.getFontShrinkRatio());
    }

    public StyleRange(int start, int length, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor, Stroke lineStroke, float fontShrinkRatio) {
        if (length == 0) {
            throw new IllegalArgumentException("The length of StyleRange cannot be 0.");
        }
        this._start = start;
        this._length = length;
        this._fontColor = fontColor;
        this._fontStyle = fontStyle;
        this._backgroundColor = backgroundColor;
        this._lineColor = lineColor;
        this._lineStroke = lineStroke;
        this._additionalStyle = additionalStyle;
        this._fontShrinkRatio = fontShrinkRatio;
    }

    public int getStart() {
        return this._start;
    }

    public void setStart(int start) {
        this._start = start;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    public Color getFontColor() {
        return this._fontColor;
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public int getAdditionalStyle() {
        return this._additionalStyle;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public Stroke getLineStroke() {
        return this._lineStroke;
    }

    public boolean isStrikethrough() {
        return (this._additionalStyle & 1) != 0;
    }

    public boolean isDoublestrikethrough() {
        return (this._additionalStyle & 2) != 0;
    }

    public boolean isWaved() {
        return (this._additionalStyle & 4) != 0;
    }

    public boolean isUnderlined() {
        return (this._additionalStyle & 8) != 0;
    }

    public boolean isDotted() {
        return (this._additionalStyle & 0x10) != 0;
    }

    public boolean isSuperscript() {
        return (this._additionalStyle & 0x20) != 0;
    }

    public boolean isSubscript() {
        return (this._additionalStyle & 0x40) != 0;
    }

    public float getFontShrinkRatio() {
        return this._fontShrinkRatio;
    }
}

