/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.UpgradeIndexMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.CommandLineUtil;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.Version;

public final class IndexUpgrader {
    private static final String LOG_PREFIX = "IndexUpgrader";
    private final Directory dir;
    private final IndexWriterConfig iwc;
    private final boolean deletePriorCommits;

    @SuppressForbidden(reason="System.out required: command line tool")
    private static void printUsage() {
        System.err.println("Upgrades an index so all segments created with a previous Lucene version are rewritten.");
        System.err.println("Usage:");
        System.err.println("  java " + IndexUpgrader.class.getName() + " [-delete-prior-commits] [-verbose] [-dir-impl X] indexDir");
        System.err.println("This tool keeps only the last commit in an index; for this");
        System.err.println("reason, if the incoming index has more than one commit, the tool");
        System.err.println("refuses to run by default. Specify -delete-prior-commits to override");
        System.err.println("this, allowing the tool to delete all but the last commit.");
        System.err.println("Specify a " + FSDirectory.class.getSimpleName() + " implementation through the -dir-impl option to force its use. If no package is specified the " + FSDirectory.class.getPackage().getName() + " package will be used.");
        System.err.println("WARNING: This tool may reorder document IDs!");
        System.exit(1);
    }

    public static void main(String[] args2) throws IOException {
        IndexUpgrader.parseArgs(args2).upgrade();
    }

    @SuppressForbidden(reason="System.out required: command line tool")
    static IndexUpgrader parseArgs(String[] args2) throws IOException {
        String path = null;
        boolean deletePriorCommits = false;
        PrintStreamInfoStream out = null;
        String dirImpl = null;
        for (int i = 0; i < args2.length; ++i) {
            String arg = args2[i];
            if ("-delete-prior-commits".equals(arg)) {
                deletePriorCommits = true;
                continue;
            }
            if ("-verbose".equals(arg)) {
                out = new PrintStreamInfoStream(System.out);
                continue;
            }
            if ("-dir-impl".equals(arg)) {
                if (i == args2.length - 1) {
                    System.out.println("ERROR: missing value for -dir-impl option");
                    System.exit(1);
                }
                dirImpl = args2[++i];
                continue;
            }
            if (path == null) {
                path = arg;
                continue;
            }
            IndexUpgrader.printUsage();
        }
        if (path == null) {
            IndexUpgrader.printUsage();
        }
        Path p = Paths.get(path, new String[0]);
        FSDirectory dir = null;
        dir = dirImpl == null ? FSDirectory.open(p) : CommandLineUtil.newFSDirectory(dirImpl, p);
        return new IndexUpgrader((Directory)dir, out, deletePriorCommits);
    }

    public IndexUpgrader(Directory dir) {
        this(dir, new IndexWriterConfig(null), false);
    }

    public IndexUpgrader(Directory dir, InfoStream infoStream, boolean deletePriorCommits) {
        this(dir, new IndexWriterConfig(null), deletePriorCommits);
        if (null != infoStream) {
            this.iwc.setInfoStream(infoStream);
        }
    }

    public IndexUpgrader(Directory dir, IndexWriterConfig iwc, boolean deletePriorCommits) {
        this.dir = dir;
        this.iwc = iwc;
        this.deletePriorCommits = deletePriorCommits;
    }

    public void upgrade() throws IOException {
        List<IndexCommit> commits;
        if (!DirectoryReader.indexExists(this.dir)) {
            throw new IndexNotFoundException(this.dir.toString());
        }
        if (!this.deletePriorCommits && (commits = DirectoryReader.listCommits(this.dir)).size() > 1) {
            throw new IllegalArgumentException("This tool was invoked to not delete prior commit points, but the following commits were found: " + commits);
        }
        this.iwc.setMergePolicy(new UpgradeIndexMergePolicy(this.iwc.getMergePolicy()));
        this.iwc.setIndexDeletionPolicy(new KeepOnlyLastCommitDeletionPolicy());
        try (IndexWriter w = new IndexWriter(this.dir, this.iwc);){
            InfoStream infoStream = this.iwc.getInfoStream();
            if (infoStream.isEnabled(LOG_PREFIX)) {
                infoStream.message(LOG_PREFIX, "Upgrading all pre-" + Version.LATEST + " segments of index directory '" + this.dir + "' to version " + Version.LATEST + "...");
            }
            w.forceMerge(1);
            if (infoStream.isEnabled(LOG_PREFIX)) {
                infoStream.message(LOG_PREFIX, "All segments upgraded to version " + Version.LATEST);
                infoStream.message(LOG_PREFIX, "Enforcing commit to rewrite all index metadata...");
            }
            w.setLiveCommitData(w.getLiveCommitData());
            assert (w.hasUncommittedChanges());
            w.commit();
            if (infoStream.isEnabled(LOG_PREFIX)) {
                infoStream.message(LOG_PREFIX, "Committed upgraded metadata to index.");
            }
        }
    }
}

