/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.os;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.performanceanalyzer.commons.metrics_generator.SchedMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.metrics_generator.linux.LinuxSchedMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.os.OSGlobals;
import org.opensearch.performanceanalyzer.commons.os.SchemaFileParser;

public final class ThreadSched {
    private static final Logger LOGGER = LogManager.getLogger(ThreadSched.class);
    public static final ThreadSched INSTANCE = new ThreadSched();
    private String pid = null;
    private List<String> tids = null;
    private Map<String, Map<String, Object>> tidKVMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> oldtidKVMap = new HashMap<String, Map<String, Object>>();
    private long kvTimestamp = 0L;
    private long oldkvTimestamp = 0L;
    private LinuxSchedMetricsGenerator schedLatencyMap = new LinuxSchedMetricsGenerator();
    private static String[] schedKeys = new String[]{"runticks", "waitticks", "totctxsws"};
    private static SchemaFileParser.FieldTypes[] schedTypes = new SchemaFileParser.FieldTypes[]{SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG, SchemaFileParser.FieldTypes.ULONG};

    private ThreadSched() {
        try {
            this.pid = OSGlobals.getPid();
            this.tids = OSGlobals.getTids();
        }
        catch (Exception e) {
            LOGGER.error(() -> new ParameterizedMessage("Error In Initializing ThreadCPU: {}", (Object)e.toString()), (Throwable)e);
        }
    }

    public synchronized void addSample() {
        this.tids = OSGlobals.getTids();
        this.oldtidKVMap.clear();
        this.oldtidKVMap.putAll(this.tidKVMap);
        this.tidKVMap.clear();
        this.oldkvTimestamp = this.kvTimestamp;
        this.kvTimestamp = System.currentTimeMillis();
        for (String tid : this.tids) {
            Map<String, Object> sample = new SchemaFileParser("/proc/" + this.pid + "/task/" + tid + "/schedstat", schedKeys, schedTypes).parse();
            this.tidKVMap.put(tid, sample);
        }
        this.calculateSchedLatency();
    }

    private void calculateSchedLatency() {
        if (this.oldkvTimestamp == this.kvTimestamp) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.tidKVMap.entrySet()) {
            Map<String, Object> v = entry.getValue();
            Map<String, Object> oldv = this.oldtidKVMap.get(entry.getKey());
            if (v == null || oldv == null || !v.containsKey("totctxsws") || !oldv.containsKey("totctxsws")) continue;
            long ctxdiff = (Long)v.getOrDefault("totctxsws", 0L) - (Long)oldv.getOrDefault("totctxsws", 0L);
            double avgRuntime = 1.0E-9 * (double)((Long)v.getOrDefault("runticks", 0L) - (Long)oldv.getOrDefault("runticks", 0L));
            double avgWaittime = 1.0E-9 * (double)((Long)v.getOrDefault("waitticks", 0L) - (Long)oldv.getOrDefault("waitticks", 0L));
            if (ctxdiff == 0L) {
                avgRuntime = 0.0;
                avgWaittime = 0.0;
            } else {
                avgRuntime /= 1.0 * (double)ctxdiff;
                avgWaittime /= 1.0 * (double)ctxdiff;
            }
            double contextSwitchRate = ctxdiff;
            this.schedLatencyMap.setSchedMetric(entry.getKey(), new SchedMetrics(avgRuntime, avgWaittime, contextSwitchRate /= 0.001 * (double)(this.kvTimestamp - this.oldkvTimestamp)));
        }
    }

    public synchronized SchedMetricsGenerator getSchedLatency() {
        return this.schedLatencyMap;
    }

    @VisibleForTesting
    public Map<String, Map<String, Object>> getTidKVMap() {
        return this.tidKVMap;
    }

    public static class SchedMetrics {
        public final double avgRuntime;
        public final double avgWaittime;
        public final double contextSwitchRate;

        SchedMetrics(double avgRuntime, double avgWaittime, double contextSwitchRate) {
            this.avgRuntime = avgRuntime;
            this.avgWaittime = avgWaittime;
            this.contextSwitchRate = contextSwitchRate;
        }

        public int hashCode() {
            return Objects.hash(this.avgRuntime, this.avgWaittime, this.contextSwitchRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchedMetrics other = (SchedMetrics)o;
            return Double.compare(this.avgRuntime, other.avgRuntime) == 0 && Double.compare(this.avgWaittime, other.avgWaittime) == 0 && Double.compare(this.contextSwitchRate, other.contextSwitchRate) == 0;
        }

        public String toString() {
            return "avgruntime: " + this.avgRuntime + " avgwaittime: " + this.avgWaittime + " ctxrate: " + this.contextSwitchRate;
        }
    }
}

