/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParsingException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class JakartaJsonProvider
extends AbstractJsonProvider {
    private static final JsonProvider defaultJsonProvider = JsonProvider.provider();
    private static final JsonBuilderFactory jsonBuilderFactory = defaultJsonProvider.createBuilderFactory(null);
    private final boolean mutableJson;

    public JakartaJsonProvider() {
        this.mutableJson = false;
    }

    public JakartaJsonProvider(boolean mutableJson) {
        this.mutableJson = mutableJson;
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        return this.parse(new StringReader(json));
    }

    @Override
    public Object parse(byte[] json) throws InvalidJsonException {
        return this.parse(new InputStreamReader((InputStream)new ByteArrayInputStream(json), StandardCharsets.UTF_8));
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.parse(new InputStreamReader(jsonStream, charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parse(Reader jsonInput) {
        try (JsonReader jsonReader = defaultJsonProvider.createReader(jsonInput);){
            JsonStructure jsonStruct = jsonReader.read();
            JsonStructure jsonStructure = this.mutableJson ? this.proxyAll(jsonStruct) : jsonStruct;
            return jsonStructure;
        }
        catch (JsonParsingException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (obj instanceof JsonObjectBuilder) {
            obj = ((JsonObjectBuilder)obj).build();
        } else if (obj instanceof JsonArrayBuilder) {
            obj = ((JsonArrayBuilder)obj).build();
        } else if (obj instanceof List) {
            obj = jsonBuilderFactory.createArrayBuilder((Collection)obj).build();
        }
        return obj.toString();
    }

    @Override
    public Object createArray() {
        if (this.mutableJson) {
            return new JsonArrayProxy(jsonBuilderFactory.createArrayBuilder().build());
        }
        return new LinkedList();
    }

    @Override
    public Object createMap() {
        if (this.mutableJson) {
            return new JsonObjectProxy(jsonBuilderFactory.createObjectBuilder().build());
        }
        return jsonBuilderFactory.createObjectBuilder();
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof JsonArray || obj instanceof JsonArrayBuilder || obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        if (obj instanceof JsonArrayBuilder) {
            obj = ((JsonArrayBuilder)obj).build();
        }
        if (obj instanceof JsonArray) {
            return ((JsonArray)obj).get(idx);
        }
        if (obj instanceof List) {
            return super.getArrayIndex(obj, idx);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        if (array instanceof JsonArrayBuilder) {
            array = index == ((JsonArrayBuilder)array).build().size() ? ((JsonArrayBuilder)array).add(this.wrap(newValue)) : ((JsonArrayBuilder)array).set(index, this.wrap(newValue));
            return;
        } else if (array instanceof JsonArray) {
            if (!this.mutableJson || !(array instanceof JsonArrayProxy)) throw new UnsupportedOperationException("JsonArray is immutable in JSON-P");
            ((JsonArrayProxy)array).set(index, this.wrap(newValue));
            return;
        } else {
            super.setArrayIndex(array, index, this.wrap(newValue));
        }
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        if (obj instanceof JsonObjectBuilder) {
            obj = ((JsonObjectBuilder)obj).build();
        }
        if (obj instanceof JsonObject) {
            JsonValue o = (JsonValue)((JsonObject)obj).get((Object)key);
            if (o == null) {
                return UNDEFINED;
            }
            return this.unwrap(o);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (obj instanceof JsonObjectBuilder) {
            ((JsonObjectBuilder)obj).add(key.toString(), this.wrap(value));
        } else if (this.mutableJson && obj instanceof JsonObjectProxy) {
            ((JsonObjectProxy)obj).put(key.toString(), this.wrap(value));
        } else {
            if (obj instanceof JsonObject) {
                throw new UnsupportedOperationException("JsonObject is immutable in JSON-P");
            }
            if (obj instanceof JsonArrayBuilder) {
                if (key == null) {
                    ((JsonArrayBuilder)obj).add(this.wrap(value));
                } else {
                    ((JsonArrayBuilder)obj).set(this.toArrayIndex(key).intValue(), this.wrap(value));
                }
            } else if (this.mutableJson && obj instanceof JsonArrayProxy) {
                if (key == null) {
                    ((JsonArrayProxy)obj).add(this.wrap(value));
                } else {
                    ((JsonArrayProxy)obj).set((int)this.toArrayIndex(key), this.wrap(value));
                }
            } else {
                if (obj instanceof JsonArray) {
                    throw new UnsupportedOperationException("JsonArray is immutable in JSON-P");
                }
                if (obj instanceof List) {
                    List array = (List)obj;
                    if (key == null) {
                        array.add(this.wrap(value));
                    } else {
                        array.add(this.toArrayIndex(key), this.wrap(value));
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeProperty(Object obj, Object key) {
        if (obj instanceof JsonObjectBuilder) {
            ((JsonObjectBuilder)obj).remove(key.toString());
            return;
        } else if (obj instanceof JsonObject) {
            if (!this.mutableJson || !(obj instanceof JsonObjectProxy)) throw new UnsupportedOperationException("JsonObject is immutable in JSON-P");
            ((JsonObjectProxy)obj).remove(key);
            return;
        } else {
            if (!this.isArray(obj)) throw new UnsupportedOperationException();
            int index = this.toArrayIndex(key);
            if (obj instanceof JsonArrayBuilder) {
                ((JsonArrayBuilder)obj).remove(index);
                return;
            } else {
                if (!(obj instanceof List)) return;
                ((List)obj).remove(index);
            }
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof JsonObject || obj instanceof JsonObjectBuilder;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        Set keys;
        if (obj instanceof JsonObjectBuilder) {
            keys = ((JsonObjectBuilder)obj).build().keySet();
        } else if (obj instanceof JsonObject) {
            keys = ((JsonObject)obj).keySet();
        } else {
            throw new UnsupportedOperationException("Json object is expected");
        }
        return new ArrayList<String>(keys);
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            if (obj instanceof JsonArrayBuilder) {
                return ((JsonArrayBuilder)obj).build().size();
            }
            return ((List)obj).size();
        }
        if (this.isMap(obj)) {
            if (obj instanceof JsonObjectBuilder) {
                obj = ((JsonObjectBuilder)obj).build();
            }
            return ((JsonObject)obj).size();
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        String className = obj != null ? obj.getClass().getName() : null;
        throw new JsonPathException("length operation can not applied to " + className);
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        ArrayList<Object> values;
        if (this.isArray(obj)) {
            if (obj instanceof JsonArrayBuilder) {
                obj = ((JsonArrayBuilder)obj).build();
            }
            values = new ArrayList<Object>(((List)obj).size());
            for (Object val : (List)obj) {
                values.add(this.unwrap(val));
            }
        } else if (this.isMap(obj)) {
            if (obj instanceof JsonObjectBuilder) {
                obj = ((JsonObjectBuilder)obj).build();
            }
            values = new ArrayList(((JsonObject)obj).size());
            for (JsonValue val : ((JsonObject)obj).values()) {
                values.add(this.unwrap(val));
            }
        } else {
            throw new UnsupportedOperationException("an array or object instance is expected");
        }
        return values;
    }

    @Override
    public Object unwrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof JsonValue)) {
            return obj;
        }
        switch (((JsonValue)obj).getValueType()) {
            case ARRAY: {
                if (this.mutableJson && obj instanceof JsonArrayProxy) {
                    return (JsonArray)obj;
                }
                return ((JsonArray)obj).getValuesAs(v -> this.unwrap(v));
            }
            case STRING: {
                return ((JsonString)obj).getString();
            }
            case NUMBER: {
                if (((JsonNumber)obj).isIntegral()) {
                    try {
                        return ((JsonNumber)obj).intValueExact();
                    }
                    catch (ArithmeticException e) {
                        return ((JsonNumber)obj).longValueExact();
                    }
                }
                return ((JsonNumber)obj).doubleValue();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NULL: {
                return null;
            }
        }
        return obj;
    }

    private Integer toArrayIndex(Object index) {
        try {
            if (index instanceof Integer) {
                return (Integer)index;
            }
            if (index instanceof Long) {
                return ((Long)index).intValue();
            }
            if (index != null) {
                return Integer.valueOf(index.toString());
            }
            throw new IllegalArgumentException("Invalid array index");
        }
        catch (NumberFormatException e) {
            throw new JsonPathException(e);
        }
    }

    private JsonValue wrap(Object obj) {
        if (obj == null) {
            return JsonValue.NULL;
        }
        if (obj instanceof JsonArray) {
            if (!this.mutableJson || obj instanceof JsonArrayProxy) {
                return (JsonArray)obj;
            }
            return this.proxyAll((JsonStructure)((JsonArray)obj));
        }
        if (obj instanceof JsonObject) {
            if (!this.mutableJson || obj instanceof JsonObjectProxy) {
                return (JsonObject)obj;
            }
            return this.proxyAll((JsonStructure)((JsonObject)obj));
        }
        if (obj instanceof JsonValue) {
            return (JsonValue)obj;
        }
        if (Boolean.TRUE.equals(obj)) {
            return JsonValue.TRUE;
        }
        if (Boolean.FALSE.equals(obj)) {
            return JsonValue.FALSE;
        }
        if (obj instanceof CharSequence) {
            return defaultJsonProvider.createValue(obj.toString());
        }
        if (obj instanceof Number) {
            if (obj instanceof Integer) {
                int v = ((Number)obj).intValue();
                return defaultJsonProvider.createValue(v);
            }
            if (obj instanceof Long) {
                long v = ((Number)obj).longValue();
                return defaultJsonProvider.createValue(v);
            }
            if (obj instanceof Float || obj instanceof Double) {
                double v = ((Number)obj).doubleValue();
                return defaultJsonProvider.createValue(v);
            }
            if (obj instanceof BigInteger) {
                return defaultJsonProvider.createValue((BigInteger)obj);
            }
            if (obj instanceof BigDecimal) {
                return defaultJsonProvider.createValue((BigDecimal)obj);
            }
            BigDecimal v = BigDecimal.valueOf(((Number)obj).doubleValue());
            return defaultJsonProvider.createValue(v);
        }
        if (obj instanceof Collection) {
            JsonArray result = jsonBuilderFactory.createArrayBuilder((Collection)obj).build();
            return this.mutableJson ? this.proxyAll((JsonStructure)result) : result;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            JsonObject result = jsonBuilderFactory.createObjectBuilder(map).build();
            return this.mutableJson ? this.proxyAll((JsonStructure)result) : result;
        }
        if (obj instanceof JsonArrayBuilder) {
            JsonArray result = ((JsonArrayBuilder)obj).build();
            return this.mutableJson ? this.proxyAll((JsonStructure)result) : result;
        }
        if (obj instanceof JsonObjectBuilder) {
            JsonObject result = ((JsonObjectBuilder)obj).build();
            return this.mutableJson ? this.proxyAll((JsonStructure)result) : result;
        }
        String className = obj.getClass().getSimpleName();
        throw new UnsupportedOperationException("Cannot create JSON element from " + className);
    }

    private JsonStructure proxyAll(JsonStructure jsonStruct) {
        if (jsonStruct == null) {
            return null;
        }
        if (jsonStruct instanceof JsonArrayProxy) {
            return (JsonArray)jsonStruct;
        }
        if (jsonStruct instanceof JsonArray) {
            ArrayList<JsonValue> array = new ArrayList<JsonValue>();
            for (JsonValue v : (JsonArray)jsonStruct) {
                if (v instanceof JsonStructure) {
                    v = this.proxyAll((JsonStructure)v);
                }
                array.add(v);
            }
            return new JsonArrayProxy(jsonBuilderFactory.createArrayBuilder(array).build());
        }
        if (jsonStruct instanceof JsonObjectProxy) {
            return (JsonObject)jsonStruct;
        }
        if (jsonStruct instanceof JsonObject) {
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry e : ((JsonObject)jsonStruct).entrySet()) {
                JsonValue v = (JsonValue)e.getValue();
                if (v instanceof JsonStructure) {
                    v = this.proxyAll((JsonStructure)v);
                }
                map.put(e.getKey(), v);
            }
            return new JsonObjectProxy(jsonBuilderFactory.createObjectBuilder(map).build());
        }
        throw new IllegalArgumentException();
    }

    private static class JsonObjectProxy
    implements JsonObject {
        private JsonObject obj;

        JsonObjectProxy(JsonObject obj) {
            this.obj = obj;
        }

        public JsonArray getJsonArray(String name) {
            return this.obj.getJsonArray(name);
        }

        public JsonObject getJsonObject(String name) {
            return this.obj.getJsonObject(name);
        }

        public JsonNumber getJsonNumber(String name) {
            return this.obj.getJsonNumber(name);
        }

        public JsonString getJsonString(String name) {
            return this.obj.getJsonString(name);
        }

        public String getString(String name) {
            return this.obj.getString(name);
        }

        public String getString(String name, String defaultValue) {
            return this.obj.getString(name, defaultValue);
        }

        public int getInt(String name) {
            return this.obj.getInt(name);
        }

        public int getInt(String name, int defaultValue) {
            return this.obj.getInt(name, defaultValue);
        }

        public boolean getBoolean(String name) {
            return this.obj.getBoolean(name);
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            return this.obj.getBoolean(name, defaultValue);
        }

        public boolean isNull(String name) {
            return this.obj.isNull(name);
        }

        public JsonValue.ValueType getValueType() {
            return this.obj.getValueType();
        }

        public int size() {
            return this.obj.size();
        }

        public boolean isEmpty() {
            return this.obj.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.obj.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.obj.containsValue(value);
        }

        public JsonValue get(Object key) {
            return (JsonValue)this.obj.get(key);
        }

        public JsonValue put(String key, JsonValue value) {
            JsonValue oldValue = (JsonValue)this.obj.get((Object)key);
            this.obj = jsonBuilderFactory.createObjectBuilder(this.obj).add(key, value).build();
            return oldValue;
        }

        public JsonValue remove(Object key) {
            JsonValue oldValue = (JsonValue)this.obj.get(key);
            if (oldValue != null) {
                this.obj = jsonBuilderFactory.createObjectBuilder(this.obj).remove(key.toString()).build();
                return oldValue;
            }
            return null;
        }

        public void putAll(Map<? extends String, ? extends JsonValue> m) {
            if (m.isEmpty()) {
                return;
            }
            JsonObjectBuilder builder = jsonBuilderFactory.createObjectBuilder(this.obj);
            for (Map.Entry<? extends String, ? extends JsonValue> e : m.entrySet()) {
                builder.add(e.getKey(), e.getValue());
            }
            this.obj = builder.build();
        }

        public void clear() {
            this.obj = jsonBuilderFactory.createObjectBuilder().build();
        }

        public Set<String> keySet() {
            return this.obj.keySet();
        }

        public Collection<JsonValue> values() {
            return this.obj.values();
        }

        public Set<Map.Entry<String, JsonValue>> entrySet() {
            return new AbstractSet<Map.Entry<String, JsonValue>>(){
                final JsonObject refObj;
                {
                    this.refObj = obj;
                }

                @Override
                public Iterator<Map.Entry<String, JsonValue>> iterator() {
                    if (this.refObj != obj) {
                        throw new ConcurrentModificationException();
                    }
                    return new Iterator<Map.Entry<String, JsonValue>>(){
                        final Iterator<Map.Entry<String, JsonValue>> it;
                        {
                            this.it = obj.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (refObj == obj) {
                                return this.it.hasNext();
                            }
                            throw new ConcurrentModificationException();
                        }

                        @Override
                        public Map.Entry<String, JsonValue> next() {
                            if (refObj == obj) {
                                return this.it.next();
                            }
                            throw new ConcurrentModificationException();
                        }
                    };
                }

                @Override
                public int size() {
                    if (this.refObj == obj) {
                        return obj.size();
                    }
                    throw new ConcurrentModificationException();
                }
            };
        }

        public int hashCode() {
            return this.obj != null ? this.obj.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return this.obj == null;
            }
            if (obj instanceof JsonObjectProxy) {
                return this.obj.equals(((JsonObjectProxy)obj).obj);
            }
            return this.obj.equals(obj);
        }

        public String toString() {
            return this.obj != null ? this.obj.toString() : null;
        }
    }

    private static class JsonArrayProxy
    implements JsonArray {
        private JsonArray arr;

        JsonArrayProxy(JsonArray arr) {
            this.arr = arr;
        }

        public JsonObject getJsonObject(int index) {
            return this.arr.getJsonObject(index);
        }

        public JsonArray getJsonArray(int index) {
            return this.arr.getJsonArray(index);
        }

        public JsonNumber getJsonNumber(int index) {
            return this.arr.getJsonNumber(index);
        }

        public JsonString getJsonString(int index) {
            return this.arr.getJsonString(index);
        }

        public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
            return this.arr.getValuesAs(clazz);
        }

        public String getString(int index) {
            return this.arr.getString(index);
        }

        public String getString(int index, String defaultValue) {
            return this.arr.getString(index, defaultValue);
        }

        public int getInt(int index) {
            return this.arr.getInt(index);
        }

        public int getInt(int index, int defaultValue) {
            return this.arr.getInt(index, defaultValue);
        }

        public boolean getBoolean(int index) {
            return this.arr.getBoolean(index);
        }

        public boolean getBoolean(int index, boolean defaultValue) {
            return this.arr.getBoolean(index, defaultValue);
        }

        public boolean isNull(int index) {
            return this.arr.isNull(index);
        }

        public JsonValue.ValueType getValueType() {
            return this.arr.getValueType();
        }

        public int size() {
            return this.arr.size();
        }

        public boolean isEmpty() {
            return this.arr.isEmpty();
        }

        public boolean contains(Object o) {
            return this.arr.contains(o);
        }

        public Iterator<JsonValue> iterator() {
            return new Iterator<JsonValue>(){
                final JsonArray refArr;
                final Iterator<JsonValue> it;
                {
                    this.refArr = arr;
                    this.it = arr.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.refArr == arr) {
                        return this.it.hasNext();
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public JsonValue next() {
                    if (this.refArr == arr) {
                        return this.it.next();
                    }
                    throw new ConcurrentModificationException();
                }
            };
        }

        public Object[] toArray() {
            return this.arr.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.arr.toArray((Object[])a);
        }

        public boolean add(JsonValue e) {
            this.arr = jsonBuilderFactory.createArrayBuilder(this.arr).add(e).build();
            return true;
        }

        public boolean remove(Object o) {
            int i = this.arr.indexOf(o);
            if (i != -1) {
                this.arr = jsonBuilderFactory.createArrayBuilder(this.arr).remove(i).build();
                return true;
            }
            return false;
        }

        public boolean containsAll(Collection<?> c) {
            return this.arr.containsAll(c);
        }

        public boolean addAll(Collection<? extends JsonValue> c) {
            if (!c.isEmpty()) {
                JsonArrayBuilder builder = jsonBuilderFactory.createArrayBuilder(this.arr);
                for (JsonValue jsonValue : c) {
                    builder.add(jsonValue);
                }
                this.arr = builder.build();
                return true;
            }
            return false;
        }

        public boolean addAll(int index, Collection<? extends JsonValue> c) {
            if (c.isEmpty()) {
                return false;
            }
            if (index < 0 || index >= this.arr.size()) {
                throw new IndexOutOfBoundsException();
            }
            JsonArrayBuilder builder = jsonBuilderFactory.createArrayBuilder(this.arr);
            for (int i = 0; i < this.arr.size(); ++i) {
                if (index == i) {
                    for (JsonValue jsonValue : c) {
                        builder.add(jsonValue);
                    }
                }
                builder.add((JsonValue)this.arr.get(i));
            }
            this.arr = builder.build();
            return true;
        }

        public boolean removeAll(Collection<?> c) {
            if (c.isEmpty()) {
                return false;
            }
            JsonArrayBuilder builder = null;
            int i = 0;
            int j = 0;
            while (i < this.arr.size()) {
                if (c.contains(this.arr.get(i))) {
                    if (builder == null) {
                        builder = jsonBuilderFactory.createArrayBuilder(this.arr);
                    }
                    builder.remove(j--);
                }
                ++i;
                ++j;
            }
            if (builder != null) {
                this.arr = builder.build();
                return true;
            }
            return false;
        }

        public boolean retainAll(Collection<?> c) {
            if (c.isEmpty()) {
                this.arr = jsonBuilderFactory.createArrayBuilder().build();
                return true;
            }
            JsonArrayBuilder builder = null;
            int i = 0;
            int j = 0;
            while (i < this.arr.size()) {
                if (!c.contains(this.arr.get(i))) {
                    if (builder == null) {
                        builder = jsonBuilderFactory.createArrayBuilder(this.arr);
                    }
                    builder.remove(j--);
                }
                ++i;
                ++j;
            }
            if (builder != null) {
                this.arr = builder.build();
                return true;
            }
            return false;
        }

        public void clear() {
            this.arr = jsonBuilderFactory.createArrayBuilder().build();
        }

        public JsonValue get(int index) {
            return (JsonValue)this.arr.get(index);
        }

        public JsonValue set(int index, JsonValue element) {
            if (index == this.arr.size()) {
                this.arr = jsonBuilderFactory.createArrayBuilder(this.arr).add(index, element).build();
                return null;
            }
            JsonValue oldValue = (JsonValue)this.arr.get(index);
            this.arr = jsonBuilderFactory.createArrayBuilder(this.arr).set(index, element).build();
            return oldValue;
        }

        public void add(int index, JsonValue element) {
            this.arr = jsonBuilderFactory.createArrayBuilder(this.arr).add(index, element).build();
        }

        public JsonValue remove(int index) {
            JsonValue oldValue = (JsonValue)this.arr.get(index);
            this.arr = jsonBuilderFactory.createArrayBuilder(this.arr).remove(index).build();
            return oldValue;
        }

        public int indexOf(Object o) {
            return this.arr.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.arr.lastIndexOf(o);
        }

        public ListIterator<JsonValue> listIterator() {
            return this.listIterator(0);
        }

        public ListIterator<JsonValue> listIterator(final int index) {
            return new ListIterator<JsonValue>(){
                final JsonArray refArr;
                final ListIterator<JsonValue> it;
                {
                    this.refArr = arr;
                    this.it = arr.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    if (this.refArr == arr) {
                        return this.it.hasNext();
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public JsonValue next() {
                    if (this.refArr == arr) {
                        return this.it.next();
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public boolean hasPrevious() {
                    if (this.refArr == arr) {
                        return this.it.hasPrevious();
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public JsonValue previous() {
                    if (this.refArr == arr) {
                        return this.it.previous();
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public int nextIndex() {
                    if (this.refArr == arr) {
                        return this.it.nextIndex();
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public int previousIndex() {
                    if (this.refArr == arr) {
                        return this.it.previousIndex();
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }

                @Override
                public void set(JsonValue e) {
                    this.it.set(e);
                }

                @Override
                public void add(JsonValue e) {
                    this.it.add(e);
                }
            };
        }

        public List<JsonValue> subList(int fromIndex, int toIndex) {
            return this.arr.subList(fromIndex, toIndex);
        }

        public int hashCode() {
            return this.arr != null ? this.arr.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return this.arr == null;
            }
            if (obj instanceof JsonArrayProxy) {
                return this.arr.equals(((JsonArrayProxy)obj).arr);
            }
            return this.arr.equals(obj);
        }

        public String toString() {
            return this.arr != null ? this.arr.toString() : null;
        }
    }
}

