/*
 * This file is part of the PackageKitQt project
 * Copyright (C) 2021-2024 Matthias Klumpp <matthias@tenstral.net>
 *
 * Licensed under the GNU Lesser General Public License Version 2.1
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the license, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

/* compile time version
 */
#define QPK_MAJOR_VERSION 1
#define QPK_MINOR_VERSION 1
#define QPK_MICRO_VERSION 2

/* check whether a PackageKitQt version equal to or greater than
 * major.minor.micro.
 */
#define QPK_CHECK_VERSION(major,minor,micro)    \
    (QPK_MAJOR_VERSION > (major) || \
     (QPK_MAJOR_VERSION == (major) && QPK_MINOR_VERSION > (minor)) || \
     (QPK_MAJOR_VERSION == (major) && QPK_MINOR_VERSION == (minor) && \
      QPK_MICRO_VERSION >= (micro)))
