
use builtin;
use str;

set edit:completion:arg-completer[procs] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'procs'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'procs'= {
            cand -W 'Watch mode with custom interval'
            cand --watch-interval 'Watch mode with custom interval'
            cand -i 'Insert column to slot'
            cand --insert 'Insert column to slot'
            cand --only 'Specified column only'
            cand --sorta 'Sort column by ascending'
            cand --sortd 'Sort column by descending'
            cand -c 'Color mode'
            cand --color 'Color mode'
            cand --theme 'Theme mode'
            cand -p 'Pager mode'
            cand --pager 'Pager mode'
            cand --interval 'Interval to calculate throughput'
            cand --use-config 'Use built-in configuration'
            cand --load-config 'Load configuration from file'
            cand --gen-completion 'Generate shell completion file'
            cand --gen-completion-out 'Generate shell completion file and write to stdout'
            cand -a 'AND  logic for multi-keyword'
            cand --and 'AND  logic for multi-keyword'
            cand -o 'OR   logic for multi-keyword'
            cand --or 'OR   logic for multi-keyword'
            cand -d 'NAND logic for multi-keyword'
            cand --nand 'NAND logic for multi-keyword'
            cand -r 'NOR  logic for multi-keyword'
            cand --nor 'NOR  logic for multi-keyword'
            cand -l 'Show list of kind'
            cand --list 'Show list of kind'
            cand --thread 'Show thread'
            cand -t 'Tree view'
            cand --tree 'Tree view'
            cand -w 'Watch mode with default interval (1s)'
            cand --watch 'Watch mode with default interval (1s)'
            cand --gen-config 'Generate configuration sample file'
            cand --no-header 'Suppress header'
            cand --debug 'Show debug message'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
    ]
    $completions[$command]
}
