# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._static_sites_operations import (
    build_create_or_update_static_site_build_function_app_settings_request,
    build_create_or_update_static_site_custom_domain_request,
    build_create_or_update_static_site_function_app_settings_request,
    build_create_or_update_static_site_request,
    build_create_user_roles_invitation_link_request,
    build_delete_static_site_build_request,
    build_delete_static_site_custom_domain_request,
    build_delete_static_site_request,
    build_delete_static_site_user_request,
    build_detach_static_site_request,
    build_get_static_site_build_request,
    build_get_static_site_builds_request,
    build_get_static_site_request,
    build_get_static_sites_by_resource_group_request,
    build_list_request,
    build_list_static_site_build_function_app_settings_request,
    build_list_static_site_build_functions_request,
    build_list_static_site_custom_domains_request,
    build_list_static_site_function_app_settings_request,
    build_list_static_site_functions_request,
    build_list_static_site_secrets_request,
    build_list_static_site_users_request,
    build_preview_workflow_request,
    build_reset_static_site_api_key_request,
    build_update_static_site_request,
    build_update_static_site_user_request,
    build_validate_custom_domain_can_be_added_to_static_site_request,
)
from .._vendor import WebSiteManagementClientMixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class StaticSitesOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2020_06_01.aio.WebSiteManagementClient`'s
        :attr:`static_sites` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @overload
    async def preview_workflow(
        self,
        location: str,
        static_sites_workflow_preview_request: _models.StaticSitesWorkflowPreviewRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSitesWorkflowPreview:
        """Generates a preview workflow file for the static site.

        Generates a preview workflow file for the static site.

        :param location: Location where you plan to create the static site. Required.
        :type location: str
        :param static_sites_workflow_preview_request: A JSON representation of the
         StaticSitesWorkflowPreviewRequest properties. See example. Required.
        :type static_sites_workflow_preview_request:
         ~azure.mgmt.web.v2020_06_01.models.StaticSitesWorkflowPreviewRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSitesWorkflowPreview or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSitesWorkflowPreview
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def preview_workflow(
        self,
        location: str,
        static_sites_workflow_preview_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSitesWorkflowPreview:
        """Generates a preview workflow file for the static site.

        Generates a preview workflow file for the static site.

        :param location: Location where you plan to create the static site. Required.
        :type location: str
        :param static_sites_workflow_preview_request: A JSON representation of the
         StaticSitesWorkflowPreviewRequest properties. See example. Required.
        :type static_sites_workflow_preview_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSitesWorkflowPreview or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSitesWorkflowPreview
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def preview_workflow(
        self,
        location: str,
        static_sites_workflow_preview_request: Union[_models.StaticSitesWorkflowPreviewRequest, IO],
        **kwargs: Any
    ) -> _models.StaticSitesWorkflowPreview:
        """Generates a preview workflow file for the static site.

        Generates a preview workflow file for the static site.

        :param location: Location where you plan to create the static site. Required.
        :type location: str
        :param static_sites_workflow_preview_request: A JSON representation of the
         StaticSitesWorkflowPreviewRequest properties. See example. Is either a
         StaticSitesWorkflowPreviewRequest type or a IO type. Required.
        :type static_sites_workflow_preview_request:
         ~azure.mgmt.web.v2020_06_01.models.StaticSitesWorkflowPreviewRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSitesWorkflowPreview or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSitesWorkflowPreview
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSitesWorkflowPreview] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_sites_workflow_preview_request, (IOBase, bytes)):
            _content = static_sites_workflow_preview_request
        else:
            _json = self._serialize.body(static_sites_workflow_preview_request, "StaticSitesWorkflowPreviewRequest")

        request = build_preview_workflow_request(
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.preview_workflow.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSitesWorkflowPreview", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    preview_workflow.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/previewStaticSiteWorkflowFile"
    }

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.StaticSiteARMResource"]:
        """Get all Static Sites for a subscription.

        Get all Static Sites for a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StaticSiteARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Web/staticSites"}

    @distributed_trace
    def get_static_sites_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.StaticSiteARMResource"]:
        """Gets all static sites in the specified resource group.

        Gets all static sites in the specified resource group.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StaticSiteARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_static_sites_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_static_sites_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_static_sites_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites"
    }

    @distributed_trace_async
    async def get_static_site(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Gets the details of a static site.

        Gets the details of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteARMResource] = kwargs.pop("cls", None)

        request = build_get_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_static_site.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_static_site.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
    }

    @overload
    async def create_or_update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: _models.StaticSiteARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Creates a new static site in an existing resource group, or updates an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Creates a new static site in an existing resource group, or updates an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: Union[_models.StaticSiteARMResource, IO],
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Creates a new static site in an existing resource group, or updates an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Is either a StaticSiteARMResource type or a IO type. Required.
        :type static_site_envelope: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteARMResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_envelope, (IOBase, bytes)):
            _content = static_site_envelope
        else:
            _json = self._serialize.body(static_site_envelope, "StaticSiteARMResource")

        request = build_create_or_update_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_static_site.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("StaticSiteARMResource", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("StaticSiteARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update_static_site.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
    }

    @distributed_trace_async
    async def delete_static_site(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Deletes a static site.

        Deletes a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to delete. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_static_site.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_static_site.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
    }

    @overload
    async def update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: _models.StaticSitePatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Creates a new static site in an existing resource group, or updates an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: ~azure.mgmt.web.v2020_06_01.models.StaticSitePatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Creates a new static site in an existing resource group, or updates an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: Union[_models.StaticSitePatchResource, IO],
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Creates a new static site in an existing resource group, or updates an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Is either a StaticSitePatchResource type or a IO type. Required.
        :type static_site_envelope: ~azure.mgmt.web.v2020_06_01.models.StaticSitePatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteARMResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_envelope, (IOBase, bytes)):
            _content = static_site_envelope
        else:
            _json = self._serialize.body(static_site_envelope, "StaticSitePatchResource")

        request = build_update_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_static_site.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("StaticSiteARMResource", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("StaticSiteARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    update_static_site.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}"
    }

    @distributed_trace
    def list_static_site_users(
        self, resource_group_name: str, name: str, authprovider: str, **kwargs: Any
    ) -> AsyncIterable["_models.StaticSiteUserARMResource"]:
        """Gets the list of users of a static site.

        Gets the list of users of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for the users. Required.
        :type authprovider: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StaticSiteUserARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.StaticSiteUserARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteUserCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_static_site_users_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    authprovider=authprovider,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_static_site_users.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteUserCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_static_site_users.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/listUsers"
    }

    @distributed_trace_async
    async def delete_static_site_user(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, authprovider: str, userid: str, **kwargs: Any
    ) -> None:
        """Deletes the user entry from the static site.

        Deletes the user entry from the static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the staticsite. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_static_site_user_request(
            resource_group_name=resource_group_name,
            name=name,
            authprovider=authprovider,
            userid=userid,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_static_site_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_static_site_user.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}"
    }

    @overload
    async def update_static_site_user(
        self,
        resource_group_name: str,
        name: str,
        authprovider: str,
        userid: str,
        static_site_user_envelope: _models.StaticSiteUserARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserARMResource:
        """Updates a user entry with the listed roles.

        Updates a user entry with the listed roles.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :param static_site_user_envelope: A JSON representation of the StaticSiteUser properties. See
         example. Required.
        :type static_site_user_envelope: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteUserARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_static_site_user(
        self,
        resource_group_name: str,
        name: str,
        authprovider: str,
        userid: str,
        static_site_user_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserARMResource:
        """Updates a user entry with the listed roles.

        Updates a user entry with the listed roles.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :param static_site_user_envelope: A JSON representation of the StaticSiteUser properties. See
         example. Required.
        :type static_site_user_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteUserARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_static_site_user(
        self,
        resource_group_name: str,
        name: str,
        authprovider: str,
        userid: str,
        static_site_user_envelope: Union[_models.StaticSiteUserARMResource, IO],
        **kwargs: Any
    ) -> _models.StaticSiteUserARMResource:
        """Updates a user entry with the listed roles.

        Updates a user entry with the listed roles.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :param static_site_user_envelope: A JSON representation of the StaticSiteUser properties. See
         example. Is either a StaticSiteUserARMResource type or a IO type. Required.
        :type static_site_user_envelope: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserARMResource
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteUserARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteUserARMResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_user_envelope, (IOBase, bytes)):
            _content = static_site_user_envelope
        else:
            _json = self._serialize.body(static_site_user_envelope, "StaticSiteUserARMResource")

        request = build_update_static_site_user_request(
            resource_group_name=resource_group_name,
            name=name,
            authprovider=authprovider,
            userid=userid,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_static_site_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteUserARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_static_site_user.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}"
    }

    @distributed_trace
    def get_static_site_builds(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.StaticSiteBuildARMResource"]:
        """Gets all static site builds for a particular static site.

        Gets all static site builds for a particular static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StaticSiteBuildARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.StaticSiteBuildARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteBuildCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_static_site_builds_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_static_site_builds.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteBuildCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_static_site_builds.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds"
    }

    @distributed_trace_async
    async def get_static_site_build(
        self, resource_group_name: str, name: str, pr_id: str, **kwargs: Any
    ) -> _models.StaticSiteBuildARMResource:
        """Gets the details of a static site build.

        Gets the details of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param pr_id: The stage site identifier. Required.
        :type pr_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteBuildARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteBuildARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteBuildARMResource] = kwargs.pop("cls", None)

        request = build_get_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            pr_id=pr_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_static_site_build.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteBuildARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_static_site_build.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}"
    }

    @distributed_trace_async
    async def delete_static_site_build(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, pr_id: str, **kwargs: Any
    ) -> None:
        """Deletes a static site build.

        Deletes a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param pr_id: The stage site identifier. Required.
        :type pr_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            pr_id=pr_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_static_site_build.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_static_site_build.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}"
    }

    @overload
    async def create_or_update_static_site_build_function_app_settings(
        self,
        resource_group_name: str,
        name: str,
        pr_id: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site build.

        Creates or updates the function app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param pr_id: The stage site identifier. Required.
        :type pr_id: str
        :param app_settings: Required.
        :type app_settings: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_static_site_build_function_app_settings(
        self,
        resource_group_name: str,
        name: str,
        pr_id: str,
        app_settings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site build.

        Creates or updates the function app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param pr_id: The stage site identifier. Required.
        :type pr_id: str
        :param app_settings: Required.
        :type app_settings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_static_site_build_function_app_settings(
        self,
        resource_group_name: str,
        name: str,
        pr_id: str,
        app_settings: Union[_models.StringDictionary, IO],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site build.

        Creates or updates the function app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param pr_id: The stage site identifier. Required.
        :type pr_id: str
        :param app_settings: Is either a StringDictionary type or a IO type. Required.
        :type app_settings: ~azure.mgmt.web.v2020_06_01.models.StringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        request = build_create_or_update_static_site_build_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            pr_id=pr_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_static_site_build_function_app_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update_static_site_build_function_app_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/config/functionappsettings"
    }

    @distributed_trace
    def list_static_site_build_functions(
        self, resource_group_name: str, name: str, pr_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.StaticSiteFunctionOverviewARMResource"]:
        """Gets the functions of a particular static site build.

        Gets the functions of a particular static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param pr_id: The stage site identifier. Required.
        :type pr_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StaticSiteFunctionOverviewARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.StaticSiteFunctionOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteFunctionOverviewCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_static_site_build_functions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    pr_id=pr_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_static_site_build_functions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteFunctionOverviewCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_static_site_build_functions.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/functions"
    }

    @distributed_trace_async
    async def list_static_site_build_function_app_settings(
        self, resource_group_name: str, name: str, pr_id: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of a static site.

        Gets the application settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param pr_id: The stage site identifier. Required.
        :type pr_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_static_site_build_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            pr_id=pr_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_static_site_build_function_app_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    list_static_site_build_function_app_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/listFunctionAppSettings"
    }

    @overload
    async def create_or_update_static_site_function_app_settings(
        self,
        resource_group_name: str,
        name: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site.

        Creates or updates the function app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: Required.
        :type app_settings: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_static_site_function_app_settings(
        self,
        resource_group_name: str,
        name: str,
        app_settings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site.

        Creates or updates the function app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: Required.
        :type app_settings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_static_site_function_app_settings(
        self, resource_group_name: str, name: str, app_settings: Union[_models.StringDictionary, IO], **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site.

        Creates or updates the function app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: Is either a StringDictionary type or a IO type. Required.
        :type app_settings: ~azure.mgmt.web.v2020_06_01.models.StringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        request = build_create_or_update_static_site_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_static_site_function_app_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update_static_site_function_app_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/functionappsettings"
    }

    @overload
    async def create_user_roles_invitation_link(
        self,
        resource_group_name: str,
        name: str,
        static_site_user_roles_invitation_envelope: _models.StaticSiteUserInvitationRequestResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserInvitationResponseResource:
        """Creates an invitation link for a user with the role.

        Creates an invitation link for a user with the role.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_user_roles_invitation_envelope: Required.
        :type static_site_user_roles_invitation_envelope:
         ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserInvitationRequestResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteUserInvitationResponseResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserInvitationResponseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_roles_invitation_link(
        self,
        resource_group_name: str,
        name: str,
        static_site_user_roles_invitation_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserInvitationResponseResource:
        """Creates an invitation link for a user with the role.

        Creates an invitation link for a user with the role.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_user_roles_invitation_envelope: Required.
        :type static_site_user_roles_invitation_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteUserInvitationResponseResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserInvitationResponseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_user_roles_invitation_link(
        self,
        resource_group_name: str,
        name: str,
        static_site_user_roles_invitation_envelope: Union[_models.StaticSiteUserInvitationRequestResource, IO],
        **kwargs: Any
    ) -> _models.StaticSiteUserInvitationResponseResource:
        """Creates an invitation link for a user with the role.

        Creates an invitation link for a user with the role.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_user_roles_invitation_envelope: Is either a
         StaticSiteUserInvitationRequestResource type or a IO type. Required.
        :type static_site_user_roles_invitation_envelope:
         ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserInvitationRequestResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteUserInvitationResponseResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteUserInvitationResponseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteUserInvitationResponseResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_user_roles_invitation_envelope, (IOBase, bytes)):
            _content = static_site_user_roles_invitation_envelope
        else:
            _json = self._serialize.body(
                static_site_user_roles_invitation_envelope, "StaticSiteUserInvitationRequestResource"
            )

        request = build_create_user_roles_invitation_link_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_user_roles_invitation_link.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteUserInvitationResponseResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_user_roles_invitation_link.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/createUserInvitation"
    }

    @distributed_trace
    def list_static_site_custom_domains(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.StaticSiteCustomDomainOverviewARMResource"]:
        """Gets all static site custom domains for a particular static site.

        Gets all static site custom domains for a particular static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site resource to search in. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StaticSiteCustomDomainOverviewARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.StaticSiteCustomDomainOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteCustomDomainOverviewCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_static_site_custom_domains_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_static_site_custom_domains.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteCustomDomainOverviewCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_static_site_custom_domains.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains"
    }

    @distributed_trace_async
    async def create_or_update_static_site_custom_domain(
        self, resource_group_name: str, name: str, domain_name: str, **kwargs: Any
    ) -> _models.StaticSiteCustomDomainOverviewARMResource:
        """Creates a new static site custom domain in an existing resource group and static site.

        Creates a new static site custom domain in an existing resource group and static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to create. Required.
        :type domain_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StaticSiteCustomDomainOverviewARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StaticSiteCustomDomainOverviewARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteCustomDomainOverviewARMResource] = kwargs.pop("cls", None)

        request = build_create_or_update_static_site_custom_domain_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.create_or_update_static_site_custom_domain.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("StaticSiteCustomDomainOverviewARMResource", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("StaticSiteCustomDomainOverviewARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update_static_site_custom_domain.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}"
    }

    @distributed_trace_async
    async def delete_static_site_custom_domain(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, domain_name: str, **kwargs: Any
    ) -> None:
        """Deletes a custom domain.

        Deletes a custom domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to delete. Required.
        :type domain_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_static_site_custom_domain_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_static_site_custom_domain.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_static_site_custom_domain.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}"
    }

    @distributed_trace_async
    async def validate_custom_domain_can_be_added_to_static_site(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, domain_name: str, **kwargs: Any
    ) -> None:
        """Validates a particular custom domain can be added to a static site.

        Validates a particular custom domain can be added to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to validate. Required.
        :type domain_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_validate_custom_domain_can_be_added_to_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.validate_custom_domain_can_be_added_to_static_site.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    validate_custom_domain_can_be_added_to_static_site.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}/validate"
    }

    @distributed_trace_async
    async def detach_static_site(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Detaches a static site.

        Detaches a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to detach. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_detach_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.detach_static_site.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    detach_static_site.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/detach"
    }

    @distributed_trace
    def list_static_site_functions(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.StaticSiteFunctionOverviewARMResource"]:
        """Gets the functions of a static site.

        Gets the functions of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StaticSiteFunctionOverviewARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.StaticSiteFunctionOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StaticSiteFunctionOverviewCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_static_site_functions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_static_site_functions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteFunctionOverviewCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_static_site_functions.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/functions"
    }

    @distributed_trace_async
    async def list_static_site_function_app_settings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of a static site.

        Gets the application settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_static_site_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_static_site_function_app_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    list_static_site_function_app_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listFunctionAppSettings"
    }

    @distributed_trace_async
    async def list_static_site_secrets(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Lists the secrets for an existing static site.

        Lists the secrets for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_static_site_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_static_site_secrets.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_static_site_secrets.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listSecrets"
    }

    @overload
    async def reset_static_site_api_key(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        reset_properties_envelope: _models.StaticSiteResetPropertiesARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Resets the api key for an existing static site.

        Resets the api key for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param reset_properties_envelope: Required.
        :type reset_properties_envelope:
         ~azure.mgmt.web.v2020_06_01.models.StaticSiteResetPropertiesARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def reset_static_site_api_key(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        reset_properties_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Resets the api key for an existing static site.

        Resets the api key for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param reset_properties_envelope: Required.
        :type reset_properties_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def reset_static_site_api_key(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        reset_properties_envelope: Union[_models.StaticSiteResetPropertiesARMResource, IO],
        **kwargs: Any
    ) -> None:
        """Resets the api key for an existing static site.

        Resets the api key for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param reset_properties_envelope: Is either a StaticSiteResetPropertiesARMResource type or a IO
         type. Required.
        :type reset_properties_envelope:
         ~azure.mgmt.web.v2020_06_01.models.StaticSiteResetPropertiesARMResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(reset_properties_envelope, (IOBase, bytes)):
            _content = reset_properties_envelope
        else:
            _json = self._serialize.body(reset_properties_envelope, "StaticSiteResetPropertiesARMResource")

        request = build_reset_static_site_api_key_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.reset_static_site_api_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    reset_static_site_api_key.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/resetapikey"
    }
