/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import naga.NIOSocket;
import naga.NIOUtils;
import naga.PacketReader;
import naga.PacketWriter;
import naga.SSLSocketChannelResponder;
import naga.exception.ProtocolViolationException;
import naga.packetreader.RawPacketReader;
import naga.packetwriter.RawPacketWriter;

public class SSLPacketHandler
implements PacketReader,
PacketWriter {
    private static final Executor TASK_HANDLER = Executors.newSingleThreadExecutor();
    private static final ThreadLocal<ByteBuffer> SSL_BUFFER = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(65536);
        }
    };
    private final SSLEngine m_engine;
    private PacketReader m_reader;
    private PacketWriter m_writer;
    private ByteBuffer m_partialIncomingBuffer;
    private ByteBuffer[] m_initialOutBuffer;
    private final NIOSocket m_socket;
    private final SSLSocketChannelResponder m_responder;
    private boolean m_sslInitiated;

    public SSLPacketHandler(SSLEngine sSLEngine, NIOSocket nIOSocket, SSLSocketChannelResponder sSLSocketChannelResponder) {
        this.m_engine = sSLEngine;
        this.m_socket = nIOSocket;
        this.m_partialIncomingBuffer = null;
        this.m_writer = RawPacketWriter.INSTANCE;
        this.m_reader = RawPacketReader.INSTANCE;
        this.m_responder = sSLSocketChannelResponder;
        this.m_sslInitiated = false;
    }

    public PacketReader getReader() {
        return this.m_reader;
    }

    public void setReader(PacketReader packetReader) {
        this.m_reader = packetReader;
    }

    public PacketWriter getWriter() {
        return this.m_writer;
    }

    public void setWriter(PacketWriter packetWriter) {
        this.m_writer = packetWriter;
    }

    private void queueSSLTasks() {
        Runnable runnable;
        if (!this.m_sslInitiated) {
            return;
        }
        int n = 0;
        while ((runnable = this.m_engine.getDelegatedTask()) != null) {
            TASK_HANDLER.execute(runnable);
            ++n;
        }
        if (n == 0) {
            return;
        }
        TASK_HANDLER.execute(new Runnable(){

            @Override
            public void run() {
                SSLPacketHandler.this.m_socket.queue(new Runnable(){

                    @Override
                    public void run() {
                        SSLPacketHandler.this.reactToHandshakeStatus(SSLPacketHandler.this.m_engine.getHandshakeStatus());
                    }
                });
            }
        });
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        if (!this.m_sslInitiated) {
            return this.m_reader.nextPacket(byteBuffer);
        }
        try {
            ByteBuffer byteBuffer2 = SSL_BUFFER.get();
            byteBuffer2.clear();
            SSLEngineResult sSLEngineResult = this.m_engine.unwrap(byteBuffer, byteBuffer2);
            switch (sSLEngineResult.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    return null;
                }
                case BUFFER_OVERFLOW: {
                    throw new ProtocolViolationException("SSL Buffer Overflow");
                }
                case CLOSED: {
                    this.m_responder.connectionBroken(this.m_socket, new EOFException("SSL Connection closed"));
                    return null;
                }
            }
            this.reactToHandshakeStatus(sSLEngineResult.getHandshakeStatus());
            return this.retrieveDecryptedPacket(byteBuffer2);
        }
        catch (SSLException sSLException) {
            this.m_responder.closeDueToSSLException(sSLException);
            return null;
        }
    }

    private void reactToHandshakeStatus(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (!this.m_sslInitiated) {
            return;
        }
        switch (handshakeStatus) {
            case NOT_HANDSHAKING: 
            case NEED_UNWRAP: {
                break;
            }
            case NEED_TASK: {
                this.queueSSLTasks();
                break;
            }
            case FINISHED: {
                this.m_socket.write(new byte[0]);
                break;
            }
            case NEED_WRAP: {
                this.m_socket.write(new byte[0]);
            }
        }
    }

    private byte[] retrieveDecryptedPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        byteBuffer.flip();
        this.m_partialIncomingBuffer = NIOUtils.join(this.m_partialIncomingBuffer, byteBuffer);
        if (this.m_partialIncomingBuffer == null || this.m_partialIncomingBuffer.remaining() == 0) {
            return SKIP_PACKET;
        }
        return this.m_reader.nextPacket(this.m_partialIncomingBuffer);
    }

    @Override
    public ByteBuffer[] write(ByteBuffer[] byteBufferArray) {
        if (!this.m_sslInitiated) {
            return this.m_writer.write(byteBufferArray);
        }
        if (this.m_engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (!NIOUtils.isEmpty(byteBufferArray)) {
                this.m_initialOutBuffer = NIOUtils.concat(this.m_initialOutBuffer, this.m_writer.write(byteBufferArray));
                byteBufferArray = new ByteBuffer[]{};
            }
            ByteBuffer byteBuffer = SSL_BUFFER.get();
            ByteBuffer[] byteBufferArray2 = null;
            try {
                SSLEngineResult sSLEngineResult = null;
                while (this.m_engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    byteBuffer.clear();
                    sSLEngineResult = this.m_engine.wrap(byteBufferArray, byteBuffer);
                    byteBuffer.flip();
                    byteBufferArray2 = NIOUtils.concat(byteBufferArray2, NIOUtils.copy(byteBuffer));
                }
                if (sSLEngineResult == null) {
                    return null;
                }
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
                    throw new SSLException("Unexpectedly not ok wrapping handshake data, was " + (Object)((Object)sSLEngineResult.getStatus()));
                }
                this.reactToHandshakeStatus(sSLEngineResult.getHandshakeStatus());
            }
            catch (SSLException sSLException) {
                throw new RuntimeException(sSLException);
            }
            return byteBufferArray2;
        }
        ByteBuffer byteBuffer = SSL_BUFFER.get();
        byteBuffer.clear();
        if (NIOUtils.isEmpty(byteBufferArray)) {
            if (this.m_initialOutBuffer == null) {
                return null;
            }
        } else {
            byteBufferArray = this.m_writer.write(byteBufferArray);
        }
        if (this.m_initialOutBuffer != null) {
            byteBufferArray = NIOUtils.concat(this.m_initialOutBuffer, byteBufferArray);
            this.m_initialOutBuffer = null;
        }
        ByteBuffer[] byteBufferArray3 = null;
        while (!NIOUtils.isEmpty(byteBufferArray)) {
            byteBuffer.clear();
            try {
                this.m_engine.wrap(byteBufferArray, byteBuffer);
            }
            catch (SSLException sSLException) {
                throw new RuntimeException(sSLException);
            }
            byteBuffer.flip();
            byteBufferArray3 = NIOUtils.concat(byteBufferArray3, NIOUtils.copy(byteBuffer));
        }
        return byteBufferArray3;
    }

    public SSLEngine getSSLEngine() {
        return this.m_engine;
    }

    void begin() throws SSLException {
        this.m_engine.beginHandshake();
        this.m_sslInitiated = true;
        this.reactToHandshakeStatus(this.m_engine.getHandshakeStatus());
    }

    public void closeEngine() {
        if (!this.m_sslInitiated) {
            return;
        }
        this.m_engine.closeOutbound();
        this.m_responder.write(new byte[0]);
    }

    public boolean isEncrypted() {
        return this.m_sslInitiated;
    }
}

