/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import java.nio.ByteBuffer;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.BooleanType;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.ResponseControl;

public class SyncDoneControl
extends AbstractControl
implements ResponseControl {
    public static final String OID = "1.3.6.1.4.1.4203.1.9.1.3";
    private static final int HASH_CODE_SEED = 757;
    private byte[] cookie;
    private boolean refreshDeletes;

    public SyncDoneControl() {
        super(OID);
    }

    public SyncDoneControl(boolean critical) {
        super(OID, critical);
    }

    public SyncDoneControl(byte[] value) {
        super(OID);
        this.setCookie(value);
    }

    public SyncDoneControl(byte[] value, boolean critical) {
        super(OID, critical);
        this.setCookie(value);
    }

    public SyncDoneControl(byte[] value, boolean refresh, boolean critical) {
        super(OID, critical);
        this.setCookie(value);
        this.setRefreshDeletes(refresh);
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] value) {
        this.cookie = value;
    }

    public boolean getRefreshDeletes() {
        return this.refreshDeletes;
    }

    public void setRefreshDeletes(boolean b) {
        this.refreshDeletes = b;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SyncDoneControl && super.equals(o)) {
            SyncDoneControl v = (SyncDoneControl)o;
            return LdapUtils.areEqual(this.cookie, v.cookie) && LdapUtils.areEqual(this.refreshDeletes, v.refreshDeletes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(757, this.getOID(), this.getCriticality(), this.cookie, this.refreshDeletes);
    }

    public String toString() {
        return String.format("[%s@%d::criticality=%s, cookie=%s, refreshDeletes=%s]", this.getClass().getName(), this.hashCode(), this.getCriticality(), LdapUtils.base64Encode(this.cookie), this.refreshDeletes);
    }

    @Override
    public void decode(byte[] berValue) {
        this.logger.trace("decoding control: {}", (Object)LdapUtils.base64Encode(berValue));
        DERParser parser = new DERParser();
        parser.registerHandler(CookieHandler.PATH, (ParseHandler)new CookieHandler(this));
        parser.registerHandler(RefreshDeletesHandler.PATH, (ParseHandler)new RefreshDeletesHandler(this));
        parser.parse(ByteBuffer.wrap(berValue));
    }

    private static class RefreshDeletesHandler
    extends AbstractParseHandler<SyncDoneControl> {
        public static final DERPath PATH = new DERPath("/SEQ/BOOL");

        RefreshDeletesHandler(SyncDoneControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncDoneControl)this.getObject()).setRefreshDeletes(BooleanType.decode(encoded));
        }
    }

    private static class CookieHandler
    extends AbstractParseHandler<SyncDoneControl> {
        public static final DERPath PATH = new DERPath("/SEQ/OCTSTR");

        CookieHandler(SyncDoneControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            byte[] cookie = OctetStringType.readBuffer(encoded);
            if (cookie != null && cookie.length > 0) {
                ((SyncDoneControl)this.getObject()).setCookie(cookie);
            }
        }
    }
}

