/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl;

import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.opensearch.common.settings.Settings;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.netty4.ssl.SecureNetty4HttpServerTransport;
import org.opensearch.plugins.SecureHttpTransportSettingsProvider;
import org.opensearch.plugins.SecureSettingsFactory;
import org.opensearch.plugins.SecureTransportSettingsProvider;
import org.opensearch.plugins.TransportExceptionHandler;
import org.opensearch.security.filter.SecurityRestFilter;
import org.opensearch.security.ssl.SecurityKeyStore;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.http.netty.Netty4ConditionalDecompressor;
import org.opensearch.security.ssl.http.netty.Netty4HttpRequestHeaderVerifier;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportAdapterProvider;

public class OpenSearchSecureSettingsFactory
implements SecureSettingsFactory {
    private final ThreadPool threadPool;
    private final SecurityKeyStore sks;
    private final SslExceptionHandler sslExceptionHandler;
    private final SecurityRestFilter restFilter;

    public OpenSearchSecureSettingsFactory(ThreadPool threadPool, SecurityKeyStore sks, SslExceptionHandler sslExceptionHandler, SecurityRestFilter restFilter) {
        this.threadPool = threadPool;
        this.sks = sks;
        this.sslExceptionHandler = sslExceptionHandler;
        this.restFilter = restFilter;
    }

    public Optional<SecureTransportSettingsProvider> getSecureTransportSettingsProvider(Settings settings) {
        return Optional.of(new SecureTransportSettingsProvider(){

            public Optional<TransportExceptionHandler> buildServerTransportExceptionHandler(Settings settings, Transport transport) {
                return Optional.of(new TransportExceptionHandler(){

                    public void onError(Throwable t) {
                        OpenSearchSecureSettingsFactory.this.sslExceptionHandler.logError(t, false);
                    }
                });
            }

            public Optional<SSLEngine> buildSecureServerTransportEngine(Settings settings, Transport transport) throws SSLException {
                return Optional.of(OpenSearchSecureSettingsFactory.this.sks.createServerTransportSSLEngine());
            }

            public Optional<SSLEngine> buildSecureClientTransportEngine(Settings settings, String hostname, int port) throws SSLException {
                return Optional.of(OpenSearchSecureSettingsFactory.this.sks.createClientTransportSSLEngine(hostname, port));
            }
        });
    }

    public Optional<SecureHttpTransportSettingsProvider> getSecureHttpTransportSettingsProvider(Settings settings) {
        return Optional.of(new SecureHttpTransportSettingsProvider(){

            public Collection<TransportAdapterProvider<HttpServerTransport>> getHttpTransportAdapterProviders(Settings settings) {
                return List.of(new TransportAdapterProvider<HttpServerTransport>(){

                    public String name() {
                        return "RequestDecompressor";
                    }

                    public <C> Optional<C> create(Settings settings, HttpServerTransport transport, Class<C> adapterClass) {
                        if (transport instanceof SecureNetty4HttpServerTransport && ChannelInboundHandlerAdapter.class.isAssignableFrom(adapterClass)) {
                            return Optional.of(new Netty4ConditionalDecompressor());
                        }
                        return Optional.empty();
                    }
                }, new TransportAdapterProvider<HttpServerTransport>(){

                    public String name() {
                        return "HeaderVerifier";
                    }

                    public <C> Optional<C> create(Settings settings, HttpServerTransport transport, Class<C> adapterClass) {
                        if (transport instanceof SecureNetty4HttpServerTransport && ChannelInboundHandlerAdapter.class.isAssignableFrom(adapterClass)) {
                            return Optional.of(new Netty4HttpRequestHeaderVerifier(OpenSearchSecureSettingsFactory.this.restFilter, OpenSearchSecureSettingsFactory.this.threadPool, settings));
                        }
                        return Optional.empty();
                    }
                });
            }

            public Optional<TransportExceptionHandler> buildHttpServerExceptionHandler(Settings settings, HttpServerTransport transport) {
                return Optional.of(new TransportExceptionHandler(){

                    public void onError(Throwable t) {
                        OpenSearchSecureSettingsFactory.this.sslExceptionHandler.logError(t, true);
                    }
                });
            }

            public Optional<SSLEngine> buildSecureHttpServerEngine(Settings settings, HttpServerTransport transport) throws SSLException {
                return Optional.of(OpenSearchSecureSettingsFactory.this.sks.createHTTPSSLEngine());
            }
        });
    }
}

