/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.WriteListener;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.MediaType;
import org.apache.tomcat.util.res.StringManager;

public final class Response {
    private static final StringManager sm = StringManager.getManager(Response.class);
    private static final Log log = LogFactory.getLog(Response.class);
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    int status = 200;
    String message = null;
    final MimeHeaders headers = new MimeHeaders();
    OutputBuffer outputBuffer;
    final Object[] notes = new Object[32];
    volatile boolean committed = false;
    volatile ActionHook hook;
    String contentType = null;
    String contentLanguage = null;
    Charset charset = null;
    String characterEncoding = null;
    long contentLength = -1L;
    private Locale locale = DEFAULT_LOCALE;
    private long contentWritten = 0L;
    private long commitTime = -1L;
    private Exception errorException = null;
    private final AtomicInteger errorState = new AtomicInteger(0);
    Request req;
    volatile WriteListener listener;
    private boolean fireListener = false;
    private boolean registeredForWrite = false;
    private final Object nonBlockingStateLock = new Object();

    public Request getRequest() {
        return this.req;
    }

    public void setRequest(Request request) {
        this.req = request;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    protected void setHook(ActionHook actionHook) {
        this.hook = actionHook;
    }

    public void setNote(int n, Object object) {
        this.notes[n] = object;
    }

    public Object getNote(int n) {
        return this.notes[n];
    }

    public void action(ActionCode actionCode, Object object) {
        if (this.hook != null) {
            if (object == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, object);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean bl) {
        if (bl && !this.committed) {
            this.commitTime = System.currentTimeMillis();
        }
        this.committed = bl;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public void setErrorException(Exception exception) {
        if (this.errorException == null) {
            this.errorException = exception;
        }
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isExceptionPresent() {
        return this.errorException != null;
    }

    public boolean setError() {
        return this.errorState.compareAndSet(0, 1);
    }

    public boolean isError() {
        return this.errorState.get() > 0;
    }

    public boolean isErrorReportRequired() {
        return this.errorState.get() == 1;
    }

    public boolean setErrorReported() {
        return this.errorState.compareAndSet(1, 2);
    }

    public void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.recycle();
    }

    public boolean containsHeader(String string) {
        return this.headers.getHeader(string) != null;
    }

    public void setHeader(String string, String string2) {
        char c = string.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(string, string2)) {
            return;
        }
        this.headers.setValue(string).setString(string2);
    }

    public void addHeader(String string, String string2) {
        this.addHeader(string, string2, null);
    }

    public void addHeader(String string, String string2, Charset charset) {
        char c = string.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(string, string2)) {
            return;
        }
        MessageBytes messageBytes = this.headers.addValue(string);
        if (charset != null) {
            messageBytes.setCharset(charset);
        }
        messageBytes.setString(string2);
    }

    private boolean checkSpecialHeader(String string, String string2) {
        if (string.equalsIgnoreCase("Content-Type")) {
            this.setContentType(string2);
            return true;
        }
        if (string.equalsIgnoreCase("Content-Length")) {
            try {
                long l = Long.parseLong(string2);
                this.setContentLength(l);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public void sendHeaders() {
        this.action(ActionCode.COMMIT, this);
        this.setCommitted(true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.locale = null;
            this.contentLanguage = null;
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.toLanguageTag();
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setCharacterEncoding(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (string == null) {
            this.charset = null;
            this.characterEncoding = null;
            return;
        }
        this.characterEncoding = string;
        try {
            this.charset = B2CConverter.getCharset((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String string) {
        if (string == null) {
            this.contentType = null;
            return;
        }
        MediaType mediaType = null;
        try {
            mediaType = MediaType.parseMediaType(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mediaType == null) {
            this.contentType = string;
            return;
        }
        this.contentType = mediaType.toStringNoCharset();
        String string2 = mediaType.getCharset();
        if (string2 == null) {
            this.contentType = string;
        } else {
            this.contentType = mediaType.toStringNoCharset();
            if ((string2 = string2.trim()).length() > 0) {
                try {
                    this.charset = B2CConverter.getCharset((String)string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.warn((Object)sm.getString("response.encoding.invalid", new Object[]{string2}), (Throwable)unsupportedEncodingException);
                }
            }
        }
    }

    public void setContentTypeNoCharset(String string) {
        this.contentType = string;
    }

    public String getContentType() {
        String string = this.contentType;
        if (string != null && this.charset != null) {
            string = string + ";charset=" + this.characterEncoding;
        }
        return string;
    }

    public void setContentLength(long l) {
        this.contentLength = l;
    }

    public int getContentLength() {
        long l = this.getContentLengthLong();
        if (l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return -1;
    }

    public long getContentLengthLong() {
        return this.contentLength;
    }

    @Deprecated
    public void doWrite(ByteChunk byteChunk) throws IOException {
        this.outputBuffer.doWrite(byteChunk);
        this.contentWritten += (long)byteChunk.getLength();
    }

    public void doWrite(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        this.outputBuffer.doWrite(byteBuffer);
        this.contentWritten += (long)(n - byteBuffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.contentType = null;
        this.contentLanguage = null;
        this.locale = DEFAULT_LOCALE;
        this.charset = null;
        this.characterEncoding = null;
        this.contentLength = -1L;
        this.status = 200;
        this.message = null;
        this.committed = false;
        this.commitTime = -1L;
        this.errorException = null;
        this.errorState.set(0);
        this.headers.recycle();
        this.listener = null;
        Object object = this.nonBlockingStateLock;
        synchronized (object) {
            this.fireListener = false;
            this.registeredForWrite = false;
        }
        this.contentWritten = 0L;
    }

    public long getContentWritten() {
        return this.contentWritten;
    }

    public long getBytesWritten(boolean bl) {
        if (bl) {
            this.action(ActionCode.CLIENT_FLUSH, this);
        }
        return this.outputBuffer.getBytesWritten();
    }

    public WriteListener getWriteListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw new NullPointerException(sm.getString("response.nullWriteListener"));
        }
        if (this.getWriteListener() != null) {
            throw new IllegalStateException(sm.getString("response.writeListenerSet"));
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.action(ActionCode.ASYNC_IS_ASYNC, atomicBoolean);
        if (!atomicBoolean.get()) {
            throw new IllegalStateException(sm.getString("response.notAsync"));
        }
        this.listener = writeListener;
        if (this.isReady()) {
            Object object = this.nonBlockingStateLock;
            synchronized (object) {
                this.registeredForWrite = true;
                this.fireListener = true;
            }
            this.action(ActionCode.DISPATCH_WRITE, null);
            if (!this.req.isRequestThread()) {
                this.action(ActionCode.DISPATCH_EXECUTE, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        if (this.listener == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("response.notNonBlocking"));
            }
            return false;
        }
        boolean bl = false;
        Object object = this.nonBlockingStateLock;
        synchronized (object) {
            if (this.registeredForWrite) {
                this.fireListener = true;
                return false;
            }
            bl = this.checkRegisterForWrite();
            this.fireListener = !bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRegisterForWrite() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Object object = this.nonBlockingStateLock;
        synchronized (object) {
            if (!this.registeredForWrite) {
                this.action(ActionCode.NB_WRITE_INTEREST, atomicBoolean);
                this.registeredForWrite = !atomicBoolean.get();
            }
        }
        return atomicBoolean.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWritePossible() throws IOException {
        boolean bl = false;
        Object object = this.nonBlockingStateLock;
        synchronized (object) {
            this.registeredForWrite = false;
            if (this.fireListener) {
                this.fireListener = false;
                bl = true;
            }
        }
        if (bl) {
            this.listener.onWritePossible();
        }
    }
}

