/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.sampler.SamplerImpl;

public abstract class SamplerParameters {
    private static final Logger LOGGER = Logger.getLogger(SamplerImpl.class.getName());
    protected static final String FILE = "settings-file";
    private final Map<String, String> parameters;

    protected SamplerParameters(String parametersS) {
        if (parametersS == null || parametersS.isEmpty()) {
            this.parameters = null;
        } else {
            this.parameters = new HashMap<String, String>();
            this.parseParameters(parametersS, this.parameters);
        }
    }

    public final String get(String key) {
        return this.parameters == null ? null : this.parameters.get(key);
    }

    public final boolean isEmpty() {
        return this.parameters == null || this.parameters.isEmpty();
    }

    public String toString() {
        return this.parameters == null ? "[no parameters]" : this.parameters.toString();
    }

    protected abstract void parseParameters(String var1, Map<String, String> var2);

    protected static Properties loadProperties(String file) {
        Properties properties = new Properties();
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            properties.load(isr);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read Sampler parameters", e);
        }
        return properties;
    }

    protected static String decode(String value) {
        value = value.replace("%27", "'");
        value = value.replace("%22", "\"");
        value = value.replace("%20", " ");
        value = value.replace("%2C", ",");
        return value;
    }
}

