/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.graalvm.visualvm.jfr.JFRSnapshotsContainer;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotConfigurator;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class AddJFRSnapshotAction
extends SingleDataSourceAction<JFRSnapshotsContainer> {
    private static final String ICON_PATH = "org/graalvm/visualvm/jfr/resources/addJFRSnapshot.png";
    private static final Image ICON = ImageUtilities.loadImage((String)"org/graalvm/visualvm/jfr/resources/addJFRSnapshot.png");
    private boolean tracksSelection = false;
    private static AddJFRSnapshotAction alwaysEnabled;
    private static AddJFRSnapshotAction selectionAware;

    public static synchronized AddJFRSnapshotAction alwaysEnabled() {
        if (alwaysEnabled == null) {
            alwaysEnabled = new AddJFRSnapshotAction();
            alwaysEnabled.putValue("SmallIcon", new ImageIcon(ICON));
            alwaysEnabled.putValue("iconBase", ICON_PATH);
        }
        return alwaysEnabled;
    }

    public static synchronized AddJFRSnapshotAction selectionAware() {
        if (selectionAware == null) {
            selectionAware = new AddJFRSnapshotAction();
            AddJFRSnapshotAction.selectionAware.tracksSelection = true;
        }
        return selectionAware;
    }

    public void actionPerformed(JFRSnapshotsContainer contanier, ActionEvent e) {
        JFRSnapshotConfigurator newSnapshotConfiguration = JFRSnapshotConfigurator.defineJFRSnapshot();
        if (newSnapshotConfiguration != null) {
            JFRSnapshotProvider.createJFRSnapshot(newSnapshotConfiguration.getJFRSnapshotFile(), newSnapshotConfiguration.getDisplayname(), newSnapshotConfiguration.deleteSourceFile());
        }
    }

    protected boolean isEnabled(JFRSnapshotsContainer container) {
        return true;
    }

    protected void initialize() {
        if (this.tracksSelection) {
            super.initialize();
        }
    }

    private AddJFRSnapshotAction() {
        super(JFRSnapshotsContainer.class);
        this.putValue("Name", NbBundle.getMessage(AddJFRSnapshotAction.class, (String)"LBL_Add_VM_Coredump"));
        this.putValue("ShortDescription", NbBundle.getMessage(AddJFRSnapshotAction.class, (String)"ToolTip_Add_VM_Coredump"));
    }
}

