/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Atom
extends Point3fi
implements Node {
    public static final int ATOM_INFRAME = 1;
    public static final int ATOM_VISSET = 2;
    public static final int ATOM_VISIBLE = 4;
    public static final int ATOM_NOTHIDDEN = 8;
    public static final int ATOM_NOFLAGS = -64;
    public static final int ATOM_INFRAME_NOTHIDDEN = 9;
    public static final int ATOM_SHAPE_VIS_MASK = -10;
    public static final int RADIUS_MAX = 16;
    public static final float RADIUS_GLOBAL = 16.1f;
    public static short MAD_GLOBAL = (short)32200;
    public char altloc = '\u0000';
    public byte atomID;
    int atomSite;
    public Group group;
    private float userDefinedVanDerWaalRadius;
    byte valence;
    short atomNumberFlags;
    public BS atomSymmetry;
    private int formalChargeAndFlags;
    private static final int CHARGE_OFFSET = 24;
    private static final int FLAG_MASK = 15;
    private static final int VIBRATION_VECTOR_FLAG = 1;
    private static final int IS_HETERO_FLAG = 2;
    private static final int NEG_DISORDER_FLAG = 4;
    private static final int CIP_CHIRALITY_OFFSET = 4;
    private static final int CIP_CHIRALITY_MASK = 496;
    private static final int CIP_CHIRALITY_RULE_OFFSET = 9;
    private static final int CIP_CHIRALITY_RULE_MASK = 3584;
    private static final int CIP_MASK = 4080;
    public short madAtom;
    public short colixAtom;
    public byte paletteID;
    public Bond[] bonds;
    private int nBondsDisplayed;
    public int nBackbonesDisplayed;
    public int clickabilityFlags;
    public int shapeVisibilityFlags;
    public static final int ID_U = 1;
    public static final int ID_ALL = 2;
    public static final int ID_XTAL = 3;
    public static final int ID_CHIME = 4;
    public static final int ID_ATOMS = 5;

    public Atom() {
        this.paletteID = PAL.CPK.id;
        this.nBondsDisplayed = 0;
        this.nBackbonesDisplayed = 0;
    }

    public Atom setAtom(int modelIndex, int atomIndex, P3 xyz, float radius, BS atomSymmetry, int atomSite, short atomicAndIsotopeNumber, int formalCharge, boolean isHetero, boolean isNegDisorder) {
        this.mi = (short)modelIndex;
        this.atomSymmetry = atomSymmetry;
        this.atomSite = atomSite;
        this.i = atomIndex;
        this.atomNumberFlags = atomicAndIsotopeNumber;
        if (isHetero) {
            this.formalChargeAndFlags = 2;
        }
        if (formalCharge != 0 && formalCharge != Integer.MIN_VALUE) {
            this.setFormalCharge(formalCharge);
        }
        this.userDefinedVanDerWaalRadius = radius;
        if (xyz != null) {
            this.setT(xyz);
        }
        return this;
    }

    public final void setShapeVisibility(int flag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= flag) : (this.shapeVisibilityFlags &= ~flag);
    }

    public boolean isCovalentlyBonded(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (!this.bonds[i].isCovalent() || this.bonds[i].getOtherAtom(this) != atomOther) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBonded(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (this.bonds[i].getOtherAtom(this) != atomOther) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (this.bonds[i].getOtherAtom(atomOther) == null) continue;
                return this.bonds[i];
            }
        }
        return null;
    }

    void addDisplayedBond(int stickVisibilityFlag, boolean isVisible) {
        this.nBondsDisplayed += isVisible ? 1 : -1;
        this.setShapeVisibility(stickVisibilityFlag, this.nBondsDisplayed > 0);
    }

    void deleteBond(Bond bond) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (this.bonds[i] != bond) continue;
                this.deleteBondAt(i);
                return;
            }
        }
    }

    private void deleteBondAt(int i) {
        int j;
        this.setCIPChirality(0);
        int newLength = this.bonds.length - 1;
        if (newLength == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondsNew = new Bond[newLength];
        for (j = 0; j < i; ++j) {
            bondsNew[j] = this.bonds[j];
        }
        while (j < newLength) {
            bondsNew[j] = this.bonds[j + 1];
            ++j;
        }
        this.bonds = bondsNew;
    }

    @Override
    public int getBondedAtomIndex(int bondIndex) {
        return this.bonds[bondIndex].getOtherAtom((Atom)this).i;
    }

    public void setMadAtom(Viewer vwr, RadiusData rd) {
        this.madAtom = this.calculateMad(vwr, rd);
    }

    public short calculateMad(Viewer vwr, RadiusData rd) {
        if (rd == null) {
            return 0;
        }
        float f = rd.value;
        if (f == 0.0f) {
            return 0;
        }
        switch (rd.factorType) {
            case SCREEN: {
                return (short)f;
            }
            case FACTOR: 
            case OFFSET: {
                float r = 0.0f;
                switch (rd.vdwType) {
                    case TEMP: {
                        float tmax = vwr.ms.getBfactor100Hi();
                        r = tmax > 0.0f ? (float)this.getBfactor100() / tmax : 0.0f;
                        break;
                    }
                    case HYDRO: {
                        r = Math.abs(this.getHydrophobicity());
                        break;
                    }
                    case BONDING: {
                        r = this.getBondingRadius();
                        break;
                    }
                    case ADPMIN: 
                    case ADPMAX: {
                        r = this.getADPMinMax(rd.vdwType == VDW.ADPMAX);
                        break;
                    }
                    default: {
                        r = this.getVanderwaalsRadiusFloat(vwr, rd.vdwType);
                    }
                }
                if (rd.factorType == RadiusData.EnumType.FACTOR) {
                    f *= r;
                    break;
                }
                f += r;
                break;
            }
            case ABSOLUTE: {
                if (f != 16.1f) break;
                return MAD_GLOBAL;
            }
        }
        short mad = (short)(f < 0.0f ? f : f * 2000.0f);
        if (mad < 0 && f > 0.0f) {
            mad = 0;
        }
        return mad;
    }

    public float getADPMinMax(boolean isMax) {
        Object[] tensors = this.getTensors();
        if (tensors == null) {
            return 0.0f;
        }
        Tensor t = (Tensor)tensors[0];
        if (t == null || t.iType != 1) {
            return 0.0f;
        }
        if (this.group.chain.model.ms.isModulated(this.i) && t.isUnmodulated) {
            t = (Tensor)tensors[1];
        }
        return t.getFactoredValue(isMax ? 2 : 1);
    }

    public Object[] getTensors() {
        return this.group.chain.model.ms.getAtomTensorList(this.i);
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    @Override
    public Edge[] getEdges() {
        return this.bonds == null ? new Edge[]{} : this.bonds;
    }

    @Override
    public int getBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public void setTranslucent(boolean isTranslucent, float translucentLevel) {
        this.colixAtom = C.getColixTranslucent3(this.colixAtom, isTranslucent, translucentLevel);
    }

    @Override
    public int getElementNumber() {
        return Elements.getElementNumber(this.atomNumberFlags);
    }

    @Override
    public int getIsotopeNumber() {
        return Elements.getIsotopeNumber(this.atomNumberFlags);
    }

    @Override
    public int getAtomicAndIsotopeNumber() {
        return this.atomNumberFlags;
    }

    public void setAtomicAndIsotopeNumber(int n) {
        if (n < 0 || (n & 0x7F) >= Elements.elementNumberMax || n > Short.MAX_VALUE) {
            n = 0;
        }
        this.atomNumberFlags = (short)n;
    }

    public String getElementSymbolIso(boolean withIsotope) {
        return Elements.elementSymbolFromNumber(withIsotope ? this.atomNumberFlags : this.atomNumberFlags & 0x7F);
    }

    public String getElementSymbol() {
        return this.getElementSymbolIso(true);
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 2) != 0;
    }

    public boolean hasVibration() {
        return (this.formalChargeAndFlags & 1) != 0;
    }

    public void setFormalCharge(int charge) {
        this.formalChargeAndFlags = this.formalChargeAndFlags & 0xF | (charge == Integer.MIN_VALUE ? 0 : (charge > 7 ? 7 : (charge < -3 ? -3 : charge))) << 24;
    }

    void setVibrationVector() {
        this.formalChargeAndFlags |= 1;
    }

    void setNegativeDisorder() {
        this.formalChargeAndFlags |= 4;
    }

    boolean isNegativeDisorder() {
        return (this.formalChargeAndFlags & 4) != 0;
    }

    @Override
    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 24;
    }

    public int getOccupancy100() {
        float[] occupancies = this.group.chain.model.ms.occupancies;
        return occupancies == null ? 100 : Math.round(occupancies[this.i]);
    }

    public boolean isOccupied() {
        float[] occupancies = this.group.chain.model.ms.occupancies;
        return occupancies == null || occupancies[this.i] >= 50.0f;
    }

    public int getBfactor100() {
        short[] bfactor100s = this.group.chain.model.ms.bfactor100s;
        return bfactor100s == null ? 0 : bfactor100s[this.i];
    }

    public float getHydrophobicity() {
        float[] values = this.group.chain.model.ms.hydrophobicities;
        return values == null ? Elements.getHydrophobicity(this.group.groupID) : values[this.i];
    }

    public boolean setRadius(float radius) {
        this.userDefinedVanDerWaalRadius = radius > 0.0f ? radius : Float.NaN;
        return !Float.isNaN(this.userDefinedVanDerWaalRadius);
    }

    public void delete(BS bsBonds) {
        this.valence = (byte)-1;
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                Bond bond = this.bonds[i];
                bond.getOtherAtom(this).deleteBond(bond);
                bsBonds.set(bond.index);
            }
        }
        this.bonds = null;
    }

    @Override
    public boolean isDeleted() {
        return this.valence < 0;
    }

    public void setValence(int nBonds) {
        if (!this.isDeleted()) {
            this.valence = (byte)(nBonds < 0 ? 0 : (nBonds <= 127 ? nBonds : 127));
        }
    }

    @Override
    public int getValence() {
        return this.isDeleted() ? -1 : (this.valence > 0 ? (int)this.valence : this.getValenceAromatic(true));
    }

    int getValenceAromatic(boolean checkAromatic) {
        if (this.isDeleted()) {
            return -1;
        }
        int n = this.valence;
        if (n == 0 && this.bonds != null) {
            int npartial = 0;
            int i = this.bonds.length;
            while (--i >= 0) {
                n += this.bonds[i].getValence();
                if (!checkAromatic || !this.bonds[i].is(515)) continue;
                ++npartial;
            }
            if (n > 0 && n < 3 && npartial != 0) {
                ++n;
            }
        }
        return n;
    }

    @Override
    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond b = this.bonds[i];
            if (!b.isCovalentNotPartial0() || b.getOtherAtom(this).isDeleted()) continue;
            ++n;
        }
        return n;
    }

    public int getCovalentOrPartialBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond b = this.bonds[i];
            if (!b.isCovalent() || b.getOtherAtom(this).isDeleted()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond b = this.bonds[i];
            if (!b.isCovalentNotPartial0()) continue;
            Atom a = this.bonds[i].getOtherAtom(this);
            if (a.valence < 0 || a.getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getImplicitHydrogenCount() {
        return this.group.chain.model.ms.getMissingHydrogenCount(this, false);
    }

    @Override
    public int getTotalHydrogenCount() {
        return this.getCovalentHydrogenCount() + this.getImplicitHydrogenCount();
    }

    @Override
    public int getTotalValence() {
        int v = this.getValence();
        if (v < 0) {
            return v;
        }
        int h = this.getImplicitHydrogenCount();
        int sp2 = this.group.chain.model.ms.aaRet[4];
        return v + h + sp2;
    }

    @Override
    public int getCovalentBondCountPlusMissingH() {
        return this.getCovalentBondCount() + this.getImplicitHydrogenCount();
    }

    int getTargetValence() {
        switch (this.getElementNumber()) {
            case 6: 
            case 14: 
            case 32: {
                return 4;
            }
            case 5: 
            case 7: 
            case 15: {
                return 3;
            }
            case 8: 
            case 16: {
                return 2;
            }
            case 1: 
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return 1;
            }
        }
        return -1;
    }

    public float getDimensionValue(int dimension) {
        return dimension == 0 ? this.x : (dimension == 1 ? this.y : this.z);
    }

    public float getVanderwaalsRadiusFloat(Viewer vwr, VDW type) {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? (float)vwr.getVanderwaalsMarType(this.atomNumberFlags, this.getVdwType(type)) / 1000.0f : this.userDefinedVanDerWaalRadius;
    }

    private VDW getVdwType(VDW type) {
        switch (type) {
            case AUTO: {
                type = this.group.chain.model.ms.getDefaultVdwType(this.mi);
                break;
            }
            case NOJMOL: {
                type = this.group.chain.model.ms.getDefaultVdwType(this.mi);
                if (type != VDW.AUTO_JMOL) break;
                type = VDW.AUTO_BABEL;
            }
        }
        return type;
    }

    public float getBondingRadius() {
        float[] rr = this.group.chain.model.ms.bondingRadii;
        float r = rr == null || this.i >= rr.length ? 0.0f : rr[this.i];
        return r == 0.0f ? Elements.getBondingRadius(this.atomNumberFlags, this.getFormalCharge()) : r;
    }

    float getVolume(Viewer vwr, VDW vType) {
        float r1;
        float f = r1 = vType == null ? this.userDefinedVanDerWaalRadius : Float.NaN;
        if (Float.isNaN(r1)) {
            r1 = (float)vwr.getVanderwaalsMarType(this.getElementNumber(), this.getVdwType(vType)) / 1000.0f;
        }
        double volume = 0.0;
        if (this.bonds != null) {
            for (int j = 0; j < this.bonds.length; ++j) {
                float d;
                float r2;
                if (!this.bonds[j].isCovalent()) continue;
                Atom atom2 = this.bonds[j].getOtherAtom(this);
                float f2 = r2 = vType == null ? atom2.userDefinedVanDerWaalRadius : Float.NaN;
                if (Float.isNaN(r2)) {
                    r2 = (float)vwr.getVanderwaalsMarType(atom2.getElementNumber(), atom2.getVdwType(vType)) / 1000.0f;
                }
                if ((d = this.distance(atom2)) > r1 + r2) continue;
                if (d + r1 <= r2) {
                    return 0.0f;
                }
                double h = (double)r1 - (double)(r1 * r1 + d * d - r2 * r2) / (2.0 * (double)d);
                volume -= 1.0471975511965976 * h * h * ((double)(3.0f * r1) - h);
            }
        }
        return (float)(volume + 4.1887902047863905 * (double)r1 * (double)r1 * (double)r1);
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public int getAtomSite() {
        return this.atomSite;
    }

    @Override
    public void getGroupBits(BS bs) {
        this.group.setAtomBits(bs);
    }

    @Override
    public String getAtomName() {
        return this.atomID > 0 ? Group.specialAtomNames[this.atomID] : (this.group.chain.model.ms.atomNames == null ? "" : this.group.chain.model.ms.atomNames[this.i]);
    }

    @Override
    public String getAtomType() {
        String[] atomTypes = this.group.chain.model.ms.atomTypes;
        String type = atomTypes == null ? null : atomTypes[this.i];
        return type == null ? this.getAtomName() : type;
    }

    @Override
    public int getAtomNumber() {
        int[] atomSerials = this.group.chain.model.ms.atomSerials;
        return atomSerials == null ? this.i : atomSerials[this.i];
    }

    public int getSeqID() {
        int[] ids = this.group.chain.model.ms.atomSeqIDs;
        return ids == null ? 0 : ids[this.i];
    }

    public boolean isVisible(int flags) {
        return (this.shapeVisibilityFlags & flags) == flags;
    }

    public float getPartialCharge() {
        float[] partialCharges = this.group.chain.model.ms.partialCharges;
        return partialCharges == null ? 0.0f : partialCharges[this.i];
    }

    public int getSymmetryTranslation(int symop, int[] cellRange, int nOps) {
        int pt = symop;
        for (int i = 0; i < cellRange.length; ++i) {
            if (!this.atomSymmetry.get(pt += nOps)) continue;
            return cellRange[i];
        }
        return 0;
    }

    public int getCellTranslation(int cellNNN, int[] cellRange, int nOps) {
        int pt = nOps;
        for (int i = 0; i < cellRange.length; ++i) {
            int j = 0;
            while (j < nOps) {
                if (this.atomSymmetry.get(pt) && cellRange[i] == cellNNN) {
                    return cellRange[i];
                }
                ++j;
                ++pt;
            }
        }
        return 0;
    }

    String getSymmetryOperatorList(boolean isAll) {
        int i;
        String str = "";
        ModelSet f = this.group.chain.model.ms;
        int nOps = f.getModelSymmetryCount(this.mi);
        if (nOps == 0 || this.atomSymmetry == null) {
            return "";
        }
        int[] cellRange = f.getModelCellRange(this.mi);
        int pt = nOps;
        int n = cellRange == null ? 1 : cellRange.length;
        BS bs = isAll ? null : new BS();
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < nOps; ++j) {
                if (!this.atomSymmetry.get(pt++)) continue;
                if (isAll) {
                    str = str + "," + (j + 1) + (cellRange == null ? 555 : cellRange[i]);
                    continue;
                }
                bs.set(j + 1);
            }
        }
        if (!isAll) {
            i = bs.nextSetBit(0);
            while (i >= 0) {
                str = str + "," + i;
                i = bs.nextSetBit(i + 1);
            }
        }
        return str.length() == 0 ? "" : str.substring(1);
    }

    @Override
    public int getModelIndex() {
        return this.mi;
    }

    @Override
    public int getMoleculeNumber(boolean inModel) {
        return this.group.chain.model.ms.getMoleculeIndex(this.i, inModel) + 1;
    }

    private float getFractionalCoord(boolean fixJavaFloat, char ch, boolean ignoreOffset, P3 pt) {
        pt = this.getFractionalCoordPt(fixJavaFloat, ignoreOffset, pt);
        return ch == 'X' ? pt.x : (ch == 'Y' ? pt.y : pt.z);
    }

    @Override
    public P3 getXYZ() {
        return this;
    }

    public P3 getFractionalCoordPt(boolean fixJavaFloat, boolean ignoreOffset, P3 pt) {
        SymmetryInterface c = this.getUnitCell();
        if (pt == null) {
            pt = P3.newP(this);
        } else {
            pt.setT(this);
        }
        if (c != null) {
            c = c.getUnitCellMultiplied();
            c.toFractional(pt, ignoreOffset);
            if (fixJavaFloat) {
                PT.fixPtFloats(pt, 100000.0f);
            }
        }
        return pt;
    }

    SymmetryInterface getUnitCell() {
        return this.group.chain.model.ms.getUnitCellForAtom(this.i);
    }

    private float getFractionalUnitCoord(boolean fixJavaFloat, char ch, P3 pt) {
        pt = this.getFractionalUnitCoordPt(fixJavaFloat, false, pt);
        return ch == 'X' ? pt.x : (ch == 'Y' ? pt.y : pt.z);
    }

    P3 getFractionalUnitCoordPt(boolean fixJavaFloat, boolean asCartesian, P3 pt) {
        SymmetryInterface c = this.getUnitCell();
        if (pt == null) {
            pt = P3.newP(this);
        } else {
            pt.setT(this);
        }
        if (c == null) {
            return pt;
        }
        c = c.getUnitCellMultiplied();
        if (this.group.chain.model.isJmolDataFrame) {
            c.toFractional(pt, false);
            if (asCartesian) {
                c.toCartesian(pt, false);
            }
        } else {
            c.toUnitCell(pt, null);
            if (!asCartesian) {
                c.toFractional(pt, false);
            }
        }
        if (fixJavaFloat) {
            PT.fixPtFloats(pt, asCartesian ? 10000.0f : 100000.0f);
        }
        return pt;
    }

    float getFractionalUnitDistance(T3 pt, T3 ptTemp1, T3 ptTemp2) {
        SymmetryInterface c = this.getUnitCell();
        if (c == null) {
            return this.distance(pt);
        }
        ptTemp1.setT(this);
        ptTemp2.setT(pt);
        if (this.group.chain.model.isJmolDataFrame) {
            c.toFractional(ptTemp1, true);
            c.toFractional(ptTemp2, true);
        } else {
            c.toUnitCell(ptTemp1, null);
            c.toUnitCell(ptTemp2, null);
        }
        return ptTemp1.distance(ptTemp2);
    }

    void setFractionalCoord(int tok, float fValue, boolean asAbsolute) {
        SymmetryInterface c = this.getUnitCell();
        if (c != null) {
            c.toFractional(this, asAbsolute);
        }
        switch (tok) {
            case 1111492612: 
            case 1111492615: {
                this.x = fValue;
                break;
            }
            case 1111492613: 
            case 1111492616: {
                this.y = fValue;
                break;
            }
            case 1111492614: 
            case 1111492617: {
                this.z = fValue;
            }
        }
        if (c != null) {
            c.toCartesian(this, asAbsolute);
        }
    }

    void setFractionalCoordTo(P3 ptNew, boolean asAbsolute) {
        this.setFractionalCoordPt(this, ptNew, asAbsolute);
    }

    public void setFractionalCoordPt(P3 pt, P3 ptNew, boolean asAbsolute) {
        pt.setT(ptNew);
        SymmetryInterface c = this.getUnitCell();
        if (c != null) {
            c.toCartesian(pt, asAbsolute && !this.group.chain.model.isJmolDataFrame);
        }
    }

    boolean isCursorOnTopOf(int xCursor, int yCursor, int minRadius, Atom competitor) {
        int r2;
        int dx;
        int dx2;
        int r = this.sD / 2;
        if (r < minRadius) {
            r = minRadius;
        }
        if ((dx2 = (dx = this.sX - xCursor) * dx) > (r2 = r * r)) {
            return false;
        }
        int dy = this.sY - yCursor;
        int dy2 = dy * dy;
        int dz2 = r2 - (dx2 + dy2);
        if (dz2 < 0) {
            return false;
        }
        if (competitor == null) {
            return true;
        }
        int z = this.sZ;
        int zCompetitor = competitor.sZ;
        int rCompetitor = competitor.sD / 2;
        if (z < zCompetitor - rCompetitor) {
            return true;
        }
        int dxCompetitor = competitor.sX - xCursor;
        int dx2Competitor = dxCompetitor * dxCompetitor;
        int dyCompetitor = competitor.sY - yCursor;
        int dy2Competitor = dyCompetitor * dyCompetitor;
        int r2Competitor = rCompetitor * rCompetitor;
        int dz2Competitor = r2Competitor - (dx2Competitor + dy2Competitor);
        return (double)z - Math.sqrt(dz2) < (double)zCompetitor - Math.sqrt(dz2Competitor);
    }

    public String getInfo() {
        return this.getIdentity(2);
    }

    public String getIdentityXYZ(P3 pt, int mode) {
        pt = mode == 3 || this.group.chain.model.isJmolDataFrame ? this.getFractionalCoordPt(!this.group.chain.model.ms.vwr.g.legacyJavaFloat, false, pt) : this;
        String s = (mode == 3 ? "" : this.getIdentity(mode) + " ") + PT.formatF(pt.x, 0, 3, true, true) + " " + PT.formatF(pt.y, 0, 3, true, true) + " " + PT.formatF(pt.z, 0, 3, true, true);
        return s;
    }

    String getIdentity(int mode) {
        SB info = new SB();
        String group3 = this.getGroup3(true);
        if (group3 != null && group3.length() > 0 && (!group3.equals("UNK") || this.group.chain.model.isBioModel)) {
            int chainID;
            info.append("[");
            info.append(group3);
            info.append("]");
            String seqcodeString = this.group.getSeqcodeString();
            if (seqcodeString != null) {
                info.append(seqcodeString);
            }
            if ((chainID = this.group.chain.chainID) != 0 && chainID != 32) {
                info.append(":");
                String s = this.getChainIDStr();
                if (chainID >= 256) {
                    s = PT.esc(s);
                }
                info.append(s);
            }
            if (mode != 2 && mode != 5) {
                return info.toString();
            }
            info.append(".");
        }
        info.append(this.getAtomName());
        if (info.length() == 0) {
            info.append(this.getElementSymbolIso(false));
            info.append(" ");
            info.appendI(this.getAtomNumber());
        }
        if (mode == 2) {
            if (this.altloc != '\u0000') {
                info.append("%");
                info.appendC(this.altloc);
            }
            if (this.group.chain.model.ms.mc > 1 && !this.group.chain.model.isJmolDataFrame) {
                info.append("/");
                info.append(this.getModelNumberForLabel());
            }
            info.append(" #");
            info.appendI(this.getAtomNumber());
        }
        return info.toString();
    }

    @Override
    public String getGroup3(boolean allowNull) {
        String group3 = this.group.getGroup3();
        return allowNull || group3 != null && group3.length() > 0 ? group3 : "UNK";
    }

    @Override
    public String getGroup1(char c0) {
        char c = this.group.getGroup1();
        return c != '\u0000' ? "" + c : (c0 != '\u0000' ? "" + c0 : "");
    }

    @Override
    public char getBioSmilesType() {
        return (char)(this.group.isProtein() ? 112 : (this.group.isDna() ? 100 : (this.group.isRna() ? 114 : (this.group.isCarbohydrate() ? 99 : 32))));
    }

    @Override
    public boolean isPurine() {
        return this.group.isPurine();
    }

    @Override
    public boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    @Override
    public int getResno() {
        return this.group.getResno();
    }

    public boolean isClickable() {
        return this.checkVisible() && this.clickabilityFlags != 0 && ((this.shapeVisibilityFlags | this.group.shapeVisibilityFlags) & this.clickabilityFlags) != 0;
    }

    public void setClickable(int flag) {
        if (flag == 0) {
            this.clickabilityFlags = 0;
        } else {
            this.clickabilityFlags |= flag;
            if (flag != 1040384) {
                this.shapeVisibilityFlags |= flag;
            }
        }
    }

    public boolean checkVisible() {
        if (this.isVisible(2)) {
            return this.isVisible(4);
        }
        boolean isVis = this.isVisible(9);
        if (isVis) {
            int flags = this.shapeVisibilityFlags;
            if (this.group.shapeVisibilityFlags != 0 && (this.group.shapeVisibilityFlags != 8192 || this.isLeadAtom())) {
                flags |= this.group.shapeVisibilityFlags;
            }
            if ((flags &= 0xFFFFFFF6) == 32 && this.clickabilityFlags == 0) {
                flags = 0;
            }
            boolean bl = isVis = flags != 0;
            if (isVis) {
                this.shapeVisibilityFlags |= 4;
            }
        }
        this.shapeVisibilityFlags |= 2;
        return isVis;
    }

    @Override
    public boolean isLeadAtom() {
        return this.group.isLeadAtom(this.i);
    }

    @Override
    public int getChainID() {
        return this.group.chain.chainID;
    }

    @Override
    public String getChainIDStr() {
        return this.group.chain.getIDStr();
    }

    public int getSurfaceDistance100() {
        return this.group.chain.model.ms.getSurfaceDistance100(this.i);
    }

    public Vibration getVibrationVector() {
        return this.group.chain.model.ms.getVibration(this.i, false);
    }

    public JmolModulationSet getModulation() {
        return this.group.chain.model.ms.getModulation(this.i);
    }

    public String getModelNumberForLabel() {
        return this.group.chain.model.ms.getModelNumberForAtomLabel(this.mi);
    }

    public int getModelNumber() {
        return this.group.chain.model.ms.getModelNumber(this.mi) % 1000000;
    }

    @Override
    public String getBioStructureTypeName() {
        return this.group.getProteinStructureType().getBioStructureTypeName(true);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return this.i;
    }

    public Atom findAromaticNeighbor(int notAtomIndex) {
        if (this.bonds == null) {
            return null;
        }
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond bondT = this.bonds[i];
            Atom a = bondT.getOtherAtom(this);
            if (!bondT.isAromatic() || a.i == notAtomIndex) continue;
            return a;
        }
        return null;
    }

    public int atomPropertyInt(int tokWhat) {
        switch (tokWhat) {
            case 1094715393: {
                return this.getAtomNumber();
            }
            case 1094713365: {
                return this.getSeqID();
            }
            case 1094713346: {
                return this.atomID;
            }
            case 1094713368: {
                return Math.max(0, this.altloc - 32);
            }
            case 1094713347: {
                return this.i;
            }
            case 1228931586: {
                return this.getCovalentBondCount();
            }
            case 1094713351: {
                return this.group.chain.chainNo;
            }
            case 1765808134: {
                return this.group.chain.model.ms.vwr.gdata.getColorArgbOrGray(this.colixAtom);
            }
            case 1086326789: 
            case 1094715402: {
                return this.getElementNumber();
            }
            case 1094713353: {
                return this.atomNumberFlags;
            }
            case 1228935687: {
                return this.group.chain.model.fileIndex + 1;
            }
            case 1631586315: {
                return this.getFormalCharge();
            }
            case 1094713356: {
                return this.group.groupID;
            }
            case 1094713357: {
                return this.group.groupIndex;
            }
            case 1094717454: {
                return this.getModelNumber();
            }
            case -1094717454: {
                return this.group.chain.model.ms.modelFileNumbers[this.mi];
            }
            case 1094713359: {
                return this.mi;
            }
            case 0x41400010: {
                return this.getMoleculeNumber(true);
            }
            case 0x41400011: {
                return this.group.getMonomerIndex() + 1;
            }
            case 1128269825: {
                return this.getOccupancy100();
            }
            case 1094713362: {
                return this.group.getBioPolymerIndexInModel() + 1;
            }
            case 1094713363: {
                return this.group.getBioPolymerLength();
            }
            case 1665140738: {
                return this.getRasMolRadius();
            }
            case 1094715412: {
                return this.getResno();
            }
            case 1094713366: {
                return this.getAtomSite();
            }
            case 1639976963: {
                return this.group.getProteinStructureType().getId();
            }
            case 1237320707: {
                return this.group.getProteinStructureSubType().getId();
            }
            case 1094713367: {
                return this.group.getStrucNo();
            }
            case 1296041985: {
                return this.getSymOp();
            }
            case 1094715418: {
                return this.getValence();
            }
        }
        return 0;
    }

    int getSymOp() {
        return this.atomSymmetry == null ? 0 : this.atomSymmetry.nextSetBit(0) + 1;
    }

    public float atomPropertyFloat(Viewer vwr, int tokWhat, P3 ptTemp) {
        switch (tokWhat) {
            case 1111490561: {
                return this.getADPMinMax(true);
            }
            case 0x42400002: {
                return this.getADPMinMax(false);
            }
            case 1111492609: 
            case 1111492629: {
                return this.x;
            }
            case 1111492610: 
            case 1111492630: {
                return this.y;
            }
            case 1111492611: 
            case 1111492631: {
                return this.z;
            }
            case 1111490587: {
                return this.group.chain.model.ms.getAtomicDSSRData(this.i);
            }
            case 1112150019: 
            case 1112150020: 
            case 1112150021: 
            case 1112152066: 
            case 1112152070: 
            case 1112152071: 
            case 1112152073: 
            case 1112152074: 
            case 1112152076: 
            case 1112152078: 
            case 1114249217: 
            case 1649022989: {
                return vwr.shm.getAtomShapeValue(tokWhat, this.group, this.i);
            }
            case 1111492618: {
                return this.getBondingRadius();
            }
            case 1111490563: {
                return vwr.getNMRCalculation().getChemicalShift(this);
            }
            case 0x42400004: {
                return Elements.getCovalentRadius(this.atomNumberFlags);
            }
            case 1111490565: 
            case 1111490574: 
            case 1111490576: {
                return this.group.getGroupParameter(tokWhat);
            }
            case 1111492612: 
            case 1111492615: {
                return this.getFractionalCoord(!vwr.g.legacyJavaFloat, 'X', false, ptTemp);
            }
            case 1111492613: 
            case 1111492616: {
                return this.getFractionalCoord(!vwr.g.legacyJavaFloat, 'Y', false, ptTemp);
            }
            case 1111492614: 
            case 1111492617: {
                return this.getFractionalCoord(!vwr.g.legacyJavaFloat, 'Z', false, ptTemp);
            }
            case 1113589786: {
                return this.getHydrophobicity();
            }
            case 1111490566: {
                return vwr.getNMRCalculation().getMagneticShielding(this);
            }
            case 1111490567: {
                return this.getMass();
            }
            case 1128269825: {
                return (float)this.getOccupancy100() / 100.0f;
            }
            case 1111492619: {
                return this.getPartialCharge();
            }
            case 1111490568: 
            case 1111490569: 
            case 1111490570: {
                if (this.group.chain.model.isJmolDataFrame && this.group.chain.model.jmolFrameType.startsWith("plot ramachandran")) {
                    switch (tokWhat) {
                        case 1111490569: {
                            return this.getFractionalCoord(!vwr.g.legacyJavaFloat, 'X', false, ptTemp);
                        }
                        case 1111490570: {
                            return this.getFractionalCoord(!vwr.g.legacyJavaFloat, 'Y', false, ptTemp);
                        }
                        case 1111490568: {
                            float omega = this.getFractionalCoord(!vwr.g.legacyJavaFloat, 'Z', false, ptTemp) - 180.0f;
                            return omega < -180.0f ? 360.0f + omega : omega;
                        }
                    }
                }
                return this.group.getGroupParameter(tokWhat);
            }
            case 1112152075: 
            case 1665140738: {
                return this.getRadius();
            }
            case 1111490571: {
                return vwr.antialiased ? this.sX / 2 : this.sX;
            }
            case 1111490572: {
                return vwr.getScreenHeight() - (vwr.antialiased ? this.sY / 2 : this.sY);
            }
            case 1111490573: {
                return vwr.antialiased ? this.sZ / 2 : this.sZ;
            }
            case 1113589787: {
                return vwr.slm.isAtomSelected(this.i) ? 1 : 0;
            }
            case 1111490575: {
                vwr.ms.getSurfaceDistanceMax();
                return (float)this.getSurfaceDistance100() / 100.0f;
            }
            case 1111492620: {
                return (float)this.getBfactor100() / 100.0f;
            }
            case 1111490577: {
                return this.getFractionalUnitCoord(!vwr.g.legacyJavaFloat, 'X', ptTemp);
            }
            case 1111490578: {
                return this.getFractionalUnitCoord(!vwr.g.legacyJavaFloat, 'Y', ptTemp);
            }
            case 1111490579: {
                return this.getFractionalUnitCoord(!vwr.g.legacyJavaFloat, 'Z', ptTemp);
            }
            case 1648363544: {
                return this.getVanderwaalsRadiusFloat(vwr, VDW.AUTO);
            }
            case 1648361473: {
                Vibration v = this.getVibrationVector();
                return v == null ? 0.0f : v.length() * vwr.getFloat(1648361473);
            }
            case 1111492626: {
                return this.getVib('x');
            }
            case 1111492627: {
                return this.getVib('y');
            }
            case 1111492628: {
                return this.getVib('z');
            }
            case 1111490583: {
                return this.getVib('X');
            }
            case 1111490584: {
                return this.getVib('Y');
            }
            case 1111490585: {
                return this.getVib('Z');
            }
            case 1111490586: {
                return this.getVib('O');
            }
            case 1111490580: {
                return this.getVib('1');
            }
            case 1111490581: {
                return this.getVib('2');
            }
            case 1111490582: {
                return this.getVib('3');
            }
            case 1312817669: {
                return this.getVolume(vwr, VDW.AUTO);
            }
            case 0x4440000E: 
            case 0x44400010: 
            case 1145047049: 
            case 1145047050: 
            case 1145047052: 
            case 1145047053: 
            case 1145047055: {
                T3 v3 = this.atomPropertyTuple(vwr, tokWhat, ptTemp);
                return v3 == null ? -1.0f : v3.length();
            }
        }
        return this.atomPropertyInt(tokWhat);
    }

    public float getVib(char ch) {
        return this.group.chain.model.ms.getVibCoord(this.i, ch);
    }

    public int getNominalMass() {
        int mass = this.getIsotopeNumber();
        return mass > 0 ? mass : Elements.getNaturalIsotope(this.getElementNumber());
    }

    @Override
    public float getMass() {
        float mass = this.getIsotopeNumber();
        return mass > 0.0f ? mass : Elements.getAtomicMass(this.getElementNumber());
    }

    public String atomPropertyString(Viewer vwr, int tokWhat) {
        switch (tokWhat) {
            case 1153433601: {
                return this.getIdentity(5);
            }
            case 1086324739: {
                char ch = this.altloc;
                return ch == '\u0000' ? "" : "" + ch;
            }
            case 1086326786: {
                return this.getAtomName();
            }
            case 1086326785: {
                return this.getAtomType();
            }
            case 1086326788: {
                return this.getChainIDStr();
            }
            case 1086324752: {
                return this.getCIPChirality(true);
            }
            case 1086324753: {
                return this.getCIPChiralityRule();
            }
            case 1086324754: 
            case 0x44000011: {
                return this.getWyckoffPosition(false);
            }
            case 1086324755: {
                return this.getWyckoffPosition(true);
            }
            case 1086324744: {
                return this.getGroup1('?');
            }
            case 1086324747: {
                String s = this.group.getSeqcodeString();
                return s == null ? "" : s;
            }
            case 1086324743: {
                return this.getGroup1('\u0000');
            }
            case 1086324742: {
                return this.getGroup3(false);
            }
            case 1086326789: {
                return this.getElementSymbolIso(true);
            }
            case 1086324745: {
                return this.getIdentity(2);
            }
            case 1086324746: {
                char ch = this.group.getInsertionCode();
                return ch == '\u0000' ? "" : "" + ch;
            }
            case 1287653388: 
            case 1825200146: {
                String s = (String)vwr.shm.getShapePropertyIndex(5, "label", this.i);
                if (s == null) {
                    s = "";
                }
                return s;
            }
            case 0x4440000B: {
                return vwr.getSymStatic().staticToRationalXYZ(this.getFractionalCoordPt(!vwr.g.legacyJavaFloat, false, null), " ");
            }
            case 1639976963: {
                return this.group.getProteinStructureType().getBioStructureTypeName(false);
            }
            case 1237320707: {
                return this.group.getProteinStructureSubType().getBioStructureTypeName(false);
            }
            case 1086324749: {
                return this.group.getStructureId();
            }
            case 0x40C0000C: {
                return vwr.getHybridizationAndAxes(this.i, null, null, "d");
            }
            case 1086326798: {
                return this.getElementSymbolIso(false);
            }
            case 1088421903: {
                return this.getSymmetryOperatorList(true);
            }
        }
        return "";
    }

    public String getWyckoffPosition(boolean withMultiplicity) {
        String s;
        ModelSet ms = this.group.chain.model.ms;
        Atom a = ms.getBasisAtom(this.i, true);
        int id = a.getSeqID();
        if (id != 0) {
            int m = id >> 16;
            char c = (char)(id & 0xFF);
            return (withMultiplicity ? "" + m : "") + c;
        }
        SymmetryInterface sym = this.getUnitCell();
        if (sym == null || (s = (String)sym.getWyckoffPosition(ms.vwr, this, "M")) == null) {
            s = "0?";
        }
        ms.setAtomSeqID(this.i, (PT.parseInt(s) << 16) + s.charAt(s.length() - 1));
        return withMultiplicity ? s : s.substring(s.length() - 1);
    }

    @Override
    public String getCIPChirality(boolean doCalculate) {
        int flags = (this.formalChargeAndFlags & 0x1F0) >> 4;
        if (flags == 0 && this.atomNumberFlags > 1 && doCalculate) {
            flags = this.group.chain.model.ms.getAtomCIPChiralityCode(this);
            this.formalChargeAndFlags |= (flags == 0 ? 3 : flags) << 4;
        }
        return JC.getCIPChiralityName(flags);
    }

    public String getCIPChiralityRule() {
        String rs = this.getCIPChirality(true);
        int flags = rs.length() == 0 ? -1 : (this.formalChargeAndFlags & 0xE00) >> 9;
        return JC.getCIPRuleName(flags + 1);
    }

    @Override
    public void setCIPChirality(int c) {
        this.formalChargeAndFlags = this.formalChargeAndFlags & 0xFFFFF00F | c << 4;
    }

    @Override
    public int getCIPChiralityCode() {
        return (this.formalChargeAndFlags & 0x1F0) >> 4;
    }

    @Override
    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    public T3 atomPropertyTuple(Viewer vwr, int tok, P3 ptTemp) {
        switch (tok) {
            case 1073742329: {
                return P3.newP(this);
            }
            case 1145047050: {
                return this.getFractionalCoordPt(!vwr.g.legacyJavaFloat, false, ptTemp);
            }
            case 1145047053: {
                return this.getFractionalCoordPt(!vwr.g.legacyJavaFloat, false, ptTemp);
            }
            case 0x4440000E: {
                return this.group.chain.model.isJmolDataFrame ? this.getFractionalCoordPt(!vwr.g.legacyJavaFloat, false, ptTemp) : this.getFractionalUnitCoordPt(!vwr.g.legacyJavaFloat, false, ptTemp);
            }
            case 1145047052: {
                return P3.new3(vwr.antialiased ? (float)(this.sX / 2) : (float)this.sX, vwr.getScreenHeight() - (vwr.antialiased ? this.sY / 2 : this.sY), vwr.antialiased ? (float)(this.sZ / 2) : (float)this.sZ);
            }
            case 1145047055: {
                return this.getVibrationVector();
            }
            case 0x44400010: {
                JmolModulationSet ms = this.getModulation();
                return ms == null ? null : ms.getV3();
            }
            case 1145047049: {
                return this;
            }
            case 1765808134: {
                return CU.colorPtFromInt(this.group.chain.model.ms.vwr.gdata.getColorArgbOrGray(this.colixAtom), ptTemp);
            }
        }
        return null;
    }

    @Override
    public int getOffsetResidueAtom(String name, int offset) {
        return this.group.getAtomIndex(name, offset);
    }

    @Override
    public boolean isCrossLinked(Node node) {
        return this.group.isCrossLinked(((Atom)node).group);
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> vReturn, boolean crosslinkCovalent, boolean crosslinkHBond) {
        return this.group.getCrossLinkVector(vReturn, crosslinkCovalent, crosslinkHBond);
    }

    @Override
    public String toString() {
        return this.getInfo();
    }

    @Override
    public BS findAtomsLike(String atomExpression) {
        return this.group.chain.model.ms.vwr.getAtomBitSet(atomExpression);
    }

    public String getUnitID(int flags) {
        Model m = this.group.chain.model;
        return m.isBioModel ? ((BioModel)m).getUnitID(this, flags) : "";
    }

    @Override
    public float getFloatProperty(String property) {
        Object data = this.group.chain.model.ms.vwr.getDataObj(property, null, 1);
        float f = Float.NaN;
        if (data != null) {
            try {
                f = ((float[])data)[this.i];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    @Override
    public boolean modelIsRawPDB() {
        Model m = this.group.chain.model;
        return m.isBioModel && !m.isPdbWithMultipleBonds && m.hydrogenCount == 0;
    }

    public void setSymop(int isym, boolean andClear) {
        if (this.atomSymmetry == null) {
            this.atomSymmetry = new BS();
        }
        if (andClear) {
            this.atomSymmetry.clearAll();
        }
        if (isym > 0) {
            this.atomSymmetry.set(isym - 1);
        }
    }

    @Override
    public int getExplicitHydrogenCount() {
        return 0;
    }
}

