/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public abstract class GpxLikeImporter<T extends IGpxReader>
extends FileImporter {
    private Class<T> klass;

    protected GpxLikeImporter(ExtensionFileFilter filter, Class<T> klass) {
        super(Objects.requireNonNull(filter));
        this.klass = Objects.requireNonNull(klass);
    }

    @Override
    public final void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String fn = file.getName();
        try (InputStream fis = Compression.getUncompressedFileInputStream(file);){
            Object r = GpxLikeImporter.buildAndParse(fis, this.klass);
            if (r.getNumberOfCoordinates() > 0) {
                r.getGpxData().storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(r.getGpxData(), fn, true);
                File fileFinal = file;
                GuiHelper.runInEDT(() -> {
                    MainApplication.getLayerManager().addLayer(gpxLayer);
                    if (Config.getPref().getBoolean("marker.makeautomarkers", true)) {
                        MarkerLayer ml = new MarkerLayer(r.getGpxData(), I18n.tr("Markers from {0}", fn), fileFinal, gpxLayer);
                        if (!ml.data.isEmpty()) {
                            MainApplication.getLayerManager().addLayer(ml);
                        }
                    }
                });
            }
            this.showInfobox(r.getNumberOfCoordinates() > 0, r);
        }
    }

    protected final void showInfobox(boolean success, T r) {
        StringBuilder msg = new StringBuilder(160).append("<html>").append(I18n.tr("Coordinates imported: {0}", r.getNumberOfCoordinates()));
        this.appendInfoboxContent(msg, success, r);
        msg.append("</html>");
        if (success) {
            SwingUtilities.invokeLater(() -> new Notification("<h3>" + I18n.tr("Import success:", new Object[0]) + "</h3>" + msg.toString()).setIcon(1).show());
        } else {
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), msg.toString(), I18n.tr("Import failure!", new Object[0]), 0, null);
        }
    }

    protected void appendInfoboxContent(StringBuilder msg, boolean success, T r) {
    }

    protected static final <T extends IGpxReader> T buildAndParse(InputStream fis, Class<T> klass) throws IOException {
        try {
            IGpxReader r = (IGpxReader)klass.getConstructor(InputStream.class).newInstance(fis);
            r.parse(true);
            return (T)r;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | SAXException e) {
            throw new IOException(e);
        }
    }
}

