/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxExtensionCollection;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class GpxParser
extends DefaultHandler {
    private String version;
    private GpxData data;
    private Collection<IGpxTrackSegment> currentTrack;
    private Map<String, Object> currentTrackAttr;
    private Collection<WayPoint> currentTrackSeg;
    private GpxRoute currentRoute;
    private WayPoint currentWayPoint;
    private State currentState = State.INIT;
    private GpxLink currentLink;
    private GpxExtensionCollection currentExtensionCollection;
    private GpxExtensionCollection currentTrackExtensionCollection;
    private final Stack<State> states = new Stack();
    private final Stack<String[]> elements = new Stack();
    private StringBuilder accumulator = new StringBuilder();
    private boolean nokiaSportsTrackerBug;

    GpxParser() {
    }

    @Override
    public void startDocument() {
        this.accumulator = new StringBuilder();
        this.data = new GpxData(true);
        this.currentExtensionCollection = new GpxExtensionCollection();
        this.currentTrackExtensionCollection = new GpxExtensionCollection();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.data.getNamespaces().add(new GpxData.XMLNamespace(prefix, uri));
    }

    private static double parseCoordinates(Attributes attributes, String key) {
        String val = attributes.getValue(key);
        if (val != null) {
            return GpxParser.parseCoordinates(val);
        }
        return GpxParser.parseCoordinates(attributes.getValue(key.replaceFirst("l", "L")));
    }

    private static double parseCoordinates(String s) {
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                Logging.trace(ex);
            }
        }
        return Double.NaN;
    }

    private static LatLon parseLatLon(Attributes attributes) {
        return new LatLon(GpxParser.parseCoordinates(attributes, "lat"), GpxParser.parseCoordinates(attributes, "lon"));
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this.elements.push(new String[]{namespaceURI, localName, qName});
        switch (this.currentState) {
            case INIT: {
                this.startElementInit(attributes);
                break;
            }
            case GPX: {
                this.startElementGpx(localName, attributes);
                break;
            }
            case METADATA: {
                this.startElementMetadata(localName, attributes);
                break;
            }
            case AUTHOR: {
                this.startElementAuthor(localName, attributes);
                break;
            }
            case TRK: {
                this.startElementTrk(localName, attributes);
                break;
            }
            case TRKSEG: {
                this.startElementTrkSeg(localName, attributes);
                break;
            }
            case WPT: {
                this.startElementWpt(localName, attributes);
                break;
            }
            case RTE: {
                this.startElementRte(localName, attributes);
                break;
            }
            case EXT: {
                this.startElementExt(namespaceURI, qName, attributes);
                break;
            }
        }
        this.accumulator.setLength(0);
    }

    private void startElementInit(Attributes attributes) {
        this.states.push(this.currentState);
        this.currentState = State.GPX;
        this.data.creator = attributes.getValue("creator");
        this.version = attributes.getValue("version");
        if (this.version != null && this.version.startsWith("1.0")) {
            this.version = "1.0";
        } else if (!"1.1".equals(this.version)) {
            this.version = "1.1";
        }
        String schemaLocation = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocation != null) {
            String[] schemaLocations = schemaLocation.split(" ", -1);
            for (int i = 0; i < schemaLocations.length - 1; i += 2) {
                String schemaURI = schemaLocations[i];
                String schemaXSD = schemaLocations[i + 1];
                this.data.getNamespaces().stream().filter(xml -> xml.getURI().equals(schemaURI)).forEach(xml -> xml.setLocation(schemaXSD));
            }
        }
    }

    private void startElementGpx(String localName, Attributes attributes) {
        switch (localName) {
            case "metadata": {
                this.states.push(this.currentState);
                this.currentState = State.METADATA;
                break;
            }
            case "wpt": {
                this.states.push(this.currentState);
                this.currentState = State.WPT;
                this.currentWayPoint = new WayPoint(GpxParser.parseLatLon(attributes));
                break;
            }
            case "rte": {
                this.states.push(this.currentState);
                this.currentState = State.RTE;
                this.currentRoute = new GpxRoute();
                break;
            }
            case "trk": {
                this.states.push(this.currentState);
                this.currentState = State.TRK;
                this.currentTrack = new ArrayList<IGpxTrackSegment>();
                this.currentTrackAttr = new HashMap<String, Object>();
                break;
            }
            case "extensions": {
                this.states.push(this.currentState);
                this.currentState = State.EXT;
                break;
            }
            case "gpx": {
                if (attributes.getValue("creator") == null || !attributes.getValue("creator").startsWith("Nokia Sports Tracker")) break;
                this.nokiaSportsTrackerBug = true;
                break;
            }
        }
    }

    private void startElementMetadata(String localName, Attributes attributes) {
        switch (localName) {
            case "author": {
                this.states.push(this.currentState);
                this.currentState = State.AUTHOR;
                break;
            }
            case "extensions": {
                this.states.push(this.currentState);
                this.currentState = State.EXT;
                break;
            }
            case "copyright": {
                this.states.push(this.currentState);
                this.currentState = State.COPYRIGHT;
                this.data.put("meta.copyright.author", attributes.getValue("author"));
                break;
            }
            case "link": {
                this.states.push(this.currentState);
                this.currentState = State.LINK;
                this.currentLink = new GpxLink(attributes.getValue("href"));
                break;
            }
            case "bounds": {
                this.data.put("meta.bounds", new Bounds(GpxParser.parseCoordinates(attributes, "minlat"), GpxParser.parseCoordinates(attributes, "minlon"), GpxParser.parseCoordinates(attributes, "maxlat"), GpxParser.parseCoordinates(attributes, "maxlon")));
                break;
            }
        }
    }

    private void startElementAuthor(String localName, Attributes attributes) {
        switch (localName) {
            case "link": {
                this.states.push(this.currentState);
                this.currentState = State.LINK;
                this.currentLink = new GpxLink(attributes.getValue("href"));
                break;
            }
            case "email": {
                this.data.put("meta.author.email", attributes.getValue("id") + '@' + attributes.getValue("domain"));
                break;
            }
        }
    }

    private void startElementTrk(String localName, Attributes attributes) {
        switch (localName) {
            case "trkseg": {
                this.states.push(this.currentState);
                this.currentState = State.TRKSEG;
                this.currentTrackSeg = new ArrayList<WayPoint>();
                break;
            }
            case "link": {
                this.states.push(this.currentState);
                this.currentState = State.LINK;
                this.currentLink = new GpxLink(attributes.getValue("href"));
                break;
            }
            case "extensions": {
                this.states.push(this.currentState);
                this.currentState = State.EXT;
                break;
            }
        }
    }

    private void startElementTrkSeg(String localName, Attributes attributes) {
        switch (localName) {
            case "trkpt": {
                this.states.push(this.currentState);
                this.currentState = State.WPT;
                this.currentWayPoint = new WayPoint(GpxParser.parseLatLon(attributes));
                break;
            }
            case "extensions": {
                this.states.push(this.currentState);
                this.currentState = State.EXT;
                break;
            }
        }
    }

    private void startElementWpt(String localName, Attributes attributes) {
        switch (localName) {
            case "link": {
                this.states.push(this.currentState);
                this.currentState = State.LINK;
                this.currentLink = new GpxLink(attributes.getValue("href"));
                break;
            }
            case "extensions": {
                this.states.push(this.currentState);
                this.currentState = State.EXT;
                break;
            }
        }
    }

    private void startElementRte(String localName, Attributes attributes) {
        switch (localName) {
            case "link": {
                this.states.push(this.currentState);
                this.currentState = State.LINK;
                this.currentLink = new GpxLink(attributes.getValue("href"));
                break;
            }
            case "rtept": {
                this.states.push(this.currentState);
                this.currentState = State.WPT;
                this.currentWayPoint = new WayPoint(GpxParser.parseLatLon(attributes));
                break;
            }
            case "extensions": {
                this.states.push(this.currentState);
                this.currentState = State.EXT;
                break;
            }
        }
    }

    private void startElementExt(String namespaceURI, String qName, Attributes attributes) {
        if (this.states.lastElement() == State.TRK) {
            this.currentTrackExtensionCollection.openChild(namespaceURI, qName, attributes);
        } else {
            this.currentExtensionCollection.openChild(namespaceURI, qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.nokiaSportsTrackerBug) {
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] != '\u0001') continue;
                ch[i] = 32;
            }
            this.nokiaSportsTrackerBug = false;
        }
        this.accumulator.append(ch, start, length);
    }

    private Optional<Map<String, Object>> getAttr() {
        switch (this.currentState) {
            case RTE: {
                return Optional.ofNullable(this.currentRoute.attr);
            }
            case METADATA: {
                return Optional.ofNullable(this.data.attr);
            }
            case WPT: {
                return Optional.ofNullable(this.currentWayPoint.attr);
            }
            case TRK: {
                return Optional.ofNullable(this.currentTrackAttr);
            }
        }
        return Optional.empty();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.elements.pop();
        switch (this.currentState) {
            case GPX: 
            case METADATA: {
                this.endElementMetadata(localName);
                break;
            }
            case AUTHOR: {
                this.endElementAuthor(localName);
                break;
            }
            case COPYRIGHT: {
                this.endElementCopyright(localName);
                break;
            }
            case LINK: {
                this.endElementLink(localName);
                break;
            }
            case WPT: {
                this.endElementWpt(localName);
                break;
            }
            case TRKSEG: {
                this.endElementTrkseg(localName);
                break;
            }
            case TRK: {
                this.endElementTrk(localName);
                break;
            }
            case EXT: {
                this.endElementExt(localName, qName);
                break;
            }
            default: {
                this.endElementDefault(localName);
            }
        }
        this.accumulator.setLength(0);
    }

    private void endElementMetadata(String localName) {
        switch (localName) {
            case "name": {
                this.data.put("meta.name", this.accumulator.toString());
                break;
            }
            case "desc": {
                this.data.put("meta.desc", this.accumulator.toString());
                break;
            }
            case "time": {
                this.data.put("meta.time", this.accumulator.toString());
                break;
            }
            case "keywords": {
                this.data.put("meta.keywords", this.accumulator.toString());
                break;
            }
            case "author": {
                if (!"1.0".equals(this.version)) break;
                this.data.put("meta.author.name", this.accumulator.toString());
                break;
            }
            case "email": {
                if (!"1.0".equals(this.version)) break;
                this.data.put("meta.author.email", this.accumulator.toString());
                break;
            }
            case "url": 
            case "urlname": {
                this.data.put(localName, this.accumulator.toString());
                break;
            }
            case "metadata": 
            case "gpx": {
                if ((this.currentState != State.METADATA || !"metadata".equals(localName)) && (this.currentState != State.GPX || !"gpx".equals(localName))) break;
                GpxParser.convertUrlToLink(this.data.attr);
                this.data.getExtensions().addAll(this.currentExtensionCollection);
                this.currentExtensionCollection.clear();
                this.currentState = this.states.pop();
                break;
            }
            case "bounds": {
                break;
            }
        }
    }

    private void endElementAuthor(String localName) {
        switch (localName) {
            case "author": {
                this.currentState = this.states.pop();
                break;
            }
            case "name": {
                this.data.put("meta.author.name", this.accumulator.toString());
                break;
            }
            case "email": {
                break;
            }
            case "link": {
                this.data.put("meta.author.link", this.currentLink);
                break;
            }
        }
    }

    private void endElementCopyright(String localName) {
        switch (localName) {
            case "copyright": {
                this.currentState = this.states.pop();
                break;
            }
            case "year": {
                this.data.put("meta.copyright.year", this.accumulator.toString());
                break;
            }
            case "license": {
                this.data.put("meta.copyright.license", this.accumulator.toString());
                break;
            }
        }
    }

    private void endElementLink(String localName) {
        switch (localName) {
            case "text": {
                this.currentLink.text = this.accumulator.toString();
                break;
            }
            case "type": {
                this.currentLink.type = this.accumulator.toString();
                break;
            }
            case "link": {
                if (this.currentLink.uri == null && !this.accumulator.toString().isEmpty()) {
                    this.currentLink = new GpxLink(this.accumulator.toString());
                }
                this.currentState = this.states.pop();
                break;
            }
        }
        if (this.currentState == State.AUTHOR) {
            this.data.put("meta.author.link", this.currentLink);
        } else if (this.currentState != State.LINK) {
            this.getAttr().ifPresent(attr -> ((Collection)attr.computeIfAbsent("meta.links", e -> new LinkedList())).add(this.currentLink));
        }
    }

    private void endElementWpt(String localName) throws SAXException {
        switch (localName) {
            case "ele": 
            case "magvar": 
            case "name": 
            case "src": 
            case "geoidheight": 
            case "type": 
            case "sym": 
            case "url": 
            case "urlname": 
            case "cmt": 
            case "desc": 
            case "fix": {
                this.currentWayPoint.put(localName, this.accumulator.toString());
                break;
            }
            case "hdop": 
            case "vdop": 
            case "pdop": {
                try {
                    this.currentWayPoint.put(localName, Float.valueOf(this.accumulator.toString()));
                }
                catch (NumberFormatException e) {
                    this.currentWayPoint.put(localName, Float.valueOf(0.0f));
                }
                break;
            }
            case "time": {
                try {
                    this.currentWayPoint.setInstant(DateUtils.parseInstant(this.accumulator.toString()));
                }
                catch (DateTimeException | UncheckedParseException e) {
                    Logging.error(e);
                }
                break;
            }
            case "rtept": {
                this.currentState = this.states.pop();
                GpxParser.convertUrlToLink(this.currentWayPoint.attr);
                if (!this.currentWayPoint.isLatLonKnown()) {
                    throw new SAXException(I18n.tr("{0} element does not have valid latitude and/or longitude.", localName));
                }
                this.currentRoute.routePoints.add(this.currentWayPoint);
                break;
            }
            case "trkpt": {
                this.currentState = this.states.pop();
                GpxParser.convertUrlToLink(this.currentWayPoint.attr);
                if (!this.currentWayPoint.isLatLonKnown()) {
                    throw new SAXException(I18n.tr("{0} element does not have valid latitude and/or longitude.", localName));
                }
                this.currentTrackSeg.add(this.currentWayPoint);
                break;
            }
            case "wpt": {
                this.currentState = this.states.pop();
                GpxParser.convertUrlToLink(this.currentWayPoint.attr);
                this.currentWayPoint.getExtensions().addAll(this.currentExtensionCollection);
                if (!this.currentWayPoint.isLatLonKnown()) {
                    this.currentExtensionCollection.clear();
                    throw new SAXException(I18n.tr("{0} element does not have valid latitude and/or longitude.", localName));
                }
                this.data.waypoints.add(this.currentWayPoint);
                this.currentExtensionCollection.clear();
                break;
            }
        }
    }

    private void endElementTrkseg(String localName) {
        if ("trkseg".equals(localName)) {
            this.currentState = this.states.pop();
            if (!this.currentTrackSeg.isEmpty()) {
                GpxTrackSegment seg = new GpxTrackSegment(this.currentTrackSeg);
                if (!this.currentExtensionCollection.isEmpty()) {
                    seg.getExtensions().addAll(this.currentExtensionCollection);
                }
                this.currentTrack.add(seg);
            }
            this.currentExtensionCollection.clear();
        }
    }

    private void endElementTrk(String localName) {
        switch (localName) {
            case "trk": {
                this.currentState = this.states.pop();
                GpxParser.convertUrlToLink(this.currentTrackAttr);
                GpxTrack trk = new GpxTrack((List<IGpxTrackSegment>)new ArrayList<IGpxTrackSegment>(this.currentTrack), this.currentTrackAttr);
                if (!this.currentTrackExtensionCollection.isEmpty()) {
                    trk.getExtensions().addAll(this.currentTrackExtensionCollection);
                }
                this.data.addTrack(trk);
                this.currentTrackExtensionCollection.clear();
                break;
            }
            case "name": 
            case "cmt": 
            case "desc": 
            case "src": 
            case "type": 
            case "number": 
            case "url": 
            case "urlname": {
                this.currentTrackAttr.put(localName, this.accumulator.toString());
                break;
            }
        }
    }

    private void endElementExt(String localName, String qName) {
        if ("extensions".equals(localName)) {
            this.currentState = this.states.pop();
        } else if (this.currentExtensionCollection != null) {
            String acc = this.accumulator.toString().trim();
            if (this.states.lastElement() == State.TRK) {
                this.currentTrackExtensionCollection.closeChild(qName, acc);
            } else {
                this.currentExtensionCollection.closeChild(qName, acc);
            }
        }
    }

    private void endElementDefault(String localName) {
        switch (localName) {
            case "wpt": {
                this.currentState = this.states.pop();
                break;
            }
            case "rte": {
                this.currentState = this.states.pop();
                GpxParser.convertUrlToLink(this.currentRoute.attr);
                this.data.addRoute(this.currentRoute);
                break;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.states.isEmpty()) {
            throw new SAXException(I18n.tr("Parse error: invalid document structure for GPX document.", new Object[0]));
        }
        this.data.getExtensions().stream("josm", "from-server").findAny().ifPresent(ext -> {
            this.data.fromServer = "true".equals(ext.getValue());
        });
        this.data.getExtensions().stream("josm", "layerPreferences").forEach(prefs -> prefs.getExtensions().stream("josm", "entry").forEach(prefEntry -> {
            Object key = prefEntry.get("key");
            Object val = prefEntry.get("value");
            if (key != null && val != null) {
                this.data.getLayerPrefs().put(key.toString(), val.toString());
            }
        }));
        this.data.endUpdate();
    }

    GpxData getData() {
        return this.data;
    }

    private static void convertUrlToLink(Map<String, Object> attr) {
        String url = (String)attr.get("url");
        String urlname = (String)attr.get("urlname");
        if (url != null) {
            GpxLink link = new GpxLink(url);
            link.text = urlname;
            Collection links = (Collection)attr.computeIfAbsent("meta.links", e -> new LinkedList());
            links.add(link);
        }
    }

    void tryToFinish() throws SAXException {
        ArrayList<String[]> remainingElements = new ArrayList<String[]>(this.elements);
        for (int i = remainingElements.size() - 1; i >= 0; --i) {
            String[] e = (String[])remainingElements.get(i);
            this.endElement(e[0], e[1], e[2]);
        }
        this.endDocument();
    }

    private static enum State {
        INIT,
        GPX,
        METADATA,
        WPT,
        RTE,
        TRK,
        EXT,
        AUTHOR,
        LINK,
        TRKSEG,
        COPYRIGHT;

    }
}

