/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.math.NumberUtils;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.MapperParsingException;

public class MethodComponentContext
implements ToXContentFragment,
Writeable {
    public static final MethodComponentContext EMPTY = new MethodComponentContext("", Collections.emptyMap());
    private static final String DELIMITER = ";";
    private static final String DELIMITER_PLACEHOLDER = "$%$";
    private final String name;
    private final Map<String, Object> parameters;
    private Version indexVersion;

    public MethodComponentContext(StreamInput in) throws IOException {
        this.name = in.readString();
        this.parameters = in.available() > 0 ? in.readMap(StreamInput::readString, (Writeable.Reader)new ParameterMapValueReader()) : null;
    }

    public static MethodComponentContext parse(Object in) {
        if (!(in instanceof Map)) {
            throw new MapperParsingException("Unable to parse MethodComponent");
        }
        Map methodMap = (Map)in;
        String name = "";
        Map<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry methodEntry : methodMap.entrySet()) {
            String key = (String)methodEntry.getKey();
            Object value = methodEntry.getValue();
            if ("name".equals(key)) {
                if (!(value instanceof String)) {
                    throw new MapperParsingException("Component name should be a string");
                }
                name = (String)value;
                continue;
            }
            if ("parameters".equals(key)) {
                if (value == null) {
                    parameters = null;
                    continue;
                }
                if (!(value instanceof Map)) {
                    throw new MapperParsingException("Unable to parse parameters for  method component");
                }
                Map<String, Object> parameters1 = ((Map)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                    Object v = e.getValue();
                    if (v instanceof Map) {
                        return MethodComponentContext.parse(v);
                    }
                    return v;
                }));
                parameters = parameters1;
                continue;
            }
            throw new MapperParsingException("Invalid parameter for MethodComponentContext: " + key);
        }
        if (name.isEmpty()) {
            throw new MapperParsingException("name needs to be set");
        }
        return new MethodComponentContext(name, parameters);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.name);
        if (this.parameters == null) {
            builder.field("parameters", (String)null);
        } else {
            builder.startObject("parameters");
            this.parameters.forEach((key, value) -> {
                try {
                    if (value instanceof MethodComponentContext) {
                        builder.startObject(key);
                        ((MethodComponentContext)value).toXContent(builder, params);
                        builder.endObject();
                    } else {
                        builder.field(key, value);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to generate xcontent for method component");
                }
            });
            builder.endObject();
        }
        return builder;
    }

    public static MethodComponentContext fromXContent(XContentParser xContentParser) throws IOException {
        if (xContentParser.currentToken() == null) {
            xContentParser.nextToken();
        }
        Map parsedMap = xContentParser.map();
        return MethodComponentContext.parse(parsedMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodComponentContext other = (MethodComponentContext)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.name, (Object)other.name);
        equalsBuilder.append(this.parameters, other.parameters);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.parameters).toHashCode();
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return this.parameters;
    }

    public String toClusterStateString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{name=").append(this.name).append(DELIMITER);
        stringBuilder.append("parameters=[");
        if (Objects.nonNull(this.parameters)) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                stringBuilder.append(entry.getKey()).append("=");
                Object objectValue = entry.getValue();
                String value = objectValue instanceof MethodComponentContext ? ((MethodComponentContext)objectValue).toClusterStateString() : entry.getValue().toString();
                value = value.replace(",", DELIMITER_PLACEHOLDER);
                stringBuilder.append(value).append(DELIMITER);
            }
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public static MethodComponentContext fromClusterStateString(String in) {
        String stringToParse = MethodComponentContext.unwrapString(in, '{', '}');
        String[] nameAndParameters = stringToParse.split(DELIMITER, 2);
        MethodComponentContext.checkExpectedArrayLength(nameAndParameters, 2);
        String name = MethodComponentContext.parseName(nameAndParameters[0]);
        String parametersString = nameAndParameters[1];
        Map<String, Object> parameters = MethodComponentContext.parseParameters(parametersString);
        return new MethodComponentContext(name, parameters);
    }

    private static String parseName(String candidateNameString) {
        MethodComponentContext.checkStringNotEmpty(candidateNameString);
        String[] nameKeyAndValue = candidateNameString.split("=");
        MethodComponentContext.checkStringMatches(nameKeyAndValue[0], "name");
        if (nameKeyAndValue.length == 1) {
            return "";
        }
        MethodComponentContext.checkExpectedArrayLength(nameKeyAndValue, 2);
        return nameKeyAndValue[1];
    }

    private static Map<String, Object> parseParameters(String candidateParameterString) {
        MethodComponentContext.checkStringNotEmpty(candidateParameterString);
        String[] parametersKeyAndValue = candidateParameterString.split("=", 2);
        MethodComponentContext.checkStringMatches(parametersKeyAndValue[0], "parameters");
        if (parametersKeyAndValue.length == 1) {
            return Collections.emptyMap();
        }
        MethodComponentContext.checkExpectedArrayLength(parametersKeyAndValue, 2);
        return MethodComponentContext.parseParametersValue(parametersKeyAndValue[1]);
    }

    private static Map<String, Object> parseParametersValue(String candidateParameterValueString) {
        String[] keyAndValueToParse;
        MethodComponentContext.checkStringNotEmpty(candidateParameterValueString);
        candidateParameterValueString = MethodComponentContext.unwrapString(candidateParameterValueString, '[', ']');
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        while (!(candidateParameterValueString.isEmpty() || (keyAndValueToParse = candidateParameterValueString.split("=", 2)).length == 1 && keyAndValueToParse[0].charAt(0) == ';')) {
            String key = keyAndValueToParse[0];
            ValueAndRestToParse parsed = MethodComponentContext.parseParameterValueAndRestToParse(keyAndValueToParse[1]);
            parameters.put(key, parsed.getValue());
            candidateParameterValueString = parsed.getRestToParse();
        }
        return parameters;
    }

    private static ValueAndRestToParse parseParameterValueAndRestToParse(String candidateParameterValueAndRestToParse) {
        Object value;
        if (candidateParameterValueAndRestToParse.charAt(0) == '{') {
            int endOfNestedMap = MethodComponentContext.findClosingPosition(candidateParameterValueAndRestToParse, '{', '}');
            String nestedMethodContext = candidateParameterValueAndRestToParse.substring(0, endOfNestedMap + 1);
            MethodComponentContext nestedParse = MethodComponentContext.fromClusterStateString(nestedMethodContext);
            String restToParse = candidateParameterValueAndRestToParse.substring(endOfNestedMap + 1);
            return new ValueAndRestToParse(nestedParse, restToParse);
        }
        String[] stringValueAndRestToParse = candidateParameterValueAndRestToParse.split(DELIMITER, 2);
        String stringValue = stringValueAndRestToParse[0];
        if (NumberUtils.isNumber((String)stringValue)) {
            value = Integer.parseInt(stringValue);
        } else if (stringValue.equals("true") || stringValue.equals("false")) {
            value = Boolean.parseBoolean(stringValue);
        } else {
            stringValue = stringValue.replace(DELIMITER_PLACEHOLDER, ",");
            value = stringValue;
        }
        return new ValueAndRestToParse(value, stringValueAndRestToParse[1]);
    }

    private static String unwrapString(String in, char expectedStart, char expectedEnd) {
        if (in.length() < 2) {
            throw new IllegalArgumentException("Invalid string.");
        }
        if (in.charAt(0) != expectedStart || in.charAt(in.length() - 1) != expectedEnd) {
            throw new IllegalArgumentException("Invalid string." + in);
        }
        return in.substring(1, in.length() - 1);
    }

    private static int findClosingPosition(String in, char expectedStart, char expectedEnd) {
        int nestedLevel = 0;
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == expectedStart) {
                ++nestedLevel;
                continue;
            }
            if (in.charAt(i) == expectedEnd) {
                --nestedLevel;
            }
            if (nestedLevel != 0) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid string. No end to the nesting");
    }

    private static void checkStringNotEmpty(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Unable to parse MethodComponentContext");
        }
    }

    private static void checkStringMatches(String string, String expected) {
        if (!Objects.equals(string, expected)) {
            throw new IllegalArgumentException("Unexpected key in MethodComponentContext.  Expected 'name' or 'parameters'");
        }
    }

    private static void checkExpectedArrayLength(String[] array, int expectedLength) {
        if (null == array) {
            throw new IllegalArgumentException("Error parsing MethodComponentContext.  Array is null.");
        }
        if (array.length != expectedLength) {
            throw new IllegalArgumentException("Error parsing MethodComponentContext.  Array is not expected length.");
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (this.parameters != null) {
            out.writeMap(this.parameters, StreamOutput::writeString, (Writeable.Writer)new ParameterMapValueWriter());
        }
    }

    @Generated
    public MethodComponentContext(String name, Map<String, Object> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Version getIndexVersion() {
        return this.indexVersion;
    }

    @Generated
    public void setIndexVersion(Version indexVersion) {
        this.indexVersion = indexVersion;
    }

    private static class ParameterMapValueReader
    implements Writeable.Reader<Object> {
        private ParameterMapValueReader() {
        }

        public Object read(StreamInput in) throws IOException {
            boolean isValueMethodComponentContext = in.readBoolean();
            if (isValueMethodComponentContext) {
                return new MethodComponentContext(in);
            }
            return in.readGenericValue();
        }
    }

    private static class ParameterMapValueWriter
    implements Writeable.Writer<Object> {
        private ParameterMapValueWriter() {
        }

        public void write(StreamOutput out, Object o) throws IOException {
            if (o instanceof MethodComponentContext) {
                out.writeBoolean(true);
                ((MethodComponentContext)o).writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeGenericValue(o);
            }
        }
    }

    private static class ValueAndRestToParse {
        private final Object value;
        private final String restToParse;

        @Generated
        public ValueAndRestToParse(Object value, String restToParse) {
            this.value = value;
            this.restToParse = restToParse;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public String getRestToParse() {
            return this.restToParse;
        }
    }
}

