/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.MethodComponent;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.training.VectorSpaceInfo;

public abstract class Parameter<T> {
    private String name;
    private T defaultValue;
    protected Predicate<T> validator;
    protected BiFunction<T, VectorSpaceInfo, Boolean> validatorWithData;

    public Parameter(String name, T defaultValue, Predicate<T> validator) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.validatorWithData = null;
    }

    public Parameter(String name, T defaultValue, Predicate<T> validator, BiFunction<T, VectorSpaceInfo, Boolean> validatorWithData) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.validatorWithData = validatorWithData;
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract ValidationException validate(Object var1);

    public abstract ValidationException validateWithData(Object var1, VectorSpaceInfo var2);

    public static class MethodComponentContextParameter
    extends Parameter<MethodComponentContext> {
        private Map<String, MethodComponent> methodComponents;

        public MethodComponentContextParameter(String name, MethodComponentContext defaultValue, Map<String, MethodComponent> methodComponents) {
            super(name, defaultValue, methodComponentContext -> {
                if (!methodComponents.containsKey(methodComponentContext.getName())) {
                    return false;
                }
                return ((MethodComponent)methodComponents.get(methodComponentContext.getName())).validate((MethodComponentContext)methodComponentContext) == null;
            }, (methodComponentContext, vectorSpaceInfo) -> {
                if (!methodComponents.containsKey(methodComponentContext.getName())) {
                    return false;
                }
                return ((MethodComponent)methodComponents.get(methodComponentContext.getName())).validateWithData((MethodComponentContext)methodComponentContext, (VectorSpaceInfo)vectorSpaceInfo) == null;
            });
            this.methodComponents = methodComponents;
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof MethodComponentContext)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Value not of type MethodComponentContext for MethodComponentContext parameter \"%s\".", this.getName()));
                return validationException;
            }
            if (!this.validator.test((MethodComponentContext)value)) {
                validationException = new ValidationException();
                validationException.addValidationError("Parameter validation failed.");
                validationException.addValidationError(String.format("Parameter validation failed for MethodComponentContext parameter \"%s\".", this.getName()));
            }
            return validationException;
        }

        @Override
        public ValidationException validateWithData(Object value, VectorSpaceInfo vectorSpaceInfo) {
            ValidationException validationException = null;
            if (!(value instanceof MethodComponentContext)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of for MethodComponentContext parameter [%s].", this.getName()));
                return validationException;
            }
            if (this.validatorWithData == null) {
                return null;
            }
            if (!((Boolean)this.validatorWithData.apply((MethodComponentContext)value, vectorSpaceInfo)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for MethodComponentContext parameter [%s].", this.getName()));
            }
            return validationException;
        }

        public MethodComponent getMethodComponent(String name) {
            return this.methodComponents.get(name);
        }
    }

    public static class StringParameter
    extends Parameter<String> {
        public StringParameter(String name, String defaultValue, Predicate<String> validator) {
            super(name, defaultValue, validator);
        }

        public StringParameter(String name, String defaultValue, Predicate<String> validator, BiFunction<String, VectorSpaceInfo, Boolean> validatorWithData) {
            super(name, defaultValue, validator, validatorWithData);
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof String)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Value not of type String for String parameter \"%s\".", this.getName()));
                return validationException;
            }
            if (!this.validator.test((String)value)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Parameter validation failed for String parameter \"%s\".", this.getName()));
            }
            return validationException;
        }

        @Override
        public ValidationException validateWithData(Object value, VectorSpaceInfo vectorSpaceInfo) {
            ValidationException validationException = null;
            if (!(value instanceof String)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of String for String parameter [%s].", this.getName()));
                return validationException;
            }
            if (this.validatorWithData == null) {
                return null;
            }
            if (!((Boolean)this.validatorWithData.apply((String)value, vectorSpaceInfo)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for String parameter [%s].", this.getName()));
            }
            return validationException;
        }
    }

    public static class IntegerParameter
    extends Parameter<Integer> {
        public IntegerParameter(String name, Integer defaultValue, Predicate<Integer> validator) {
            super(name, defaultValue, validator);
        }

        public IntegerParameter(String name, Integer defaultValue, Predicate<Integer> validator, BiFunction<Integer, VectorSpaceInfo, Boolean> validatorWithData) {
            super(name, defaultValue, validator, validatorWithData);
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof Integer)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Value not of type Integer for Integer parameter \"%s\".", this.getName()));
                return validationException;
            }
            if (!this.validator.test((Integer)value)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("Parameter validation failed for Integer parameter \"%s\".", this.getName()));
            }
            return validationException;
        }

        @Override
        public ValidationException validateWithData(Object value, VectorSpaceInfo vectorSpaceInfo) {
            ValidationException validationException = null;
            if (!(value instanceof Integer)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of Integer for Integer parameter [%s].", this.getName()));
                return validationException;
            }
            if (this.validatorWithData == null) {
                return null;
            }
            if (!((Boolean)this.validatorWithData.apply((Integer)value, vectorSpaceInfo)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for Integer parameter [%s].", this.getName()));
            }
            return validationException;
        }
    }

    public static class BooleanParameter
    extends Parameter<Boolean> {
        public BooleanParameter(String name, Boolean defaultValue, Predicate<Boolean> validator) {
            super(name, defaultValue, validator);
        }

        public BooleanParameter(String name, Boolean defaultValue, Predicate<Boolean> validator, BiFunction<Boolean, VectorSpaceInfo, Boolean> validatorWithData) {
            super(name, defaultValue, validator, validatorWithData);
        }

        @Override
        public ValidationException validate(Object value) {
            ValidationException validationException = null;
            if (!(value instanceof Boolean)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value is not an instance of Boolean for Boolean parameter [%s].", this.getName()));
                return validationException;
            }
            if (!this.validator.test((Boolean)value)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for Boolean parameter [%s].", this.getName()));
            }
            return validationException;
        }

        @Override
        public ValidationException validateWithData(Object value, VectorSpaceInfo vectorSpaceInfo) {
            ValidationException validationException = null;
            if (!(value instanceof Boolean)) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("value not of type Boolean for Boolean parameter [%s].", this.getName()));
                return validationException;
            }
            if (this.validatorWithData == null) {
                return null;
            }
            if (!((Boolean)this.validatorWithData.apply((Boolean)value, vectorSpaceInfo)).booleanValue()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format("parameter validation failed for Boolean parameter [%s].", this.getName()));
            }
            return validationException;
        }
    }
}

