complete -c qrtool -n "__fish_use_subcommand" -l generate-completion -d 'Generate shell completion' -r -f -a "{bash	'Bash',elvish	'Elvish',fish	'fish',nushell	'Nushell',powershell	'PowerShell',zsh	'Zsh'}"
complete -c qrtool -n "__fish_use_subcommand" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c qrtool -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c qrtool -n "__fish_use_subcommand" -f -a "encode" -d 'Encode input data in a QR code'
complete -c qrtool -n "__fish_use_subcommand" -f -a "decode" -d 'Detect and decode a QR code'
complete -c qrtool -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s o -l output -d 'Output the result to a file' -r -F
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s r -l read-from -d 'Read input data from a file' -r -F
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s s -l size -d 'The module size in pixels' -r
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s l -l error-correction-level -l level -d 'Error correction level' -r -f -a "{l	'Level L',m	'Level M',q	'Level Q',h	'Level H'}"
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s v -l symbol-version -l symversion -d 'The version of the symbol' -r
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s m -l margin -d 'The width of margin' -r
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s t -l type -d 'The format of the output' -r -f -a "{png	'Portable Network Graphics',svg	'Scalable Vector Graphics',terminal	'To the terminal as UTF-8 string'}"
complete -c qrtool -n "__fish_seen_subcommand_from encode" -l mode -d 'The mode of the output' -r -f -a "{numeric	'All digits',alphanumeric	'Alphanumerics and few symbols',byte	'Arbitrary binary data',kanji	'Shift JIS text'}"
complete -c qrtool -n "__fish_seen_subcommand_from encode" -l variant -d 'The type of QR code' -r -f -a "{normal	'Normal QR code',micro	'Micro QR code'}"
complete -c qrtool -n "__fish_seen_subcommand_from encode" -l foreground -d 'Foreground color' -r
complete -c qrtool -n "__fish_seen_subcommand_from encode" -l background -d 'Background color' -r
complete -c qrtool -n "__fish_seen_subcommand_from encode" -l verbose -d 'Also print the metadata'
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c qrtool -n "__fish_seen_subcommand_from encode" -s V -l version -d 'Print version'
complete -c qrtool -n "__fish_seen_subcommand_from decode" -s t -l type -d 'The format of the input' -r -f -a "{bmp	'Windows Bitmap',dds	'DirectDraw Surface',farbfeld	'Farbfeld',gif	'Graphics Interchange Format',hdr	'Radiance RGBE',ico	'ICO file format',jpeg	'JPEG',openexr	'OpenEXR',png	'Portable Network Graphics',pnm	'Portable Anymap Format',qoi	'Quite OK Image Format',svg	'Scalable Vector Graphics',tga	'Truevision TGA',tiff	'Tag Image File Format',webp	'WebP'}"
complete -c qrtool -n "__fish_seen_subcommand_from decode" -l verbose -d 'Also print the metadata'
complete -c qrtool -n "__fish_seen_subcommand_from decode" -l metadata -d 'Print only the metadata'
complete -c qrtool -n "__fish_seen_subcommand_from decode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c qrtool -n "__fish_seen_subcommand_from decode" -s V -l version -d 'Print version'
complete -c qrtool -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encode; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from help" -f -a "encode" -d 'Encode input data in a QR code'
complete -c qrtool -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encode; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from help" -f -a "decode" -d 'Detect and decode a QR code'
complete -c qrtool -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encode; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
