/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.task;

import java.time.Instant;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.timeseries.model.TaskState;
import org.opensearch.timeseries.settings.TimeSeriesSettings;
import org.opensearch.timeseries.task.RealtimeTaskCache;

public class TaskCacheManager {
    private final Logger logger = LogManager.getLogger(TaskCacheManager.class);
    private Map<String, RealtimeTaskCache> realtimeTaskCaches = new ConcurrentHashMap<String, RealtimeTaskCache>();
    private Queue<String> deletedTasks = new ConcurrentLinkedQueue<String>();
    protected volatile Integer maxCachedDeletedTask;
    protected Queue<String> deletedConfigs;

    public TaskCacheManager(Settings settings, ClusterService clusterService) {
        this.maxCachedDeletedTask = (Integer)TimeSeriesSettings.MAX_CACHED_DELETED_TASKS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TimeSeriesSettings.MAX_CACHED_DELETED_TASKS, it -> {
            this.maxCachedDeletedTask = it;
        });
        this.deletedConfigs = new ConcurrentLinkedQueue<String>();
    }

    public RealtimeTaskCache getRealtimeTaskCache(String configId) {
        return this.realtimeTaskCaches.get(configId);
    }

    public void initRealtimeTaskCache(String configId, long configIntervalInMillis) {
        this.realtimeTaskCaches.put(configId, new RealtimeTaskCache(null, null, null, configIntervalInMillis));
        this.logger.debug("Realtime task cache inited");
    }

    public void addDeletedTask(String taskId) {
        if (this.deletedTasks.size() < this.maxCachedDeletedTask) {
            this.deletedTasks.add(taskId);
        }
    }

    public boolean hasDeletedTask() {
        return !this.deletedTasks.isEmpty();
    }

    public String pollDeletedTask() {
        return this.deletedTasks.poll();
    }

    public void clearRealtimeTaskCache() {
        this.realtimeTaskCaches.clear();
    }

    public boolean isRealtimeTaskChangeNeeded(String detectorId, String newState, Float newInitProgress, String newError) {
        if (this.realtimeTaskCaches.containsKey(detectorId)) {
            RealtimeTaskCache realtimeTaskCache = this.realtimeTaskCaches.get(detectorId);
            boolean stateChangeNeeded = false;
            String oldState = realtimeTaskCache.getState();
            if (!(newState == null || newState.equals(oldState) || TaskState.INIT.name().equals(newState) && TaskState.RUNNING.name().equals(oldState))) {
                stateChangeNeeded = true;
            }
            boolean initProgressChangeNeeded = false;
            Float existingProgress = realtimeTaskCache.getInitProgress();
            if (newInitProgress != null && !newInitProgress.equals(existingProgress) && (existingProgress == null || newInitProgress.floatValue() > existingProgress.floatValue())) {
                initProgressChangeNeeded = true;
            }
            boolean errorChanged = false;
            if (newError != null && !newError.equals(realtimeTaskCache.getError())) {
                errorChanged = true;
            }
            return stateChangeNeeded || initProgressChangeNeeded || errorChanged;
        }
        return true;
    }

    public void updateRealtimeTaskCache(String configId, String newState, Float newInitProgress, String newError) {
        RealtimeTaskCache realtimeTaskCache = this.realtimeTaskCaches.get(configId);
        if (realtimeTaskCache != null) {
            if (newState != null) {
                realtimeTaskCache.setState(newState);
            }
            if (newInitProgress != null) {
                realtimeTaskCache.setInitProgress(newInitProgress);
            }
            if (newError != null) {
                realtimeTaskCache.setError(newError);
            }
            if (newState != null && !TaskState.NOT_ENDED_STATES.contains(newState)) {
                this.logger.info("Realtime task done with state {}, remove RT task cache for config ", (Object)newState, (Object)configId);
                this.removeRealtimeTaskCache(configId);
            }
        } else {
            this.logger.debug("Realtime task cache is not inited yet for config {}", (Object)configId);
        }
    }

    public void refreshRealtimeJobRunTime(String configId) {
        RealtimeTaskCache taskCache = this.realtimeTaskCaches.get(configId);
        if (taskCache != null) {
            taskCache.setLastJobRunTime(Instant.now().toEpochMilli());
        }
    }

    public String[] getConfigIdsInRealtimeTaskCache() {
        return this.realtimeTaskCaches.keySet().toArray(new String[0]);
    }

    public void removeRealtimeTaskCache(String configId) {
        if (this.realtimeTaskCaches.containsKey(configId)) {
            this.logger.info("Delete realtime cache for config {}", (Object)configId);
            this.realtimeTaskCaches.remove(configId);
        }
    }

    public void markResultIndexQueried(String configId) {
        RealtimeTaskCache realtimeTaskCache = this.realtimeTaskCaches.get(configId);
        if (realtimeTaskCache != null) {
            realtimeTaskCache.setQueriedResultIndex(true);
        }
    }

    public boolean hasQueriedResultIndex(String configId) {
        RealtimeTaskCache realtimeTaskCache = this.realtimeTaskCaches.get(configId);
        if (realtimeTaskCache != null) {
            return realtimeTaskCache.hasQueriedResultIndex();
        }
        return false;
    }

    public void addDeletedConfig(String configId) {
        if (this.deletedConfigs.size() < this.maxCachedDeletedTask) {
            this.deletedConfigs.add(configId);
        }
    }

    public String pollDeletedConfig() {
        return this.deletedConfigs.poll();
    }
}

