/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.json.JSONObject;
import org.opensearch.client.Client;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryId;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.dispatcher.AsyncQueryHandler;
import org.opensearch.sql.spark.dispatcher.BatchQueryHandler;
import org.opensearch.sql.spark.dispatcher.IndexDMLHandler;
import org.opensearch.sql.spark.dispatcher.InteractiveQueryHandler;
import org.opensearch.sql.spark.dispatcher.RefreshQueryHandler;
import org.opensearch.sql.spark.dispatcher.StreamingQueryHandler;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryActionType;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryDetails;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.execution.session.SessionManager;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.flint.FlintIndexMetadataService;
import org.opensearch.sql.spark.leasemanager.LeaseManager;
import org.opensearch.sql.spark.response.JobExecutionResponseReader;
import org.opensearch.sql.spark.rest.model.LangType;
import org.opensearch.sql.spark.utils.SQLQueryUtils;

public class SparkQueryDispatcher {
    public static final String INDEX_TAG_KEY = "index";
    public static final String DATASOURCE_TAG_KEY = "datasource";
    public static final String CLUSTER_NAME_TAG_KEY = "domain_ident";
    public static final String JOB_TYPE_TAG_KEY = "type";
    private EMRServerlessClientFactory emrServerlessClientFactory;
    private DataSourceService dataSourceService;
    private JobExecutionResponseReader jobExecutionResponseReader;
    private FlintIndexMetadataService flintIndexMetadataService;
    private Client client;
    private SessionManager sessionManager;
    private LeaseManager leaseManager;
    private StateStore stateStore;

    public DispatchQueryResponse dispatch(DispatchQueryRequest dispatchQueryRequest) {
        EMRServerlessClient emrServerlessClient = this.emrServerlessClientFactory.getClient();
        DataSourceMetadata dataSourceMetadata = this.dataSourceService.verifyDataSourceAccessAndGetRawMetadata(dispatchQueryRequest.getDatasource());
        AsyncQueryHandler asyncQueryHandler = this.sessionManager.isEnabled() ? new InteractiveQueryHandler(this.sessionManager, this.jobExecutionResponseReader, this.leaseManager) : new BatchQueryHandler(emrServerlessClient, this.jobExecutionResponseReader, this.leaseManager);
        DispatchQueryContext.DispatchQueryContextBuilder contextBuilder = DispatchQueryContext.builder().dataSourceMetadata(dataSourceMetadata).tags(SparkQueryDispatcher.getDefaultTagsForJobSubmission(dispatchQueryRequest)).queryId(AsyncQueryId.newAsyncQueryId(dataSourceMetadata.getName()));
        if (LangType.SQL.equals((Object)dispatchQueryRequest.getLangType()) && SQLQueryUtils.isFlintExtensionQuery(dispatchQueryRequest.getQuery())) {
            IndexQueryDetails indexQueryDetails = SQLQueryUtils.extractIndexDetails(dispatchQueryRequest.getQuery());
            SparkQueryDispatcher.fillMissingDetails(dispatchQueryRequest, indexQueryDetails);
            contextBuilder.indexQueryDetails(indexQueryDetails);
            if (this.isEligibleForIndexDMLHandling(indexQueryDetails)) {
                asyncQueryHandler = this.createIndexDMLHandler(emrServerlessClient);
            } else if (this.isEligibleForStreamingQuery(indexQueryDetails)) {
                asyncQueryHandler = new StreamingQueryHandler(emrServerlessClient, this.jobExecutionResponseReader, this.leaseManager);
            } else if (IndexQueryActionType.REFRESH.equals((Object)indexQueryDetails.getIndexQueryActionType())) {
                asyncQueryHandler = new RefreshQueryHandler(emrServerlessClient, this.jobExecutionResponseReader, this.flintIndexMetadataService, this.stateStore, this.leaseManager);
            }
        }
        return asyncQueryHandler.submit(dispatchQueryRequest, contextBuilder.build());
    }

    private boolean isEligibleForStreamingQuery(IndexQueryDetails indexQueryDetails) {
        Boolean isCreateAutoRefreshIndex = IndexQueryActionType.CREATE.equals((Object)indexQueryDetails.getIndexQueryActionType()) && indexQueryDetails.getFlintIndexOptions().autoRefresh();
        Boolean isAlterQuery = IndexQueryActionType.ALTER.equals((Object)indexQueryDetails.getIndexQueryActionType());
        return isCreateAutoRefreshIndex != false || isAlterQuery != false;
    }

    private boolean isEligibleForIndexDMLHandling(IndexQueryDetails indexQueryDetails) {
        return IndexQueryActionType.DROP.equals((Object)indexQueryDetails.getIndexQueryActionType()) || IndexQueryActionType.VACUUM.equals((Object)indexQueryDetails.getIndexQueryActionType()) || IndexQueryActionType.ALTER.equals((Object)indexQueryDetails.getIndexQueryActionType()) && indexQueryDetails.getFlintIndexOptions().getProvidedOptions().containsKey("auto_refresh") && !indexQueryDetails.getFlintIndexOptions().autoRefresh();
    }

    public JSONObject getQueryResponse(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        EMRServerlessClient emrServerlessClient = this.emrServerlessClientFactory.getClient();
        if (asyncQueryJobMetadata.getSessionId() != null) {
            return new InteractiveQueryHandler(this.sessionManager, this.jobExecutionResponseReader, this.leaseManager).getQueryResponse(asyncQueryJobMetadata);
        }
        if (IndexDMLHandler.isIndexDMLQuery(asyncQueryJobMetadata.getJobId())) {
            return this.createIndexDMLHandler(emrServerlessClient).getQueryResponse(asyncQueryJobMetadata);
        }
        return new BatchQueryHandler(emrServerlessClient, this.jobExecutionResponseReader, this.leaseManager).getQueryResponse(asyncQueryJobMetadata);
    }

    public String cancelJob(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        EMRServerlessClient emrServerlessClient = this.emrServerlessClientFactory.getClient();
        AsyncQueryHandler queryHandler = asyncQueryJobMetadata.getSessionId() != null ? new InteractiveQueryHandler(this.sessionManager, this.jobExecutionResponseReader, this.leaseManager) : (IndexDMLHandler.isIndexDMLQuery(asyncQueryJobMetadata.getJobId()) ? this.createIndexDMLHandler(emrServerlessClient) : (asyncQueryJobMetadata.getJobType() == JobType.BATCH ? new RefreshQueryHandler(emrServerlessClient, this.jobExecutionResponseReader, this.flintIndexMetadataService, this.stateStore, this.leaseManager) : (asyncQueryJobMetadata.getJobType() == JobType.STREAMING ? new StreamingQueryHandler(emrServerlessClient, this.jobExecutionResponseReader, this.leaseManager) : new BatchQueryHandler(emrServerlessClient, this.jobExecutionResponseReader, this.leaseManager))));
        return queryHandler.cancelJob(asyncQueryJobMetadata);
    }

    private IndexDMLHandler createIndexDMLHandler(EMRServerlessClient emrServerlessClient) {
        return new IndexDMLHandler(emrServerlessClient, this.jobExecutionResponseReader, this.flintIndexMetadataService, this.stateStore, this.client);
    }

    private static void fillMissingDetails(DispatchQueryRequest dispatchQueryRequest, IndexQueryDetails indexQueryDetails) {
        if (indexQueryDetails.getFullyQualifiedTableName() != null && indexQueryDetails.getFullyQualifiedTableName().getDatasourceName() == null) {
            indexQueryDetails.getFullyQualifiedTableName().setDatasourceName(dispatchQueryRequest.getDatasource());
        }
    }

    private static Map<String, String> getDefaultTagsForJobSubmission(DispatchQueryRequest dispatchQueryRequest) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(CLUSTER_NAME_TAG_KEY, dispatchQueryRequest.getClusterName());
        tags.put(DATASOURCE_TAG_KEY, dispatchQueryRequest.getDatasource());
        return tags;
    }

    @Generated
    public SparkQueryDispatcher(EMRServerlessClientFactory emrServerlessClientFactory, DataSourceService dataSourceService, JobExecutionResponseReader jobExecutionResponseReader, FlintIndexMetadataService flintIndexMetadataService, Client client, SessionManager sessionManager, LeaseManager leaseManager, StateStore stateStore) {
        this.emrServerlessClientFactory = emrServerlessClientFactory;
        this.dataSourceService = dataSourceService;
        this.jobExecutionResponseReader = jobExecutionResponseReader;
        this.flintIndexMetadataService = flintIndexMetadataService;
        this.client = client;
        this.sessionManager = sessionManager;
        this.leaseManager = leaseManager;
        this.stateStore = stateStore;
    }
}

