// Common Security Services Manager
// Security.framework/Headers/cssm*.h

// Schema Management Name Space Range Definition
pub const DB_RECORDTYPE_SCHEMA_START = 0x00000000;
pub const DB_RECORDTYPE_SCHEMA_END = DB_RECORDTYPE_SCHEMA_START + 4;

// Open Group Application Name Space Range Definition
pub const DB_RECORDTYPE_OPEN_GROUP_START = 0x0000000A;
pub const DB_RECORDTYPE_OPEN_GROUP_END = DB_RECORDTYPE_OPEN_GROUP_START + 8;

// Industry At Large Application Name Space Range Definition
pub const DB_RECORDTYPE_APP_DEFINED_START = 0x80000000;
pub const DB_RECORDTYPE_APP_DEFINED_END = 0xffffffff;

pub const DB_RECORDTYPE = enum(u32) {
    // Record Types defined in the Schema Management Name Space
    SCHEMA_INFO = DB_RECORDTYPE_SCHEMA_START + 0,
    SCHEMA_INDEXES = DB_RECORDTYPE_SCHEMA_START + 1,
    SCHEMA_ATTRIBUTES = DB_RECORDTYPE_SCHEMA_START + 2,
    SCHEMA_PARSING_MODULE = DB_RECORDTYPE_SCHEMA_START + 3,

    // Record Types defined in the Open Group Application Name Space
    ANY = DB_RECORDTYPE_OPEN_GROUP_START + 0,
    CERT = DB_RECORDTYPE_OPEN_GROUP_START + 1,
    CRL = DB_RECORDTYPE_OPEN_GROUP_START + 2,
    POLICY = DB_RECORDTYPE_OPEN_GROUP_START + 3,
    GENERIC = DB_RECORDTYPE_OPEN_GROUP_START + 4,
    PUBLIC_KEY = DB_RECORDTYPE_OPEN_GROUP_START + 5,
    PRIVATE_KEY = DB_RECORDTYPE_OPEN_GROUP_START + 6,
    SYMMETRIC_KEY = DB_RECORDTYPE_OPEN_GROUP_START + 7,
    ALL_KEYS = DB_RECORDTYPE_OPEN_GROUP_START + 8,

    // AppleFileDL record types
    GENERIC_PASSWORD = DB_RECORDTYPE_APP_DEFINED_START + 0,
    INTERNET_PASSWORD = DB_RECORDTYPE_APP_DEFINED_START + 1,
    APPLESHARE_PASSWORD = DB_RECORDTYPE_APP_DEFINED_START + 2,

    X509_CERTIFICATE = DB_RECORDTYPE_APP_DEFINED_START + 0x1000,
    USER_TRUST,
    X509_CRL,
    UNLOCK_REFERRAL,
    EXTENDED_ATTRIBUTE,
    METADATA = DB_RECORDTYPE_APP_DEFINED_START + 0x8000,

    _,
};
