/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.asyncquery.model;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryId;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.execution.statestore.StateModel;

public class AsyncQueryJobMetadata
extends StateModel {
    public static final String TYPE_JOBMETA = "jobmeta";
    public static final String JOB_TYPE = "jobType";
    public static final String INDEX_NAME = "indexName";
    private final AsyncQueryId queryId;
    private final String applicationId;
    private final String jobId;
    private final String resultIndex;
    private final String sessionId;
    private final JobType jobType;
    private final String datasourceName;
    private final String indexName;
    private final long seqNo;
    private final long primaryTerm;

    public AsyncQueryJobMetadata(AsyncQueryId queryId, String applicationId, String jobId, String resultIndex) {
        this(queryId, applicationId, jobId, resultIndex, null, null, JobType.INTERACTIVE, null, -2L, 0L);
    }

    public AsyncQueryJobMetadata(AsyncQueryId queryId, String applicationId, String jobId, String resultIndex, String sessionId) {
        this(queryId, applicationId, jobId, resultIndex, sessionId, null, JobType.INTERACTIVE, null, -2L, 0L);
    }

    public AsyncQueryJobMetadata(AsyncQueryId queryId, String applicationId, String jobId, String resultIndex, String sessionId, String datasourceName, JobType jobType, String indexName) {
        this(queryId, applicationId, jobId, resultIndex, sessionId, datasourceName, jobType, indexName, -2L, 0L);
    }

    public AsyncQueryJobMetadata(AsyncQueryId queryId, String applicationId, String jobId, String resultIndex, String sessionId, String datasourceName, JobType jobType, String indexName, long seqNo, long primaryTerm) {
        this.queryId = queryId;
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.resultIndex = resultIndex;
        this.sessionId = sessionId;
        this.datasourceName = datasourceName;
        this.jobType = jobType;
        this.indexName = indexName;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("queryId", this.queryId.getId()).field("type", TYPE_JOBMETA).field("jobId", this.jobId).field("applicationId", this.applicationId).field("resultIndex", this.resultIndex).field("sessionId", this.sessionId).field("dataSourceName", this.datasourceName).field(JOB_TYPE, this.jobType.getText().toLowerCase(Locale.ROOT)).field(INDEX_NAME, this.indexName).endObject();
        return builder;
    }

    public static AsyncQueryJobMetadata copy(AsyncQueryJobMetadata copy, long seqNo, long primaryTerm) {
        return new AsyncQueryJobMetadata(copy.getQueryId(), copy.getApplicationId(), copy.getJobId(), copy.getResultIndex(), copy.getSessionId(), copy.datasourceName, copy.jobType, copy.indexName, seqNo, primaryTerm);
    }

    public static AsyncQueryJobMetadata fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        AsyncQueryId queryId = null;
        String jobId = null;
        String applicationId = null;
        String resultIndex = null;
        String sessionId = null;
        String datasourceName = null;
        String jobTypeStr = null;
        String indexName = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "queryId": {
                    queryId = new AsyncQueryId(parser.textOrNull());
                    continue block24;
                }
                case "jobId": {
                    jobId = parser.textOrNull();
                    continue block24;
                }
                case "applicationId": {
                    applicationId = parser.textOrNull();
                    continue block24;
                }
                case "resultIndex": {
                    resultIndex = parser.textOrNull();
                    continue block24;
                }
                case "sessionId": {
                    sessionId = parser.textOrNull();
                    continue block24;
                }
                case "dataSourceName": {
                    datasourceName = parser.textOrNull();
                }
                case "jobType": {
                    jobTypeStr = parser.textOrNull();
                }
                case "indexName": {
                    indexName = parser.textOrNull();
                }
                case "type": {
                    continue block24;
                }
            }
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        if (jobId == null || applicationId == null) {
            throw new IllegalArgumentException("jobId and applicationId are required fields.");
        }
        return new AsyncQueryJobMetadata(queryId, applicationId, jobId, resultIndex, sessionId, datasourceName, Strings.isNullOrEmpty(jobTypeStr) ? null : JobType.fromString(jobTypeStr), indexName, seqNo, primaryTerm);
    }

    @Override
    public String getId() {
        return this.queryId.docId();
    }

    @Generated
    public AsyncQueryId getQueryId() {
        return this.queryId;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getResultIndex() {
        return this.resultIndex;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public JobType getJobType() {
        return this.jobType;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    @Generated
    public long getSeqNo() {
        return this.seqNo;
    }

    @Override
    @Generated
    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncQueryJobMetadata)) {
            return false;
        }
        AsyncQueryJobMetadata other = (AsyncQueryJobMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AsyncQueryId this$queryId = this.getQueryId();
        AsyncQueryId other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !((Object)this$queryId).equals(other$queryId)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$resultIndex = this.getResultIndex();
        String other$resultIndex = other.getResultIndex();
        if (this$resultIndex == null ? other$resultIndex != null : !this$resultIndex.equals(other$resultIndex)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        JobType this$jobType = this.getJobType();
        JobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !((Object)((Object)this$jobType)).equals((Object)other$jobType)) {
            return false;
        }
        String this$datasourceName = this.getDatasourceName();
        String other$datasourceName = other.getDatasourceName();
        if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        return !(this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncQueryJobMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AsyncQueryId $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : ((Object)$queryId).hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $resultIndex = this.getResultIndex();
        result = result * 59 + ($resultIndex == null ? 43 : $resultIndex.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        JobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : ((Object)((Object)$jobType)).hashCode());
        String $datasourceName = this.getDatasourceName();
        result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        return result;
    }
}

