/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

class AbstractVariantBackedConfigurationMetadata
implements ModuleConfigurationMetadata {
    private final ModuleComponentIdentifier componentId;
    private final ComponentVariant variant;
    private final List<? extends ModuleDependencyMetadata> dependencies;

    AbstractVariantBackedConfigurationMetadata(ModuleComponentIdentifier componentId, ComponentVariant variant) {
        this.componentId = componentId;
        this.variant = variant;
        ArrayList<GradleDependencyMetadata> dependencies = new ArrayList<GradleDependencyMetadata>(variant.getDependencies().size());
        boolean forcedDependencies = PlatformSupport.hasForcedDependencies(variant);
        for (ComponentVariant.Dependency dependency : variant.getDependencies()) {
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dependency.getGroup(), dependency.getModule()), dependency.getVersionConstraint(), (AttributeContainer)dependency.getAttributes(), dependency.getRequestedCapabilities());
            ImmutableList<ExcludeMetadata> excludes = dependency.getExcludes();
            IvyArtifactName dependencyArtifact = dependency.getDependencyArtifact();
            dependencies.add(new GradleDependencyMetadata(selector, (List<ExcludeMetadata>)excludes, false, dependency.isEndorsingStrictVersions(), dependency.getReason(), forcedDependencies, dependencyArtifact));
        }
        for (ComponentVariant.DependencyConstraint dependencyConstraint : variant.getDependencyConstraints()) {
            dependencies.add(new GradleDependencyMetadata(DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dependencyConstraint.getGroup(), dependencyConstraint.getModule()), dependencyConstraint.getVersionConstraint(), (AttributeContainer)dependencyConstraint.getAttributes(), (Collection<Capability>)ImmutableList.of()), Collections.emptyList(), true, false, dependencyConstraint.getReason(), forcedDependencies, null));
        }
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    AbstractVariantBackedConfigurationMetadata(ModuleComponentIdentifier componentId, ComponentVariant variant, List<? extends ModuleDependencyMetadata> dependencies) {
        this.componentId = componentId;
        this.variant = variant;
        this.dependencies = dependencies;
    }

    @Override
    public String getName() {
        return this.variant.getName();
    }

    @Override
    public VariantResolveMetadata.Identifier getIdentifier() {
        return this.variant.getIdentifier();
    }

    @Override
    public ImmutableSet<String> getHierarchy() {
        return ImmutableSet.of((Object)this.variant.getName());
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.componentId, (Object)"variant", (Object)this.variant.getName());
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.variant.getAttributes().asImmutable();
    }

    @Override
    public Set<? extends VariantResolveMetadata> getVariants() {
        return ImmutableSet.of((Object)this.variant);
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public DeprecationMessageBuilder.WithDocumentation getConsumptionDeprecation() {
        return null;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        return ImmutableList.of();
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    @Override
    public CapabilitiesMetadata getCapabilities() {
        return this.variant.getCapabilities();
    }

    @Override
    public ImmutableList<? extends ComponentArtifactMetadata> getArtifacts() {
        return this.variant.getArtifacts();
    }

    @Override
    public List<? extends ModuleDependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    protected ComponentVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean isExternalVariant() {
        return this.variant.isExternalVariant();
    }

    @Override
    public boolean isEligibleForCaching() {
        return this.variant.isEligibleForCaching();
    }
}

