/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.UTFStringParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.Transition;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;

final class DataStructureParser {
    private final String[] relations;

    DataStructureParser(String[] relations) {
        this.relations = relations;
    }

    public DataStructure[] read(byte[] data, Offset offset) throws InvalidJfrFileException {
        int noDataStructures = NumberReaders.readInt(data, offset);
        DataStructure[] dataStructures = new DataStructure[noDataStructures];
        for (int i = 0; i < noDataStructures; ++i) {
            int arraySize = NumberReaders.readInt(data, offset);
            ValueDescriptor[] vds = new ValueDescriptor[arraySize];
            for (int n = 0; n < arraySize; ++n) {
                String id = UTFStringParser.readString(data, offset);
                String name = UTFStringParser.readString(data, offset);
                String description = UTFStringParser.readString(data, offset);
                Transition transition = DataStructureParser.readTransition(data, offset);
                DataType dataType = ParserToolkit.get(DataType.values(), NumberReaders.readByte(data, offset));
                int contentType = NumberReaders.readInt(data, offset);
                int dataStructIndex = NumberReaders.readInt(data, offset);
                NumberReaders.readInt(data, offset);
                String relation = dataType.isPrimitive() && dataStructIndex > 0 ? ParserToolkit.get(this.relations, dataStructIndex - 1) : null;
                vds[n] = new ValueDescriptor(id, name, description, transition, dataType, relation, contentType, dataStructures, dataStructIndex);
            }
            dataStructures[i] = new DataStructure(vds);
        }
        return dataStructures;
    }

    private static Transition readTransition(byte[] bytes, Offset offset) throws InvalidJfrFileException {
        byte transitionType = bytes[offset.getAndIncrease(1)];
        if (transitionType == 0) {
            return Transition.None;
        }
        if (transitionType == 1) {
            return Transition.From;
        }
        return Transition.To;
    }
}

