"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const legacy = __importStar(require("../lib/legacy"));
const modernExtend_1 = require("../lib/modernExtend");
const reporting = __importStar(require("../lib/reporting"));
const utils = __importStar(require("../lib/utils"));
const e = exposes.presets;
const ea = exposes.access;
const fzLocal = {
    on_off_via_brightness: {
        cluster: 'genLevelCtrl',
        type: ['attributeReport', 'readResponse'],
        convert: (model, msg, publish, options, meta) => {
            if (msg.data.hasOwnProperty('currentLevel')) {
                const currentLevel = Number(msg.data['currentLevel']);
                const property = utils.postfixWithEndpointName('state', msg, model, meta);
                return { [property]: currentLevel > 0 ? 'ON' : 'OFF' };
            }
        },
    },
};
const definitions = [
    {
        zigbeeModel: ['DL15S'],
        model: 'DL15S-1BZ',
        vendor: 'Leviton',
        description: 'Lumina RF 15A switch, 120/277V',
        extend: [(0, modernExtend_1.onOff)()],
    },
    {
        zigbeeModel: ['DG6HD'],
        model: 'DG6HD-1BW',
        vendor: 'Leviton',
        description: 'Zigbee in-wall smart dimmer',
        extend: [(0, modernExtend_1.light)({ effect: false, configureReporting: true })],
    },
    {
        zigbeeModel: ['DG3HL'],
        model: 'DG3HL-1BW',
        vendor: 'Leviton',
        description: 'Indoor Decora smart Zigbee 3.0 certified plug-in dimmer',
        extend: [(0, modernExtend_1.light)({ effect: false, configureReporting: true })],
    },
    {
        zigbeeModel: ['DG15A'],
        model: 'DG15A-1BW',
        vendor: 'Leviton',
        description: 'Indoor Decora smart Zigbee 3.0 certified plug-in outlet',
        extend: [(0, modernExtend_1.onOff)()],
    },
    {
        zigbeeModel: ['DG15S'],
        model: 'DG15S-1BW',
        vendor: 'Leviton',
        description: 'Decora smart Zigbee 3.0 certified 15A switch',
        extend: [(0, modernExtend_1.onOff)({ powerOnBehavior: false })],
    },
    {
        zigbeeModel: ['65A01-1'],
        model: 'RC-2000WH',
        vendor: 'Leviton',
        description: 'Omnistat2 wireless thermostat',
        fromZigbee: [legacy.fz.thermostat_att_report, fromZigbee_1.default.fan],
        toZigbee: [
            toZigbee_1.default.thermostat_local_temperature,
            toZigbee_1.default.thermostat_local_temperature_calibration,
            toZigbee_1.default.thermostat_occupancy,
            toZigbee_1.default.thermostat_occupied_heating_setpoint,
            toZigbee_1.default.thermostat_unoccupied_heating_setpoint,
            toZigbee_1.default.thermostat_occupied_cooling_setpoint,
            toZigbee_1.default.thermostat_unoccupied_cooling_setpoint,
            toZigbee_1.default.thermostat_setpoint_raise_lower,
            toZigbee_1.default.thermostat_remote_sensing,
            toZigbee_1.default.thermostat_control_sequence_of_operation,
            toZigbee_1.default.thermostat_system_mode,
            toZigbee_1.default.thermostat_weekly_schedule,
            toZigbee_1.default.thermostat_clear_weekly_schedule,
            toZigbee_1.default.thermostat_relay_status_log,
            toZigbee_1.default.thermostat_temperature_setpoint_hold,
            toZigbee_1.default.thermostat_temperature_setpoint_hold_duration,
            toZigbee_1.default.fan_mode,
        ],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(9);
            await reporting.bind(endpoint, coordinatorEndpoint, ['hvacThermostat', 'hvacFanCtrl']);
            await reporting.thermostatTemperature(endpoint);
            await reporting.thermostatSystemMode(endpoint);
            await reporting.thermostatOccupiedHeatingSetpoint(endpoint);
            await reporting.thermostatUnoccupiedHeatingSetpoint(endpoint);
            await reporting.thermostatOccupiedCoolingSetpoint(endpoint);
            await reporting.thermostatUnoccupiedCoolingSetpoint(endpoint);
            await reporting.fanMode(endpoint);
        },
        exposes: [
            e
                .climate()
                .withSetpoint('occupied_heating_setpoint', 10, 30, 1)
                .withLocalTemperature()
                .withSystemMode(['off', 'auto', 'heat', 'cool'])
                .withFanMode(['auto', 'on', 'smart'])
                .withSetpoint('occupied_cooling_setpoint', 10, 30, 1)
                .withLocalTemperatureCalibration()
                .withPiHeatingDemand(),
        ],
    },
    {
        // Reference from a similar switch: https://gist.github.com/nebhead/dc5a0a827ec14eef6196ded4be6e2dd0
        zigbeeModel: ['ZS057'],
        model: 'ZS057-D0Z',
        vendor: 'Leviton',
        description: 'Wall switch, 0-10V dimmer, 120-277V, Lumina™ RF',
        meta: { disableDefaultResponse: true },
        extend: [(0, modernExtend_1.light)({ effect: false, configureReporting: true })],
        fromZigbee: [fzLocal.on_off_via_brightness, fromZigbee_1.default.lighting_ballast_configuration],
        toZigbee: [toZigbee_1.default.ballast_config],
        exposes: [
            // Note: ballast_power_on_level used to be here, but it doesn't appear to work properly with this device
            // If set, it's reset back to 0 when the device is turned off then back to 32 when turned on
            e.numeric('ballast_minimum_level', ea.ALL).withValueMin(1).withValueMax(254).withDescription('Specifies the minimum brightness value'),
            e.numeric('ballast_maximum_level', ea.ALL).withValueMin(1).withValueMax(254).withDescription('Specifies the maximum brightness value'),
        ],
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=leviton.js.map