"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityTracesPluginOrder = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.TIMESTAMP_DATETIME_TYPES = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SECURITY_ROLES = exports.SECURITY_PLUGIN_ACCOUNT_API = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATA_SOURCE_TYPE = exports.QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_END_TIME = exports.PROMQL_METRIC_SUBTYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_METRIC_SUBTYPE = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OTEL_METRIC_SUBTYPE = exports.OTEL_DATE_FORMAT = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.EDIT = exports.DSL_SETTINGS = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DIRECT_DUMMY_QUERY = exports.DEFAULT_START_TIME = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = exports.ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = void 0;
exports.queryWorkbenchPluginID = exports.queryWorkbenchPluginCheck = exports.pageStyles = exports.observabilityTracesTitle = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const DSL_CAT = exports.DSL_CAT = '/cat.indices';
const DSL_MAPPING = exports.DSL_MAPPING = '/indices.getFieldMapping';
const DSL_SETTINGS = exports.DSL_SETTINGS = '/indices.getFieldSettings';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const INTEGRATIONS_BASE = exports.INTEGRATIONS_BASE = '/api/integrations';
const JOBS_BASE = exports.JOBS_BASE = '/query/jobs';
const DATACONNECTIONS_BASE = exports.DATACONNECTIONS_BASE = '/api/dataconnections';
const EDIT = exports.EDIT = '/edit';
const DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_UPDATE_STATUS = '/status';
const SECURITY_ROLES = exports.SECURITY_ROLES = '/api/v1/configuration/roles';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const CONSOLE_PROXY = exports.CONSOLE_PROXY = '/api/console/proxy';
const SECURITY_PLUGIN_ACCOUNT_API = exports.SECURITY_PLUGIN_ACCOUNT_API = '/api/v1/configuration/account';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const DSL_ENDPOINT = exports.DSL_ENDPOINT = '/_plugins/_dsl';
const DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
const JOBS_ENDPOINT_BASE = exports.JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
const JOB_RESULT_ENDPOINT = exports.JOB_RESULT_ENDPOINT = '/result';
const observabilityID = exports.observabilityID = 'observability-logs';
const observabilityTitle = exports.observabilityTitle = 'Observability';
const observabilityPluginOrder = exports.observabilityPluginOrder = 1500;
const observabilityApplicationsID = exports.observabilityApplicationsID = 'observability-applications';
const observabilityApplicationsTitle = exports.observabilityApplicationsTitle = 'Applications';
const observabilityApplicationsPluginOrder = exports.observabilityApplicationsPluginOrder = 5090;
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const observabilityLogsTitle = exports.observabilityLogsTitle = 'Logs';
const observabilityLogsPluginOrder = exports.observabilityLogsPluginOrder = 5091;
const observabilityMetricsID = exports.observabilityMetricsID = 'observability-metrics';
const observabilityMetricsTitle = exports.observabilityMetricsTitle = 'Metrics';
const observabilityMetricsPluginOrder = exports.observabilityMetricsPluginOrder = 5092;
const observabilityTracesID = exports.observabilityTracesID = 'observability-traces';
const observabilityTracesTitle = exports.observabilityTracesTitle = 'Traces';
const observabilityTracesPluginOrder = exports.observabilityTracesPluginOrder = 5093;
const observabilityNotebookID = exports.observabilityNotebookID = 'observability-notebooks';
const observabilityNotebookTitle = exports.observabilityNotebookTitle = 'Notebooks';
const observabilityNotebookPluginOrder = exports.observabilityNotebookPluginOrder = 5094;
const observabilityPanelsID = exports.observabilityPanelsID = 'observability-dashboards';
const observabilityPanelsTitle = exports.observabilityPanelsTitle = 'Dashboards';
const observabilityPanelsPluginOrder = exports.observabilityPanelsPluginOrder = 5095;
const observabilityIntegrationsID = exports.observabilityIntegrationsID = 'integrations';
const observabilityIntegrationsTitle = exports.observabilityIntegrationsTitle = 'Integrations';
const observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsPluginOrder = 9020;
const observabilityDataConnectionsID = exports.observabilityDataConnectionsID = 'datasources';
const observabilityDataConnectionsTitle = exports.observabilityDataConnectionsTitle = 'Data sources';
const observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsPluginOrder = 9030;
const queryWorkbenchPluginID = exports.queryWorkbenchPluginID = 'opensearch-query-workbench';
const queryWorkbenchPluginCheck = exports.queryWorkbenchPluginCheck = 'plugin:queryWorkbenchDashboards';

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const PPL_DATE_FORMAT = exports.PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
const OTEL_DATE_FORMAT = exports.OTEL_DATE_FORMAT = 'YYYY-MM-DDTHH:mm:ss';
const SPAN_REGEX = exports.SPAN_REGEX = /span/;
const PROMQL_METRIC_SUBTYPE = exports.PROMQL_METRIC_SUBTYPE = 'promqlmetric';
const OTEL_METRIC_SUBTYPE = exports.OTEL_METRIC_SUBTYPE = 'openTelemetryMetric';
const PPL_METRIC_SUBTYPE = exports.PPL_METRIC_SUBTYPE = 'metric';
const PPL_SPAN_REGEX = exports.PPL_SPAN_REGEX = /by\s*span/i;
const PPL_STATS_REGEX = exports.PPL_STATS_REGEX = /\|\s*stats/i;
const PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
const PPL_INDEX_REGEX = exports.PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
const PPL_WHERE_CLAUSE_REGEX = exports.PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
const PPL_NEWLINE_REGEX = exports.PPL_NEWLINE_REGEX = /[\n\r]+/g;
const PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DESCRIBE_INDEX_REGEX = /(describe)\s+([^|\s]+)/i;

// Observability plugin URI
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = exports.OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';

// Color Constants
const PLOTLY_COLOR = exports.PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
const LONG_CHART_COLOR = exports.LONG_CHART_COLOR = PLOTLY_COLOR[1];
const pageStyles = exports.pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
let VIS_CHART_TYPES = exports.VIS_CHART_TYPES = /*#__PURE__*/function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
  VIS_CHART_TYPES["Histogram"] = "histogram";
  return VIS_CHART_TYPES;
}({});
const NUMERICAL_FIELDS = exports.NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
const ENABLED_VIS_TYPES = exports.ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text];

// Live tail constants
const LIVE_OPTIONS = exports.LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
const LIVE_END_TIME = exports.LIVE_END_TIME = 'now';
const DEFAULT_CHART_STYLES = exports.DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
const FILLOPACITY_DIV_FACTOR = exports.FILLOPACITY_DIV_FACTOR = 200;
const SLIDER_MIN_VALUE = exports.SLIDER_MIN_VALUE = 0;
const SLIDER_MAX_VALUE = exports.SLIDER_MAX_VALUE = 100;
const SLIDER_STEP = exports.SLIDER_STEP = 1;
const THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_WIDTH = 3;
const THRESHOLD_LINE_OPACITY = exports.THRESHOLD_LINE_OPACITY = 0.7;
const MAX_BUCKET_LENGTH = exports.MAX_BUCKET_LENGTH = 16;
let BarOrientation = exports.BarOrientation = /*#__PURE__*/function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
  return BarOrientation;
}({});
const PLOT_MARGIN = exports.PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
const WAITING_TIME_ON_USER_ACTIONS = exports.WAITING_TIME_ON_USER_ACTIONS = 300;
const VISUALIZATION_ERROR = exports.VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data',
  NO_SERIES: 'Add a field to start',
  NO_METRIC: 'Invalid Metric MetaData'
};
const S3_DATA_SOURCE_TYPE = exports.S3_DATA_SOURCE_TYPE = 's3glue';
const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_DATASOURCE_CACHE = 'async-query-catalog-cache';
const ASYNC_QUERY_ACCELERATIONS_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = 'async-query-acclerations-cache';
const DIRECT_DUMMY_QUERY = exports.DIRECT_DUMMY_QUERY = 'select 1';
const DEFAULT_START_TIME = exports.DEFAULT_START_TIME = 'now-15m';
const QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_START_TIME = 'now-40y';
const QUERY_ASSIST_END_TIME = exports.QUERY_ASSIST_END_TIME = 'now';
const TIMESTAMP_DATETIME_TYPES = exports.TIMESTAMP_DATETIME_TYPES = ['date', 'date_nanos'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJQUExfQkFTRSIsImV4cG9ydHMiLCJQUExfU0VBUkNIIiwiRFNMX0JBU0UiLCJEU0xfU0VBUkNIIiwiRFNMX0NBVCIsIkRTTF9NQVBQSU5HIiwiRFNMX1NFVFRJTkdTIiwiT0JTRVJWQUJJTElUWV9CQVNFIiwiSU5URUdSQVRJT05TX0JBU0UiLCJKT0JTX0JBU0UiLCJEQVRBQ09OTkVDVElPTlNfQkFTRSIsIkVESVQiLCJEQVRBQ09OTkVDVElPTlNfVVBEQVRFX1NUQVRVUyIsIlNFQ1VSSVRZX1JPTEVTIiwiRVZFTlRfQU5BTFlUSUNTIiwiU0FWRURfT0JKRUNUUyIsIlNBVkVEX1FVRVJZIiwiU0FWRURfVklTVUFMSVpBVElPTiIsIkNPTlNPTEVfUFJPWFkiLCJTRUNVUklUWV9QTFVHSU5fQUNDT1VOVF9BUEkiLCJQUExfRU5EUE9JTlQiLCJTUUxfRU5EUE9JTlQiLCJEU0xfRU5EUE9JTlQiLCJEQVRBQ09OTkVDVElPTlNfRU5EUE9JTlQiLCJKT0JTX0VORFBPSU5UX0JBU0UiLCJKT0JfUkVTVUxUX0VORFBPSU5UIiwib2JzZXJ2YWJpbGl0eUlEIiwib2JzZXJ2YWJpbGl0eVRpdGxlIiwib2JzZXJ2YWJpbGl0eVBsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eUFwcGxpY2F0aW9uc0lEIiwib2JzZXJ2YWJpbGl0eUFwcGxpY2F0aW9uc1RpdGxlIiwib2JzZXJ2YWJpbGl0eUFwcGxpY2F0aW9uc1BsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eUxvZ3NJRCIsIm9ic2VydmFiaWxpdHlMb2dzVGl0bGUiLCJvYnNlcnZhYmlsaXR5TG9nc1BsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eU1ldHJpY3NJRCIsIm9ic2VydmFiaWxpdHlNZXRyaWNzVGl0bGUiLCJvYnNlcnZhYmlsaXR5TWV0cmljc1BsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eVRyYWNlc0lEIiwib2JzZXJ2YWJpbGl0eVRyYWNlc1RpdGxlIiwib2JzZXJ2YWJpbGl0eVRyYWNlc1BsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eU5vdGVib29rSUQiLCJvYnNlcnZhYmlsaXR5Tm90ZWJvb2tUaXRsZSIsIm9ic2VydmFiaWxpdHlOb3RlYm9va1BsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eVBhbmVsc0lEIiwib2JzZXJ2YWJpbGl0eVBhbmVsc1RpdGxlIiwib2JzZXJ2YWJpbGl0eVBhbmVsc1BsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eUludGVncmF0aW9uc0lEIiwib2JzZXJ2YWJpbGl0eUludGVncmF0aW9uc1RpdGxlIiwib2JzZXJ2YWJpbGl0eUludGVncmF0aW9uc1BsdWdpbk9yZGVyIiwib2JzZXJ2YWJpbGl0eURhdGFDb25uZWN0aW9uc0lEIiwib2JzZXJ2YWJpbGl0eURhdGFDb25uZWN0aW9uc1RpdGxlIiwib2JzZXJ2YWJpbGl0eURhdGFDb25uZWN0aW9uc1BsdWdpbk9yZGVyIiwicXVlcnlXb3JrYmVuY2hQbHVnaW5JRCIsInF1ZXJ5V29ya2JlbmNoUGx1Z2luQ2hlY2siLCJTUUxfRE9DVU1FTlRBVElPTl9VUkwiLCJQUExfRE9DVU1FTlRBVElPTl9VUkwiLCJQUExfUEFUVEVSTlNfRE9DVU1FTlRBVElPTl9VUkwiLCJVSV9EQVRFX0ZPUk1BVCIsIlBQTF9EQVRFX0ZPUk1BVCIsIk9URUxfREFURV9GT1JNQVQiLCJTUEFOX1JFR0VYIiwiUFJPTVFMX01FVFJJQ19TVUJUWVBFIiwiT1RFTF9NRVRSSUNfU1VCVFlQRSIsIlBQTF9NRVRSSUNfU1VCVFlQRSIsIlBQTF9TUEFOX1JFR0VYIiwiUFBMX1NUQVRTX1JFR0VYIiwiUFBMX0lOREVYX0lOU0VSVF9QT0lOVF9SRUdFWCIsIlBQTF9JTkRFWF9SRUdFWCIsIlBQTF9XSEVSRV9DTEFVU0VfUkVHRVgiLCJQUExfTkVXTElORV9SRUdFWCIsIlBQTF9ERVNDUklCRV9JTkRFWF9SRUdFWCIsIkJBU0VfT0JTRVJWQUJJTElUWV9VUkkiLCJCQVNFX0RBVEFDT05ORUNUSU9OU19VUkkiLCJPUEVOU0VBUkNIX1BBTkVMU19BUEkiLCJPQkpFQ1QiLCJPUEVOU0VBUkNIX0RBVEFDT05ORUNUSU9OU19BUEkiLCJEQVRBQ09OTkVDVElPTiIsIlNBVkVEX09CSkVDVCIsIlBMT1RMWV9DT0xPUiIsIkxPTkdfQ0hBUlRfQ09MT1IiLCJwYWdlU3R5bGVzIiwiZmxvYXQiLCJ3aWR0aCIsIm1heFdpZHRoIiwiVklTX0NIQVJUX1RZUEVTIiwiTlVNRVJJQ0FMX0ZJRUxEUyIsIkVOQUJMRURfVklTX1RZUEVTIiwiQmFyIiwiSG9yaXpvbnRhbEJhciIsIkxpbmUiLCJQaWUiLCJIZWF0TWFwIiwiVGV4dCIsIkxJVkVfT1BUSU9OUyIsImxhYmVsIiwic3RhcnRUaW1lIiwiZGVsYXlUaW1lIiwiTElWRV9FTkRfVElNRSIsIkRFRkFVTFRfQ0hBUlRfU1RZTEVTIiwiRGVmYXVsdE1vZGVMaW5lIiwiSW50ZXJwb2xhdGlvbiIsIkxpbmVXaWR0aCIsIkZpbGxPcGFjaXR5IiwiTWFya2VyU2l6ZSIsIlNob3dMZWdlbmQiLCJMZWdlbmRQb3NpdGlvbiIsIkxhYmVsQW5nbGUiLCJEZWZhdWx0U29ydFNlY3RvcnMiLCJEZWZhdWx0TW9kZVNjYXR0ZXIiLCJGSUxMT1BBQ0lUWV9ESVZfRkFDVE9SIiwiU0xJREVSX01JTl9WQUxVRSIsIlNMSURFUl9NQVhfVkFMVUUiLCJTTElERVJfU1RFUCIsIlRIUkVTSE9MRF9MSU5FX1dJRFRIIiwiVEhSRVNIT0xEX0xJTkVfT1BBQ0lUWSIsIk1BWF9CVUNLRVRfTEVOR1RIIiwiQmFyT3JpZW50YXRpb24iLCJQTE9UX01BUkdJTiIsImwiLCJyIiwiYiIsInQiLCJwYWQiLCJXQUlUSU5HX1RJTUVfT05fVVNFUl9BQ1RJT05TIiwiVklTVUFMSVpBVElPTl9FUlJPUiIsIk5PX0RBVEEiLCJJTlZBTElEX0RBVEEiLCJOT19TRVJJRVMiLCJOT19NRVRSSUMiLCJTM19EQVRBX1NPVVJDRV9UWVBFIiwiQVNZTkNfUVVFUllfU0VTU0lPTl9JRCIsIkFTWU5DX1FVRVJZX0RBVEFTT1VSQ0VfQ0FDSEUiLCJBU1lOQ19RVUVSWV9BQ0NFTEVSQVRJT05TX0NBQ0hFIiwiRElSRUNUX0RVTU1ZX1FVRVJZIiwiREVGQVVMVF9TVEFSVF9USU1FIiwiUVVFUllfQVNTSVNUX1NUQVJUX1RJTUUiLCJRVUVSWV9BU1NJU1RfRU5EX1RJTUUiLCJUSU1FU1RBTVBfREFURVRJTUVfVFlQRVMiXSwic291cmNlcyI6WyJzaGFyZWQudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG4vLyBDbGllbnQgcm91dGVcbmV4cG9ydCBjb25zdCBQUExfQkFTRSA9ICcvYXBpL3BwbCc7XG5leHBvcnQgY29uc3QgUFBMX1NFQVJDSCA9ICcvc2VhcmNoJztcbmV4cG9ydCBjb25zdCBEU0xfQkFTRSA9ICcvYXBpL2RzbCc7XG5leHBvcnQgY29uc3QgRFNMX1NFQVJDSCA9ICcvc2VhcmNoJztcbmV4cG9ydCBjb25zdCBEU0xfQ0FUID0gJy9jYXQuaW5kaWNlcyc7XG5leHBvcnQgY29uc3QgRFNMX01BUFBJTkcgPSAnL2luZGljZXMuZ2V0RmllbGRNYXBwaW5nJztcbmV4cG9ydCBjb25zdCBEU0xfU0VUVElOR1MgPSAnL2luZGljZXMuZ2V0RmllbGRTZXR0aW5ncyc7XG5leHBvcnQgY29uc3QgT0JTRVJWQUJJTElUWV9CQVNFID0gJy9hcGkvb2JzZXJ2YWJpbGl0eSc7XG5leHBvcnQgY29uc3QgSU5URUdSQVRJT05TX0JBU0UgPSAnL2FwaS9pbnRlZ3JhdGlvbnMnO1xuZXhwb3J0IGNvbnN0IEpPQlNfQkFTRSA9ICcvcXVlcnkvam9icyc7XG5leHBvcnQgY29uc3QgREFUQUNPTk5FQ1RJT05TX0JBU0UgPSAnL2FwaS9kYXRhY29ubmVjdGlvbnMnO1xuZXhwb3J0IGNvbnN0IEVESVQgPSAnL2VkaXQnO1xuZXhwb3J0IGNvbnN0IERBVEFDT05ORUNUSU9OU19VUERBVEVfU1RBVFVTID0gJy9zdGF0dXMnO1xuZXhwb3J0IGNvbnN0IFNFQ1VSSVRZX1JPTEVTID0gJy9hcGkvdjEvY29uZmlndXJhdGlvbi9yb2xlcyc7XG5leHBvcnQgY29uc3QgRVZFTlRfQU5BTFlUSUNTID0gJy9ldmVudF9hbmFseXRpY3MnO1xuZXhwb3J0IGNvbnN0IFNBVkVEX09CSkVDVFMgPSAnL3NhdmVkX29iamVjdHMnO1xuZXhwb3J0IGNvbnN0IFNBVkVEX1FVRVJZID0gJy9xdWVyeSc7XG5leHBvcnQgY29uc3QgU0FWRURfVklTVUFMSVpBVElPTiA9ICcvdmlzJztcbmV4cG9ydCBjb25zdCBDT05TT0xFX1BST1hZID0gJy9hcGkvY29uc29sZS9wcm94eSc7XG5leHBvcnQgY29uc3QgU0VDVVJJVFlfUExVR0lOX0FDQ09VTlRfQVBJID0gJy9hcGkvdjEvY29uZmlndXJhdGlvbi9hY2NvdW50JztcblxuLy8gU2VydmVyIHJvdXRlXG5leHBvcnQgY29uc3QgUFBMX0VORFBPSU5UID0gJy9fcGx1Z2lucy9fcHBsJztcbmV4cG9ydCBjb25zdCBTUUxfRU5EUE9JTlQgPSAnL19wbHVnaW5zL19zcWwnO1xuZXhwb3J0IGNvbnN0IERTTF9FTkRQT0lOVCA9ICcvX3BsdWdpbnMvX2RzbCc7XG5leHBvcnQgY29uc3QgREFUQUNPTk5FQ1RJT05TX0VORFBPSU5UID0gJy9fcGx1Z2lucy9fcXVlcnkvX2RhdGFzb3VyY2VzJztcbmV4cG9ydCBjb25zdCBKT0JTX0VORFBPSU5UX0JBU0UgPSAnL19wbHVnaW5zL19hc3luY19xdWVyeSc7XG5leHBvcnQgY29uc3QgSk9CX1JFU1VMVF9FTkRQT0lOVCA9ICcvcmVzdWx0JztcblxuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlJRCA9ICdvYnNlcnZhYmlsaXR5LWxvZ3MnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlUaXRsZSA9ICdPYnNlcnZhYmlsaXR5JztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5UGx1Z2luT3JkZXIgPSAxNTAwO1xuXG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUFwcGxpY2F0aW9uc0lEID0gJ29ic2VydmFiaWxpdHktYXBwbGljYXRpb25zJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5QXBwbGljYXRpb25zVGl0bGUgPSAnQXBwbGljYXRpb25zJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5QXBwbGljYXRpb25zUGx1Z2luT3JkZXIgPSA1MDkwO1xuXG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUxvZ3NJRCA9ICdvYnNlcnZhYmlsaXR5LWxvZ3MnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlMb2dzVGl0bGUgPSAnTG9ncyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUxvZ3NQbHVnaW5PcmRlciA9IDUwOTE7XG5cbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5TWV0cmljc0lEID0gJ29ic2VydmFiaWxpdHktbWV0cmljcyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eU1ldHJpY3NUaXRsZSA9ICdNZXRyaWNzJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5TWV0cmljc1BsdWdpbk9yZGVyID0gNTA5MjtcblxuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlUcmFjZXNJRCA9ICdvYnNlcnZhYmlsaXR5LXRyYWNlcyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eVRyYWNlc1RpdGxlID0gJ1RyYWNlcyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eVRyYWNlc1BsdWdpbk9yZGVyID0gNTA5MztcblxuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlOb3RlYm9va0lEID0gJ29ic2VydmFiaWxpdHktbm90ZWJvb2tzJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5Tm90ZWJvb2tUaXRsZSA9ICdOb3RlYm9va3MnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlOb3RlYm9va1BsdWdpbk9yZGVyID0gNTA5NDtcblxuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlQYW5lbHNJRCA9ICdvYnNlcnZhYmlsaXR5LWRhc2hib2FyZHMnO1xuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlQYW5lbHNUaXRsZSA9ICdEYXNoYm9hcmRzJztcbmV4cG9ydCBjb25zdCBvYnNlcnZhYmlsaXR5UGFuZWxzUGx1Z2luT3JkZXIgPSA1MDk1O1xuXG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUludGVncmF0aW9uc0lEID0gJ2ludGVncmF0aW9ucyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUludGVncmF0aW9uc1RpdGxlID0gJ0ludGVncmF0aW9ucyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eUludGVncmF0aW9uc1BsdWdpbk9yZGVyID0gOTAyMDtcblxuZXhwb3J0IGNvbnN0IG9ic2VydmFiaWxpdHlEYXRhQ29ubmVjdGlvbnNJRCA9ICdkYXRhc291cmNlcyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eURhdGFDb25uZWN0aW9uc1RpdGxlID0gJ0RhdGEgc291cmNlcyc7XG5leHBvcnQgY29uc3Qgb2JzZXJ2YWJpbGl0eURhdGFDb25uZWN0aW9uc1BsdWdpbk9yZGVyID0gOTAzMDtcblxuZXhwb3J0IGNvbnN0IHF1ZXJ5V29ya2JlbmNoUGx1Z2luSUQgPSAnb3BlbnNlYXJjaC1xdWVyeS13b3JrYmVuY2gnO1xuZXhwb3J0IGNvbnN0IHF1ZXJ5V29ya2JlbmNoUGx1Z2luQ2hlY2sgPSAncGx1Z2luOnF1ZXJ5V29ya2JlbmNoRGFzaGJvYXJkcyc7XG5cbi8vIFNoYXJlZCBDb25zdGFudHNcbmV4cG9ydCBjb25zdCBTUUxfRE9DVU1FTlRBVElPTl9VUkwgPSAnaHR0cHM6Ly9vcGVuc2VhcmNoLm9yZy9kb2NzL2xhdGVzdC9zZWFyY2gtcGx1Z2lucy9zcWwvaW5kZXgvJztcbmV4cG9ydCBjb25zdCBQUExfRE9DVU1FTlRBVElPTl9VUkwgPVxuICAnaHR0cHM6Ly9vcGVuc2VhcmNoLm9yZy9kb2NzL2xhdGVzdC9zZWFyY2gtcGx1Z2lucy9zcWwvcHBsL2luZGV4JztcbmV4cG9ydCBjb25zdCBQUExfUEFUVEVSTlNfRE9DVU1FTlRBVElPTl9VUkwgPVxuICAnaHR0cHM6Ly9naXRodWIuY29tL29wZW5zZWFyY2gtcHJvamVjdC9zcWwvYmxvYi8yLngvZG9jcy91c2VyL3BwbC9jbWQvcGF0dGVybnMucnN0I2Rlc2NyaXB0aW9uJztcbmV4cG9ydCBjb25zdCBVSV9EQVRFX0ZPUk1BVCA9ICdNTS9ERC9ZWVlZIGhoOm1tIEEnO1xuZXhwb3J0IGNvbnN0IFBQTF9EQVRFX0ZPUk1BVCA9ICdZWVlZLU1NLUREIEhIOm1tOnNzLlNTU1NTUyc7XG5leHBvcnQgY29uc3QgT1RFTF9EQVRFX0ZPUk1BVCA9ICdZWVlZLU1NLUREVEhIOm1tOnNzJztcbmV4cG9ydCBjb25zdCBTUEFOX1JFR0VYID0gL3NwYW4vO1xuXG5leHBvcnQgY29uc3QgUFJPTVFMX01FVFJJQ19TVUJUWVBFID0gJ3Byb21xbG1ldHJpYyc7XG5leHBvcnQgY29uc3QgT1RFTF9NRVRSSUNfU1VCVFlQRSA9ICdvcGVuVGVsZW1ldHJ5TWV0cmljJztcbmV4cG9ydCBjb25zdCBQUExfTUVUUklDX1NVQlRZUEUgPSAnbWV0cmljJztcblxuZXhwb3J0IGNvbnN0IFBQTF9TUEFOX1JFR0VYID0gL2J5XFxzKnNwYW4vaTtcbmV4cG9ydCBjb25zdCBQUExfU1RBVFNfUkVHRVggPSAvXFx8XFxzKnN0YXRzL2k7XG5leHBvcnQgY29uc3QgUFBMX0lOREVYX0lOU0VSVF9QT0lOVF9SRUdFWCA9IC8oc2VhcmNoIHNvdXJjZXxzb3VyY2V8aW5kZXgpXFxzKj1cXHMqKFtefFxcc10rKSguKikvaTtcbmV4cG9ydCBjb25zdCBQUExfSU5ERVhfUkVHRVggPSAvKHNlYXJjaCBzb3VyY2V8c291cmNlfGluZGV4KVxccyo9XFxzKihbXnxcXHNdKykvaTtcbmV4cG9ydCBjb25zdCBQUExfV0hFUkVfQ0xBVVNFX1JFR0VYID0gL1xccyp3aGVyZVxccysvaTtcbmV4cG9ydCBjb25zdCBQUExfTkVXTElORV9SRUdFWCA9IC9bXFxuXFxyXSsvZztcbmV4cG9ydCBjb25zdCBQUExfREVTQ1JJQkVfSU5ERVhfUkVHRVggPSAvKGRlc2NyaWJlKVxccysoW158XFxzXSspL2k7XG5cbi8vIE9ic2VydmFiaWxpdHkgcGx1Z2luIFVSSVxuY29uc3QgQkFTRV9PQlNFUlZBQklMSVRZX1VSSSA9ICcvX3BsdWdpbnMvX29ic2VydmFiaWxpdHknO1xuY29uc3QgQkFTRV9EQVRBQ09OTkVDVElPTlNfVVJJID0gJy9fcGx1Z2lucy9fcXVlcnkvX2RhdGFzb3VyY2VzJztcbmV4cG9ydCBjb25zdCBPUEVOU0VBUkNIX1BBTkVMU19BUEkgPSB7XG4gIE9CSkVDVDogYCR7QkFTRV9PQlNFUlZBQklMSVRZX1VSSX0vb2JqZWN0YCxcbn07XG5leHBvcnQgY29uc3QgT1BFTlNFQVJDSF9EQVRBQ09OTkVDVElPTlNfQVBJID0ge1xuICBEQVRBQ09OTkVDVElPTjogYCR7QkFTRV9EQVRBQ09OTkVDVElPTlNfVVJJfWAsXG59O1xuXG4vLyBTYXZlZCBPYmplY3RzXG5leHBvcnQgY29uc3QgU0FWRURfT0JKRUNUID0gJy9vYmplY3QnO1xuXG4vLyBDb2xvciBDb25zdGFudHNcbmV4cG9ydCBjb25zdCBQTE9UTFlfQ09MT1IgPSBbXG4gICcjM0NBMUM3JyxcbiAgJyM1NEIzOTknLFxuICAnI0RCNzQ4QScsXG4gICcjRjJCRTRCJyxcbiAgJyM2OENDQzInLFxuICAnIzJBNzg2NicsXG4gICcjODQzNzY5JyxcbiAgJyMzNzRGQjgnLFxuICAnI0JENkYyNicsXG4gICcjNEM2MzZGJyxcbl07XG5cbmV4cG9ydCBjb25zdCBMT05HX0NIQVJUX0NPTE9SID0gUExPVExZX0NPTE9SWzFdO1xuXG5leHBvcnQgY29uc3QgcGFnZVN0eWxlczogQ1NTLlByb3BlcnRpZXMgPSB7XG4gIGZsb2F0OiAnbGVmdCcsXG4gIHdpZHRoOiAnMTAwJScsXG4gIG1heFdpZHRoOiAnMTEzMHB4Jyxcbn07XG5cbmV4cG9ydCBlbnVtIFZJU19DSEFSVF9UWVBFUyB7XG4gIEJhciA9ICdiYXInLFxuICBIb3Jpem9udGFsQmFyID0gJ2hvcml6b250YWxfYmFyJyxcbiAgTGluZSA9ICdsaW5lJyxcbiAgUGllID0gJ3BpZScsXG4gIEhlYXRNYXAgPSAnaGVhdG1hcCcsXG4gIFRleHQgPSAndGV4dCcsXG4gIEhpc3RvZ3JhbSA9ICdoaXN0b2dyYW0nLFxufVxuXG5leHBvcnQgY29uc3QgTlVNRVJJQ0FMX0ZJRUxEUyA9IFsnc2hvcnQnLCAnaW50ZWdlcicsICdsb25nJywgJ2Zsb2F0JywgJ2RvdWJsZSddO1xuXG5leHBvcnQgY29uc3QgRU5BQkxFRF9WSVNfVFlQRVMgPSBbXG4gIFZJU19DSEFSVF9UWVBFUy5CYXIsXG4gIFZJU19DSEFSVF9UWVBFUy5Ib3Jpem9udGFsQmFyLFxuICBWSVNfQ0hBUlRfVFlQRVMuTGluZSxcbiAgVklTX0NIQVJUX1RZUEVTLlBpZSxcbiAgVklTX0NIQVJUX1RZUEVTLkhlYXRNYXAsXG4gIFZJU19DSEFSVF9UWVBFUy5UZXh0LFxuXTtcblxuLy8gTGl2ZSB0YWlsIGNvbnN0YW50c1xuZXhwb3J0IGNvbnN0IExJVkVfT1BUSU9OUyA9IFtcbiAge1xuICAgIGxhYmVsOiAnNXMnLFxuICAgIHN0YXJ0VGltZTogJ25vdy01cycsXG4gICAgZGVsYXlUaW1lOiA1MDAwLFxuICB9LFxuICB7XG4gICAgbGFiZWw6ICcxMHMnLFxuICAgIHN0YXJ0VGltZTogJ25vdy0xMHMnLFxuICAgIGRlbGF5VGltZTogMTAwMDAsXG4gIH0sXG4gIHtcbiAgICBsYWJlbDogJzMwcycsXG4gICAgc3RhcnRUaW1lOiAnbm93LTMwcycsXG4gICAgZGVsYXlUaW1lOiAzMDAwMCxcbiAgfSxcbiAge1xuICAgIGxhYmVsOiAnMW0nLFxuICAgIHN0YXJ0VGltZTogJ25vdy0xbScsXG4gICAgZGVsYXlUaW1lOiA2MDAwMCxcbiAgfSxcbiAge1xuICAgIGxhYmVsOiAnNW0nLFxuICAgIHN0YXJ0VGltZTogJ25vdy01bScsXG4gICAgZGVsYXlUaW1lOiA2MDAwMCAqIDUsXG4gIH0sXG4gIHtcbiAgICBsYWJlbDogJzE1bScsXG4gICAgc3RhcnRUaW1lOiAnbm93LTE1bScsXG4gICAgZGVsYXlUaW1lOiA2MDAwMCAqIDE1LFxuICB9LFxuICB7XG4gICAgbGFiZWw6ICczMG0nLFxuICAgIHN0YXJ0VGltZTogJ25vdy0zMG0nLFxuICAgIGRlbGF5VGltZTogNjAwMDAgKiAzMCxcbiAgfSxcbiAge1xuICAgIGxhYmVsOiAnMWgnLFxuICAgIHN0YXJ0VGltZTogJ25vdy0xaCcsXG4gICAgZGVsYXlUaW1lOiA2MDAwMCAqIDYwLFxuICB9LFxuICB7XG4gICAgbGFiZWw6ICcyaCcsXG4gICAgc3RhcnRUaW1lOiAnbm93LTJoJyxcbiAgICBkZWxheVRpbWU6IDYwMDAwICogMTIwLFxuICB9LFxuXTtcblxuZXhwb3J0IGNvbnN0IExJVkVfRU5EX1RJTUUgPSAnbm93JztcblxuZXhwb3J0IGludGVyZmFjZSBEZWZhdWx0Q2hhcnRTdHlsZXNQcm9wcyB7XG4gIERlZmF1bHRNb2RlTGluZTogc3RyaW5nO1xuICBJbnRlcnBvbGF0aW9uOiBzdHJpbmc7XG4gIExpbmVXaWR0aDogbnVtYmVyO1xuICBGaWxsT3BhY2l0eTogbnVtYmVyO1xuICBNYXJrZXJTaXplOiBudW1iZXI7XG4gIFNob3dMZWdlbmQ6IHN0cmluZztcbiAgTGVnZW5kUG9zaXRpb246IHN0cmluZztcbiAgTGFiZWxBbmdsZTogbnVtYmVyO1xuICBEZWZhdWx0U29ydFNlY3RvcnM6IHN0cmluZztcbiAgRGVmYXVsdE1vZGVTY2F0dGVyOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjb25zdCBERUZBVUxUX0NIQVJUX1NUWUxFUzogRGVmYXVsdENoYXJ0U3R5bGVzUHJvcHMgPSB7XG4gIERlZmF1bHRNb2RlTGluZTogJ2xpbmVzJyxcbiAgSW50ZXJwb2xhdGlvbjogJ3NwbGluZScsXG4gIExpbmVXaWR0aDogMCxcbiAgRmlsbE9wYWNpdHk6IDEwMCxcbiAgTWFya2VyU2l6ZTogNSxcbiAgU2hvd0xlZ2VuZDogJ3Nob3cnLFxuICBMZWdlbmRQb3NpdGlvbjogJ3YnLFxuICBMYWJlbEFuZ2xlOiAwLFxuICBEZWZhdWx0U29ydFNlY3RvcnM6ICdsYXJnZXN0X3RvX3NtYWxsZXN0JyxcbiAgRGVmYXVsdE1vZGVTY2F0dGVyOiAnbWFya2VycycsXG59O1xuXG5leHBvcnQgY29uc3QgRklMTE9QQUNJVFlfRElWX0ZBQ1RPUiA9IDIwMDtcbmV4cG9ydCBjb25zdCBTTElERVJfTUlOX1ZBTFVFID0gMDtcbmV4cG9ydCBjb25zdCBTTElERVJfTUFYX1ZBTFVFID0gMTAwO1xuZXhwb3J0IGNvbnN0IFNMSURFUl9TVEVQID0gMTtcbmV4cG9ydCBjb25zdCBUSFJFU0hPTERfTElORV9XSURUSCA9IDM7XG5leHBvcnQgY29uc3QgVEhSRVNIT0xEX0xJTkVfT1BBQ0lUWSA9IDAuNztcbmV4cG9ydCBjb25zdCBNQVhfQlVDS0VUX0xFTkdUSCA9IDE2O1xuXG5leHBvcnQgZW51bSBCYXJPcmllbnRhdGlvbiB7XG4gIGhvcml6b250YWwgPSAnaCcsXG4gIHZlcnRpY2FsID0gJ3YnLFxufVxuXG5leHBvcnQgY29uc3QgUExPVF9NQVJHSU4gPSB7XG4gIGw6IDMwLFxuICByOiA1LFxuICBiOiAzMCxcbiAgdDogNTAsXG4gIHBhZDogNCxcbn07XG5cbmV4cG9ydCBjb25zdCBXQUlUSU5HX1RJTUVfT05fVVNFUl9BQ1RJT05TID0gMzAwO1xuXG5leHBvcnQgY29uc3QgVklTVUFMSVpBVElPTl9FUlJPUiA9IHtcbiAgTk9fREFUQTogJ05vIGRhdGEgZm91bmQuJyxcbiAgSU5WQUxJRF9EQVRBOiAnSW52YWxpZCB2aXN1YWxpemF0aW9uIGRhdGEnLFxuICBOT19TRVJJRVM6ICdBZGQgYSBmaWVsZCB0byBzdGFydCcsXG4gIE5PX01FVFJJQzogJ0ludmFsaWQgTWV0cmljIE1ldGFEYXRhJyxcbn07XG5cbmV4cG9ydCBjb25zdCBTM19EQVRBX1NPVVJDRV9UWVBFID0gJ3MzZ2x1ZSc7XG5cbmV4cG9ydCBjb25zdCBBU1lOQ19RVUVSWV9TRVNTSU9OX0lEID0gJ2FzeW5jLXF1ZXJ5LXNlc3Npb24taWQnO1xuZXhwb3J0IGNvbnN0IEFTWU5DX1FVRVJZX0RBVEFTT1VSQ0VfQ0FDSEUgPSAnYXN5bmMtcXVlcnktY2F0YWxvZy1jYWNoZSc7XG5leHBvcnQgY29uc3QgQVNZTkNfUVVFUllfQUNDRUxFUkFUSU9OU19DQUNIRSA9ICdhc3luYy1xdWVyeS1hY2NsZXJhdGlvbnMtY2FjaGUnO1xuXG5leHBvcnQgY29uc3QgRElSRUNUX0RVTU1ZX1FVRVJZID0gJ3NlbGVjdCAxJztcblxuZXhwb3J0IGNvbnN0IERFRkFVTFRfU1RBUlRfVElNRSA9ICdub3ctMTVtJztcbmV4cG9ydCBjb25zdCBRVUVSWV9BU1NJU1RfU1RBUlRfVElNRSA9ICdub3ctNDB5JztcbmV4cG9ydCBjb25zdCBRVUVSWV9BU1NJU1RfRU5EX1RJTUUgPSAnbm93JztcblxuZXhwb3J0IGNvbnN0IFRJTUVTVEFNUF9EQVRFVElNRV9UWVBFUyA9IFsnZGF0ZScsICdkYXRlX25hbm9zJ107XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNPLE1BQU1BLFFBQVEsR0FBQUMsT0FBQSxDQUFBRCxRQUFBLEdBQUcsVUFBVTtBQUMzQixNQUFNRSxVQUFVLEdBQUFELE9BQUEsQ0FBQUMsVUFBQSxHQUFHLFNBQVM7QUFDNUIsTUFBTUMsUUFBUSxHQUFBRixPQUFBLENBQUFFLFFBQUEsR0FBRyxVQUFVO0FBQzNCLE1BQU1DLFVBQVUsR0FBQUgsT0FBQSxDQUFBRyxVQUFBLEdBQUcsU0FBUztBQUM1QixNQUFNQyxPQUFPLEdBQUFKLE9BQUEsQ0FBQUksT0FBQSxHQUFHLGNBQWM7QUFDOUIsTUFBTUMsV0FBVyxHQUFBTCxPQUFBLENBQUFLLFdBQUEsR0FBRywwQkFBMEI7QUFDOUMsTUFBTUMsWUFBWSxHQUFBTixPQUFBLENBQUFNLFlBQUEsR0FBRywyQkFBMkI7QUFDaEQsTUFBTUMsa0JBQWtCLEdBQUFQLE9BQUEsQ0FBQU8sa0JBQUEsR0FBRyxvQkFBb0I7QUFDL0MsTUFBTUMsaUJBQWlCLEdBQUFSLE9BQUEsQ0FBQVEsaUJBQUEsR0FBRyxtQkFBbUI7QUFDN0MsTUFBTUMsU0FBUyxHQUFBVCxPQUFBLENBQUFTLFNBQUEsR0FBRyxhQUFhO0FBQy9CLE1BQU1DLG9CQUFvQixHQUFBVixPQUFBLENBQUFVLG9CQUFBLEdBQUcsc0JBQXNCO0FBQ25ELE1BQU1DLElBQUksR0FBQVgsT0FBQSxDQUFBVyxJQUFBLEdBQUcsT0FBTztBQUNwQixNQUFNQyw2QkFBNkIsR0FBQVosT0FBQSxDQUFBWSw2QkFBQSxHQUFHLFNBQVM7QUFDL0MsTUFBTUMsY0FBYyxHQUFBYixPQUFBLENBQUFhLGNBQUEsR0FBRyw2QkFBNkI7QUFDcEQsTUFBTUMsZUFBZSxHQUFBZCxPQUFBLENBQUFjLGVBQUEsR0FBRyxrQkFBa0I7QUFDMUMsTUFBTUMsYUFBYSxHQUFBZixPQUFBLENBQUFlLGFBQUEsR0FBRyxnQkFBZ0I7QUFDdEMsTUFBTUMsV0FBVyxHQUFBaEIsT0FBQSxDQUFBZ0IsV0FBQSxHQUFHLFFBQVE7QUFDNUIsTUFBTUMsbUJBQW1CLEdBQUFqQixPQUFBLENBQUFpQixtQkFBQSxHQUFHLE1BQU07QUFDbEMsTUFBTUMsYUFBYSxHQUFBbEIsT0FBQSxDQUFBa0IsYUFBQSxHQUFHLG9CQUFvQjtBQUMxQyxNQUFNQywyQkFBMkIsR0FBQW5CLE9BQUEsQ0FBQW1CLDJCQUFBLEdBQUcsK0JBQStCOztBQUUxRTtBQUNPLE1BQU1DLFlBQVksR0FBQXBCLE9BQUEsQ0FBQW9CLFlBQUEsR0FBRyxnQkFBZ0I7QUFDckMsTUFBTUMsWUFBWSxHQUFBckIsT0FBQSxDQUFBcUIsWUFBQSxHQUFHLGdCQUFnQjtBQUNyQyxNQUFNQyxZQUFZLEdBQUF0QixPQUFBLENBQUFzQixZQUFBLEdBQUcsZ0JBQWdCO0FBQ3JDLE1BQU1DLHdCQUF3QixHQUFBdkIsT0FBQSxDQUFBdUIsd0JBQUEsR0FBRywrQkFBK0I7QUFDaEUsTUFBTUMsa0JBQWtCLEdBQUF4QixPQUFBLENBQUF3QixrQkFBQSxHQUFHLHdCQUF3QjtBQUNuRCxNQUFNQyxtQkFBbUIsR0FBQXpCLE9BQUEsQ0FBQXlCLG1CQUFBLEdBQUcsU0FBUztBQUVyQyxNQUFNQyxlQUFlLEdBQUExQixPQUFBLENBQUEwQixlQUFBLEdBQUcsb0JBQW9CO0FBQzVDLE1BQU1DLGtCQUFrQixHQUFBM0IsT0FBQSxDQUFBMkIsa0JBQUEsR0FBRyxlQUFlO0FBQzFDLE1BQU1DLHdCQUF3QixHQUFBNUIsT0FBQSxDQUFBNEIsd0JBQUEsR0FBRyxJQUFJO0FBRXJDLE1BQU1DLDJCQUEyQixHQUFBN0IsT0FBQSxDQUFBNkIsMkJBQUEsR0FBRyw0QkFBNEI7QUFDaEUsTUFBTUMsOEJBQThCLEdBQUE5QixPQUFBLENBQUE4Qiw4QkFBQSxHQUFHLGNBQWM7QUFDckQsTUFBTUMsb0NBQW9DLEdBQUEvQixPQUFBLENBQUErQixvQ0FBQSxHQUFHLElBQUk7QUFFakQsTUFBTUMsbUJBQW1CLEdBQUFoQyxPQUFBLENBQUFnQyxtQkFBQSxHQUFHLG9CQUFvQjtBQUNoRCxNQUFNQyxzQkFBc0IsR0FBQWpDLE9BQUEsQ0FBQWlDLHNCQUFBLEdBQUcsTUFBTTtBQUNyQyxNQUFNQyw0QkFBNEIsR0FBQWxDLE9BQUEsQ0FBQWtDLDRCQUFBLEdBQUcsSUFBSTtBQUV6QyxNQUFNQyxzQkFBc0IsR0FBQW5DLE9BQUEsQ0FBQW1DLHNCQUFBLEdBQUcsdUJBQXVCO0FBQ3RELE1BQU1DLHlCQUF5QixHQUFBcEMsT0FBQSxDQUFBb0MseUJBQUEsR0FBRyxTQUFTO0FBQzNDLE1BQU1DLCtCQUErQixHQUFBckMsT0FBQSxDQUFBcUMsK0JBQUEsR0FBRyxJQUFJO0FBRTVDLE1BQU1DLHFCQUFxQixHQUFBdEMsT0FBQSxDQUFBc0MscUJBQUEsR0FBRyxzQkFBc0I7QUFDcEQsTUFBTUMsd0JBQXdCLEdBQUF2QyxPQUFBLENBQUF1Qyx3QkFBQSxHQUFHLFFBQVE7QUFDekMsTUFBTUMsOEJBQThCLEdBQUF4QyxPQUFBLENBQUF3Qyw4QkFBQSxHQUFHLElBQUk7QUFFM0MsTUFBTUMsdUJBQXVCLEdBQUF6QyxPQUFBLENBQUF5Qyx1QkFBQSxHQUFHLHlCQUF5QjtBQUN6RCxNQUFNQywwQkFBMEIsR0FBQTFDLE9BQUEsQ0FBQTBDLDBCQUFBLEdBQUcsV0FBVztBQUM5QyxNQUFNQyxnQ0FBZ0MsR0FBQTNDLE9BQUEsQ0FBQTJDLGdDQUFBLEdBQUcsSUFBSTtBQUU3QyxNQUFNQyxxQkFBcUIsR0FBQTVDLE9BQUEsQ0FBQTRDLHFCQUFBLEdBQUcsMEJBQTBCO0FBQ3hELE1BQU1DLHdCQUF3QixHQUFBN0MsT0FBQSxDQUFBNkMsd0JBQUEsR0FBRyxZQUFZO0FBQzdDLE1BQU1DLDhCQUE4QixHQUFBOUMsT0FBQSxDQUFBOEMsOEJBQUEsR0FBRyxJQUFJO0FBRTNDLE1BQU1DLDJCQUEyQixHQUFBL0MsT0FBQSxDQUFBK0MsMkJBQUEsR0FBRyxjQUFjO0FBQ2xELE1BQU1DLDhCQUE4QixHQUFBaEQsT0FBQSxDQUFBZ0QsOEJBQUEsR0FBRyxjQUFjO0FBQ3JELE1BQU1DLG9DQUFvQyxHQUFBakQsT0FBQSxDQUFBaUQsb0NBQUEsR0FBRyxJQUFJO0FBRWpELE1BQU1DLDhCQUE4QixHQUFBbEQsT0FBQSxDQUFBa0QsOEJBQUEsR0FBRyxhQUFhO0FBQ3BELE1BQU1DLGlDQUFpQyxHQUFBbkQsT0FBQSxDQUFBbUQsaUNBQUEsR0FBRyxjQUFjO0FBQ3hELE1BQU1DLHVDQUF1QyxHQUFBcEQsT0FBQSxDQUFBb0QsdUNBQUEsR0FBRyxJQUFJO0FBRXBELE1BQU1DLHNCQUFzQixHQUFBckQsT0FBQSxDQUFBcUQsc0JBQUEsR0FBRyw0QkFBNEI7QUFDM0QsTUFBTUMseUJBQXlCLEdBQUF0RCxPQUFBLENBQUFzRCx5QkFBQSxHQUFHLGlDQUFpQzs7QUFFMUU7QUFDTyxNQUFNQyxxQkFBcUIsR0FBQXZELE9BQUEsQ0FBQXVELHFCQUFBLEdBQUcsOERBQThEO0FBQzVGLE1BQU1DLHFCQUFxQixHQUFBeEQsT0FBQSxDQUFBd0QscUJBQUEsR0FDaEMsaUVBQWlFO0FBQzVELE1BQU1DLDhCQUE4QixHQUFBekQsT0FBQSxDQUFBeUQsOEJBQUEsR0FDekMsK0ZBQStGO0FBQzFGLE1BQU1DLGNBQWMsR0FBQTFELE9BQUEsQ0FBQTBELGNBQUEsR0FBRyxvQkFBb0I7QUFDM0MsTUFBTUMsZUFBZSxHQUFBM0QsT0FBQSxDQUFBMkQsZUFBQSxHQUFHLDRCQUE0QjtBQUNwRCxNQUFNQyxnQkFBZ0IsR0FBQTVELE9BQUEsQ0FBQTRELGdCQUFBLEdBQUcscUJBQXFCO0FBQzlDLE1BQU1DLFVBQVUsR0FBQTdELE9BQUEsQ0FBQTZELFVBQUEsR0FBRyxNQUFNO0FBRXpCLE1BQU1DLHFCQUFxQixHQUFBOUQsT0FBQSxDQUFBOEQscUJBQUEsR0FBRyxjQUFjO0FBQzVDLE1BQU1DLG1CQUFtQixHQUFBL0QsT0FBQSxDQUFBK0QsbUJBQUEsR0FBRyxxQkFBcUI7QUFDakQsTUFBTUMsa0JBQWtCLEdBQUFoRSxPQUFBLENBQUFnRSxrQkFBQSxHQUFHLFFBQVE7QUFFbkMsTUFBTUMsY0FBYyxHQUFBakUsT0FBQSxDQUFBaUUsY0FBQSxHQUFHLFlBQVk7QUFDbkMsTUFBTUMsZUFBZSxHQUFBbEUsT0FBQSxDQUFBa0UsZUFBQSxHQUFHLGFBQWE7QUFDckMsTUFBTUMsNEJBQTRCLEdBQUFuRSxPQUFBLENBQUFtRSw0QkFBQSxHQUFHLG1EQUFtRDtBQUN4RixNQUFNQyxlQUFlLEdBQUFwRSxPQUFBLENBQUFvRSxlQUFBLEdBQUcsK0NBQStDO0FBQ3ZFLE1BQU1DLHNCQUFzQixHQUFBckUsT0FBQSxDQUFBcUUsc0JBQUEsR0FBRyxjQUFjO0FBQzdDLE1BQU1DLGlCQUFpQixHQUFBdEUsT0FBQSxDQUFBc0UsaUJBQUEsR0FBRyxVQUFVO0FBQ3BDLE1BQU1DLHdCQUF3QixHQUFBdkUsT0FBQSxDQUFBdUUsd0JBQUEsR0FBRyx5QkFBeUI7O0FBRWpFO0FBQ0EsTUFBTUMsc0JBQXNCLEdBQUcsMEJBQTBCO0FBQ3pELE1BQU1DLHdCQUF3QixHQUFHLCtCQUErQjtBQUN6RCxNQUFNQyxxQkFBcUIsR0FBQTFFLE9BQUEsQ0FBQTBFLHFCQUFBLEdBQUc7RUFDbkNDLE1BQU0sRUFBRyxHQUFFSCxzQkFBdUI7QUFDcEMsQ0FBQztBQUNNLE1BQU1JLDhCQUE4QixHQUFBNUUsT0FBQSxDQUFBNEUsOEJBQUEsR0FBRztFQUM1Q0MsY0FBYyxFQUFHLEdBQUVKLHdCQUF5QjtBQUM5QyxDQUFDOztBQUVEO0FBQ08sTUFBTUssWUFBWSxHQUFBOUUsT0FBQSxDQUFBOEUsWUFBQSxHQUFHLFNBQVM7O0FBRXJDO0FBQ08sTUFBTUMsWUFBWSxHQUFBL0UsT0FBQSxDQUFBK0UsWUFBQSxHQUFHLENBQzFCLFNBQVMsRUFDVCxTQUFTLEVBQ1QsU0FBUyxFQUNULFNBQVMsRUFDVCxTQUFTLEVBQ1QsU0FBUyxFQUNULFNBQVMsRUFDVCxTQUFTLEVBQ1QsU0FBUyxFQUNULFNBQVMsQ0FDVjtBQUVNLE1BQU1DLGdCQUFnQixHQUFBaEYsT0FBQSxDQUFBZ0YsZ0JBQUEsR0FBR0QsWUFBWSxDQUFDLENBQUMsQ0FBQztBQUV4QyxNQUFNRSxVQUEwQixHQUFBakYsT0FBQSxDQUFBaUYsVUFBQSxHQUFHO0VBQ3hDQyxLQUFLLEVBQUUsTUFBTTtFQUNiQyxLQUFLLEVBQUUsTUFBTTtFQUNiQyxRQUFRLEVBQUU7QUFDWixDQUFDO0FBQUMsSUFFVUMsZUFBZSxHQUFBckYsT0FBQSxDQUFBcUYsZUFBQSwwQkFBZkEsZUFBZTtFQUFmQSxlQUFlO0VBQWZBLGVBQWU7RUFBZkEsZUFBZTtFQUFmQSxlQUFlO0VBQWZBLGVBQWU7RUFBZkEsZUFBZTtFQUFmQSxlQUFlO0VBQUEsT0FBZkEsZUFBZTtBQUFBO0FBVXBCLE1BQU1DLGdCQUFnQixHQUFBdEYsT0FBQSxDQUFBc0YsZ0JBQUEsR0FBRyxDQUFDLE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSxFQUFFLE9BQU8sRUFBRSxRQUFRLENBQUM7QUFFeEUsTUFBTUMsaUJBQWlCLEdBQUF2RixPQUFBLENBQUF1RixpQkFBQSxHQUFHLENBQy9CRixlQUFlLENBQUNHLEdBQUcsRUFDbkJILGVBQWUsQ0FBQ0ksYUFBYSxFQUM3QkosZUFBZSxDQUFDSyxJQUFJLEVBQ3BCTCxlQUFlLENBQUNNLEdBQUcsRUFDbkJOLGVBQWUsQ0FBQ08sT0FBTyxFQUN2QlAsZUFBZSxDQUFDUSxJQUFJLENBQ3JCOztBQUVEO0FBQ08sTUFBTUMsWUFBWSxHQUFBOUYsT0FBQSxDQUFBOEYsWUFBQSxHQUFHLENBQzFCO0VBQ0VDLEtBQUssRUFBRSxJQUFJO0VBQ1hDLFNBQVMsRUFBRSxRQUFRO0VBQ25CQyxTQUFTLEVBQUU7QUFDYixDQUFDLEVBQ0Q7RUFDRUYsS0FBSyxFQUFFLEtBQUs7RUFDWkMsU0FBUyxFQUFFLFNBQVM7RUFDcEJDLFNBQVMsRUFBRTtBQUNiLENBQUMsRUFDRDtFQUNFRixLQUFLLEVBQUUsS0FBSztFQUNaQyxTQUFTLEVBQUUsU0FBUztFQUNwQkMsU0FBUyxFQUFFO0FBQ2IsQ0FBQyxFQUNEO0VBQ0VGLEtBQUssRUFBRSxJQUFJO0VBQ1hDLFNBQVMsRUFBRSxRQUFRO0VBQ25CQyxTQUFTLEVBQUU7QUFDYixDQUFDLEVBQ0Q7RUFDRUYsS0FBSyxFQUFFLElBQUk7RUFDWEMsU0FBUyxFQUFFLFFBQVE7RUFDbkJDLFNBQVMsRUFBRSxLQUFLLEdBQUc7QUFDckIsQ0FBQyxFQUNEO0VBQ0VGLEtBQUssRUFBRSxLQUFLO0VBQ1pDLFNBQVMsRUFBRSxTQUFTO0VBQ3BCQyxTQUFTLEVBQUUsS0FBSyxHQUFHO0FBQ3JCLENBQUMsRUFDRDtFQUNFRixLQUFLLEVBQUUsS0FBSztFQUNaQyxTQUFTLEVBQUUsU0FBUztFQUNwQkMsU0FBUyxFQUFFLEtBQUssR0FBRztBQUNyQixDQUFDLEVBQ0Q7RUFDRUYsS0FBSyxFQUFFLElBQUk7RUFDWEMsU0FBUyxFQUFFLFFBQVE7RUFDbkJDLFNBQVMsRUFBRSxLQUFLLEdBQUc7QUFDckIsQ0FBQyxFQUNEO0VBQ0VGLEtBQUssRUFBRSxJQUFJO0VBQ1hDLFNBQVMsRUFBRSxRQUFRO0VBQ25CQyxTQUFTLEVBQUUsS0FBSyxHQUFHO0FBQ3JCLENBQUMsQ0FDRjtBQUVNLE1BQU1DLGFBQWEsR0FBQWxHLE9BQUEsQ0FBQWtHLGFBQUEsR0FBRyxLQUFLO0FBZTNCLE1BQU1DLG9CQUE2QyxHQUFBbkcsT0FBQSxDQUFBbUcsb0JBQUEsR0FBRztFQUMzREMsZUFBZSxFQUFFLE9BQU87RUFDeEJDLGFBQWEsRUFBRSxRQUFRO0VBQ3ZCQyxTQUFTLEVBQUUsQ0FBQztFQUNaQyxXQUFXLEVBQUUsR0FBRztFQUNoQkMsVUFBVSxFQUFFLENBQUM7RUFDYkMsVUFBVSxFQUFFLE1BQU07RUFDbEJDLGNBQWMsRUFBRSxHQUFHO0VBQ25CQyxVQUFVLEVBQUUsQ0FBQztFQUNiQyxrQkFBa0IsRUFBRSxxQkFBcUI7RUFDekNDLGtCQUFrQixFQUFFO0FBQ3RCLENBQUM7QUFFTSxNQUFNQyxzQkFBc0IsR0FBQTlHLE9BQUEsQ0FBQThHLHNCQUFBLEdBQUcsR0FBRztBQUNsQyxNQUFNQyxnQkFBZ0IsR0FBQS9HLE9BQUEsQ0FBQStHLGdCQUFBLEdBQUcsQ0FBQztBQUMxQixNQUFNQyxnQkFBZ0IsR0FBQWhILE9BQUEsQ0FBQWdILGdCQUFBLEdBQUcsR0FBRztBQUM1QixNQUFNQyxXQUFXLEdBQUFqSCxPQUFBLENBQUFpSCxXQUFBLEdBQUcsQ0FBQztBQUNyQixNQUFNQyxvQkFBb0IsR0FBQWxILE9BQUEsQ0FBQWtILG9CQUFBLEdBQUcsQ0FBQztBQUM5QixNQUFNQyxzQkFBc0IsR0FBQW5ILE9BQUEsQ0FBQW1ILHNCQUFBLEdBQUcsR0FBRztBQUNsQyxNQUFNQyxpQkFBaUIsR0FBQXBILE9BQUEsQ0FBQW9ILGlCQUFBLEdBQUcsRUFBRTtBQUFDLElBRXhCQyxjQUFjLEdBQUFySCxPQUFBLENBQUFxSCxjQUFBLDBCQUFkQSxjQUFjO0VBQWRBLGNBQWM7RUFBZEEsY0FBYztFQUFBLE9BQWRBLGNBQWM7QUFBQTtBQUtuQixNQUFNQyxXQUFXLEdBQUF0SCxPQUFBLENBQUFzSCxXQUFBLEdBQUc7RUFDekJDLENBQUMsRUFBRSxFQUFFO0VBQ0xDLENBQUMsRUFBRSxDQUFDO0VBQ0pDLENBQUMsRUFBRSxFQUFFO0VBQ0xDLENBQUMsRUFBRSxFQUFFO0VBQ0xDLEdBQUcsRUFBRTtBQUNQLENBQUM7QUFFTSxNQUFNQyw0QkFBNEIsR0FBQTVILE9BQUEsQ0FBQTRILDRCQUFBLEdBQUcsR0FBRztBQUV4QyxNQUFNQyxtQkFBbUIsR0FBQTdILE9BQUEsQ0FBQTZILG1CQUFBLEdBQUc7RUFDakNDLE9BQU8sRUFBRSxnQkFBZ0I7RUFDekJDLFlBQVksRUFBRSw0QkFBNEI7RUFDMUNDLFNBQVMsRUFBRSxzQkFBc0I7RUFDakNDLFNBQVMsRUFBRTtBQUNiLENBQUM7QUFFTSxNQUFNQyxtQkFBbUIsR0FBQWxJLE9BQUEsQ0FBQWtJLG1CQUFBLEdBQUcsUUFBUTtBQUVwQyxNQUFNQyxzQkFBc0IsR0FBQW5JLE9BQUEsQ0FBQW1JLHNCQUFBLEdBQUcsd0JBQXdCO0FBQ3ZELE1BQU1DLDRCQUE0QixHQUFBcEksT0FBQSxDQUFBb0ksNEJBQUEsR0FBRywyQkFBMkI7QUFDaEUsTUFBTUMsK0JBQStCLEdBQUFySSxPQUFBLENBQUFxSSwrQkFBQSxHQUFHLGdDQUFnQztBQUV4RSxNQUFNQyxrQkFBa0IsR0FBQXRJLE9BQUEsQ0FBQXNJLGtCQUFBLEdBQUcsVUFBVTtBQUVyQyxNQUFNQyxrQkFBa0IsR0FBQXZJLE9BQUEsQ0FBQXVJLGtCQUFBLEdBQUcsU0FBUztBQUNwQyxNQUFNQyx1QkFBdUIsR0FBQXhJLE9BQUEsQ0FBQXdJLHVCQUFBLEdBQUcsU0FBUztBQUN6QyxNQUFNQyxxQkFBcUIsR0FBQXpJLE9BQUEsQ0FBQXlJLHFCQUFBLEdBQUcsS0FBSztBQUVuQyxNQUFNQyx3QkFBd0IsR0FBQTFJLE9BQUEsQ0FBQTBJLHdCQUFBLEdBQUcsQ0FBQyxNQUFNLEVBQUUsWUFBWSxDQUFDIn0=