"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addBackticksIfNeeded = addBackticksIfNeeded;
exports.basePathLink = void 0;
exports.combineSchemaAndDatarows = combineSchemaAndDatarows;
exports.get = get;
var _core_refs = require("../../public/framework/core_refs");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * TODO making this method type-safe is nontrivial: if you just define
 * `Nested<T> = { [k: string]: Nested<T> | T }` then you can't accumulate because `T` is not `Nested<T>`
 * There might be a way to define a recursive type that accumulates cleanly but it's probably not
 * worth the effort.
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function get(obj, path, defaultValue) {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return path.split('.').reduce((acc, part) => acc && acc[part], obj) || defaultValue;
}
function addBackticksIfNeeded(input) {
  if (input === undefined) {
    return '';
  }
  // Check if the string already has backticks
  if (input.startsWith('`') && input.endsWith('`')) {
    return input; // Return the string as it is
  } else {
    // Add backticks to the string
    return '`' + input + '`';
  }
}
function combineSchemaAndDatarows(schema, datarows) {
  const combinedData = [];
  datarows.forEach(row => {
    const rowData = {};
    schema.forEach((field, index) => {
      rowData[field.name] = row[index];
    });
    combinedData.push(rowData);
  });
  return combinedData;
}

/**
 * Safely prepend the `basePath` from `coreRefs` to the given link.
 * If `coreRefs.http.basePath` exists (always true in normal operation), prepend it to the link.
 * If it doesn't exist (usually during unit testing), return the link as-is.
 *
 * @param link The link to prepend with `coreRefs.http.basePath`.
 * @returns The link with the prepended `basePath` if it exists, otherwise the unmodified link.
 */
const basePathLink = link => {
  var _coreRefs$http;
  if ((_coreRefs$http = _core_refs.coreRefs.http) !== null && _coreRefs$http !== void 0 && _coreRefs$http.basePath) {
    return _core_refs.coreRefs.http.basePath.prepend(link);
  } else {
    return link;
  }
};
exports.basePathLink = basePathLink;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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