"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReport = void 0;
var _constants = require("../utils/constants");
var _savedSearchReportHelper = require("../utils/savedSearchReportHelper");
var _saveReport = require("./saveReport");
var _lodash = _interopRequireDefault(require("lodash"));
var _helpers = require("../utils/helpers");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const createReport = async (request, context, report, config, savedReportId) => {
  const isScheduledTask = false;
  //@ts-ignore
  const logger = context.reporting_plugin.logger;
  // @ts-ignore
  const opensearchReportsClient = context.reporting_plugin.opensearchReportsClient.asScoped(request);
  const opensearchClient = context.core.opensearch.legacy.client;
  // @ts-ignore
  const timezone = request.query.timezone;
  // @ts-ignore
  const dateFormat = request.query.dateFormat || _constants.DATA_REPORT_CONFIG.excelDateFormat;
  // @ts-ignore
  const csvSeparator = request.query.csvSeparator || ',';
  // @ts-ignore
  const allowLeadingWildcards = !!request.query.allowLeadingWildcards;
  const protocol = config.get('osd_server', 'protocol');
  const hostname = config.get('osd_server', 'hostname');
  const port = config.get('osd_server', 'port');
  const basePath = config.osdConfig.get('server', 'basePath');
  let createReportResult;
  let reportId;
  const {
    report_definition: {
      report_params: reportParams
    }
  } = report;
  const {
    report_source: reportSource
  } = reportParams;
  try {
    // create new report instance and set report state to "pending"
    if (savedReportId) {
      reportId = savedReportId;
    } else {
      const opensearchResp = await (0, _saveReport.saveReport)(report, opensearchReportsClient);
      reportId = opensearchResp.reportInstance.id;
    }
    // generate report
    if (reportSource === _constants.REPORT_TYPE.savedSearch) {
      createReportResult = await (0, _savedSearchReportHelper.createSavedSearchReport)(report, opensearchClient, dateFormat, csvSeparator, allowLeadingWildcards, isScheduledTask, logger, timezone);
    } else {
      // report source can only be one of [saved search, visualization, dashboard, notebook]
      // compose url
      const relativeUrl = report.query_url.startsWith(basePath) ? report.query_url : `${basePath}${report.query_url}`;
      const completeQueryUrl = `${protocol}://${hostname}:${port}${relativeUrl}`;
      const extraHeaders = _lodash.default.pick(request.headers, _constants.EXTRA_HEADERS);
      const {
        core_params,
        report_name: reportName,
        report_source: reportSource
      } = reportParams;
      const coreParams = core_params;
      const {
        header,
        footer,
        window_height: windowHeight,
        window_width: windowWidth,
        report_format: reportFormat
      } = coreParams;
      const curTime = new Date();
      const timeCreated = curTime.valueOf();
      const fileName = `${(0, _helpers.getFileName)(reportName, curTime)}.${reportFormat}`;
      return {
        timeCreated,
        dataUrl: '',
        fileName,
        reportId,
        queryUrl: relativeUrl
      };
    }
    // update report state to "created"
    // TODO: temporarily remove the following
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.created);
    // }
  } catch (error) {
    // update report instance with "error" state
    // TODO: save error detail and display on UI
    // TODO: temporarily disable the following, will add back
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.error);
    // }
    throw error;
  }
  return createReportResult;
};
exports.createReport = createReport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsIl9zYXZlZFNlYXJjaFJlcG9ydEhlbHBlciIsIl9zYXZlUmVwb3J0IiwiX2xvZGFzaCIsIl9pbnRlcm9wUmVxdWlyZURlZmF1bHQiLCJfaGVscGVycyIsIm9iaiIsIl9fZXNNb2R1bGUiLCJkZWZhdWx0IiwiY3JlYXRlUmVwb3J0IiwicmVxdWVzdCIsImNvbnRleHQiLCJyZXBvcnQiLCJjb25maWciLCJzYXZlZFJlcG9ydElkIiwiaXNTY2hlZHVsZWRUYXNrIiwibG9nZ2VyIiwicmVwb3J0aW5nX3BsdWdpbiIsIm9wZW5zZWFyY2hSZXBvcnRzQ2xpZW50IiwiYXNTY29wZWQiLCJvcGVuc2VhcmNoQ2xpZW50IiwiY29yZSIsIm9wZW5zZWFyY2giLCJsZWdhY3kiLCJjbGllbnQiLCJ0aW1lem9uZSIsInF1ZXJ5IiwiZGF0ZUZvcm1hdCIsIkRBVEFfUkVQT1JUX0NPTkZJRyIsImV4Y2VsRGF0ZUZvcm1hdCIsImNzdlNlcGFyYXRvciIsImFsbG93TGVhZGluZ1dpbGRjYXJkcyIsInByb3RvY29sIiwiZ2V0IiwiaG9zdG5hbWUiLCJwb3J0IiwiYmFzZVBhdGgiLCJvc2RDb25maWciLCJjcmVhdGVSZXBvcnRSZXN1bHQiLCJyZXBvcnRJZCIsInJlcG9ydF9kZWZpbml0aW9uIiwicmVwb3J0X3BhcmFtcyIsInJlcG9ydFBhcmFtcyIsInJlcG9ydF9zb3VyY2UiLCJyZXBvcnRTb3VyY2UiLCJvcGVuc2VhcmNoUmVzcCIsInNhdmVSZXBvcnQiLCJyZXBvcnRJbnN0YW5jZSIsImlkIiwiUkVQT1JUX1RZUEUiLCJzYXZlZFNlYXJjaCIsImNyZWF0ZVNhdmVkU2VhcmNoUmVwb3J0IiwicmVsYXRpdmVVcmwiLCJxdWVyeV91cmwiLCJzdGFydHNXaXRoIiwiY29tcGxldGVRdWVyeVVybCIsImV4dHJhSGVhZGVycyIsIl8iLCJwaWNrIiwiaGVhZGVycyIsIkVYVFJBX0hFQURFUlMiLCJjb3JlX3BhcmFtcyIsInJlcG9ydF9uYW1lIiwicmVwb3J0TmFtZSIsImNvcmVQYXJhbXMiLCJoZWFkZXIiLCJmb290ZXIiLCJ3aW5kb3dfaGVpZ2h0Iiwid2luZG93SGVpZ2h0Iiwid2luZG93X3dpZHRoIiwid2luZG93V2lkdGgiLCJyZXBvcnRfZm9ybWF0IiwicmVwb3J0Rm9ybWF0IiwiY3VyVGltZSIsIkRhdGUiLCJ0aW1lQ3JlYXRlZCIsInZhbHVlT2YiLCJmaWxlTmFtZSIsImdldEZpbGVOYW1lIiwiZGF0YVVybCIsInF1ZXJ5VXJsIiwiZXJyb3IiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsiY3JlYXRlUmVwb3J0LnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHtcbiAgUkVQT1JUX1RZUEUsXG4gIERBVEFfUkVQT1JUX0NPTkZJRyxcbiAgRVhUUkFfSEVBREVSUyxcbn0gZnJvbSAnLi4vdXRpbHMvY29uc3RhbnRzJztcblxuaW1wb3J0IHtcbiAgSUxlZ2FjeVNjb3BlZENsdXN0ZXJDbGllbnQsXG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgTG9nZ2VyLFxuICBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG59IGZyb20gJy4uLy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5pbXBvcnQgeyBjcmVhdGVTYXZlZFNlYXJjaFJlcG9ydCB9IGZyb20gJy4uL3V0aWxzL3NhdmVkU2VhcmNoUmVwb3J0SGVscGVyJztcbmltcG9ydCB7IFJlcG9ydFNjaGVtYVR5cGUsIFZpc3VhbFJlcG9ydFNjaGVtYVR5cGUgfSBmcm9tICcuLi8uLi9tb2RlbCc7XG5pbXBvcnQgeyBDcmVhdGVSZXBvcnRSZXN1bHRUeXBlIH0gZnJvbSAnLi4vdXRpbHMvdHlwZXMnO1xuaW1wb3J0IHsgc2F2ZVJlcG9ydCB9IGZyb20gJy4vc2F2ZVJlcG9ydCc7XG5pbXBvcnQgeyBSZXBvcnRpbmdDb25maWcgfSBmcm9tICdzZXJ2ZXInO1xuaW1wb3J0IF8gZnJvbSAnbG9kYXNoJztcbmltcG9ydCB7IGdldEZpbGVOYW1lIH0gZnJvbSAnLi4vdXRpbHMvaGVscGVycyc7XG5cbmV4cG9ydCBjb25zdCBjcmVhdGVSZXBvcnQgPSBhc3luYyAoXG4gIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICByZXBvcnQ6IFJlcG9ydFNjaGVtYVR5cGUsXG4gIGNvbmZpZzogUmVwb3J0aW5nQ29uZmlnLFxuICBzYXZlZFJlcG9ydElkPzogc3RyaW5nXG4pOiBQcm9taXNlPENyZWF0ZVJlcG9ydFJlc3VsdFR5cGU+ID0+IHtcbiAgY29uc3QgaXNTY2hlZHVsZWRUYXNrID0gZmFsc2U7XG4gIC8vQHRzLWlnbm9yZVxuICBjb25zdCBsb2dnZXI6IExvZ2dlciA9IGNvbnRleHQucmVwb3J0aW5nX3BsdWdpbi5sb2dnZXI7XG4gIC8vIEB0cy1pZ25vcmVcbiAgY29uc3Qgb3BlbnNlYXJjaFJlcG9ydHNDbGllbnQ6IElMZWdhY3lTY29wZWRDbHVzdGVyQ2xpZW50ID0gY29udGV4dC5yZXBvcnRpbmdfcGx1Z2luLm9wZW5zZWFyY2hSZXBvcnRzQ2xpZW50LmFzU2NvcGVkKFxuICAgIHJlcXVlc3RcbiAgKTtcbiAgY29uc3Qgb3BlbnNlYXJjaENsaWVudCA9IGNvbnRleHQuY29yZS5vcGVuc2VhcmNoLmxlZ2FjeS5jbGllbnQ7XG4gIC8vIEB0cy1pZ25vcmVcbiAgY29uc3QgdGltZXpvbmUgPSByZXF1ZXN0LnF1ZXJ5LnRpbWV6b25lO1xuICAvLyBAdHMtaWdub3JlXG4gIGNvbnN0IGRhdGVGb3JtYXQgPVxuICAgIHJlcXVlc3QucXVlcnkuZGF0ZUZvcm1hdCB8fCBEQVRBX1JFUE9SVF9DT05GSUcuZXhjZWxEYXRlRm9ybWF0O1xuICAvLyBAdHMtaWdub3JlXG4gIGNvbnN0IGNzdlNlcGFyYXRvciA9IHJlcXVlc3QucXVlcnkuY3N2U2VwYXJhdG9yIHx8ICcsJztcbiAgLy8gQHRzLWlnbm9yZVxuICBjb25zdCBhbGxvd0xlYWRpbmdXaWxkY2FyZHMgPSAhIXJlcXVlc3QucXVlcnkuYWxsb3dMZWFkaW5nV2lsZGNhcmRzO1xuXG4gIGNvbnN0IHByb3RvY29sID0gY29uZmlnLmdldCgnb3NkX3NlcnZlcicsICdwcm90b2NvbCcpO1xuICBjb25zdCBob3N0bmFtZSA9IGNvbmZpZy5nZXQoJ29zZF9zZXJ2ZXInLCAnaG9zdG5hbWUnKTtcbiAgY29uc3QgcG9ydCA9IGNvbmZpZy5nZXQoJ29zZF9zZXJ2ZXInLCAncG9ydCcpO1xuICBjb25zdCBiYXNlUGF0aCA9IGNvbmZpZy5vc2RDb25maWcuZ2V0KCdzZXJ2ZXInLCAnYmFzZVBhdGgnKTtcblxuICBsZXQgY3JlYXRlUmVwb3J0UmVzdWx0OiBDcmVhdGVSZXBvcnRSZXN1bHRUeXBlO1xuICBsZXQgcmVwb3J0SWQ7XG5cbiAgY29uc3Qge1xuICAgIHJlcG9ydF9kZWZpbml0aW9uOiB7IHJlcG9ydF9wYXJhbXM6IHJlcG9ydFBhcmFtcyB9LFxuICB9ID0gcmVwb3J0O1xuICBjb25zdCB7IHJlcG9ydF9zb3VyY2U6IHJlcG9ydFNvdXJjZSB9ID0gcmVwb3J0UGFyYW1zO1xuXG4gIHRyeSB7XG4gICAgLy8gY3JlYXRlIG5ldyByZXBvcnQgaW5zdGFuY2UgYW5kIHNldCByZXBvcnQgc3RhdGUgdG8gXCJwZW5kaW5nXCJcbiAgICBpZiAoc2F2ZWRSZXBvcnRJZCkge1xuICAgICAgcmVwb3J0SWQgPSBzYXZlZFJlcG9ydElkO1xuICAgIH0gZWxzZSB7XG4gICAgICBjb25zdCBvcGVuc2VhcmNoUmVzcCA9IGF3YWl0IHNhdmVSZXBvcnQocmVwb3J0LCBvcGVuc2VhcmNoUmVwb3J0c0NsaWVudCk7XG4gICAgICByZXBvcnRJZCA9IG9wZW5zZWFyY2hSZXNwLnJlcG9ydEluc3RhbmNlLmlkO1xuICAgIH1cbiAgICAvLyBnZW5lcmF0ZSByZXBvcnRcbiAgICBpZiAocmVwb3J0U291cmNlID09PSBSRVBPUlRfVFlQRS5zYXZlZFNlYXJjaCkge1xuICAgICAgY3JlYXRlUmVwb3J0UmVzdWx0ID0gYXdhaXQgY3JlYXRlU2F2ZWRTZWFyY2hSZXBvcnQoXG4gICAgICAgIHJlcG9ydCxcbiAgICAgICAgb3BlbnNlYXJjaENsaWVudCxcbiAgICAgICAgZGF0ZUZvcm1hdCxcbiAgICAgICAgY3N2U2VwYXJhdG9yLFxuICAgICAgICBhbGxvd0xlYWRpbmdXaWxkY2FyZHMsXG4gICAgICAgIGlzU2NoZWR1bGVkVGFzayxcbiAgICAgICAgbG9nZ2VyLFxuICAgICAgICB0aW1lem9uZVxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgLy8gcmVwb3J0IHNvdXJjZSBjYW4gb25seSBiZSBvbmUgb2YgW3NhdmVkIHNlYXJjaCwgdmlzdWFsaXphdGlvbiwgZGFzaGJvYXJkLCBub3RlYm9va11cbiAgICAgIC8vIGNvbXBvc2UgdXJsXG4gICAgICBjb25zdCByZWxhdGl2ZVVybCA9IHJlcG9ydC5xdWVyeV91cmwuc3RhcnRzV2l0aChiYXNlUGF0aClcbiAgICAgICAgPyByZXBvcnQucXVlcnlfdXJsXG4gICAgICAgIDogYCR7YmFzZVBhdGh9JHtyZXBvcnQucXVlcnlfdXJsfWA7XG4gICAgICBjb25zdCBjb21wbGV0ZVF1ZXJ5VXJsID0gYCR7cHJvdG9jb2x9Oi8vJHtob3N0bmFtZX06JHtwb3J0fSR7cmVsYXRpdmVVcmx9YDtcbiAgICAgIGNvbnN0IGV4dHJhSGVhZGVycyA9IF8ucGljayhyZXF1ZXN0LmhlYWRlcnMsIEVYVFJBX0hFQURFUlMpO1xuXG4gICAgICBjb25zdCB7XG4gICAgICAgIGNvcmVfcGFyYW1zLFxuICAgICAgICByZXBvcnRfbmFtZTogcmVwb3J0TmFtZSxcbiAgICAgICAgcmVwb3J0X3NvdXJjZTogcmVwb3J0U291cmNlLFxuICAgICAgfSA9IHJlcG9ydFBhcmFtcztcbiAgICAgIGNvbnN0IGNvcmVQYXJhbXMgPSBjb3JlX3BhcmFtcyBhcyBWaXN1YWxSZXBvcnRTY2hlbWFUeXBlO1xuICAgICAgY29uc3Qge1xuICAgICAgICBoZWFkZXIsXG4gICAgICAgIGZvb3RlcixcbiAgICAgICAgd2luZG93X2hlaWdodDogd2luZG93SGVpZ2h0LFxuICAgICAgICB3aW5kb3dfd2lkdGg6IHdpbmRvd1dpZHRoLFxuICAgICAgICByZXBvcnRfZm9ybWF0OiByZXBvcnRGb3JtYXQsXG4gICAgICB9ID0gY29yZVBhcmFtcztcbiAgICAgIGNvbnN0IGN1clRpbWUgPSBuZXcgRGF0ZSgpO1xuICAgICAgY29uc3QgdGltZUNyZWF0ZWQgPSBjdXJUaW1lLnZhbHVlT2YoKTtcbiAgICAgIGNvbnN0IGZpbGVOYW1lID0gYCR7Z2V0RmlsZU5hbWUocmVwb3J0TmFtZSwgY3VyVGltZSl9LiR7cmVwb3J0Rm9ybWF0fWA7XG5cbiAgICAgIHJldHVybiB7IHRpbWVDcmVhdGVkLCBkYXRhVXJsOiAnJywgZmlsZU5hbWUsIHJlcG9ydElkLCBxdWVyeVVybDogcmVsYXRpdmVVcmwgfTtcbiAgICB9XG4gICAgLy8gdXBkYXRlIHJlcG9ydCBzdGF0ZSB0byBcImNyZWF0ZWRcIlxuICAgIC8vIFRPRE86IHRlbXBvcmFyaWx5IHJlbW92ZSB0aGUgZm9sbG93aW5nXG4gICAgLy8gaWYgKCFzYXZlZFJlcG9ydElkKSB7XG4gICAgLy8gICBhd2FpdCB1cGRhdGVSZXBvcnRTdGF0ZShyZXBvcnRJZCwgb3BlbnNlYXJjaFJlcG9ydHNDbGllbnQsIFJFUE9SVF9TVEFURS5jcmVhdGVkKTtcbiAgICAvLyB9XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgLy8gdXBkYXRlIHJlcG9ydCBpbnN0YW5jZSB3aXRoIFwiZXJyb3JcIiBzdGF0ZVxuICAgIC8vIFRPRE86IHNhdmUgZXJyb3IgZGV0YWlsIGFuZCBkaXNwbGF5IG9uIFVJXG4gICAgLy8gVE9ETzogdGVtcG9yYXJpbHkgZGlzYWJsZSB0aGUgZm9sbG93aW5nLCB3aWxsIGFkZCBiYWNrXG4gICAgLy8gaWYgKCFzYXZlZFJlcG9ydElkKSB7XG4gICAgLy8gICBhd2FpdCB1cGRhdGVSZXBvcnRTdGF0ZShyZXBvcnRJZCwgb3BlbnNlYXJjaFJlcG9ydHNDbGllbnQsIFJFUE9SVF9TVEFURS5lcnJvcik7XG4gICAgLy8gfVxuICAgIHRocm93IGVycm9yO1xuICB9XG5cbiAgcmV0dXJuIGNyZWF0ZVJlcG9ydFJlc3VsdDtcbn07XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLFVBQUEsR0FBQUMsT0FBQTtBQVlBLElBQUFDLHdCQUFBLEdBQUFELE9BQUE7QUFHQSxJQUFBRSxXQUFBLEdBQUFGLE9BQUE7QUFFQSxJQUFBRyxPQUFBLEdBQUFDLHNCQUFBLENBQUFKLE9BQUE7QUFDQSxJQUFBSyxRQUFBLEdBQUFMLE9BQUE7QUFBK0MsU0FBQUksdUJBQUFFLEdBQUEsV0FBQUEsR0FBQSxJQUFBQSxHQUFBLENBQUFDLFVBQUEsR0FBQUQsR0FBQSxLQUFBRSxPQUFBLEVBQUFGLEdBQUE7QUF2Qi9DO0FBQ0E7QUFDQTtBQUNBOztBQXNCTyxNQUFNRyxZQUFZLEdBQUcsTUFBQUEsQ0FDMUJDLE9BQW9DLEVBQ3BDQyxPQUE4QixFQUM5QkMsTUFBd0IsRUFDeEJDLE1BQXVCLEVBQ3ZCQyxhQUFzQixLQUNjO0VBQ3BDLE1BQU1DLGVBQWUsR0FBRyxLQUFLO0VBQzdCO0VBQ0EsTUFBTUMsTUFBYyxHQUFHTCxPQUFPLENBQUNNLGdCQUFnQixDQUFDRCxNQUFNO0VBQ3REO0VBQ0EsTUFBTUUsdUJBQW1ELEdBQUdQLE9BQU8sQ0FBQ00sZ0JBQWdCLENBQUNDLHVCQUF1QixDQUFDQyxRQUFRLENBQ25IVCxPQUNGLENBQUM7RUFDRCxNQUFNVSxnQkFBZ0IsR0FBR1QsT0FBTyxDQUFDVSxJQUFJLENBQUNDLFVBQVUsQ0FBQ0MsTUFBTSxDQUFDQyxNQUFNO0VBQzlEO0VBQ0EsTUFBTUMsUUFBUSxHQUFHZixPQUFPLENBQUNnQixLQUFLLENBQUNELFFBQVE7RUFDdkM7RUFDQSxNQUFNRSxVQUFVLEdBQ2RqQixPQUFPLENBQUNnQixLQUFLLENBQUNDLFVBQVUsSUFBSUMsNkJBQWtCLENBQUNDLGVBQWU7RUFDaEU7RUFDQSxNQUFNQyxZQUFZLEdBQUdwQixPQUFPLENBQUNnQixLQUFLLENBQUNJLFlBQVksSUFBSSxHQUFHO0VBQ3REO0VBQ0EsTUFBTUMscUJBQXFCLEdBQUcsQ0FBQyxDQUFDckIsT0FBTyxDQUFDZ0IsS0FBSyxDQUFDSyxxQkFBcUI7RUFFbkUsTUFBTUMsUUFBUSxHQUFHbkIsTUFBTSxDQUFDb0IsR0FBRyxDQUFDLFlBQVksRUFBRSxVQUFVLENBQUM7RUFDckQsTUFBTUMsUUFBUSxHQUFHckIsTUFBTSxDQUFDb0IsR0FBRyxDQUFDLFlBQVksRUFBRSxVQUFVLENBQUM7RUFDckQsTUFBTUUsSUFBSSxHQUFHdEIsTUFBTSxDQUFDb0IsR0FBRyxDQUFDLFlBQVksRUFBRSxNQUFNLENBQUM7RUFDN0MsTUFBTUcsUUFBUSxHQUFHdkIsTUFBTSxDQUFDd0IsU0FBUyxDQUFDSixHQUFHLENBQUMsUUFBUSxFQUFFLFVBQVUsQ0FBQztFQUUzRCxJQUFJSyxrQkFBMEM7RUFDOUMsSUFBSUMsUUFBUTtFQUVaLE1BQU07SUFDSkMsaUJBQWlCLEVBQUU7TUFBRUMsYUFBYSxFQUFFQztJQUFhO0VBQ25ELENBQUMsR0FBRzlCLE1BQU07RUFDVixNQUFNO0lBQUUrQixhQUFhLEVBQUVDO0VBQWEsQ0FBQyxHQUFHRixZQUFZO0VBRXBELElBQUk7SUFDRjtJQUNBLElBQUk1QixhQUFhLEVBQUU7TUFDakJ5QixRQUFRLEdBQUd6QixhQUFhO0lBQzFCLENBQUMsTUFBTTtNQUNMLE1BQU0rQixjQUFjLEdBQUcsTUFBTSxJQUFBQyxzQkFBVSxFQUFDbEMsTUFBTSxFQUFFTSx1QkFBdUIsQ0FBQztNQUN4RXFCLFFBQVEsR0FBR00sY0FBYyxDQUFDRSxjQUFjLENBQUNDLEVBQUU7SUFDN0M7SUFDQTtJQUNBLElBQUlKLFlBQVksS0FBS0ssc0JBQVcsQ0FBQ0MsV0FBVyxFQUFFO01BQzVDWixrQkFBa0IsR0FBRyxNQUFNLElBQUFhLGdEQUF1QixFQUNoRHZDLE1BQU0sRUFDTlEsZ0JBQWdCLEVBQ2hCTyxVQUFVLEVBQ1ZHLFlBQVksRUFDWkMscUJBQXFCLEVBQ3JCaEIsZUFBZSxFQUNmQyxNQUFNLEVBQ05TLFFBQ0YsQ0FBQztJQUNILENBQUMsTUFBTTtNQUNMO01BQ0E7TUFDQSxNQUFNMkIsV0FBVyxHQUFHeEMsTUFBTSxDQUFDeUMsU0FBUyxDQUFDQyxVQUFVLENBQUNsQixRQUFRLENBQUMsR0FDckR4QixNQUFNLENBQUN5QyxTQUFTLEdBQ2YsR0FBRWpCLFFBQVMsR0FBRXhCLE1BQU0sQ0FBQ3lDLFNBQVUsRUFBQztNQUNwQyxNQUFNRSxnQkFBZ0IsR0FBSSxHQUFFdkIsUUFBUyxNQUFLRSxRQUFTLElBQUdDLElBQUssR0FBRWlCLFdBQVksRUFBQztNQUMxRSxNQUFNSSxZQUFZLEdBQUdDLGVBQUMsQ0FBQ0MsSUFBSSxDQUFDaEQsT0FBTyxDQUFDaUQsT0FBTyxFQUFFQyx3QkFBYSxDQUFDO01BRTNELE1BQU07UUFDSkMsV0FBVztRQUNYQyxXQUFXLEVBQUVDLFVBQVU7UUFDdkJwQixhQUFhLEVBQUVDO01BQ2pCLENBQUMsR0FBR0YsWUFBWTtNQUNoQixNQUFNc0IsVUFBVSxHQUFHSCxXQUFxQztNQUN4RCxNQUFNO1FBQ0pJLE1BQU07UUFDTkMsTUFBTTtRQUNOQyxhQUFhLEVBQUVDLFlBQVk7UUFDM0JDLFlBQVksRUFBRUMsV0FBVztRQUN6QkMsYUFBYSxFQUFFQztNQUNqQixDQUFDLEdBQUdSLFVBQVU7TUFDZCxNQUFNUyxPQUFPLEdBQUcsSUFBSUMsSUFBSSxDQUFDLENBQUM7TUFDMUIsTUFBTUMsV0FBVyxHQUFHRixPQUFPLENBQUNHLE9BQU8sQ0FBQyxDQUFDO01BQ3JDLE1BQU1DLFFBQVEsR0FBSSxHQUFFLElBQUFDLG9CQUFXLEVBQUNmLFVBQVUsRUFBRVUsT0FBTyxDQUFFLElBQUdELFlBQWEsRUFBQztNQUV0RSxPQUFPO1FBQUVHLFdBQVc7UUFBRUksT0FBTyxFQUFFLEVBQUU7UUFBRUYsUUFBUTtRQUFFdEMsUUFBUTtRQUFFeUMsUUFBUSxFQUFFNUI7TUFBWSxDQUFDO0lBQ2hGO0lBQ0E7SUFDQTtJQUNBO0lBQ0E7SUFDQTtFQUNGLENBQUMsQ0FBQyxPQUFPNkIsS0FBSyxFQUFFO0lBQ2Q7SUFDQTtJQUNBO0lBQ0E7SUFDQTtJQUNBO0lBQ0EsTUFBTUEsS0FBSztFQUNiO0VBRUEsT0FBTzNDLGtCQUFrQjtBQUMzQixDQUFDO0FBQUM0QyxPQUFBLENBQUF6RSxZQUFBLEdBQUFBLFlBQUEifQ==