/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.watabou.noosa.Game;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.SparseArray;
import java.util.HashSet;

public abstract class Actor
implements Bundlable {
    public static final float TICK = 1.0f;
    private float time;
    private int id = 0;
    protected static final int VFX_PRIO = 100;
    protected static final int HERO_PRIO = 0;
    protected static final int BLOB_PRIO = -10;
    protected static final int MOB_PRIO = -20;
    protected static final int BUFF_PRIO = -30;
    private static final int DEFAULT = -100;
    protected int actPriority = -100;
    private static final String TIME = "time";
    private static final String ID = "id";
    private static HashSet<Actor> all = new HashSet();
    private static HashSet<Char> chars = new HashSet();
    private static volatile Actor current;
    private static SparseArray<Actor> ids;
    private static int nextID;
    private static float now;
    private static final String NEXTID = "nextid";
    public static boolean keepActorThreadAlive;

    protected abstract boolean act();

    protected void spendConstant(float time) {
        this.time += time;
        float ex = Math.abs(this.time % 1.0f);
        if (ex < 0.001f) {
            this.time = Math.round(this.time);
        }
    }

    protected void spend(float time) {
        this.spendConstant(time);
    }

    public void spendToWhole() {
        this.time = (float)Math.ceil(this.time);
    }

    protected void postpone(float time) {
        if (this.time < now + time) {
            this.time = now + time;
            float ex = Math.abs(this.time % 1.0f);
            if (ex < 0.001f) {
                this.time = Math.round(this.time);
            }
        }
    }

    public float cooldown() {
        return this.time - now;
    }

    public void clearTime() {
        this.time = 0.0f;
    }

    public void timeToNow() {
        this.time = now;
    }

    protected void diactivate() {
        this.time = Float.MAX_VALUE;
    }

    protected void onAdd() {
    }

    protected void onRemove() {
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        bundle.put(TIME, this.time);
        bundle.put(ID, this.id);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        this.time = bundle.getFloat(TIME);
        int incomingID = bundle.getInt(ID);
        this.id = Actor.findById(incomingID) == null ? incomingID : nextID++;
    }

    public int id() {
        if (this.id > 0) {
            return this.id;
        }
        this.id = nextID++;
        return this.id;
    }

    public static float now() {
        return now;
    }

    public static synchronized void clear() {
        now = 0.0f;
        all.clear();
        chars.clear();
        ids.clear();
    }

    public static synchronized void fixTime() {
        if (all.isEmpty()) {
            return;
        }
        float min = Float.MAX_VALUE;
        for (Actor a : all) {
            if (!(a.time < min)) continue;
            min = a.time;
        }
        min = (int)min;
        for (Actor a : all) {
            a.time -= min;
        }
        if (Dungeon.hero != null && all.contains(Dungeon.hero)) {
            Statistics.duration += min;
        }
        now -= min;
    }

    public static void init() {
        Actor.add(Dungeon.hero);
        for (Mob mob : Dungeon.level.mobs) {
            Actor.add(mob);
        }
        for (Mob mob : Dungeon.level.mobs) {
            mob.restoreEnemy();
        }
        for (Blob blob : Dungeon.level.blobs.values()) {
            Actor.add(blob);
        }
        current = null;
    }

    public static void storeNextID(Bundle bundle) {
        bundle.put(NEXTID, nextID);
    }

    public static void restoreNextID(Bundle bundle) {
        nextID = bundle.getInt(NEXTID);
    }

    public static void resetNextID() {
        nextID = 1;
    }

    public void next() {
        if (current == this) {
            current = null;
        }
    }

    public static boolean processing() {
        return current != null;
    }

    public static int curActorPriority() {
        return current != null ? Actor.current.actPriority : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process() {
        boolean interrupted = false;
        do {
            boolean doNext;
            current = null;
            if (!interrupted && !Game.switchingScene()) {
                float earliest = Float.MAX_VALUE;
                for (Actor actor : all) {
                    if (!(actor.time < earliest) && (actor.time != earliest || current != null && actor.actPriority <= Actor.current.actPriority)) continue;
                    earliest = actor.time;
                    current = actor;
                }
            }
            if (current != null) {
                now = Actor.current.time;
                Actor acting = current;
                if (acting instanceof Char && ((Char)acting).sprite != null) {
                    try {
                        CharSprite charSprite = ((Char)acting).sprite;
                        synchronized (charSprite) {
                            if (((Char)acting).sprite.isMoving) {
                                ((Char)acting).sprite.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                boolean bl = interrupted = interrupted || Thread.interrupted();
                if (interrupted) {
                    doNext = false;
                    current = null;
                } else {
                    doNext = acting.act();
                    if (doNext && (Dungeon.hero == null || !Dungeon.hero.isAlive())) {
                        doNext = false;
                        current = null;
                    }
                }
            } else {
                doNext = false;
            }
            if (doNext) continue;
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                boolean bl = interrupted = interrupted || Thread.interrupted();
                if (interrupted) {
                    current = null;
                    interrupted = false;
                }
                Thread.currentThread().notify();
                try {
                    Thread.currentThread().wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        } while (keepActorThreadAlive);
    }

    public static void add(Actor actor) {
        Actor.add(actor, now);
    }

    public static void addDelayed(Actor actor, float delay) {
        Actor.add(actor, now + Math.max(delay, 0.0f));
    }

    private static synchronized void add(Actor actor, float time) {
        if (all.contains(actor)) {
            return;
        }
        ids.put(actor.id(), actor);
        all.add(actor);
        actor.time += time;
        actor.onAdd();
        if (actor instanceof Char) {
            Char ch = (Char)actor;
            chars.add(ch);
            for (Buff buff : ch.buffs()) {
                Actor.add(buff);
            }
        }
    }

    public static synchronized void remove(Actor actor) {
        if (actor != null) {
            all.remove(actor);
            chars.remove(actor);
            actor.onRemove();
            if (actor.id > 0) {
                ids.remove(actor.id);
            }
        }
    }

    public static void delayChar(Char ch, float time) {
        ch.spendConstant(time);
        for (Buff b : ch.buffs()) {
            b.spendConstant(time);
        }
    }

    public static synchronized Char findChar(int pos) {
        for (Char ch : chars) {
            if (ch.pos != pos) continue;
            return ch;
        }
        return null;
    }

    public static synchronized Actor findById(int id) {
        return (Actor)ids.get(id);
    }

    public static synchronized HashSet<Actor> all() {
        return new HashSet<Actor>(all);
    }

    public static synchronized HashSet<Char> chars() {
        return new HashSet<Char>(chars);
    }

    static {
        ids = new SparseArray();
        nextID = 1;
        now = 0.0f;
        keepActorThreadAlive = true;
    }
}

