/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.bombs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.items.bombs.Bomb;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class Flashbang
extends Bomb {
    public Flashbang() {
        this.image = ItemSpriteSheet.FLASHBANG;
    }

    @Override
    public void explode(int cell) {
        super.explode(cell);
        Level l = Dungeon.level;
        for (Char ch : Actor.chars()) {
            int power;
            if (ch.fieldOfView == null || !ch.fieldOfView[cell] || (power = 16 - 4 * l.distance(ch.pos, cell)) <= 0) continue;
            Buff.prolong(ch, Blindness.class, power);
            Buff.prolong(ch, Cripple.class, power);
            if (ch != Dungeon.hero) continue;
            GameScene.flash(-2130706433);
        }
    }

    @Override
    public int value() {
        return this.quantity * 60;
    }
}

