/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.BannerSprites;
import com.shatteredpixel.shatteredpixeldungeon.effects.Fireball;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.AboutScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.BadgesScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.ChangesScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.HeroSelectScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.NewsScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.RankingsScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.StartScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.SupporterScene;
import com.shatteredpixel.shatteredpixeldungeon.services.news.News;
import com.shatteredpixel.shatteredpixeldungeon.services.updates.AvailableUpdateData;
import com.shatteredpixel.shatteredpixeldungeon.services.updates.Updates;
import com.shatteredpixel.shatteredpixeldungeon.ui.Archs;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.StyledButton;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndSettings;
import com.watabou.glwrap.Blending;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Music;
import com.watabou.utils.ColorMath;
import com.watabou.utils.DeviceCompat;
import java.util.Date;

public class TitleScene
extends PixelScene {
    @Override
    public void create() {
        super.create();
        Music.INSTANCE.playTracks(new String[]{"music/theme_1.ogg", "music/theme_2.ogg"}, new float[]{1.0f, 1.0f}, false);
        TitleScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        Archs archs = new Archs();
        archs.setSize(w, h);
        this.add(archs);
        Image title = BannerSprites.get(BannerSprites.Type.PIXEL_DUNGEON);
        this.add(title);
        float topRegion = Math.max(title.height - 6.0f, (float)h * 0.45f);
        title.x = ((float)w - title.width()) / 2.0f;
        title.y = 2.0f + (topRegion - title.height()) / 2.0f;
        TitleScene.align(title);
        this.placeTorch(title.x + 22.0f, title.y + 46.0f);
        this.placeTorch(title.x + title.width - 22.0f, title.y + 46.0f);
        Image signs = new Image(BannerSprites.get(BannerSprites.Type.PIXEL_DUNGEON_SIGNS)){
            private float time;
            {
                this.time = 0.0f;
            }

            @Override
            public void update() {
                super.update();
                this.am = Math.max(0.0f, (float)Math.sin(this.time += Game.elapsed));
                if ((double)this.time >= 4.71238898038469) {
                    this.time = 0.0f;
                }
            }

            @Override
            public void draw() {
                Blending.setLightMode();
                super.draw();
                Blending.setNormalMode();
            }
        };
        signs.x = title.x + (title.width() - signs.width()) / 2.0f;
        signs.y = title.y;
        this.add(signs);
        Chrome.Type GREY_TR = Chrome.Type.GREY_BUTTON_TR;
        StyledButton btnPlay = new StyledButton(GREY_TR, Messages.get(this, "enter", new Object[0])){

            @Override
            protected void onClick() {
                if (GamesInProgress.checkAll().size() == 0) {
                    GamesInProgress.selectedClass = null;
                    GamesInProgress.curSlot = 1;
                    ShatteredPixelDungeon.switchScene(HeroSelectScene.class);
                } else {
                    ShatteredPixelDungeon.switchNoFade(StartScene.class);
                }
            }

            @Override
            protected boolean onLongClick() {
                if (DeviceCompat.isDebug()) {
                    GamesInProgress.selectedClass = null;
                    GamesInProgress.curSlot = 1;
                    ShatteredPixelDungeon.switchScene(HeroSelectScene.class);
                    return true;
                }
                return super.onLongClick();
            }
        };
        btnPlay.icon(Icons.get(Icons.ENTER));
        this.add(btnPlay);
        SupportButton btnSupport = new SupportButton(GREY_TR, Messages.get(this, "support", new Object[0]));
        this.add(btnSupport);
        StyledButton btnRankings = new StyledButton(GREY_TR, Messages.get(this, "rankings", new Object[0])){

            @Override
            protected void onClick() {
                ShatteredPixelDungeon.switchNoFade(RankingsScene.class);
            }
        };
        btnRankings.icon(Icons.get(Icons.RANKINGS));
        this.add(btnRankings);
        Dungeon.dailyReplay = false;
        Dungeon.daily = false;
        StyledButton btnBadges = new StyledButton(GREY_TR, Messages.get(this, "badges", new Object[0])){

            @Override
            protected void onClick() {
                ShatteredPixelDungeon.switchNoFade(BadgesScene.class);
            }
        };
        btnBadges.icon(Icons.get(Icons.BADGES));
        this.add(btnBadges);
        NewsButton btnNews = new NewsButton(GREY_TR, Messages.get(this, "news", new Object[0]));
        btnNews.icon(Icons.get(Icons.NEWS));
        this.add(btnNews);
        ChangesButton btnChanges = new ChangesButton(GREY_TR, Messages.get(this, "changes", new Object[0]));
        btnChanges.icon(Icons.get(Icons.CHANGES));
        this.add(btnChanges);
        SettingsButton btnSettings = new SettingsButton(GREY_TR, Messages.get(this, "settings", new Object[0]));
        this.add(btnSettings);
        StyledButton btnAbout = new StyledButton(GREY_TR, Messages.get(this, "about", new Object[0])){

            @Override
            protected void onClick() {
                ShatteredPixelDungeon.switchScene(AboutScene.class);
            }
        };
        btnAbout.icon(Icons.get(Icons.SHPX));
        this.add(btnAbout);
        int BTN_HEIGHT = 20;
        int GAP = (int)((float)h - topRegion - (float)((TitleScene.landscape() ? 3 : 4) * 20)) / 3;
        GAP /= TitleScene.landscape() ? 3 : 5;
        GAP = Math.max(GAP, 2);
        if (TitleScene.landscape()) {
            btnPlay.setRect(title.x - 50.0f, topRegion + (float)GAP, (title.width() + 100.0f) / 2.0f - 1.0f, 20.0f);
            TitleScene.align(btnPlay);
            btnSupport.setRect(btnPlay.right() + 2.0f, btnPlay.top(), btnPlay.width(), 20.0f);
            btnRankings.setRect(btnPlay.left(), btnPlay.bottom() + (float)GAP, btnPlay.width() * 0.67f - 1.0f, 20.0f);
            btnBadges.setRect(btnRankings.left(), btnRankings.bottom() + (float)GAP, btnRankings.width(), 20.0f);
            btnNews.setRect(btnRankings.right() + 2.0f, btnRankings.top(), btnRankings.width(), 20.0f);
            btnChanges.setRect(btnNews.left(), btnNews.bottom() + (float)GAP, btnRankings.width(), 20.0f);
            btnSettings.setRect(btnNews.right() + 2.0f, btnNews.top(), btnRankings.width(), 20.0f);
            btnAbout.setRect(btnSettings.left(), btnSettings.bottom() + (float)GAP, btnRankings.width(), 20.0f);
        } else {
            btnPlay.setRect(title.x, topRegion + (float)GAP, title.width(), 20.0f);
            TitleScene.align(btnPlay);
            btnSupport.setRect(btnPlay.left(), btnPlay.bottom() + (float)GAP, btnPlay.width(), 20.0f);
            btnRankings.setRect(btnPlay.left(), btnSupport.bottom() + (float)GAP, btnPlay.width() / 2.0f - 1.0f, 20.0f);
            btnBadges.setRect(btnRankings.right() + 2.0f, btnRankings.top(), btnRankings.width(), 20.0f);
            btnNews.setRect(btnRankings.left(), btnRankings.bottom() + (float)GAP, btnRankings.width(), 20.0f);
            btnChanges.setRect(btnNews.right() + 2.0f, btnNews.top(), btnNews.width(), 20.0f);
            btnSettings.setRect(btnNews.left(), btnNews.bottom() + (float)GAP, btnRankings.width(), 20.0f);
            btnAbout.setRect(btnSettings.right() + 2.0f, btnSettings.top(), btnSettings.width(), 20.0f);
        }
        BitmapText version = new BitmapText("v" + Game.version, pixelFont);
        version.measure();
        version.hardlight(0x888888);
        version.x = (float)w - version.width() - 4.0f;
        version.y = (float)h - version.height() - 2.0f;
        this.add(version);
        if (DeviceCompat.isDesktop()) {
            ExitButton btnExit = new ExitButton();
            btnExit.setPos((float)w - btnExit.width(), 0.0f);
            this.add(btnExit);
        }
        this.fadeIn();
    }

    private void placeTorch(float x, float y) {
        Fireball fb = new Fireball();
        fb.setPos(x, y);
        this.add(fb);
    }

    private static class SupportButton
    extends StyledButton {
        public SupportButton(Chrome.Type type, String label) {
            super(type, label);
            this.icon(Icons.get(Icons.GOLD));
            this.textColor(0xFFFF44);
        }

        @Override
        protected void onClick() {
            ShatteredPixelDungeon.switchNoFade(SupporterScene.class);
        }
    }

    private static class SettingsButton
    extends StyledButton {
        public SettingsButton(Chrome.Type type, String label) {
            super(type, label);
            if (Messages.lang().status() == Languages.Status.X_UNFINISH) {
                this.icon(Icons.get(Icons.LANGS));
                this.icon.hardlight(1.5f, 0.0f, 0.0f);
            } else {
                this.icon(Icons.get(Icons.PREFS));
            }
        }

        @Override
        public void update() {
            super.update();
            if (Messages.lang().status() == Languages.Status.X_UNFINISH) {
                this.textColor(ColorMath.interpolate(0xFFFFFF, 0xFF0000, 0.5f + (float)Math.sin(Game.timeTotal * 5.0f) / 2.0f));
            }
        }

        @Override
        protected void onClick() {
            if (Messages.lang().status() == Languages.Status.X_UNFINISH) {
                WndSettings.last_index = 4;
            }
            ShatteredPixelDungeon.scene().add(new WndSettings());
        }
    }

    private static class ChangesButton
    extends StyledButton {
        boolean updateShown = false;

        public ChangesButton(Chrome.Type type, String label) {
            super(type, label);
            if (SPDSettings.updates()) {
                Updates.checkForUpdate();
            }
        }

        @Override
        public void update() {
            super.update();
            if (!this.updateShown && Updates.updateAvailable()) {
                this.updateShown = true;
                this.text(Messages.get(TitleScene.class, "update", new Object[0]));
            }
            if (this.updateShown) {
                this.textColor(ColorMath.interpolate(0xFFFFFF, 0x33BB33, 0.5f + (float)Math.sin(Game.timeTotal * 5.0f) / 2.0f));
            }
        }

        @Override
        protected void onClick() {
            if (Updates.updateAvailable()) {
                AvailableUpdateData update = Updates.updateData();
                ShatteredPixelDungeon.scene().addToFront(new WndOptions(Icons.get(Icons.CHANGES), update.versionName == null ? Messages.get(this, "title", new Object[0]) : Messages.get(this, "versioned_title", update.versionName), update.desc == null ? Messages.get(this, "desc", new Object[0]) : update.desc, new String[]{Messages.get(this, "update", new Object[0]), Messages.get(this, "changes", new Object[0])}){

                    @Override
                    protected void onSelect(int index) {
                        if (index == 0) {
                            Updates.launchUpdate(Updates.updateData());
                        } else if (index == 1) {
                            ChangesScene.changesSelected = 0;
                            ShatteredPixelDungeon.switchNoFade(ChangesScene.class);
                        }
                    }
                });
            } else {
                ChangesScene.changesSelected = 0;
                ShatteredPixelDungeon.switchNoFade(ChangesScene.class);
            }
        }
    }

    private static class NewsButton
    extends StyledButton {
        int unreadCount = -1;

        public NewsButton(Chrome.Type type, String label) {
            super(type, label);
            if (SPDSettings.news()) {
                News.checkForNews();
            }
        }

        @Override
        public void update() {
            super.update();
            if (this.unreadCount == -1 && News.articlesAvailable()) {
                long lastRead = SPDSettings.newsLastRead();
                if (lastRead == 0L) {
                    if (News.articles().get(0) != null) {
                        SPDSettings.newsLastRead(News.articles().get((int)0).date.getTime());
                    }
                } else {
                    this.unreadCount = News.unreadArticles(new Date(SPDSettings.newsLastRead()));
                    if (this.unreadCount > 0) {
                        this.unreadCount = Math.min(this.unreadCount, 9);
                        this.text(this.text() + "(" + this.unreadCount + ")");
                    }
                }
            }
            if (this.unreadCount > 0) {
                this.textColor(ColorMath.interpolate(0xFFFFFF, 0x33BB33, 0.5f + (float)Math.sin(Game.timeTotal * 5.0f) / 2.0f));
            }
        }

        @Override
        protected void onClick() {
            super.onClick();
            ShatteredPixelDungeon.switchNoFade(NewsScene.class);
        }
    }
}

