MPlayer(1)                                             MPlayer(1)



NAME
       mplayer  - Movie Player for Linux
       mencoder - Movie Encoder for Linux


SYNOPSIS
       mplayer [options] [ file | URL | playlist | - ]
       mplayer [global options] file1 [specific options] [file2]
               [specific options]
       mplayer [global options] {group of files and options}
               [group specific options]
       mplayer [dvd|vcd|cdda|cddb|tv]://title [options]
       mplayer [mms[t]|http|http_proxy|rt[s]p]://
               [user:passwd@]URL[:port] [options]
       mencoder [options] [ file | URL | - ] [-o file]
       gmplayer [options] [-skin skin]


DESCRIPTION
       mplayer is a movie player for LINUX (runs  on  many  other
       Unices and non-x86 CPUs, see the documentation).  It plays
       most MPEG/VOB, AVI, ASF/WMA/WMV, RM, QT/MOV/MP4,  OGG/OGM,
       VIVO, FLI, NuppelVideo, yuv4mpeg, FILM and RoQ files, sup-
       ported by many native, XAnim, and Win32 DLL  codecs.   You
       can  watch  VideoCD,  SVCD, DVD, 3ivx, DivX 3/4/5 and even
       WMV movies, too (without using the avifile library).

       Another great feature of MPlayer is the wide range of sup-
       ported  output  drivers.   It  works  with  X11,  XV, DGA,
       OpenGL, SVGAlib, fbdev, AAlib, DirectFB, but you can  also
       use  GGI,  SDL  (and this way all their drivers), VESA (on
       every VESA compatible card, even without  X11),  some  low
       level card-specific drivers (for Matrox, 3Dfx and ATI) and
       some hardware MPEG decoder boards,  such  as  the  Siemens
       DVB, DXR2 and DXR3/Hollywood+.  Most of them support soft-
       ware or hardware scaling,  so  you  can  enjoy  movies  in
       fullscreen.

       MPlayer  has an onscreen display (OSD) for status informa-
       tion, nice big antialiased  shaded  subtitles  and  visual
       feedback  for  keyboard  controls.   European/ISO 8859-1,2
       (Hungarian, English,  Czech,  etc),  Cyrillic  and  Korean
       fonts  are  supported  along with 10 subtitle formats (Mi-
       croDVD, SubRip, SubViewer, Sami, VPlayer, RT,  SSA,  AQTi-
       tle,  JACOsub  and  our own: MPsub) and DVD subtitles (SPU
       streams, VobSub and Closed Captions).

       mencoder (MPlayer's Movie Encoder) is a simple  movie  en-
       coder,  designed  to  encode  MPlayer-playable movies (see
       above) to other MPlayer-playable formats (see below).   It
       encodes  to  DivX4, XviD, one of the libavcodec codecs and
       PCM/MP3/VBRMP3 audio in 1, 2 or 3 passes.  Furthermore  it
       has  stream  copying  abilities,  a powerful plugin system
       (crop, expand, flip, postprocess,  rotate,  scale,  noise,
       rgb/yuv conversion) and more.

       gmplayer  is  MPlayer with a graphical user interface.  It
       has the same options as MPlayer.



GENERAL NOTES
       Also see the HTML documentation!

       Every 'flag' option has a 'noflag' counterpart,  e.g.  the
       opposite of the -fs option is -nofs.

       You  can  put  all  of the options in a configuration file
       which will be read every time mplayer is run.  The system-
       wide configuration file 'mplayer.conf' is in your configu-
       ration directory  (e.g.  /etc/mplayer  or  /usr/local/etc/
       mplayer),  the  user  specific one is '~/.mplayer/config'.
       User specific options override system-wide options and op-
       tions given on the command line override either.  The syn-
       tax of the configuration files is 'option=<value>', every-
       thing  after  a '#' is considered a comment.  Options that
       work without values can be  enabled  by  setting  them  to
       'yes'  or '1' and disabled by setting them to 'no' or '0'.
       Even suboptions can be specified in this way.

       EXAMPLE:
       # Use Matrox driver by default.
       vo=xmga
       # I love practicing handstands while watching videos.
       flip=yes
       # Decode/encode multiple files from png, start it with -mf
       on
       mf= type=png:fps=25



PLAYER OPTIONS (MPLAYER ONLY)
       -autoq <quality> (use with -vop pp)
              Dynamically changes the level of postprocessing de-
              pending on available spare CPU  time.   The  number
              you specify will be the maximum level used.  Usual-
              ly you can use some big number.  You  have  to  use
              -vop pp without parameters in order to use this.

       -autosync <factor>
              Gradually adjusts the A/V sync based on audio delay
              measurements.  Specifying -autosync 0, the default,
              will cause frame timing to be based entirely on au-
              dio  delay  measurements.   Specifying  -autosync 1
              will  do  the  same, but will subtly change the A/V
              correction algorithm used.  An uneven  video  frame
              rate  in a movie which plays fine with -nosound can
              often be helped by setting this to an integer value
              greater  than  1.  The higher the value, the closer
              the timing will be to -nosound.   Try  -autosync 30
              to  smooth out problems with sound drivers which do
              not implement a perfect  audio  delay  measurement.
              With  this  value, if large A/V sync offsets occur,
              they will only take about 1 or 2 seconds to  settle
              out.   This  delay  in  reaction time to sudden A/V
              offsets should be the only side-effect  of  turning
              this option on, for all sound drivers.

       -benchmark
              Prints  some  statistics  on  CPU usage and dropped
              frames  at  the  end.   Use  in  combination   with
              -nosound  and  -vo  null  for benchmarking only the
              video codec.

       -framedrop (also see -hardframedrop)
              Skips displaying some frames to maintain  A/V  sync
              on  slow  systems.   Decoding  of  B frames is also
              skipped and video filters are not used.

       -h, -help, --help
              Show short summary of options.

       -hardframedrop
              More  intense  frame  dropping  (breaks  decoding).
              Leads to image distortion!

       -identify
              Show  file parameters in easy parsable format.  The
              wrapper script TOOLS/midentify suppresses the other
              mplayer  output  and  (hopefully)  shellescapes the
              filenames.

       -input <commands>
              This option can be used to configure certain  parts
              of  the  input  system.   Paths  are relative to ~/
              .mplayer/.

              NOTE:
              Autorepeat is  currently  only  supported  by  joy-
              sticks.
              Available commands are:

                 conf=<file>         Read alternative input.conf.
                                     If given  without  pathname,
                                     ~/.mplayer is assumed.
                 ar-delay            Delay   in  msec  before  we
                                     start to autorepeat a key (0
                                     to disable).
                 ar-rate             How  many  key  presses  per
                                     second when we autorepeat.
                 keylist             Prints all keys that can  be
                                     bound.
                 cmdlist             Prints all commands that can
                                     be bound.
                 js-dev              Specifies the  joystick  de-
                                     vice   to  use  (default  is
                                     /dev/input/js0).
                 file                Read commands from the given
                                     file.  Mostly  useful with a
                                     fifo.

       -lircconf <configuration file>
              Specifies a configuration file for LIRC (Linux  In-
              frared  Remote Control, see http://www.lirc.org) if
              you don't like the default ~/.lircrc.

       -loop <number>
              Loops movie playback <number> times.  0 means  for-
              ever.

       -nojoystick
              Turns off joystick support.  Default is on, if com-
              piled in.

       -nolirc
              Turns off LIRC support.

       -nortc
              Turns off usage of the Linux RTC (real-time clock -
              /dev/rtc) as timing mechanism.

       -playlist <file>
              Play  files according to a playlist (1 file per row
              or Winamp or ASX format).

       -quiet
              Display less output and status messages.

       -really-quiet
              Display even less output and status messages.

       -rnd
              Play files in random order.

       -sdp   Specifies that the input file is  a  SDP  ('Session
              Description  Protocol')  file that describes an RTP
              session (see http://www.live.com/mplayer/).

       -skin <skin directory> (BETA CODE)
              Load skin from the given  directory  (WITHOUT  path
              name).

              EXAMPLE:
                 -skin fittyfene     tries   Skin/fittyfene.   It
                                     first    checks     /usr/lo-
                                     cal/share/mplayer/  and  af-
                                     terwards ~/.mplayer/.

       -slave
              This option switches on slave mode.   This  is  in-
              tended  for  use  of  MPlayer as a backend to other
              programs.  Instead of intercepting keyboard events,
              MPlayer will read simplistic command lines from its
              stdin.  The section SLAVE  MODE  PROTOCOL  explains
              the syntax.

       -softsleep
              Uses  high  quality software timers.  As precise as
              the  RTC  without  requiring  special   privileges.
              Comes at the price of higher CPU consumption.

       -speed <0.01-100>
              Set playback speed rate.

       -sstep <sec>
              Specifies seconds between displayed frames.  Useful
              for slideshows.

       -use-stdin



DEMUXER/STREAM OPTIONS
       -aid <id> (also see -alang option)
              Select audio channel [MPEG: 0-31 AVI/OGM: 1-99 ASF/
              RM:  0-127  VOB(AC3):  128-159  VOB(LPCM): 160-191]
              MPlayer prints the available IDs  when  running  in
              verbose (-v) mode.

       -alang <two letter country code> (also see -aid option)
              Works  only  for  DVD playback.  It selects the DVD
              audio language  and  always  tries  to  play  audio
              streams whose language matches the given code.  For
              the list of available languages, use  with  the  -v
              switch and look at the output.

              EXAMPLE:
                 -alang hu,en        Plays  Hungarian  and  falls
                                     back to English if Hungarian
                                     is not available.

       -audio-demuxer <number> (-audiofile only)
              Force  audio demuxer type for -audiofile.  Give the
              demuxer ID as  defined  in  demuxers.h.   Use  -au-
              dio-demuxer 17 to force .mp3 detection.

       -audiofile <filename>
              Play  audio  from an external file (WAV, MP3 or Ogg
              Vorbis).

       -cdrom-device <path to device>
              Override default CDROM drive name /dev/cdrom.

       -cache <kbytes>
              This option specifies how much memory  (in  kbytes)
              to use when precaching a file/URL.  Especially use-
              ful on slow media (default is -nocache).

       -cdda <option1:option2>
              This option can be used to tune the CD Audio  read-
              ing feature of MPlayer.
              Available options are:

                 speed=<value>       set CD spin speed

                 paranoia=<0-2>      set paranoia level
                                        0: disable checking
                                        1:  overlap checking only
                                        (default)
                                        2: full  data  correction
                                        and verification

                 generic-dev=<value> use  specified  generic SCSI
                                     device

                 sector-size=<value> atomic read size

                 overlap=<value>     force minimum overlap search
                                     during verification to <val-
                                     ue> sectors.

                 toc-bias            Assume  that  the  beginning
                                     offset of track 1 as report-
                                     ed in the TOC  will  be  ad-
                                     dressed   as   LBA 0.   Some
                                     Toshiba drives need this for
                                     getting   track   boundaries
                                     correct.

                 toc-offset=<value>  Add <value> sectors  to  the
                                     values   reported  when  ad-
                                     dressing  tracks.   May   be
                                     negative.

                 (no)skip            (never) accept imperfect da-
                                     ta reconstruction.

       -channels <number>
              Change the number of playback channels, defaults to
              '2'  if  not  specified.   If  the number of output
              channels is bigger than the number of  input  chan-
              nels  empty  channels  are  inserted (unless mixing
              from mono to stereo, then the mono channel  is  re-
              peated  in both output channels).  If the number of
              output channels is smaller than the number of input
              channels,  results  depend  on  the  audio  decoder
              (-afm).  Mplayer asks the decoder to decode the au-
              dio into as many channels as specified. Now it's up
              to the decoder to fulfill the requirement.  If  the
              decoder  outputs  more channels than requested, the
              exceeding channels are truncated. This  is  usually
              only  important  when playing videos with AC3 audio
              (like DVDs). In that case liba52 does the  decoding
              by  default  and correctly downmixes the audio into
              the requested number of channels.

              NOTE:
              This option is honored by codecs (AC3 only) filters
              (surround) and ao drivers (OSS at least).
              Available options are:

                 2                   Stereo
                 4                   Surround
                 6                   Full 5.1

       -chapter <chapter id>[-<end chapter id>]
              Specify which chapter to start playing at.  Option-
              ally specify which chapter to end playing  at  (de-
              fault: 1).  Examples can be found below.

       -csslib <filename>
              (old-style DVD option) This option is used to over-
              ride the default location of libcss.so.

       -demuxer <number>
              Force demuxer type.  Give the demuxer ID as defined
              in  demuxers.h.   Use -demuxer 17 to force .mp3 de-
              tection.

       -dumpaudio (MPLAYER only)
              Dumps raw compressed audio stream to  ./stream.dump
              (useful with mpeg/ac3).

       -dumpfile <filename> (MPLAYER only)
              Specify  which file MPlayer should dump to.  Should
              be used together with  -dumpaudio  /  -dumpvideo  /
              -dumpstream.

       -dumpstream (MPLAYER only)
              Dumps the raw stream to ./stream.dump.  Useful when
              ripping from DVD or network.

       -dumpvideo (MPLAYER only)
              Dump raw compressed video stream  to  ./stream.dump
              (not very usable).

       -dvd <title id>
              Tell  MPlayer  which movies (specified by title id)
              to play.  For example sometimes '1' is  a  trailer,
              and '2' is the real movie.

              NOTE:
              Sometimes  deinterlacing  is required for DVD play-
              back, see the -vop pp=0x20000 option.

       -dvd-device <path to device>
              Override default DVD device name /dev/dvd.

       -dvdangle <angle id>
              Some DVD discs contain scenes that  can  be  viewed
              from  multiple  angles.   Here you can tell MPlayer
              which angles to use (default: 1).  Examples can  be
              found below.

       -dvdauth <DVD device>
              (old-style  DVD option) Turns on DVD authentication
              using the given device.

       -dvdkey <CSS key>
              (old-style DVD option) When  decoding  a  VOB  file
              copied  undecrypted from DVD, this option gives the
              CSS key needed to  decrypt  the  VOB  (the  key  is
              printed  when authenticating with the DVD drive us-
              ing -dvdauth).

       -dvdnav (BETA CODE)
              Force usage of libdvdnav.

       -forceidx
              Force rebuilding of INDEX.  Useful for  files  with
              broken  index (desyncs, etc).  Seeking will be pos-
              sible.  You can fix the index permanently with MEn-
              coder (see the documentation).

       -fps <value>
              Override video framerate (if value is wrong/missing
              in the header) (float number).

       -frames <number>
              Play/convert only first <number> frames, then quit.

       -hr-mp3-seek (.MP3 only)
              Hi-res mp3 seeking.  Default is: enabled when play-
              ing from external MP3 file, as we need to  seek  to
              the  very exact position to keep A/V sync.It can be
              slow especially when seeking backwards - it has  to
              rewind to the beginning to find the exact frame.

       -idx (also see -forceidx)
              Rebuilds  INDEX  of  the AVI if no INDEX was found,
              thus allowing seeking.  Useful  with  broken/incom-
              plete downloads, or badly created AVIs.

       -mc <seconds/frame>
              Maximum A-V sync correction per frame (in seconds).

       -mf <option1:option2:...>
              Used when decoding from multiple PNG or JPEG files.
              Available options are:

                 on                  turns on multifile support
                 w=<value>           width of the output (autode-
                                     tect)
                 h=<value>           height of  the  output  (au-
                                     todetect)
                 fps=<value>         fps  of the output (default:
                                     25)
                 type=<value>        type of input files  (avail-
                                     able types: jpeg, png, tga)

       -ni (.AVI only)
              Force  usage  of  non-interleaved AVI parser (fixes
              playing of some bad AVI files).

       -nobps (.AVI only)
              Do not use average  byte/sec  value  for  A-V  sync
              (AVI).  Helps with some AVI files with broken head-
              er.

       -passwd <password> (see -user option too)
              Specify password for http authentication.

       -rawaudio <option1:option2:...>
              This option lets you play raw audio files.  It  may
              also  be used to play audio CDs which are not 44KHz
              16Bit stereo.
              Available options are:

                 on                  use raw audio demuxer
                 channels=<value>    number of channels
                 rate=<value>        rate in samples per second
                 samplesize=<value>  sample size in byte
                 format=<value>      fourcc in hex

       -rtsp-stream-over-tcp
              Used with 'rtsp://' URLs to specify  that  the  re-
              sulting  incoming  RTP and RTCP packets be streamed
              over TCP (using the same TCP connection  as  RTSP).
              This  option may be useful if you have a broken In-
              ternet connection that does not pass  incoming  UDP
              packets (see http://www.live.com/mplayer/).

       -skipopening
              Skip DVD opening (dvdnav only).

       -sb <byte position> (see -ss option too)
              Seek  to  byte  position.  Useful for playback from
              CDROM images / .VOB files with junk at  the  begin-
              ning.

       -srate <Hz>
              Forces  the  given  audio  playback  rate, changing
              video speed to keep a-v sync.  MEncoder passes this
              value to lame for resampling.

       -ss <time> (see -sb option too)
              Seek to given time position.

              EXAMPLE:
                 -ss 56              seeks to 56 seconds
                 -ss 01:10:00        seeks to 1 hour 10 min

       -tv <option1:option2:...>
              This  option  enables  the  TV  grabbing feature of
              MPlayer.

              NOTE:
              MPlayer doesn't accept colons so type dots  instead
              in the device ID (e.g. hw.0,0 instead of hw:0,0).
              Be  advised  that  although you can select any sam-
              plerate when using ALSA, the LAME  audio  codec  is
              able  to  encode  only  the 'standard' samplerates.
              You'll get an .avi file  with  no  sound  when  you
              choose an odd samplerate and use this codec.
              Available options are:

                 on                  use TV input

                 noaudio             no sound

                 driver=<value>      available:  dummy,  v4l, bs-
                                     dbt848

                 device=<value>      Specify  other  device  than
                                     the default /dev/video0.

                 input=<value>       Specify other input than the
                                     default 0 (Television)  (see
                                     output for a list)

                 freq=<value>        Specify the frequency to set
                                     the tuner to (e.g. 511.250).

                 outfmt=<value>      output  format  of the tuner
                                     (yv12, rgb32, rgb24,  rgb16,
                                     rgb15, uyvy, yuy2, i420)

                 width=<value>       width of the output window

                 height=<value>      height of the output window

                 buffersize=<value>  capture   buffer   size   in
                                     megabytes (default  is  half
                                     of the physical memory)

                 norm=<value>        available: PAL, SECAM, NTSC

                 channel=<value>     Set  tuner  to <value> chan-
                                     nel.

                 chanlist=<value>    available: europe-east,  eu-
                                     rope-west,  us-bcast, us-ca-
                                     ble, etc

                 audiorate=<value>   set audio capture bitrate

                 forceaudio          capture audio even if  there
                                     are no audio sources report-
                                     ed by v4l

                 alsa                capture from ALSA

                 amode=<0-3>         choose an audio mode:
                                        0: mono
                                        1: stereo
                                        2: language 1
                                        3: language 2

                 forcechan=<1-2>     By  default,  the  count  of
                                     recorded  audio  channels is
                                     determined automatically  by
                                     querying the audio mode from
                                     the tv  card.   This  option
                                     allows  to force stereo/mono
                                     recording regardless of  the
                                     amode  option and the values
                                     returned by v4l.   This  can
                                     be  used for troubleshooting
                                     when the tv card  is  unable
                                     to  report the current audio
                                     mode.

                 adevice=<value>     set an audio device
                                        /dev/... for OSS
                                        hardware ID for ALSA

                 audioid=<value>     choose an  audio  output  of
                                     the  capture card, if it has
                                     more of them

                 [volume|bass|treble|balance]=<0-65535>
                                     These options set parameters
                                     of  the  mixer  on the video
                                     capture  card.   They   will
                                     have no effect, if your card
                                     doesn't have one.

       -user <user name> (see -passwd option too)
              Specify user name for http authentication.

       -vcd <track>
              Play video CD track from device  instead  of  plain
              file.

       -vid <id>
              Select video channel [MPG: 0-15 ASF: 0-255].

       -vivo <sub-options> (DEBUG CODE)
              Force  audio  parameters for the .vivo demuxer (for
              debugging purposes).



OSD/SUB OPTIONS
       NOTE:
       See -vop expand too.

       -dumpmicrodvdsub (MPLAYER only)
              Convert the given subtitle (specified with the -sub
              switch) to the MicroDVD subtitle format.  Creates a
              dumpsub.sub file in the current directory.

       -dumpmpsub (MPLAYER only)
              Convert the given subtitle (specified with the -sub
              switch)  to MPlayer's subtitle format, MPsub.  Cre-
              ates a dump.mpsub file in the current directory.

       -dumpsrtsub (MPLAYER only)
              Convert the given subtitle (specified with the -sub
              switch)  to the time-based SubViewer (SRT) subtitle
              format.  Creates a dumpsub.srt file in the  current
              directory.

       -dumpjacosub (MPLAYER only)
              Convert the given subtitle (specified with the -sub
              switch) to the time-based JACOsub subtitle  format.
              Creates a dumpsub.js file in the current directory.

       -dumpsami (MPLAYER only)
              Convert the given subtitle (specified with the -sub
              switch)  to  the  time-based  SAMI subtitle format.
              Creates a dumpsub.smi file in the current  directo-
              ry.

       -dumpsub (MPLAYER only) (BETA CODE)
              Dumps the subtitle substream from VOB streams.  See
              -dump*sub and -vobsubout* options too.

       -ifo <vobsub ifo file>
              Indicate the file that will be used to load palette
              and frame size for VOBSUB subtitles.

       -ffactor <number>
              Resample alphamap of the font.  Can be:

                 0                   plain white fonts
                 0.75                very  narrow  black  outline
                                     [default]
                 1                   narrow black outline
                 10                  bold black outline

       -font <path to font.desc file>
              Search for the OSD/SUB fonts in an alternative  di-
              rectory (default for normal fonts: ~/.mplayer/font/
              font.desc, default for FreeType fonts:  ~/.mplayer/
              subfont.ttf).

              NOTE:
              With  FreeType,  this option determines path to the
              text font file.
              The -subfont-*  options  are  available  only  with
              FreeType  support compiled in.  If FreeType support
              is enabled, the old font support can't be used.

              EXAMPLE:
                 -font ~/.mplayer/arial-14/font.desc
                 -font ~/.mplayer/arialuni.ttf

       -noautosub
              Turns off automatic loading of subtitle files.

       -nooverlapsub
              Turns off support for overlapping subtitles.

       -osdlevel <0-2> (MPLAYER only)
              Specifies which mode the OSD should  start  in  (0:
              none, 1: seek, 2: seek+timer, default is 1).

       -sid <id> (also see -slang option)
              Turns  on  DVD subtitle displaying.  Also, you MUST
              specify a number which corresponds to a DVD  subti-
              tle  language  (0-31).   For  the list of available
              subtitles, use with the -v switch and look  at  the
              output.

       -slang <two letter country code> (also see -sid option)
              Works  only for DVD playback.  Turns on/selects DVD
              subtitle language.  For the list of available  sub-
              titles, use with the -v switch and look at the out-
              put.

              EXAMPLE:
                 -slang hu,en        Selects Hungarian and  falls
                                     back to English if Hungarian
                                     is not available.

       -sub <subtitle file>
              Use/display this subtitle file.

       -subcc
              Display DVD Closed Caption (CC)  subtitles.   These
              are  NOT the VOB subtitles, these are special ASCII
              subtitles for the hearing impaired encoded  in  the
              VOB userdata stream on most region 1 DVDs.  CC sub-
              titles have not been spotted on DVDs from other re-
              gions so far.

       -subcp <codepage>
              If  your system supports iconv(3), you can use this
              option to specify codepage of the subtitle.

              EXAMPLE:
                 -subcp latin2
                 -subcp cp1250

       -sub-demuxer <number> (BETA CODE)
              Force subtitle demuxer type for -subfile.

       -subdelay <sec>
              Delays subtitles by <sec> seconds.   Can  be  nega-
              tive.

       -subfont-autoscale <0-3>
              Sets the autoscale mode.

              NOTE:
              Zero  means  that text-scale and osd-scale are font
              heights in points.
              The mode can be:

                 0                   no autoscale
                 1                   proportional to movie height
                 2                   proportional to movie width
                 3                   proportional to movie diago-
                                     nal (default)

       -subfont-blur <0-8>
              Sets the font blur radius (default: 2).

       -subfont-encoding <value>
              Sets the font encoding.  When set to 'unicode', all
              the  glyphs from the font file will be rendered and
              unicode will be used (default: unicode).

       -subfont-osd-scale <0-100>
              Sets the osd elements  autoscale  coefficient  (de-
              fault: 6).

       -subfont-outline <0-8>
              Sets the font outline thickness (default: 2).

       -subfont-text-scale <0-100>
              Sets  the subtitle text autoscale coefficient (per-
              centage of the screen size) (default: 5).

       -subfps <rate>
              Specify frame/sec rate of subtitle file (float num-
              ber), default: the same fps as the movie.

              NOTE:
              ONLY  for  frame-based SUB files, i.e. NOT MicroDVD
              format.

       -subfile <filename> (BETA CODE)
              Currently useless.  Same  as  -audiofile,  but  for
              subtitle streams (OggDS?).

       -subpos <0-100> (useful with -vop expand)
              Specify  the  position  of subtitles on the screen.
              The value is the vertical position of the  subtitle
              in % of the screen height.

       -unicode
              Tells  MPlayer  to handle the subtitle file as UNI-
              CODE.

       -utf8
              Tells MPlayer to handle the subtitle file as  UTF8.

       -vobsub <vobsub file without extension>
              Specify  the  VobSub  files that are to be used for
              subtitle.  This is the full pathname without exten-
              sions, i.e. without the '.idx', '.ifo' or '.sub'.

       -vobsubid <0-31>
              Specify the VobSub subtitle id.



AUDIO OUTPUT OPTIONS (MPLAYER ONLY)
       -abs <value> (OBSOLETE)
              Override  audio  driver/card buffer size detection,
              -ao oss only

       -af <plugin1,plugin2,plugin3[=options],...>
              Activate a comma separated list  of  audio  filters
              and their options.
              Available filters are:

                 resample[=srate[:sloppy][:fast]]
                                     Changes  the  sample rate of
                                     the audio stream to an inte-
                                     ger  srate  (Hz).   It  only
                                     supports the 16  bit  little
                                     endian format.

                 channels[=nch]      Change  the  number of chan-
                                     nels to nch output channels.
                                     If   the  number  of  output
                                     channels is bigger than  the
                                     number   of  input  channels
                                     empty channels are  inserted
                                     (except  mixing from mono to
                                     stereo, then the mono  chan-
                                     nel  is  repeated in both of
                                     the  output  channels).   If
                                     the  number  of output chan-
                                     nels  is  smaller  than  the
                                     number of input channels the
                                     exceeding channels are trun-
                                     cated.

                 format[=bps,f]      Select the format f and bits
                                     per sample bps used for out-
                                     put  from  the filter layer.
                                     The option bps is an integer
                                     and  denotes  bytes per sam-
                                     ple.  The  format  f  is   a
                                     string containing a concate-
                                     nated mix of:
                                     alaw, mulaw or imaadpcm
                                     float or int
                                     unsigned or signed
                                     le or be (little or big  en-
                                     dian)

                 volume[=v:sc:pr:en] Select   the  output  volume
                                     level.  This filter  is  not
                                     reentrant  and can therefore
                                     only be enabled once for ev-
                                     ery audio stream.
                                        v: desired gain in dB for
                                        all   channels   in   the
                                        stream.  The  gain can be
                                        set from -200dB to  +40dB
                                        (where  -200dB  mutes the
                                        sound   completely    and
                                        +40dB  equals  a  gain of
                                        1000). The  default  gain
                                        is -20dB.
                                        sc: enable soft clipping.
                                        pr: enable probing of the
                                        volume level for each au-
                                        dio stream. Both the max-
                                        imum   and  instantaneous
                                        volume is probed. The in-
                                        stantaneous   volume  can
                                        only be accessed  through
                                        the   runtime  interface,
                                        but the maximum volume is
                                        printed at the end of the
                                        movie. This value can  be
                                        used   when   transcoding
                                        movies  to  maximize  the
                                        utilization of the dynam-
                                        ic range.
                                        en:  enable  and  disable
                                        the volume control.

                 delay[=d]           Delay sound output by d sec-
                                     onds  (floating  point  num-
                                     ber).

       -af-adv <force=(0-3):list=(filters)> (see -af option too)
              Specify advanced audio filter options:

                 force=<0-3>         Forces  the insertion of au-
                                     dio filters to  one  of  the
                                     following:
                                        0:  Completely  automatic
                                        insertion of filters (de-
                                        fault)
                                        1: Optimize for speed
                                        2: Optimize for accuracy
                                        3: Turn off auto

                 list=<filters>      Same  as  -af  (see  -af op-
                                     tion).

       -ao <driver1[:device],driver2,...[,]>
              Specify a priority list  of  audio  output  drivers
              (optionally  with  device) to be used.  'device' is
              valid with SDL, too, it means subdriver then.

              NOTE:
              To get a full list of available  drivers,  see  -ao
              help.
              If  the list has a trailing ',' it will fallback to
              drivers not listed.

              EXAMPLE
                 -ao oss:/dev/dsp2,oss:/dev/dsp1,
                                     try  to  use  OSS  with  the
                                     specified  sound devices and
                                     fallback  to  others  if  it
                                     fails
                 -ao sdl:esd         specify the SDL subdriver

       -aofile <filename>
              Filename for -ao pcm.

       -aop <list=plugin1,plugin2...:option1=value1:opt2=val2...>
              Specify audio plugin(s) and their options (see doc-
              umentation too).
              Available options are:

                 list=[plugins]      comma separated list of plu-
                                     gins   (resample,  surround,
                                     format, volume, extrastereo,
                                     volnorm)

                 delay=<sec>         example  plugin, do not use.

                 format=<format>     output format (format plugin
                                     only)

                 fout=<Hz>           output  frequency  (resample
                                     plugin only)

                 volume=<0-255>      volume (volume plugin only)

                 mul=<value>         stereo coefficient (default:
                                     2.5) (extrastereo plugin on-
                                     ly)

                 softclip            compressor / 'soft-clipping'
                                     capabilities  (volume plugin
                                     only)

       -delay <sec>
              Audio delay in seconds (may be +/- float value).

       -mixer <device>
              This option will tell MPlayer to  use  a  different
              device for mixing than /dev/mixer.

       -nowaveheader (-ao pcm only)
              Don't include wave header.  Used for RAW PCM.



VIDEO OUTPUT OPTIONS (MPLAYER ONLY)
       -aa* (-vo aa only)
              You  can get a list and an explanation of available
              options executing mplayer -aahelp

       -bpp <depth>
              Use different color depth than autodetect.  Not all
              -vo drivers support it (fbdev, dga2, svga, vesa).

       -brightness <-100 - 100>
              Adjust  brightness of video output (default 0).  It
              changes intensity of RGB components of video signal
              from black to white screen.

       -contrast <-100 - 100>
              Adjust contrast of video output (default 0).  Works
              in similar manner as brightness.

       -display <name>
              Specify the hostname and display number  of  the  X
              server you want to display on.

              EXAMPLE:
                 -display xtest.localdomain:0

       -double
              Enables  doublebuffering.  Fixes flicker by storing
              two frames in memory, and displaying one while  de-
              coding  another.   Can affect OSD.  Needs twice the
              memory of a single buffer,  so  it  won't  work  on
              cards with very little video memory.

       -dr
              Turns  on  direct  rendering  (not supported by all
              codecs and video outputs) (default is off).   Warn-
              ing: may cause OSD/SUB corruption!

       -dxr2 <option1:option2:...>
              This  option  is  used  to control the dxr2 driver.
              Note: The lavc filter is now auto inserted  if  you
              try  to  play  a  non MPEG1/2 format so all formats
              supported by MPlayer should play out of the box (if
              you  have  the  CPU  power  needed to encode on the
              fly).  The overlay chipset used on the dxr2  is  of
              pretty  bad quality but the default settings should
              work for everybody. The OSD may be usable with  the
              overlay  (not on TV) by drawing it in the colorkey.
              With the default  colorkey  settings  you  may  get
              variable results, usually you will see the colorkey
              around the characters or some other  funny  effect.
              Buf  if  you  properly adjust the colorkey settings
              you should be able to get acceptable results.

                 ar-mode=<value>     aspect ratio mode (0 =  nor-
                                     mal,  1 = pan scan, 2 = let-
                                     terbox (default))

                 iec958-encoded/decoded
                                     iec958 output mode

                 mute                mute sound output

                 ucode=<value>       path to the microcode

              TV Out

                 75ire               enable 7.5 IRE

                 bw                  b/w TV output

                 color               color TV output

                 interlaced          interlaced TV output

                 macrovision=<value> macrovision mode  (0  =  off
                                     (default),  1 = agc, 2 = agc
                                     2 colorstripe,  3  =  agc  4
                                     colorstripe)

                 norm=<value>        TV   norm  (ntsc  (default),
                                     pal,pal60,palm,paln,palnc)

                 square/ccir601-pixel
                                     TV pixel mode

              Overlay

                 cr-[left|right|top|bot]=<-20-20>
                                     adjust the overlay cropping

                 ck-[rgb]min=<0-255> minimum value for the  color
                                     key

                 ck-[rgb]max=<0-255> maximum  value for the color
                                     key

                 ck-[rgb]=<0-255>    color key values

                 ignore-cache        do not use the VGA cache

                 ol-osd              enable the osd hack  on  the
                                     overlay

                 ol[hwxy]-cor=<value>
                                     adjust  the overlay size and
                                     position in case it  doesn't
                                     match the window perfectly

                 overlay             enable the overlay

                 overlay-ratio=<1-2500>
                                     tune  the  overlay  (default
                                     1000)

                 update-cache        recreate the VGA cache

       -fb <device> (fbdev or DirectFB only)
              Specifies the framebuffer device to  use.   By  de-
              fault it uses /dev/fb0.

       -fbmode <modename> (fbdev only)
              Change  video  mode  to the one that is labelled as
              <modename> in /etc/fb.modes.

              NOTE:
              VESA framebuffer doesn't support mode changing.

       -fbmodeconfig <filename> (fbdev only)
              Use this configuration file instead of the  default
              /etc/fb.modes.  Only valid for the fbdev driver.

       -forcexv (SDL only)
              Force using XVideo.

       -fs
              Fullscreen  playing (centers movie, and makes black
              bands around it).  Toggle it with the 'f' key  (not
              all video outputs support it).  See also -zoom.

       -fsmode-dontuse <0-31> (OBSOLETE) (use -fs option)
              Try  this option if you still experience fullscreen
              problems.

       -geometry x[%][:y[%]]
              Adjust where the output is on the screen initially.
              The  x  and y specifications are in pixels measured
              from the top-right of the screen to  the  top-right
              of the image being displayed, however if a percent-
              age sign is given after the argument it  turns  the
              value  into a percentage of the screen size in that
              direction.  The values given must be integers.

              EXAMPLE:
                 50:40               Places the window  at  x=50,
                                     y=40
                 50%:50%             Places  the  window  in  the
                                     middle of the screen
                 100%                Places the window at the top
                                     left corner of the screen
                 100%:100%           Places  the  window  at  the
                                     bottom left  corner  of  the
                                     screen

       -hue <-100 - 100>
              Adjust  hue  of video signal (default: 0).  You can
              get colored negative of image with this option.

       -icelayer <0-15> (icewm only)
              Sets the layer of the fullscreen window of  mplayer
              for icewm.

                 0                   Desktop
                 2                   Below
                 4                   Normal
                 6                   OnTop
                 8                   Dock
                 10                  AboveDock
                 12                  Menu (default)

       -jpeg <option1:option2:...> (-vo jpeg only)
              Specify options for the JPEG output.
              Available  options  are:  [no]progressiv, [no]base-
              line, optimize, smooth, quality and outdir.

       -monitor_dotclock <dotclock (or pixelclock) range>  (fbdev
       and vesa only)
              Look into etc/example.conf for further  information
              and in DOCS/video.html.

       -monitor_hfreq  <horizontal  frequency  range>  (fbdev and
       vesa only)

       -monitor_vfreq  <vertical frequency range> (fbdev and vesa
       only)

       -monitoraspect <ratio>
              Set aspect ratio of your monitor or TV screen.  See
              also -aspect for movie aspect.

              EXAMPLE:
                 -monitoraspect 4:3  or 1.3333
                 -monitoraspect 16:9 or 1.7777

       -nograbpointer
              Do not grab  mouse  pointer  after  VidMode  change
              (-vm), useful for multihead setup.

       -noslices
              Disable  drawing  video  by 16-pixel height slices/
              bands, instead draws the while frame  in  a  single
              run.   May  be faster or slower, depending on card/
              cache.  It has effect only with libmpeg2 and libav-
              codec codecs.

       -panscan <0.0-1.0>
              Enables  Pan & Scan functionality, i.e. in order to
              display a 16:9 movie on a 4:3 display, the sides of
              the movie are cropped to get a 4:3 image which fits
              the screen.  This function works only with xv, xmga
              and xvidix drivers.
              The  range  controls  how  much  of  the  image  is
              cropped.

       -rootwin
              Play movie in the root window (desktop  background)
              instead of opening a new one.  Works only with x11,
              xv, xmga and xvidix drivers.

       -saturation <-100 - 100>
              Adjust saturation of  video  output  (default:  0).
              You can get grayscale output with this option.

       -screenw <pixels> -screenh <pixels>
              If  you  use  an output driver which can't know the
              resolution of the screen (fbdev/x11  and/or  TVout)
              this  is  where  you can specify the horizontal and
              vertical resolution.

       -stop_xscreensaver
              Turns off xscreensaver at startup and turns  it  on
              again on exit.

       -vm
              Try  to change to a better video mode.  dga, x11/xv
              (XF86VidMode) and sdl output drivers support it.

       -vo <driver1[:device],driver2,...[,]>
              Specify a priority list  of  video  output  drivers
              (optionally  with  device) to be used.  'device' is
              valid with SDL and GGI,  too,  it  means  subdriver
              then.

              NOTE:
              See  -vo help for a full list of available drivers.
              If the list has a trailing ',' it will fallback  to
              drivers not listed.

              EXAMPLE:
                 -vo xmga,xv,        Try  Matrox  kernel  driver,
                                     then Xv driver, then others
                 -vo sdl:aalib       specify the SDL subdriver

       -vsync
              Enables VBI for vesa.

       -wid <window id>
              This tells MPlayer to use a X11  window,  which  is
              useful  to  embed  MPlayer  in  a browser (with the
              plugger extension for instance).

       -xineramascreen <0-...>
              In Xinerama configurations (i.e. a  single  desktop
              that  spans  across  multiple displays) this option
              tells MPlayer which screen to display movie on.

       -z <0-9>
              Specifies compression level  for  PNG  output  (-vo
              png)

                 0                   no compression
                 9                   max compression

       -zrbw (-vo zr only)
              Display  in  black  and  white (for optimal perfor-
              mance, this option can be combined with the 'decode
              only  in black and white' option for codecs belong-
              ing to the FFmpeg family).

       -zrcrop <[width]x[height]+[x offset]+[y offset]>  (-vo  zr
       only)
              Select a part of the input image for display,  mul-
              tiple  occurences of this option switch on cinerama
              mode.  In cinerama mode the  movie  is  distributed
              over more than one TV (or beamer) to create a larg-
              er screen.  Options appearing after the  n-th  -zr-
              crop apply to the n-th MJPEG card, each card should
              at least have a -zrdev in addition to the  -zrcrop.
              For  examples, see the output of -zrhelp and the Zr
              section of the documentation.

       -zrdev <device> (-vo zr only)
              Specify the device special  file  that  belongs  to
              your  MJPEG  card, by default this driver takes the
              first v4l device it can find.

       -zrfd (-vo zr only)
              Force  decimation:  Decimation,  as  specified   by
              -zrhdec  and  -zrvdec, only happens if the hardware
              scaler can stretch the image to its original  size.
              Use this option to force decimation.

       -zrhelp (-vo zr only)
              Display  a  list of all -zr* options, their default
              values and an example of cinerama mode.

       -zrnorm <norm> (-vo zr only)
              Specify norm PAL/NTSC, the default is 'no  change'.

       -zrquality <1-20> (-vo zr only)
              A  number from 1 to 20 representing the jpeg encod-
              ing quality.  1 gives the best quality and 20 gives
              very bad quality.

       -zrvdec <1,2,4> -zrhdec <1,2,4> (-vo zr only)
              Vertical/horizontal  decimation:  Ask the driver to
              send only every 2nd or 4th line/pixel of the  input
              image  to  the MJPEG card and use the scaler of the
              MJPEG card to strech  the  image  to  its  original
              size.

       -zrxdoff  <x  display offset>, -zrydoff <y display offset>
       (-vo zr only)
              If  the  movie is smaller than the TV screen, these
              options control the position of the movie  relative
              to  the upper left corner of the screen.  The movie
              is centered by default.



DECODING/FILTERING OPTIONS
       -ac <[-]codec1,[-]codec2,...[,]>
              Specify a priority list of audio codecs to be used,
              according  to their codec name in codecs.conf.  Use
              a '-' before the codec name to omit it.

              NOTE:
              See -ac help for a full list of available codecs.
              If the list has a trailing ',' it will fallback  to
              codecs not listed.

              EXAMPLE:
                 -ac mp3acm          force l3codeca.acm MP3 codec
                 -ac mad,            try libmad first, then fall-
                                     back to others
                 -ac hwac3,a52,      try       hardware       AC3
                                     passthrough,  then  software
                                     AC3 codec, then others
                 -ac -ffmp3,         try other codecs except FFm-
                                     peg's MP3 decoder

       -afm <driver1,driver2,...>
              Specify a priority list  of  audio  drivers  to  be
              used,   according   to   their   driver   name   in
              codecs.conf.  It falls back to default if  none  is
              ok.

              NOTE:
              See -afm help for a full list of available drivers.

              EXAMPLE:
                 -afm ffmpeg         try   FFmpeg's    libavcodec
                                     (mp1/2/3) codecs first
                 -afm acm,dshow      try Win32 codecs first

       -aspect <ratio>
              Override aspect ratio of movies.  It's autodetected
              on MPEG files, but can't be  autodetected  on  most
              AVI files.

              EXAMPLE:
                 -aspect 4:3  or -aspect 1.3333
                 -aspect 16:9 or -aspect 1.7777

       -flip
              Flip image upside-down.

       -lavdopts <option1:option2:...> (DEBUG CODE)
              If  decoding  with a codec from libavcodec, you can
              specify its parameters here.

              EXAMPLE:
                 -lavdopts bug=1

       NOTE:
       Just add the values of the things you want to enable.
       Available options are:

                 ec                  error concealment:
                                        1:  use  strong   deblock
                                        filter for damaged MBs
                                        2:  iterative  MV  search
                                        (slow)
                                        3: all (default)

                 er=<value>          error resilience:
                                        0: disabled
                                        1: careful  (should  work
                                        with broken encoders)
                                        2:    normal    (default)
                                        (works with compliant en-
                                        coders)
                                        3: agressive (more checks
                                        but might cause  problems
                                        even   for   valid   bit-
                                        streams)
                                        4: very agressive

                 bug=<value>         manually work around encoder
                                     bugs:
                                        0: nothing
                                        1:  autodetect  bugs (de-
                                        fault)
                                        2 (msmpeg4v3):  some  old
                                        lavc  generated msmpeg4v3
                                        files (no autodetect)
                                        4 (mpeg4): xvid interlac-
                                        ing  bug (autodetected if
                                        fourcc==XVIX)
                                        8 (mpeg4): UMP4  (autode-
                                        tected if fourcc==UMP4)
                                        16 (mpeg4): padding bug
                                        32  (mpeg4):  illegal vlc
                                        bug   (autodetected   per
                                        fourcc)

                 gray                grayscale  only  decoding (a
                                     bit faster than with color)

       -noaspect
              Disable automatic movie aspect ratio  compensation.

       -nosound
              Do not play/encode sound.

       -vop pp=<option1/option2/...>
              This  option  enables  usage  of MPlayer's internal
              postprocessing filter, and also gives an  interface
              where you can pass options to the named filter.

              Note  that each sub-filter must be separated with a
              / sign.
              Each filter defaults to 'c' (chrominance).
              The keywords accept a '-' prefix to disable the op-
              tion.
              A  ':'  followed by a letter may be appended to the
              option to indicate its scope:
                 a: Automatically switches the filter off if  the
                 CPU is too slow.
                 c: Do chrominance filtering, too.
                 y:  Do  not do chrominance filtering (only lumi-
                 nance filtering).

              EXAMPLE:
                 -vop pp=hb/vb/dr/al/lb
                 -vop pp=hb/vb/dr/al
                 -vop pp=de/-al      default   filters    without
                                     brightness/contrast  correc-
                                     tion
                 -vop pp=de/tn:1:2:3 Enable  default  filters   &
                                     temporal denoiser.
                 -vop pp=hb:y/vb:a -autoq 6
                                     Deblock  horizontal only lu-
                                     minance and switch  vertical
                                     deblocking  on  or off auto-
                                     matically    depending    on
                                     available CPU time.

       -pp <quality> (see -vop pp option too)
              Set postprocess level of the DLL. This option is NO
              LONGER USABLE with  MPlayer's  postprocess  filter,
              but  only with Win32 DirectShow DLLs which have in-
              teral postprocessing routine.

              The valid range of -pp value vary on codecs, mostly
              0-6, where 0=disable 6=slowest/best.


       -ssf <mode>
              Specifies SwScaler parameters.

              EXAMPLE
                 -vop scale -ssf lgb=3.0

                 lgb=<0-100>         Gaussian blur filter (luma)
                 cgb=<0-100>         Gaussian  blur filter (chro-
                                     ma)
                 ls=<0-100>          sharpen filter (luma)
                 cs=<0-100>          sharpen filter (chroma)
                 chs=<h>             chroma horizontal shifting
                 cvs=<v>             chroma vertical shifting

       -stereo <mode>
              Select type of MP2/MP3 stereo output.

                 0                   Stereo
                 1                   Left channel
                 2                   Right channel

       -sws <software scaler type> (see -vop scale option too)
              This option sets the quality  (and  speed,  respec-
              tively)  of the software scaler, with the -zoom op-
              tion.  For example with x11 or other outputs  which
              lack hardware acceleration.  Possible settings are:

              NOTE:
              For -sws 2 and 7, the sharpness can be set with the
              scaling parameter (p) of -vop scale (0 (soft) - 100
              (sharp)), for  -sws  9,  it  specifies  the  filter
              length (1 - 10).

                 0                   fast bilinear (default)
                 1                   bilinear
                 2                   bicubic (good quality)
                 3                   experimental
                 4                   nearest neighbour (bad qual-
                                     ity)
                 5                   area
                 6                   luma bicubic / chroma bilin-
                                     ear
                 7                   gauss
                 8                   sincR
                 9                   lanczos
                 10                  bicubic spline

       -vc <[-]codec1,[-]codec2,...[,]>
              Specify a priority list of video codecs to be used,
              according to their codec name in codecs.conf.   Use
              a '-' before the codec name to omit it.

              NOTE:
              See -vc help for a full list of available codecs.
              If  the list has a trailing ',' it will fallback to
              codecs not listed.

              EXAMPLE:
                 -vc divx            force Win32/VFW DivX  codec,
                                     no fallback
                 -vc divx4,          try  divx4linux codec first,
                                     then fallback to others
                 -vc -divxds,-divx,  try  other   codecs   except
                                     Win32 DivX codecs
                 -vc ffmpeg12,mpeg12,
                                     try   libavcodec's   MPEG1/2
                                     codec, then  libmpeg2,  then
                                     others

       -vfm <driver1,driver2,...>
              Specify  a  priority  list  of  video drivers to be
              used,   according   to   their   driver   name   in
              codecs.conf.   It  falls back to default if none is
              ok.

              NOTE:
              If libdivxdecore support was compiled in, then odi-
              vx  and  divx4  now  contains  just  the same DivX4
              codec, but different APIs to reach it.  For differ-
              ence  between them and when to use which, check the
              DivX4 section in the documentation.
              See -vfm help for a full list of available drivers.

              EXAMPLE:
                 -vfm ffmpeg,dshow,vfw
                                     try the libavcodec, then Di-
                                     rectshow,  then  VFW  codecs
                                     and  fallback to the others,
                                     if still none is ok
                 -vfm xanim          try XAnim codecs first

       -vop <...,filter3[=options],filter2,filter1>
              Activate a comma separated list  of  video  filters
              and their options in reverse order.

              NOTE:
              The parameters are optional and if omitted, some of
              them are set to default values.  Use -1 to keep the
              default value.  Parameters w:h means width x height
              in pixels, x:y means x;y position counted from  the
              upper left corner of the bigger image.
              To  get  a full list of available plugins, see -vop
              help.
              Available filters are:

                 crop[=w:h:x:y]      Crops the given part of  the
                                     image and discards the rest.
                                     Useful to remove black bands
                                     from widescreen movies.

                 rectangle[=w:h:x:y] Draws a rectangle of the re-
                                     quested width and height  at
                                     the   specified  coordinates
                                     over the image (used to test
                                     crop).  (default: maximum w/
                                     h, upper left x/y position)

                 expand[=w:h:x:y:o]  Expands (not  scales)  movie
                                     resolution to the given val-
                                     ue and places  the  unscaled
                                     original at coordinates x y.
                                     Can be used for placing sub-
                                     titles/OSD  in the resulting
                                     black bands (default: origi-
                                     nal w/h, centered x/y).  The
                                     last parameter (de)activates
                                     OSD  rendering (default: 0).

                 flip                Flips the image upside down.
                                     See also option -flip.

                 mirror              Flips the image on Y axis.

                 rotate[=<0-7>]      Rotates and flips (optional)
                                     the image  +/-  90  degrees.
                                     For  parameters  between 4-7
                                     rotation is only done if the
                                     movie's geometry is portrait
                                     and not landscape.

                 scale[=w:h[:c[:p]]] Scales the  image  with  the
                                     software  scaler  (slow) and
                                     performs  a  YUV<->RGB  col-
                                     orspace conversion (see -sws
                                     option too).  The value 0 is
                                     used   for  scaled  (aspect)
                                     destination w/h.   (default:
                                     original w/h, destination w/
                                     h  with   -zoom)   Optionaly
                                     chroma skipping (c from 0-3)
                                     and scaling  parameters  can
                                     be specified.  (see the -sws
                                     option for details)

                 yuy2                Forces software YV12/I420 or
                                     422P to YUY2 conversion.

                 rgb2bgr[=swap]      RGB 24/32 <-> BGR 24/32 col-
                                     orspace conversion with  op-
                                     tional R <-> B swapping.

                 palette             RGB/BGR  8 -> 15/16/24/32bpp
                                     colorspace conversion  using
                                     palette.

                 format[=fourcc]     Restricts the colorspace for
                                     next filter.  It does not do
                                     any conversion.  Use togeth-
                                     er with the scale filter for
                                     a real conversion.

                 pp[=flags]          Activates the external post-
                                     processing   filter.    (see
                                     -vop pp option for details)

                 lavc[=quality:fps]  Realtime  MPEG1  encoder for
                                     use  with  DVB/DXR3  (libav-
                                     codec)

                 fame                Realtime  MPEG1  encoder for
                                     use with DVB/DXR3 (libfame)

                 dvbscale[=aspect]   Set up optimal  scaling  for
                                     DVB    cards.    (aspect   =
                                     DVB_HEIGHT*ASPECTRATIO,  de-
                                     fault: 768)

                 cropdetect[=0-255]  Calculates  necessary  crop-
                                     ping parameters  and  prints
                                     the  recommended  parameters
                                     to  stdout.   The  threshold
                                     can  be optionally specified
                                     from nothing (0)  to  every-
                                     thing (255).  (default: 24)

                 noise[=luma[u][t|a][h][p]:chroma[u][t|a][h][p]]
                                     Adds noise
                                        <0-100>: luma noise
                                        <0-100>: chroma noise
                                        u: uniform noise
                                        t: temporal noise
                                        a:    averaged   temporal
                                        noise
                                        h: high quality
                                        p: mix with pattern

                 eq[=bright:cont]    Activates    the    software
                                     equalizer  with  interactive
                                     controls like  the  hardware
                                     eq controls.  The values can
                                     be from -100 to 100.

                 halfpack            Convert planar YUV 4:2:0  to
                                     half-height   packed  4:2:2,
                                     downsampling luma but  keep-
                                     ing   all   chroma  samples.
                                     Useful for  output  to  low-
                                     resolution  display  devices
                                     when hardware downscaling is
                                     poor   quality   or  is  not
                                     available.

                 dint[=sense:level]  Detects and drops  first  of
                                     interlaced  frames  in video
                                     stream.  Values can be  from
                                     0.0  to 1.0 - first (default
                                     0.1) is relative  difference
                                     between   neighbor   pixels,
                                     second  (default  0.15)   is
                                     what  part  of image have to
                                     be detected as interlaced to
                                     drop the frame.

                 unsharp=l|cWxH:amount[:l|cWxH:amount]
                                     Unsharp   mask   /  gaussian
                                     blur.
                                        l: apply effect  on  luma
                                        component
                                        c: apply effect on chroma
                                        components
                                        WxH: width and height  of
                                        the  matrix, odd sized in
                                        both  directions  (min  =
                                        3x3,   max   =  13x11  or
                                        11x13, usually  something
                                        between 3x3 and 7x7)
                                        amount:  relative  amount
                                        of sharpness  /  blur  to
                                        add  to the image (amount
                                        < 0 = blur, amount > 0  =
                                        sharpen,   usually  some-
                                        thing  between  -1.5  and
                                        1.5)

                 swapuv              Swap U & V plane.

                 il=[d|i][s][:[d|i][s]]
                                     (de)interleaves lines.
                                        d: deinterleave
                                        i: interleave
                                        s:  swap fields (exchange
                                        even & odd lines)

                 boxblur=radius:power[:radius:power]
                                        radius: size of the  fil-
                                        ter
                                        power: how often the fil-
                                        ter should be applied



                 !!! .IPs 1bpp !!! .IPs 2xsai !!!  .IPs  eq2  !!!
                 .IPs yvu9 !!! more (IMHO all of -vop help should
                 be documented), !!!  especially  bmovl  (see  .c
                 file), add vo/test?




       -x <x> (MPLAYER only)
              Scale  image  to  x  width (if sw/hw scaling avail-
              able).  Disables aspect calculations.

       -xvidopts <option1:option2:...>
              Specify additional parameters  when  decoding  with
              XviD.

                 dr2                 Activate   direct  rendering
                                     method 2.
                 nodr2               Deactivate direct  rendering
                                     method 2.

       -xy <x>
                 x<=8                Scale image by factor <x>.
                 x>8                 Set  width to <x> and calcu-
                                     late height to keep  correct
                                     aspect ratio.

       -y <y> (MPLAYER only)
              Scale  image  to  y height (if sw/hw scaling avail-
              able).  Disables aspect calculations.

       -zoom
              Allow software scaling, where available.  Could  be
              used to force scaling with -vop scale.

              NOTE:
              -vop  scale will IGNORE options -x / -y / -xy / -fs
              / -aspect without -zoom.



ENCODING OPTIONS (MENCODER ONLY)
       -audio-density <1-50>
              Number of audio chunks per second (default is 2 for
              0.5s long audio chunks).

              NOTE:
              CBR  only,  VBR ignores this as it puts each packet
              in a new chunk.

       -audio-delay <0.0-...>
              Sets the audio delay field in the header.   Default
              is 0.0, negative values do not work.  This does not
              delay the audio while encoding, but the player will
              see the default audio delay, sparing you the use of
              the -delay option.

       -audio-preload <0.0-2.0>
              Sets up audio  buffering  time  interval  (default:
              0.5s).

       -divx4opts <option1:option2:...>
              If  encoding  to DivX4, you can specify its parame-
              ters here.
              Available options are:

                 help                get help

                 br=<value>          specify bitrate in
                                        kbit <4-16000> or
                                        bit  <16001-24000000>

                 key=<value>         maximum  keyframe   interval
                                     (in frames)

                 deinterlace         enable  deinterlacing (avoid
                                     it, DivX4 is buggy)

                 q=<1-5>             quality (1-fastest, 5-best)

                 min_quant=<1-31>    minimum quantizer

                 max_quant=<1-31>    maximum quantizer

                 rc_period=<value>   rate control period

                 rc_reaction_period=<value>
                                     rate control reaction period

                 rc_reaction_ratio=<value>
                                     rate control reaction ratio

                 crispness=<0-100>   specify crispness/smoothness

                 pass=<1-2>          With  this  you  can  encode
                                     2pass  DivX4  files.   First
                                     encode  with  pass=1,   then
                                     with  the  same  parameters,
                                     encode with pass=2.

                 vbrpass=<0-2>       Override the  pass  argument
                                     and use XviD VBR Library in-
                                     stead of DivX4 VBR.   Avail-
                                     able options are:
                                        0:  one pass encoding (as
                                        in not  putting  pass  on
                                        the command line)
                                        1:  Analysis (first) pass
                                        of  two  pass   encoding.
                                        The  resulting  AVI  file
                                        can   be   directed    to
                                        /dev/null.
                                        2: Final (second) pass of
                                        two pass encoding.

       -endpos <[[hh:]mm:]ss[.ms]|size[b|kb|mb]> (see -ss and -sb
       option too)
              Stop encoding at given time or byte position.   Can
              be specified in many ways:

              NOTE:
              Byte  position  won't  be  accurate, as it can only
              stop at a frame boundary.

              EXAMPLE:
                 -endpos 56          encode only 56 seconds
                 -endpos 01:10:00    encode only 1 hour  10  min-
                                     utes
                 -endpos 100mb       encode only 100 MBytes

       -ffourcc <fourcc>
              Can  be  used  to  override the video fourcc of the
              output file.

              EXAMPLE:
                 -ffourcc div3       will have  the  output  file
                                     contain   'div3'   as  video
                                     fourcc.

       -include <configuration file>
              Specify configuration file to be parsed  after  the
              default

       -info <option1:option2:...> (.AVI only)
              Specify the info header of the resulting .AVI file.
              Available options are:

                 help                show this description

                 name=<value>        title of the subject of  the
                                     file

                 artist=<value>      artist   or  author  of  the
                                     original subject of the file

                 genre=<value>       original work category

                 subject=<value>     contents of the file

                 copyright=<value>   copyright   information  for
                                     the file

                 srcform=<value>     original form of the materi-
                                     al that was digitized

                 comment=<value>     general  comments  about the
                                     file or the subject  of  the
                                     file

       -lameopts <option1:option2:...>
              If encoding to MP3 with libmp3lame, you can specify
              its parameters here.
              Available options are:

                 help                get help

                 vbr=<0-4>           variable bitrate method
                                        0: cbr
                                        1: mt
                                        2: rh(default)
                                        3: abr
                                        4: mtrh

                 abr                 average bitrate

                 cbr                 constant bitrate

                 br=<0-1024>         specify bitrate in kBit (CBR
                                     and ABR only)

                 q=<0-9>             quality  (0-highest,  9-low-
                                     est) (only for VBR)

                 aq=<0-9>            algorithmic quality (0-best/
                                     slowest, 9-worst/fastest)

                 ratio=<1-100>       compression ratio

                 vol=<0-10>          set audio input gain

                 mode=<0-3>          (default: auto)
                                        0: stereo
                                        1: joint-stereo
                                        2: dualchannel
                                        3: mono

                 padding=<0-2>
                                        0: no
                                        1: all
                                        2: adjust

       -lavcopts <option1:option2:...>
              If  encoding  with a codec from libavcodec, you can
              specify its parameters here.

              EXAMPLE:
                 -lavcopts                    vcodec=msmpeg4:vbi-
                 trate=1800:vhq:keyint=250

              Available options are:

                 vcodec=<value>      use   the   specified  codec
                                     (there is  no  default,  you
                                     must specify it):
                                        mjpeg: Motion JPEG
                                        h263: H263
                                        h263p: H263 Plus
                                        mpeg4: DivX 4/5
                                        msmpeg4: DivX 3
                                        rv10:  an  old  RealVideo
                                        codec
                                        mpeg1video:  MPEG1  video
                                        :)

                 vqmin=<2-31>        minimum quantizer (pass 1/2)
                                     (default: 3)

                 vqscale=<2-31>      constant quantizer  (selects
                                     fixed  quantizer  mode) (de-
                                     fault: 0 (disabled))

                 vqmax=<1-31>        maximum quantizer (pass 1/2)
                                     (default: 15)

                 vqdiff=<1-31>       maximum quantizer difference
                                     between  I   or   P   frames
                                     (pass 1/2) (default: 3)

                 vmax_b_frames=<0-4> maximum  number  of B frames
                                     between non B frames:
                                        0: no B frames (default)
                                        0-2: sane range

                 vme=<0-5>           motion estimation method:
                                        0: none (very lq)
                                        1: full (slow)
                                        2: log (lq)
                                        3: phods (lq)
                                        4: EPZS (default)
                                        5: X1

                 vhq                 high  quality  mode,  encode
                                     each   macro  block  in  all
                                     modes an choose the smallest
                                     (slow).   (default:  HQ dis-
                                     abled)

                 v4mv                4 motion  vectors  per  mac-
                                     roblock   (slightly   better
                                     quality),  cannot  be   used
                                     with  B  frames.   (default:
                                     disabled)

                 keyint=<0-300>      interval  between  keyframes
                                     in  frames.   Larger numbers
                                     mean slightly smaller files,
                                     but  less precise seeking, 0
                                     means no key frames and val-
                                     ues >300 aren't recommended.
                                     For a strict mpeg1/2/4  com-
                                     pliance  this  would have to
                                     be <=132.  (default: 250  or
                                     one key frame every ten sec-
                                     onds in a 25fps movie)

                 vb_strategy=<0-1>   strategy to  choose  between
                                     I/P/B frames (pass 2):
                                        0: always use the maximum
                                        number of B  frames  (de-
                                        fault)
                                        1: avoid B frames in high
                                        motion  scenes   (bitrate
                                        mispredictions)

                 vpass=<1-2>         Activates   internal   2pass
                                     mode (default: disabled):
                                        1: first pass
                                        2: second pass

                 aspect=<x.x/y.y>    Store movie aspect internal-
                                     ly,  just  like  MPEG files.
                                     Much  nicer  solution   than
                                     rescaling,  because  quality
                                     isn't decreased. Only MPlay-
                                     er  will  play  these  files
                                     back correctly, other  play-
                                     ers  will  display them with
                                     wrong aspect. Example:
                                        aspect=16.0/9.0

                 vbitrate=<value>    specify  bitrate  (pass 1/2)
                                     in
                                        kBit <4-16000> or
                                        Bit  <16001-24000000>
                                        (warning:  1kBit  =  1000
                                        Bits)
                                        (default: 800)

                 vratetol=<value>    approximated filesize toler-
                                     ance   in  kbit.   (warning:
                                     1kBit = 1000 Bits) (default:
                                     8000)

                 vrc_maxrate=<value> maximum  bitrate in kbit/sec
                                     (pass 1/2)

                 vrc_minrate=<value> minimum bitrate in  kbit/sec
                                     (pass 1/2)

                 vrc_buf_size=<value>
                                     buffer size in kbit (pass 1/
                                     2).  Note:  vratetol  should
                                     not  be too large during the
                                     second pass or  there  might
                                     be        problems        if
                                     vrc_(min|max)rate is used.

                 vb_qfactor=<-31.0-31.0>
                                     quantizer factor  between  B
                                     and  non B frames (pass 1/2)
                                     (default: 1.25)

                 vi_qfactor=<-31.0-31.0>
                                     (pass 1/2) (default: 0.8)

                 vb_qoffset=<-31.0-31.0>
                                     quantizer offset  between  B
                                     and  non B frames (pass 1/2)
                                     (default: 1.25)

                 vi_qoffset=<-31.0-31.0>
                                     (pass 1/2) (default: 0.0)
                                     if v{b|i}_qfactor > 0
                                     I/B-Frame  quantizer  =   P-
                                     Frame       quantizer      *
                                     v{b|i}_qfactor             +
                                     v{b|i}_qoffset
                                     else
                                     do  normal ratecontrol (dont
                                     lock to next P  frame  quan-
                                     tizer)   and  set  q=  -q  *
                                     v{b|i}_qfactor             +
                                     v{b|i}_qoffset

                 vqblur=<0.0-1.0>    quantizer blur (pass1):
                                        0.0: qblur disabled
                                        0.5 (default)
                                        1.0: average the quantiz-
                                        er  over   all   previous
                                        frames,   larger   values
                                        will
                                         average  the   quantizer
                                        more  over  time  (slower
                                        change)

                 vqblur=<0.0-99.0>   quantizer   gaussian   blur,
                                     larger  values  will average
                                     the quantizer more over time
                                     (slower change) (pass2) (de-
                                     fault: 0.5)

                 vqcomp=<value>      quantizer  compression,  de-
                                     pends upon vrc_eq (pass 1/2)
                                     (default: 0.5)

                 vrc_eq=<equation>   main  ratecontrol   equation
                                     (pass 1/2):

                                     1: constant bitrate
                                     tex: constant quality
                                     1+(tex/avgTex-1)*qComp:  ap-
                                     proximately the equation  of
                                     the old ratecontrol code
                                     tex^qComp: with qcomp 0.5 or
                                     something  like  that   (de-
                                     fault)

                                     infix operators: +,-,*,/,^

                                     variables:
                                     tex:                 texture
                                     complexity
                                     iTex,pTex:       intra,  non
                                     intra texture complexity
                                     avgTex:              average
                                     texture complexity
                                     avgIITexaverage: intra  tex-
                                     ture complexity in I frames
                                     avgPITexaverage:  intra tex-
                                     ture complexity in P frames
                                     avgPPTexaverage:  non  intra
                                     texture   complexity   in  P
                                     frames
                                     avgBPTexaverage:  non  intra
                                     texture   complexity   in  B
                                     frames
                                     mv:               bits  used
                                     for MVs
                                     fCode:               maximum
                                     length of MV in log2 scale
                                     iCount:           number  of
                                     intra MBs / number of MBs
                                     var:                 spatial
                                     complexity
                                     mcVar:              temporal
                                     complexity
                                     qComp:            qcomp from
                                     the command line
                                     isI, isP,  isB:    is  1  if
                                     picture type is I/P/B else 0
                                     Pi,E:             see   your
                                     favorite math book

                                     functions:
                                     max(a,b),min(a,b): maximum /
                                     minimum
                                     gt(a,b): is 1 if a>b, 0 oth-
                                     erwise
                                     lt(a,b): is 1 if a<b, 0 oth-
                                     erwise
                                     eq(a,b): is 1 if a==b,0 oth-
                                     erwise
                                     sin,  cos,  tan, sinh, cosh,
                                     tanh, exp, log, abs

                 vrc_override=<options>
                                     User specified  quality  for
                                     specific  parts  (pass 1/2).
                                     The  options   are   <start-
                                     frame,  end-frame, quality[/
                                     start-frame,      end-frame,
                                     quality[/...]]>:
                                        quality 2-31: quantizer
                                        quality  -500-0:  quality
                                        correcture in %

                 vrc_init_cplx=<0-1000>
                                     initial complexity (pass 1)

                 vqsquish=<0-1>      specify  how  to  keep   the
                                     quantizer  between  qmin and
                                     qmax (pass 1/2):
                                        0: use cliping
                                        1: use a  nice  differen-
                                        tiable function (default)

                 vlelim=<-1000-1000> single coefficient  elimina-
                                     tion   threshold  for  lumi-
                                     nance.  Negative values will
                                     also consider the dc coeffi-
                                     cient (should be at least -4
                                     or  lower  for  encoding  at
                                     quant=1):
                                        0: disabled (default)
                                        -4 (JVT recommendation)

                 vcelim=<-1000-1000> single coefficient  elimina-
                                     tion  threshold  for chromi-
                                     nance.  Negative values will
                                     also consider the dc coeffi-
                                     cient (should be at least -4
                                     or  lower  for  encoding  at
                                     quant=1):
                                        0 disabled (default)
                                        7 (JVT recommendation)

                 vstrict             strict standard  compliance.
                                     Only recommended if you want
                                     to feed the output into  the
                                     mpeg4 reference decoder.

                 vdpart              data  partitioning.   Adds 2
                                     byte per video  packet,  im-
                                     proves error-resistance when
                                     transfering over  unreliable
                                     channels (eg. streaming over
                                     the internet)

                 vpsize=<0-10000>    video packet size,  improves
                                     error-resistance  (see  -vd-
                                     part option too):
                                        0: disabled (default)
                                        100-1000: good choice

                 gray                grayscale   only    encoding
                                     (faster) (default: disabled)

                 vfdct=<0-99>        dct algorithm:
                                        0: automatically select a
                                        good one (default)
                                        1: fast integer
                                        2: accurate integer
                                        3: mmx
                                        4: mlib

                 idct=<0-99>         idct  algorithm.   Note: all
                                     these  IDCTs  do  pass   the
                                     IEEE1180 tests afaik:
                                        0: automatically select a
                                        good one (default)
                                        1: jpeg reference integer
                                        2: simple
                                        3: simplemmx
                                        4:  libmpeg2mmx  (inaccu-
                                        rate, DONT USE for encod-
                                        ing with keyint >100)
                                        5: ps2
                                        6: mlib
                                        7: arm

                 lumi_mask=<0.0-1.0> luminance masking.  Warning:
                                     be careful, too large values
                                     can     cause    disasterous
                                     things.    Warning2:   large
                                     values  might  look  good on
                                     some monitors but  may  look
                                     horrible on other monitors:
                                        0.0: disabled (default)
                                        0.0-0.3: sane range

                 dark_mask=<0.0-1.0> darkness  masking.  Warning:
                                     be careful, too large values
                                     can     cause    disasterous
                                     things.    Warning2:   large
                                     values  might  look  good on
                                     some monitors but  may  look
                                     horrible on other monitors /
                                     TV / TFT:
                                        0.0: disabled (default)
                                        0.0-0.3: sane range

                 tcplx_mask=<0.0-1.0>
                                     temporal complexity  masking
                                     (default: 0.0 (disabled))

                 scplx_mask=<0.0-1.0>
                                     spatial  complexity masking.
                                     Larger values  help  against
                                     blockiness, if no deblocking
                                     filter is used for decoding.
                                     Crop  any  black  borders to
                                     get better quality:
                                        0.0: disabled (default)
                                        0.0-0.5: sane range

                 naq                 normalize adaptive quantiza-
                                     tion (experimental)

                 ildct               use interlaced dct

                 mpeg_quant          use  MPEG quantizers instead
                                     of  H.263.   (default:  dis-
                                     abled) (i.e. use H.263 quan-
                                     tizers)

       -noskip
              Do not skip frames.

       -o <filename>
              Outputs to the given filename, instead of  the  de-
              fault 'test.avi'.

       -oac <codec name>
              Encode  with the given codec.  Use -ovc help to get
              a list of available codecs.  (no default set)

              EXAMPLE:
                 -oac copy           no encoding, just streamcopy
                 -oac pcm            encode to uncompressed PCM
                 -oac mp3lame        encode to MP3 (using Lame)

       -ofps <fps>
              The  output file will have different frame/sec than
              the source.  You MUST set it for variable fps (asf,
              some mov) and progressive (29.97fps telecined mpeg)
              files.

       -ovc <codec name>
              Encode with the given codec.  Use -ovc help to  get
              a list of available codecs.  (no default set)

              EXAMPLE:
                 -ovc copy           no encoding, just streamcopy
                 -ovc divx4          encode to DivX4/DivX5
                 -ovc rawrgb         encode to uncompressed RGB24
                 -ovc lavc           encode   with  a  libavcodec
                                     codecs

       -passlogfile <filename>
              When encoding in 2pass mode, MEncoder  dumps  first
              pass' informations to the given file instead of the
              default divx2pass.log.

       -skiplimit <value>
              Maximal  skipable  frames  after  non-skipped   one
              (-noskiplimit for unlimited number).

       -v, --verbose
              Enable  verbose output (more -v means more verbosi-
              ty).

       -vobsubout <basename>
              Specify the basename for the output .idx  and  .sub
              files.   This  turns  off subtitle rendering in the
              encoded movie and diverts  it  to  Vobsub  subtitle
              files.

       -vobsuboutindex <index>
              Specify  the  index  of the subtitles in the output
              files.  (default: 0)

       -vobsuboutid <langid>
              Specify the language two letter code for the subti-
              tles.   This overrides what is read from the DVD or
              the .ifo file.

       -xvidencopts <option1:option2:...>
              If encoding to XviD, you can specify its parameters
              here.
              There's  three  modes  available : constant bitrate
              (CBR), fixed quantizer and 2pass.
              Available options are:

                 pass=<1|2>          specify the  pass  in  2pass
                                     mode

                 quality=<0-6>       specify the encoding quality
                                     (default=6)

                 br=<value>          sets the bitrate to be  used
                                     in kbits/second if <16000 or
                                     in  bits/second  if   >16000
                                     (CBR   or  2pass  mode,  de-
                                     fault=687 kbits/s)

                 rc_reaction_delay_factor=<value>
                                     specify how  fast  the  rate
                                     control reacts, lower values
                                     are faster

                 rc_averaging_period=<value>
                                     period to reach the required
                                     average

                 rc_buffer=<value>   size  of  the  rate  control
                                     buffer

                 quant_range=<1-31>-<1-31>[/<1-31>-<1-31>]
                                     min & max quantizer for  all
                                     frames   (default=2-31,  CBR
                                     mode)
                                     min & max quantizer for  I/P
                                     frames   (default=2-31/2-31,
                                     2pass mode)

                 min_key_interval=<value>
                                     minimum interval between key
                                     frames (default=0, 2pass on-
                                     ly)

                 max_key_interval=<value>
                                     maximum interval between key
                                     frames (default=10*fps)

                 mpeg_quant          use  MPEG quantizers instead
                                     of H.263 (default=off)

                 mod_quant           decide whether to  use  MPEG
                                     or  H.263  quantizers  on  a
                                     frame-by-frame  basis.  (de-
                                     fault=off, 2pass mode only)

                 lumi_mask           use  a lumimasking algorithm
                                     (default=off, seems buggy)

                 hintedme            save Motion Estimation  vec-
                                     tors  to  a  file during the
                                     first pass  and  reuse  this
                                     file  during the second (de-
                                     fault=off, 2pass mode  only,
                                     seems buggy)

                 hintfile            specify  the  temporary file
                                     to be used by the 'hintedme'
                                     option             (default=
                                     ./xvid_hint_me.dat,    2pass
                                     mode only)

                 debug               save per-frame statistics in
                                     xvid.dbg (default=off)
                                     this is *not* the 2pass con-
                                     trol file

                 keyframe_boost=<0-1000>
                                     (default=0, 2pass mode only)

                 kfthreshold=<value> (default=10, 2pass mode  on-
                                     ly)

                 kfreduction=<0-100> (default=30,  2pass mode on-
                                     ly)

                 fixed_quant=<1-31>  switch  to  fixed  quantizer
                                     mode  and  specify the quan-
                                     tizer to be used



KEYBOARD CONTROL
       NOTE:
       MPlayer has a fully configurable, command driven,  control
       layer  which  allow you to control MPlayer using keyboard,
       mouse, joystick or remote control (using lirc).
       The default configuration file for  the  input  system  is
       ~/.mplayer/input.conf  but  it  can be overriden using the
       -input conf option.
       These keys may/may not work, depending on your video  out-
       put driver.

       general control
                 <- and ->           seek   backward/forward   10
                                     seconds
                 up and down         seek   backward/forward    1
                                     minute
                 pgup and pgdown     seek   backward/forward   10
                                     minutes
                 < and >             backward/forward in playlist
                 HOME and END        go to next/previous playtree
                                     entry in the parent list
                 INS and DEL         go to next/previous alterna-
                                     tive  source  (asx  playlist
                                     only)
                 p / SPACE           pause movie (any key unpaus-
                                     es)
                 q / ESC             stop playing and quit
                 + and -             adjust  audio  delay  by +/-
                                     0.1 second
                 / and *             decrease/increase volume
                 9 and 0             decrease/increase volume
                 m                   mute sound
                 f                   toggle fullscreen
                 w and e             decrease/increase    panscan
                                     range
                 o                   toggle  between  OSD states:
                                     none / seek / seek+timer
                 d                   toggle frame dropping
                 v                   toggle subtitle visibility
                 j                   switch subtitle language
                 z and x             adjust subtitle delay by +/-
                                     0.1 second
                 r and t             adjust subtitle position

                 (The  following  keys  are valid only when using
                 -vo xv or -vo [vesa|fbdev]:vidix or  -vo  xvidix
                 -vo (x)mga or -vc divxds (slow).)

                 1 and 2             adjust contrast
                 3 and 4             adjust brightness
                 5 and 6             adjust hue
                 7 and 8             adjust saturation

       GUI keyboard control
                 ENTER               start playing
                 s                   stop playing
                 a                   about
                 l                   load file
                 c                   skin browser
                 p                   toggle playlist

       TV input control
                 h and k             select previous/next channel
                 n                   change norm
                 u                   change channel list

       DVDNAV input control
                 K,J,H,L             browse up/down/left/right
                 M                   jump to main menu
                 S                   select



SLAVE MODE PROTOCOL
       If the -slave switch is given, playback is controlled by a
       line-based  protocol.   Each line must contain one command
       otherwise one of the following tokens:

       Commands

                 seek <value> [type=<0/1/2>]
                                     Seek to some  place  in  the
                                     movie.  Type 0 is a relative
                                     seek of +/- <value> seconds.
                                     Type  1 seek to <value> % in
                                     the movie.  Type 2 is a seek
                                     to  an  absolute position of
                                     <value> seconds.

                 audio_delay <value> Adjust the  audio  delay  of
                                     value seconds

                 quit                Quit MPlayer

                 pause               Pause/unpause the playback

                 grap_frames         Somebody know ?

                 pt_step <value> [force=<value>]
                                     Go to next/previous entry in
                                     the playtree.

                 pt_up_step <value> [force=<value>]
                                     Like pt_step but it jumps to
                                     next/previous  in the parent
                                     list.

                 alt_src_step <value>
                                     When more than one source is
                                     available   it  selects  the
                                     next/previous one (only sup-
                                     ported by asx playlist).

                 sub_delay <value> [abs=<value>]
                                     Adjust  the  subtitles delay
                                     of +/-  <value>  seconds  or
                                     set  it  to  <value> seconds
                                     when abs is non zero.

                 osd [level=<value>] Toggle osd mode or set it to
                                     level when level > 0.

                 volume <dir>        Increase/decrease volume

                 [contrast|brightness|hue|saturation]   <-100   -
                 100> [abs=<value>]
                                     Set/Adjust video parameters.

                 frame_drop [type=<value>]
                                     Toggle/Set  frame   dropping
                                     mode.

                 sub_visibility      Toggle  subtitle visibility.

                 sub_pos <value>     Adjust subtitles position.

                 vo_fullscreen       Switch to fullscreen mode.

                 tv_step_channel <dir>
                                     Select   next/previous    tv
                                     channel.

                 tv_step_norm        Change TV norm.

                 tv_step_chanlist    Change channel list.

                 gui_[loadsubtitle|about|play|stop]
                                     GUI actions



FILES
       /etc/mplayer/mplayer.conf
              system-wide settings

       ~/.mplayer/config
              user settings

       ~/.mplayer/input.conf
              input  bindings  (see  '-input  keylist'  for  full
              keylist)

       ~/.mplayer/gui.conf
              GUI configuration file

       ~/.mplayer/gui.pl
              GUI playlist

       ~/.mplayer/font/
              font directory (There must be a font.desc file  and
              files with .RAW extension.)

       ~/.mplayer/DVDkeys/
              cracked CSS keys
       Sub files
              are  searched  for  in  this  priority (for example
              /mnt/movie/movie.avi):
                 /mnt/cdrom/movie.sub
                 ~/.mplayer/sub/movie.sub
                 ~/.mplayer/default.sub



EXAMPLES
       Quickstart DVD playing
              mplayer -dvd 1

       Play in japanese with english subtitles
              mplayer -dvd 1 -alang ja -slang en

       Play only chapters 5, 6, 7
              mplayer -dvd 1 -chapter 5-7

       Multiangle DVD playing
              mplayer -dvd 1 -dvdangle 2

       Playing from a different DVD device
              mplayer -dvd 1 -dvd-device /dev/dvd2

       Old style DVD (VOB) playing
              mplayer   -dvdauth   /dev/dvd    /mnt/dvd/VIDEO_TS/
              VTS_02_4.VOB

       Stream from HTTP
              mplayer http://mplayer.hq/example.avi

       Stream using RTSP
              mplayer rtsp://server.example.com/streamName

       Convert subtitle to MPsub (to ./dump.mpsub)
              mplayer dummy.avi -sub source.sub -dumpmpsub

       Input from standard V4L
              mplayer                 -tv                on:driv-
              er=v4l:width=640:height=480:outfmt=i420 -vc rawi420
              -vo xv

       Encoding DVD title #2, only selected chapters
              mencoder  -dvd  2 -chapter 10-15 -o title2.avi -oac
              copy -ovc divx4

       Encoding DVD title #2, resizing to 640x480
              mencoder -dvd 2 -vop  scale=640:480  -o  title2.avi
              -oac copy -ovc divx4

       Encoding  DVD  title  #2, resizing to 512xHHH (keep aspect
       ratio)
              mencoder  -dvd  2  -vop  scale -zoom -xy 512 -o ti-
              tle2.avi -oac copy -ovc divx4

       The same, but with libavcodec family, MPEG4  (Divx5)  com-
       pression
              mencoder -dvd 2 -o title2.avi -ovc  lavc  -lavcopts
              vcodec=mpeg4:vhq:vbitrate=1800 -oac copy

       The same, but with libavcodec family, MJPEG compression
              mencoder  -dvd  2 -o titel2.avi -ovc lavc -lavcopts
              vcodec=mjpeg:vhq:vbitrate=1800 -oac copy

       Encoding all *.jpg files in the current dir
              mencoder \*.jpg -mf on:fps=25  -o  output.avi  -ovc
              divx4

       Encoding from tuner
              mencoder  -tv on:driver=v4l:width=640:height=480 -o
              tv.avi -ovc rawrgb

       Encoding from a pipe
              rar p test-SVCD.rar  |  mencoder  -ovc  divx4  -di-
              vx4opts br=800 -ofps 24 -- -

       Encoding multiple *.vob files
              cat *.vob | mencoder <options> -



BUGS
       Probably.   PLEASE,  double-check the documentation (espe-
       cially bugreports.html), the FAQ and the mail archive  be-
       fore!
       Send  your complete bug reports to the MPlayer-users mail-
       ing list at <mplayer-users@mplayerhq.hu>.   We  love  com-
       plete bug reports :)



AUTHORS
       Check documentation.

       MPlayer is (C) 2000-2002
              Arpad Gereoffy

       This man page is written and maintained by
              Gabucino
              Diego Biurrun
              Jonas Jermann

       Please  send  mails  about it to the MPlayer-users mailing
       list.



STANDARD DISCLAIMER
       Use only at your own risk!  There may be errors and  inac-
       curacies  that  could  be  damaging to your system or your
       eye.  Proceed with caution, and although  this  is  highly
       unlikely,  the  authors  don't take any responsibility for
       that!



                            2002-10-19                 MPlayer(1)
