/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.SerializationTester;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class DragSourceContext
implements DragSourceListener,
DragSourceMotionListener,
Serializable {
    private static final long serialVersionUID = -115407898692194719L;
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 1;
    protected static final int OVER = 2;
    protected static final int CHANGED = 3;
    private static Transferable emptyTransferable;
    private transient DragSourceContextPeer peer;
    private DragGestureEvent trigger;
    private Cursor cursor;
    private transient Transferable transferable;
    private transient DragSourceListener listener;
    private boolean useCustomCursor;
    private final int sourceActions;

    public DragSourceContext(DragSourceContextPeer dscp, DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point offset, Transferable t, DragSourceListener dsl) {
        if (dscp == null) {
            throw new NullPointerException("DragSourceContextPeer");
        }
        if (trigger == null) {
            throw new NullPointerException("Trigger");
        }
        if (trigger.getDragSource() == null) {
            throw new IllegalArgumentException("DragSource");
        }
        if (trigger.getComponent() == null) {
            throw new IllegalArgumentException("Component");
        }
        if (trigger.getSourceAsDragGestureRecognizer().getSourceActions() == 0) {
            throw new IllegalArgumentException("source actions");
        }
        if (trigger.getDragAction() == 0) {
            throw new IllegalArgumentException("no drag action");
        }
        if (t == null) {
            throw new NullPointerException("Transferable");
        }
        if (dragImage != null && offset == null) {
            throw new NullPointerException("offset");
        }
        this.peer = dscp;
        this.trigger = trigger;
        this.cursor = dragCursor;
        this.transferable = t;
        this.listener = dsl;
        this.sourceActions = trigger.getSourceAsDragGestureRecognizer().getSourceActions();
        this.useCustomCursor = dragCursor != null;
        this.updateCurrentCursor(trigger.getDragAction(), this.getSourceActions(), 0);
    }

    public DragSource getDragSource() {
        return this.trigger.getDragSource();
    }

    public Component getComponent() {
        return this.trigger.getComponent();
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        return this.sourceActions;
    }

    public synchronized void setCursor(Cursor c) {
        this.useCustomCursor = c != null;
        this.setCursorImpl(c);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public synchronized void addDragSourceListener(DragSourceListener dsl) throws TooManyListenersException {
        if (dsl == null) {
            return;
        }
        if (this.equals(dsl)) {
            throw new IllegalArgumentException("DragSourceContext may not be its own listener");
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = dsl;
    }

    public synchronized void removeDragSourceListener(DragSourceListener dsl) {
        if (this.listener == null || !this.listener.equals(dsl)) {
            throw new IllegalArgumentException();
        }
        this.listener = null;
    }

    public void transferablesFlavorsChanged() {
        if (this.peer != null) {
            this.peer.transferablesFlavorsChanged();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragEnter(dsde);
        }
        this.getDragSource().processDragEnter(dsde);
        this.updateCurrentCursor(this.getSourceActions(), dsde.getTargetActions(), 1);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragOver(dsde);
        }
        this.getDragSource().processDragOver(dsde);
        this.updateCurrentCursor(this.getSourceActions(), dsde.getTargetActions(), 2);
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragExit(dse);
        }
        this.getDragSource().processDragExit(dse);
        this.updateCurrentCursor(0, 0, 0);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dropActionChanged(dsde);
        }
        this.getDragSource().processDropActionChanged(dsde);
        this.updateCurrentCursor(this.getSourceActions(), dsde.getTargetActions(), 3);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragDropEnd(dsde);
        }
        this.getDragSource().processDragDropEnd(dsde);
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dsde) {
        this.getDragSource().processDragMouseMoved(dsde);
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected synchronized void updateCurrentCursor(int sourceAct, int targetAct, int status) {
        if (this.useCustomCursor) {
            return;
        }
        Cursor c = null;
        switch (status) {
            default: {
                targetAct = 0;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        int ra = sourceAct & targetAct;
        c = ra == 0 ? ((sourceAct & 0x40000000) == 0x40000000 ? DragSource.DefaultLinkNoDrop : ((sourceAct & 2) == 2 ? DragSource.DefaultMoveNoDrop : DragSource.DefaultCopyNoDrop)) : ((ra & 0x40000000) == 0x40000000 ? DragSource.DefaultLinkDrop : ((ra & 2) == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop));
        this.setCursorImpl(c);
    }

    private void setCursorImpl(Cursor c) {
        if (this.cursor == null || !this.cursor.equals(c)) {
            this.cursor = c;
            if (this.peer != null) {
                this.peer.setCursor(this.cursor);
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(SerializationTester.test(this.transferable) ? this.transferable : null);
        s.writeObject(SerializationTester.test(this.listener) ? this.listener : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.transferable = (Transferable)s.readObject();
        this.listener = (DragSourceListener)s.readObject();
        if (this.transferable == null) {
            if (emptyTransferable == null) {
                emptyTransferable = new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[0];
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return false;
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                        throw new UnsupportedFlavorException(flavor);
                    }
                };
            }
            this.transferable = emptyTransferable;
        }
    }
}

