"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspacePermissionMode = exports.WORKSPACE_USE_CASES = exports.WORKSPACE_UPDATE_APP_ID = exports.WORKSPACE_UI_SETTINGS_CLIENT_WRAPPER_ID = exports.WORKSPACE_SAVED_OBJECTS_CLIENT_WRAPPER_ID = exports.WORKSPACE_OVERVIEW_APP_ID = exports.WORKSPACE_LIST_APP_ID = exports.WORKSPACE_ID_CONSUMER_WRAPPER_ID = exports.WORKSPACE_FATAL_ERROR_APP_ID = exports.WORKSPACE_CREATE_APP_ID = exports.WORKSPACE_CONFLICT_CONTROL_SAVED_OBJECTS_CLIENT_WRAPPER_ID = exports.WORKSPACE_APP_CATEGORIES = exports.PRIORITY_FOR_WORKSPACE_UI_SETTINGS_WRAPPER = exports.PRIORITY_FOR_WORKSPACE_ID_CONSUMER_WRAPPER = exports.PRIORITY_FOR_WORKSPACE_CONFLICT_CONTROL_WRAPPER = exports.PRIORITY_FOR_PERMISSION_CONTROL_WRAPPER = exports.DEFAULT_SELECTED_FEATURES_IDS = void 0;
var _i18n = require("@osd/i18n");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const WORKSPACE_FATAL_ERROR_APP_ID = exports.WORKSPACE_FATAL_ERROR_APP_ID = 'workspace_fatal_error';
const WORKSPACE_CREATE_APP_ID = exports.WORKSPACE_CREATE_APP_ID = 'workspace_create';
const WORKSPACE_LIST_APP_ID = exports.WORKSPACE_LIST_APP_ID = 'workspace_list';
const WORKSPACE_UPDATE_APP_ID = exports.WORKSPACE_UPDATE_APP_ID = 'workspace_update';
const WORKSPACE_OVERVIEW_APP_ID = exports.WORKSPACE_OVERVIEW_APP_ID = 'workspace_overview';
/**
 * Since every workspace always have overview and update page, these features will be selected by default
 * and can't be changed in the workspace form feature selector
 */
const DEFAULT_SELECTED_FEATURES_IDS = exports.DEFAULT_SELECTED_FEATURES_IDS = [WORKSPACE_UPDATE_APP_ID, WORKSPACE_OVERVIEW_APP_ID];
const WORKSPACE_SAVED_OBJECTS_CLIENT_WRAPPER_ID = exports.WORKSPACE_SAVED_OBJECTS_CLIENT_WRAPPER_ID = 'workspace';
const WORKSPACE_CONFLICT_CONTROL_SAVED_OBJECTS_CLIENT_WRAPPER_ID = exports.WORKSPACE_CONFLICT_CONTROL_SAVED_OBJECTS_CLIENT_WRAPPER_ID = 'workspace_conflict_control';
const WORKSPACE_UI_SETTINGS_CLIENT_WRAPPER_ID = exports.WORKSPACE_UI_SETTINGS_CLIENT_WRAPPER_ID = 'workspace_ui_settings';
let WorkspacePermissionMode = exports.WorkspacePermissionMode = /*#__PURE__*/function (WorkspacePermissionMode) {
  WorkspacePermissionMode["Read"] = "read";
  WorkspacePermissionMode["Write"] = "write";
  WorkspacePermissionMode["LibraryRead"] = "library_read";
  WorkspacePermissionMode["LibraryWrite"] = "library_write";
  return WorkspacePermissionMode;
}({});
const WORKSPACE_ID_CONSUMER_WRAPPER_ID = exports.WORKSPACE_ID_CONSUMER_WRAPPER_ID = 'workspace_id_consumer';

/**
 * The priority for these wrappers matters:
 * 1. WORKSPACE_ID_CONSUMER wrapper should be the first wrapper to execute, as it will add the `workspaces` field
 * to `options` based on the request, which will be honored by permission control wrapper and conflict wrapper.
 * 2. The order of permission wrapper and conflict wrapper does not matter as no dependency between these two wrappers.
 */
const PRIORITY_FOR_WORKSPACE_ID_CONSUMER_WRAPPER = exports.PRIORITY_FOR_WORKSPACE_ID_CONSUMER_WRAPPER = -3;
const PRIORITY_FOR_WORKSPACE_UI_SETTINGS_WRAPPER = exports.PRIORITY_FOR_WORKSPACE_UI_SETTINGS_WRAPPER = -2;
const PRIORITY_FOR_WORKSPACE_CONFLICT_CONTROL_WRAPPER = exports.PRIORITY_FOR_WORKSPACE_CONFLICT_CONTROL_WRAPPER = -1;
const PRIORITY_FOR_PERMISSION_CONTROL_WRAPPER = exports.PRIORITY_FOR_PERMISSION_CONTROL_WRAPPER = 0;
const WORKSPACE_APP_CATEGORIES = exports.WORKSPACE_APP_CATEGORIES = Object.freeze({
  // below categories are for workspace
  getStarted: {
    id: 'getStarted',
    label: _i18n.i18n.translate('core.ui.getStarted.label', {
      defaultMessage: 'Get started'
    }),
    order: 10000
  },
  dashboardAndReport: {
    id: 'dashboardReport',
    label: _i18n.i18n.translate('core.ui.dashboardReport.label', {
      defaultMessage: 'Dashboard and report'
    }),
    order: 11000
  },
  investigate: {
    id: 'investigate',
    label: _i18n.i18n.translate('core.ui.investigate.label', {
      defaultMessage: 'Investigate'
    }),
    order: 12000
  },
  detect: {
    id: 'detect',
    label: _i18n.i18n.translate('core.ui.detect.label', {
      defaultMessage: 'Detect'
    }),
    order: 13000
  },
  searchSolution: {
    id: 'searchSolution',
    label: _i18n.i18n.translate('core.ui.searchSolution.label', {
      defaultMessage: 'Build search solution'
    }),
    order: 14000
  }
});
/**
 *
 * This is a temp solution to store relationships between use cases  and features.
 * The relationship should be provided by plugin itself. The workspace plugin should
 * provide some method to register single feature to the use case map instead of
 * store a static map in workspace.
 *
 */
const WORKSPACE_USE_CASES = exports.WORKSPACE_USE_CASES = Object.freeze({
  observability: {
    id: 'observability',
    title: _i18n.i18n.translate('workspace.usecase.observability.title', {
      defaultMessage: 'Observability'
    }),
    description: _i18n.i18n.translate('workspace.usecase.observability.description', {
      defaultMessage: 'Gain visibility into system health, performance, and reliability through monitoring and analysis of logs, metrics, and traces.'
    }),
    features: ['discover', 'dashboards', 'visualize', 'maps-dashboards', 'observability-notebooks', 'reports-dashboards', 'integrations', 'alerting', 'anomaly-detection-dashboards', 'observability-metrics', 'observability-traces', 'observability-applications',
    // Add management avoid index patterns application not found for dashboards or visualize
    'management']
  },
  'security-analytics': {
    id: 'security-analytics',
    title: _i18n.i18n.translate('workspace.usecase.security.analytics.title', {
      defaultMessage: 'Security Analytics'
    }),
    description: _i18n.i18n.translate('workspace.usecase.analytics.description', {
      defaultMessage: 'Detect and investigate potential security threats and vulnerabilities across your systems and data.'
    }),
    features: ['discover', 'dashboards', 'visualize', 'maps-dashboards', 'observability-notebooks', 'reports-dashboards', 'integrations', 'alerting', 'anomaly-detection-dashboards', 'opensearch_security_analytics_dashboards',
    // Add management avoid index patterns application not found for dashboards or visualize
    'management']
  },
  analytics: {
    id: 'analytics',
    title: _i18n.i18n.translate('workspace.usecase.analytics.title', {
      defaultMessage: 'Analytics'
    }),
    description: _i18n.i18n.translate('workspace.usecase.analytics.description', {
      defaultMessage: 'Analyze data to derive insights, identify patterns and trends, and make data-driven decisions.'
    }),
    features: ['discover', 'dashboards', 'visualize', 'maps-dashboards', 'observability-notebooks', 'reports-dashboards', 'integrations', 'alerting', 'anomaly-detection-dashboards',
    // Add management avoid index patterns application not found for dashboards or visualize
    'management']
  },
  search: {
    id: 'search',
    title: _i18n.i18n.translate('workspace.usecase.search.title', {
      defaultMessage: 'Search'
    }),
    description: _i18n.i18n.translate('workspace.usecase.search.description', {
      defaultMessage: "Quickly find and explore relevant information across your organization's data sources."
    }),
    features: ['discover', 'dashboards', 'visualize', 'maps-dashboards', 'reports-dashboards', 'searchRelevance',
    // Add management avoid index patterns application not found for dashboards or visualize
    'management']
  }
});