/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

final class ExternalUtil {
    static final Logger LOG = Logger.getLogger("org.openide.filesystems");

    ExternalUtil() {
    }

    public static void exception(Exception exception) {
        LOG.log(Level.INFO, null, exception);
    }

    public static Throwable copyAnnotation(Throwable throwable, Throwable throwable2) {
        return throwable.initCause(throwable2);
    }

    public static void annotate(Throwable throwable, String string) {
        Exceptions.attachLocalizedMessage((Throwable)throwable, (String)string);
    }

    public static Throwable annotate(Throwable throwable, Throwable throwable2) {
        Throwable throwable3 = throwable;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        try {
            throwable.initCause(throwable2);
        }
        catch (IllegalStateException illegalStateException) {
            Exception exception = new Exception(throwable.getMessage(), throwable2);
            exception.setStackTrace(throwable.getStackTrace());
            return exception;
        }
        return throwable3;
    }

    public static void log(String string) {
        LOG.fine(string);
    }

    public static Class findClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            return Class.forName(string);
        }
        return Class.forName(string, true, classLoader);
    }
}

