/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.GroupTitle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeGroupTitle
extends GroupTitle {
    private String csname;

    public DateTimeGroupTitle(Bib2Gls bib2Gls, DateFormat dateFormat, Date date, String string, String string2, boolean bl, boolean bl2) {
        super(bib2Gls, null, dateFormat.format(date), date.getTime(), string, string2);
        SimpleDateFormat simpleDateFormat;
        if (bl && bl2) {
            simpleDateFormat = new SimpleDateFormat("{yyyy}{MM}{dd}{HH}{mm}{ss}{Z}");
            this.csname = "datetimegroup";
        } else if (bl) {
            simpleDateFormat = new SimpleDateFormat("{yyyy}{MM}{dd}{G}");
            this.csname = "dategroup";
        } else {
            simpleDateFormat = new SimpleDateFormat("{HH}{mm}{ss}{Z}");
            this.csname = "timegroup";
        }
        this.setTitle(simpleDateFormat.format(date));
    }

    @Override
    protected String getNonHierCsSetName() {
        return "bibglsset" + this.csname + "title";
    }

    @Override
    protected String getNonHierCsLabelName() {
        return "bibgls" + this.csname;
    }

    @Override
    public String format(String string) {
        if (this.supportsHierarchy) {
            return String.format("%s{%s}{%d}{%s}{%s}{%d}", this.getTitle(), this.getActual(), this.getId(), this.type == null ? "" : this.getType(), this.parent == null ? "" : this.parent, this.level);
        }
        return String.format("%s{%s}{%d}{%s}", this.getTitle(), this.getActual(), this.getId(), this.type == null ? "" : this.getType());
    }
}

