/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.action.support.single.shard.TransportSingleShardAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiFunction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexService;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.indices.IndicesService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.script.FilterScript;
import org.opensearch.script.ScoreScript;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class PainlessExecuteAction
extends ActionType<Response> {
    public static final PainlessExecuteAction INSTANCE = new PainlessExecuteAction();
    private static final String NAME = "cluster:admin/scripts/painless/execute";

    private PainlessExecuteAction() {
        super(NAME, Response::new);
    }

    public static class RestAction
    extends BaseRestHandler {
        public List<RestHandler.Route> routes() {
            return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_scripts/painless/_execute"), new RestHandler.Route(RestRequest.Method.POST, "/_scripts/painless/_execute")));
        }

        public String getName() {
            return "_scripts_painless_execute";
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
            Request request = Request.parse(restRequest.contentOrSourceParamParser());
            return channel -> client.executeLocally((ActionType)INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
        }
    }

    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        private final ScriptService scriptService;
        private final IndicesService indicesServices;

        @Inject
        public TransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, ClusterService clusterService, IndicesService indicesServices) {
            super(PainlessExecuteAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, "management");
            this.scriptService = scriptService;
            this.indicesServices = indicesServices;
        }

        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            if (request.concreteIndex() != null) {
                return super.checkRequestBlock(state, request);
            }
            return null;
        }

        protected boolean resolveIndex(Request request) {
            return request.contextSetup != null && request.contextSetup.getIndex() != null;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            if (request.concreteIndex() == null) {
                return null;
            }
            return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
        }

        protected Response shardOperation(Request request, ShardId shardId) throws IOException {
            IndexService indexService;
            if (request.contextSetup != null && request.contextSetup.getIndex() != null) {
                String indexExpression;
                IndicesOptions indicesOptions;
                ClusterState clusterState = this.clusterService.state();
                Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, indicesOptions = IndicesOptions.strictSingleIndexNoExpandForbidClosed(), new String[]{indexExpression = request.contextSetup.index});
                if (concreteIndices.length != 1) {
                    throw new IllegalArgumentException("[" + indexExpression + "] does not resolve to a single index");
                }
                Index concreteIndex = concreteIndices[0];
                indexService = this.indicesServices.indexServiceSafe(concreteIndex);
            } else {
                indexService = null;
            }
            return TransportAction.innerShardOperation(request, this.scriptService, indexService);
        }

        static Response innerShardOperation(Request request, ScriptService scriptService, IndexService indexService) throws IOException {
            ScriptContext<?> scriptContext = request.context;
            if (scriptContext == PainlessTestScript.CONTEXT) {
                PainlessTestScript.Factory factory = (PainlessTestScript.Factory)scriptService.compile(request.script, PainlessTestScript.CONTEXT);
                PainlessTestScript painlessTestScript = factory.newInstance(request.script.getParams());
                String result = Objects.toString(painlessTestScript.execute());
                return new Response(result);
            }
            if (scriptContext == FilterScript.CONTEXT) {
                return TransportAction.prepareRamIndex(request, (CheckedBiFunction<QueryShardContext, LeafReaderContext, Response, IOException>)((CheckedBiFunction)(context, leafReaderContext) -> {
                    FilterScript.Factory factory = (FilterScript.Factory)scriptService.compile(request.script, FilterScript.CONTEXT);
                    FilterScript.LeafFactory leafFactory = factory.newFactory(request.getScript().getParams(), context.lookup());
                    FilterScript filterScript = leafFactory.newInstance(leafReaderContext);
                    filterScript.setDocument(0);
                    boolean result = filterScript.execute();
                    return new Response(result);
                }), indexService);
            }
            if (scriptContext == ScoreScript.CONTEXT) {
                return TransportAction.prepareRamIndex(request, (CheckedBiFunction<QueryShardContext, LeafReaderContext, Response, IOException>)((CheckedBiFunction)(context, leafReaderContext) -> {
                    ScoreScript.Factory factory = (ScoreScript.Factory)scriptService.compile(request.script, ScoreScript.CONTEXT);
                    ScoreScript.LeafFactory leafFactory = factory.newFactory(request.getScript().getParams(), context.lookup(), context.searcher());
                    ScoreScript scoreScript = leafFactory.newInstance(leafReaderContext);
                    scoreScript.setDocument(0);
                    if (request.contextSetup.query != null) {
                        Query luceneQuery = request.contextSetup.query.rewrite((QueryRewriteContext)context).toQuery(context);
                        IndexSearcher indexSearcher = new IndexSearcher((IndexReader)leafReaderContext.reader());
                        luceneQuery = indexSearcher.rewrite(luceneQuery);
                        Weight weight = indexSearcher.createWeight(luceneQuery, ScoreMode.COMPLETE, 1.0f);
                        Scorer scorer = weight.scorer((LeafReaderContext)indexSearcher.getIndexReader().leaves().get(0));
                        int docID = scorer.iterator().nextDoc();
                        assert (docID == scorer.docID());
                        scoreScript.setScorer((Scorable)scorer);
                    }
                    double result = scoreScript.execute(null);
                    return new Response(result);
                }), indexService);
            }
            throw new UnsupportedOperationException("unsupported context [" + scriptContext.name + "]");
        }

        /*
         * Exception decompiling
         */
        private static Response prepareRamIndex(Request request, CheckedBiFunction<QueryShardContext, LeafReaderContext, Response, IOException> handler, IndexService indexService) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ long lambda$prepareRamIndex$2(long absoluteStartMillis) {
            return absoluteStartMillis;
        }
    }

    public static abstract class PainlessTestScript {
        private final Map<String, Object> params;
        public static final String[] PARAMETERS = new String[0];
        public static final ScriptContext<Factory> CONTEXT = new ScriptContext("painless_test", Factory.class);

        public PainlessTestScript(Map<String, Object> params) {
            this.params = params;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public abstract Object execute();

        public static interface Factory {
            public PainlessTestScript newInstance(Map<String, Object> var1);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Object result;

        Response(Object result) {
            this.result = result;
        }

        Response(StreamInput in) throws IOException {
            super(in);
            this.result = in.readGenericValue();
        }

        public Object getResult() {
            return this.result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.result);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("result", this.result);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.result, response.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }
    }

    public static class Request
    extends SingleShardRequest<Request>
    implements ToXContentObject {
        private static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
        private static final ParseField CONTEXT_FIELD = new ParseField("context", new String[0]);
        private static final ParseField CONTEXT_SETUP_FIELD = new ParseField("context_setup", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("painless_execute_request", args -> new Request((Script)args[0], (String)args[1], (ContextSetup)args[2]));
        static final Map<String, ScriptContext<?>> SUPPORTED_CONTEXTS;
        private final Script script;
        private final ScriptContext<?> context;
        private final ContextSetup contextSetup;

        static ScriptContext<?> fromScriptContextName(String name) {
            ScriptContext<?> scriptContext = SUPPORTED_CONTEXTS.get(name);
            if (scriptContext == null) {
                throw new UnsupportedOperationException("unsupported script context name [" + name + "]");
            }
            return scriptContext;
        }

        static Request parse(XContentParser parser) throws IOException {
            return (Request)((Object)PARSER.parse(parser, null));
        }

        Request(Script script, String scriptContextName, ContextSetup setup) {
            this.script = Objects.requireNonNull(script);
            Object object = this.context = scriptContextName != null ? Request.fromScriptContextName(scriptContextName) : PainlessTestScript.CONTEXT;
            if (setup != null) {
                this.contextSetup = setup;
                this.index(this.contextSetup.index);
            } else {
                this.contextSetup = null;
            }
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.script = new Script(in);
            this.context = Request.fromScriptContextName(in.readString());
            this.contextSetup = (ContextSetup)in.readOptionalWriteable(ContextSetup::new);
        }

        public Script getScript() {
            return this.script;
        }

        public ScriptContext<?> getContext() {
            return this.context;
        }

        public ContextSetup getContextSetup() {
            return this.contextSetup;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.script.getType() != ScriptType.INLINE) {
                validationException = ValidateActions.addValidationError((String)"only inline scripts are supported", validationException);
            }
            if (Request.needDocumentAndIndex(this.context)) {
                if (this.contextSetup.index == null) {
                    validationException = ValidateActions.addValidationError((String)"index is a required parameter for current context", (ActionRequestValidationException)validationException);
                }
                if (this.contextSetup.document == null) {
                    validationException = ValidateActions.addValidationError((String)"document is a required parameter for current context", (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.script.writeTo(out);
            out.writeString(this.context.name);
            out.writeOptionalWriteable((Writeable)this.contextSetup);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
            builder.field(CONTEXT_FIELD.getPreferredName(), this.context.name);
            if (this.contextSetup != null) {
                builder.field(CONTEXT_SETUP_FIELD.getPreferredName(), (ToXContent)this.contextSetup);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.script, request.script) && Objects.equals(this.context, request.context) && Objects.equals(this.contextSetup, request.contextSetup);
        }

        public int hashCode() {
            return Objects.hash(this.script, this.context, this.contextSetup);
        }

        public String toString() {
            return "Request{script=" + this.script + "context=" + this.context + ", contextSetup=" + this.contextSetup + "}";
        }

        static boolean needDocumentAndIndex(ScriptContext<?> scriptContext) {
            return scriptContext == FilterScript.CONTEXT || scriptContext == ScoreScript.CONTEXT;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Script.parse((XContentParser)p), SCRIPT_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CONTEXT_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ContextSetup::parse, CONTEXT_SETUP_FIELD);
            HashMap<String, Object> supportedContexts = new HashMap<String, Object>();
            supportedContexts.put("painless_test", PainlessTestScript.CONTEXT);
            supportedContexts.put("filter", FilterScript.CONTEXT);
            supportedContexts.put("score", ScoreScript.CONTEXT);
            SUPPORTED_CONTEXTS = Collections.unmodifiableMap(supportedContexts);
        }

        static class ContextSetup
        implements Writeable,
        ToXContentObject {
            private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
            private static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
            private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
            private static final ConstructingObjectParser<ContextSetup, Void> PARSER = new ConstructingObjectParser("execute_script_context", args -> new ContextSetup((String)args[0], (BytesReference)args[1], (QueryBuilder)args[2]));
            private final String index;
            private final BytesReference document;
            private final QueryBuilder query;
            private MediaType mediaType;

            static ContextSetup parse(XContentParser parser, Void context) throws IOException {
                ContextSetup contextSetup = (ContextSetup)PARSER.parse(parser, null);
                contextSetup.setXContentType(parser.contentType());
                return contextSetup;
            }

            ContextSetup(String index, BytesReference document, QueryBuilder query) {
                this.index = index;
                this.document = document;
                this.query = query;
            }

            ContextSetup(StreamInput in) throws IOException {
                this.index = in.readOptionalString();
                this.document = in.readOptionalBytesReference();
                String mediaType = in.readOptionalString();
                if (mediaType != null) {
                    this.mediaType = MediaType.fromMediaType((String)mediaType);
                }
                this.query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
            }

            public String getIndex() {
                return this.index;
            }

            public BytesReference getDocument() {
                return this.document;
            }

            public QueryBuilder getQuery() {
                return this.query;
            }

            public MediaType getXContentType() {
                return this.mediaType;
            }

            public void setXContentType(MediaType mediaType) {
                this.mediaType = mediaType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ContextSetup that = (ContextSetup)o;
                return Objects.equals(this.index, that.index) && Objects.equals(this.document, that.document) && Objects.equals(this.query, that.query) && Objects.equals(this.mediaType, that.mediaType);
            }

            public int hashCode() {
                return Objects.hash(this.index, this.document, this.query, this.mediaType);
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeOptionalString(this.index);
                out.writeOptionalBytesReference(this.document);
                out.writeOptionalString(this.mediaType != null ? this.mediaType.mediaTypeWithoutParameters() : null);
                out.writeOptionalNamedWriteable((NamedWriteable)this.query);
            }

            public String toString() {
                return "ContextSetup{, index='" + this.index + "', document=" + this.document + ", query=" + this.query + ", xContentType=" + this.mediaType + "}";
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                if (this.index != null) {
                    builder.field(INDEX_FIELD.getPreferredName(), this.index);
                }
                if (this.document != null) {
                    builder.field(DOCUMENT_FIELD.getPreferredName());
                    try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)this.document, (MediaType)this.mediaType);){
                        builder.generator().copyCurrentStructure(parser);
                    }
                }
                if (this.query != null) {
                    builder.field(QUERY_FIELD.getPreferredName(), (ToXContent)this.query);
                }
                builder.endObject();
                return builder;
            }

            static {
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_FIELD);
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                    try (XContentBuilder b = XContentBuilder.builder((XContent)p.contentType().xContent());){
                        b.copyCurrentStructure(p);
                        BytesReference bytesReference = BytesReference.bytes((XContentBuilder)b);
                        return bytesReference;
                    }
                }, DOCUMENT_FIELD);
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), QUERY_FIELD);
            }
        }
    }
}

