/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.opensearch.action.admin.cluster.settings.SettingsUpdater;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.Priority;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.remote.RemoteMigrationIndexMetadataUpdater;
import org.opensearch.node.remotestore.RemoteStoreNodeService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportClusterUpdateSettingsAction
extends TransportClusterManagerNodeAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterUpdateSettingsAction.class);
    private final AllocationService allocationService;
    private final ClusterSettings clusterSettings;
    private final ClusterManagerTaskThrottler.ThrottlingKey clusterUpdateSettingTaskKey;

    @Inject
    public TransportClusterUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterSettings clusterSettings) {
        super("cluster:admin/settings/update", false, transportService, clusterService, threadPool, actionFilters, ClusterUpdateSettingsRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        this.clusterSettings = clusterSettings;
        this.clusterUpdateSettingTaskKey = clusterService.registerClusterManagerTask("cluster-update-settings", true);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterUpdateSettingsRequest request, ClusterState state) {
        if (request.transientSettings().size() + request.persistentSettings().size() == 1 && (Metadata.SETTING_READ_ONLY_SETTING.exists(request.persistentSettings()) || Metadata.SETTING_READ_ONLY_SETTING.exists(request.transientSettings()) || Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.transientSettings()) || Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.persistentSettings()))) {
            return null;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterUpdateSettingsResponse read(StreamInput in) throws IOException {
        return new ClusterUpdateSettingsResponse(in);
    }

    @Override
    protected void clusterManagerOperation(final ClusterUpdateSettingsRequest request, final ClusterState state, final ActionListener<ClusterUpdateSettingsResponse> listener) {
        final SettingsUpdater updater = new SettingsUpdater(this.clusterSettings);
        this.clusterService.submitStateUpdateTask("cluster_update_settings", new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.IMMEDIATE, (AckedRequest)request, listener){
            private volatile boolean changed;
            {
                super(priority, request2, listener2);
                this.changed = false;
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return TransportClusterUpdateSettingsAction.this.clusterUpdateSettingTaskKey;
            }

            @Override
            protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                return new ClusterUpdateSettingsResponse(acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    super.onAllNodesAcked(e);
                }
            }

            @Override
            public void onAckTimeout() {
                if (this.changed) {
                    this.reroute(false);
                } else {
                    super.onAckTimeout();
                }
            }

            private void reroute(final boolean updateSettingsAcked) {
                if (!TransportClusterUpdateSettingsAction.this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
                    logger.debug("Skipping reroute after cluster update settings, because node is no longer cluster-manager");
                    listener.onResponse((Object)new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    return;
                }
                TransportClusterUpdateSettingsAction.this.clusterService.submitStateUpdateTask("reroute_after_cluster_update_settings", new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.URGENT, (AckedRequest)request, listener){

                    @Override
                    public boolean mustAck(DiscoveryNode discoveryNode) {
                        return updateSettingsAcked;
                    }

                    @Override
                    protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                        return new ClusterUpdateSettingsResponse(updateSettingsAcked && acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
                    }

                    @Override
                    public void onNoLongerClusterManager(String source) {
                        logger.debug("failed to preform reroute after cluster settings were updated - current node is no longer a cluster-manager");
                        listener.onResponse((Object)new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                        listener.onFailure((Exception)new OpenSearchException("reroute after update settings failed", (Throwable)e, new Object[0]));
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return TransportClusterUpdateSettingsAction.this.allocationService.reroute(currentState, "reroute after cluster update settings");
                    }
                });
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                super.onFailure(source, e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                TransportClusterUpdateSettingsAction.this.validateCompatibilityModeSettingRequest(request, state);
                ClusterState clusterState = updater.updateSettings(currentState, TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.transientSettings()), TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.persistentSettings()), logger);
                this.changed = clusterState != currentState;
                return clusterState;
            }
        });
    }

    public void validateCompatibilityModeSettingRequest(ClusterUpdateSettingsRequest request, ClusterState clusterState) {
        Settings settings = Settings.builder().put(request.persistentSettings()).put(request.transientSettings()).build();
        if (RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING.exists(settings)) {
            String value = RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING.get((Settings)settings).mode;
            this.validateAllNodesOfSameVersion(clusterState.nodes());
            if (RemoteStoreNodeService.CompatibilityMode.STRICT.mode.equals(value)) {
                this.validateAllNodesOfSameType(clusterState.nodes());
                this.validateIndexSettings(clusterState);
            }
        }
    }

    private void validateAllNodesOfSameVersion(DiscoveryNodes discoveryNodes) {
        if (!discoveryNodes.getMaxNodeVersion().equals((Object)discoveryNodes.getMinNodeVersion())) {
            throw new SettingsException("can not change the compatibility mode when all the nodes in cluster are not of the same version");
        }
    }

    private void validateAllNodesOfSameType(DiscoveryNodes discoveryNodes) {
        Set nodeTypes = discoveryNodes.getNodes().values().stream().map(DiscoveryNode::isRemoteStoreNode).collect(Collectors.toSet());
        if (nodeTypes.size() != 1) {
            throw new SettingsException("can not switch to STRICT compatibility mode when the cluster contains both remote and non-remote nodes");
        }
    }

    private void validateIndexSettings(ClusterState clusterState) {
        Collection<IndexMetadata> allIndicesMetadata = clusterState.metadata().indices().values();
        if (!allIndicesMetadata.isEmpty() && allIndicesMetadata.stream().anyMatch(indexMetadata -> !RemoteMigrationIndexMetadataUpdater.indexHasAllRemoteStoreRelatedMetadata(indexMetadata))) {
            throw new SettingsException("can not switch to STRICT compatibility mode since all indices in the cluster does not have remote store based index settings");
        }
    }
}

