/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchQueryAggregationCategorizer;
import org.opensearch.action.search.SearchQueryCategorizingVisitor;
import org.opensearch.action.search.SearchQueryCounters;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShapeVisitor;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

final class SearchQueryCategorizer {
    private static final Logger log = LogManager.getLogger(SearchQueryCategorizer.class);
    final SearchQueryCounters searchQueryCounters;
    final SearchQueryAggregationCategorizer searchQueryAggregationCategorizer;

    public SearchQueryCategorizer(MetricsRegistry metricsRegistry) {
        this.searchQueryCounters = new SearchQueryCounters(metricsRegistry);
        this.searchQueryAggregationCategorizer = new SearchQueryAggregationCategorizer(this.searchQueryCounters);
    }

    public void categorize(SearchSourceBuilder source) {
        QueryBuilder topLevelQueryBuilder = source.query();
        this.logQueryShape(topLevelQueryBuilder);
        this.incrementQueryTypeCounters(topLevelQueryBuilder);
        this.incrementQueryAggregationCounters(source.aggregations());
        this.incrementQuerySortCounters(source.sorts());
    }

    private void incrementQuerySortCounters(List<SortBuilder<?>> sorts) {
        if (sorts != null && sorts.size() > 0) {
            ListIterator<SortBuilder<?>> it = sorts.listIterator();
            while (it.hasNext()) {
                SortBuilder<?> sortBuilder = it.next();
                String sortOrder = sortBuilder.order().toString();
                this.searchQueryCounters.sortCounter.add(1.0, Tags.create().addTag("sort_order", sortOrder));
            }
        }
    }

    private void incrementQueryAggregationCounters(AggregatorFactories.Builder aggregations) {
        if (aggregations == null) {
            return;
        }
        this.searchQueryAggregationCategorizer.incrementSearchQueryAggregationCounters(aggregations.getAggregatorFactories());
    }

    private void incrementQueryTypeCounters(QueryBuilder topLevelQueryBuilder) {
        if (topLevelQueryBuilder == null) {
            return;
        }
        SearchQueryCategorizingVisitor searchQueryVisitor = new SearchQueryCategorizingVisitor(this.searchQueryCounters);
        topLevelQueryBuilder.visit(searchQueryVisitor);
    }

    private void logQueryShape(QueryBuilder topLevelQueryBuilder) {
        if (topLevelQueryBuilder == null) {
            return;
        }
        QueryShapeVisitor shapeVisitor = new QueryShapeVisitor();
        topLevelQueryBuilder.visit(shapeVisitor);
        log.trace("Query shape : {}", (Object)shapeVisitor.prettyPrintTree("  "));
    }
}

