/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opensearch.cluster.ClusterInfoService;
import org.opensearch.cluster.ClusterManagerMetrics;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.NodeConnectionsService;
import org.opensearch.cluster.RepositoryCleanupInProgress;
import org.opensearch.cluster.RestoreInProgress;
import org.opensearch.cluster.SnapshotDeletionsInProgress;
import org.opensearch.cluster.SnapshotsInProgress;
import org.opensearch.cluster.action.index.MappingUpdatedAction;
import org.opensearch.cluster.action.index.NodeMappingRefreshAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.decommission.DecommissionAttributeMetadata;
import org.opensearch.cluster.metadata.ComponentTemplateMetadata;
import org.opensearch.cluster.metadata.ComposableIndexTemplateMetadata;
import org.opensearch.cluster.metadata.DataStreamMetadata;
import org.opensearch.cluster.metadata.IndexGraveyard;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataDeleteIndexService;
import org.opensearch.cluster.metadata.MetadataIndexAliasesService;
import org.opensearch.cluster.metadata.MetadataIndexStateService;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.metadata.MetadataMappingService;
import org.opensearch.cluster.metadata.MetadataUpdateSettingsService;
import org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.opensearch.cluster.metadata.WeightedRoutingMetadata;
import org.opensearch.cluster.routing.DelayedAllocationService;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.opensearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.opensearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.ConcurrentRecoveriesAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.opensearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.MaxRetryAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.NodeLoadAwareAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.NodeVersionAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.RemoteStoreMigrationAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.ResizeAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.RestoreInProgressAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.SnapshotInProgressAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.TargetPoolAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.AbstractModule;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.gateway.GatewayAllocator;
import org.opensearch.gateway.ShardsBatchGatewayAllocator;
import org.opensearch.ingest.IngestMetadata;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksNodeService;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.script.ScriptMetadata;
import org.opensearch.search.pipeline.SearchPipelineMetadata;
import org.opensearch.snapshots.SnapshotsInfoService;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskResultsService;

public class ClusterModule
extends AbstractModule {
    public static final String BALANCED_ALLOCATOR = "balanced";
    public static final Setting<String> SHARDS_ALLOCATOR_TYPE_SETTING = new Setting("cluster.routing.allocation.type", "balanced", Function.identity(), Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;
    private final List<ClusterPlugin> clusterPlugins;
    final Collection<AllocationDecider> deciderList;
    final ShardsAllocator shardsAllocator;
    static final Set<String> PRE_6_3_METADATA_CUSTOMS_WHITE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"index-graveyard", "ingest", "repositories", "stored_scripts"}));
    static final Set<String> PRE_6_3_CLUSTER_CUSTOMS_WHITE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"restore", "snapshot_deletions", "snapshots"}));

    public ClusterModule(Settings settings, ClusterService clusterService, List<ClusterPlugin> clusterPlugins, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, ThreadContext threadContext, ClusterManagerMetrics clusterManagerMetrics) {
        this.clusterPlugins = clusterPlugins;
        this.deciderList = ClusterModule.createAllocationDeciders(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.allocationDeciders = new AllocationDeciders(this.deciderList);
        this.shardsAllocator = ClusterModule.createShardsAllocator(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = new IndexNameExpressionResolver(threadContext);
        this.allocationService = new AllocationService(this.allocationDeciders, this.shardsAllocator, clusterInfoService, snapshotsInfoService, settings, clusterManagerMetrics);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        ClusterModule.registerClusterCustom(entries, "snapshots", SnapshotsInProgress::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)SnapshotsInProgress::readDiffFrom));
        ClusterModule.registerClusterCustom(entries, "restore", RestoreInProgress::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)RestoreInProgress::readDiffFrom));
        ClusterModule.registerClusterCustom(entries, "snapshot_deletions", SnapshotDeletionsInProgress::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)SnapshotDeletionsInProgress::readDiffFrom));
        ClusterModule.registerClusterCustom(entries, "repository_cleanup", RepositoryCleanupInProgress::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)RepositoryCleanupInProgress::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "repositories", RepositoriesMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)RepositoriesMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "ingest", IngestMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)IngestMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "search_pipeline", SearchPipelineMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)SearchPipelineMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "stored_scripts", ScriptMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)ScriptMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "index-graveyard", IndexGraveyard::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)IndexGraveyard::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "persistent_tasks", PersistentTasksCustomMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)PersistentTasksCustomMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "component_template", ComponentTemplateMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)ComponentTemplateMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "index_template", ComposableIndexTemplateMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)ComposableIndexTemplateMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "data_stream", DataStreamMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)DataStreamMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "weighted_shard_routing", WeightedRoutingMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)WeightedRoutingMetadata::readDiffFrom));
        ClusterModule.registerMetadataCustom(entries, "decommissionedAttribute", DecommissionAttributeMetadata::new, (Writeable.Reader<NamedDiff>)((Writeable.Reader)DecommissionAttributeMetadata::readDiffFrom));
        entries.add(new NamedWriteableRegistry.Entry(Task.Status.class, "persistent_executor", PersistentTasksNodeService.Status::new));
        return entries;
    }

    public static ClusterState filterCustomsForPre63Clients(ClusterState clusterState) {
        ClusterState.Builder builder = ClusterState.builder(clusterState);
        clusterState.customs().keySet().iterator().forEachRemaining(name -> {
            if (!PRE_6_3_CLUSTER_CUSTOMS_WHITE_LIST.contains(name)) {
                builder.removeCustom((String)name);
            }
        });
        Metadata.Builder metaBuilder = Metadata.builder(clusterState.metadata());
        clusterState.metadata().customs().keySet().iterator().forEachRemaining(name -> {
            if (!PRE_6_3_METADATA_CUSTOMS_WHITE_LIST.contains(name)) {
                metaBuilder.removeCustom((String)name);
            }
        });
        return builder.metadata(metaBuilder).build();
    }

    public static List<NamedXContentRegistry.Entry> getNamedXWriteables() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("repositories", new String[0]), RepositoriesMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("ingest", new String[0]), IngestMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("search_pipeline", new String[0]), SearchPipelineMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("stored_scripts", new String[0]), ScriptMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("index-graveyard", new String[0]), IndexGraveyard::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("persistent_tasks", new String[0]), PersistentTasksCustomMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("component_template", new String[0]), ComponentTemplateMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("index_template", new String[0]), ComposableIndexTemplateMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("data_stream", new String[0]), DataStreamMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("weighted_shard_routing", new String[0]), WeightedRoutingMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("decommissionedAttribute", new String[0]), DecommissionAttributeMetadata::fromXContent));
        return entries;
    }

    private static <T extends ClusterState.Custom> void registerClusterCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, ClusterState.Custom.class, name, reader, diffReader);
    }

    private static <T extends Metadata.Custom> void registerMetadataCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, Metadata.Custom.class, name, reader, diffReader);
    }

    private static <T extends NamedWriteable> void registerCustom(List<NamedWriteableRegistry.Entry> entries, Class<T> category, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        entries.add(new NamedWriteableRegistry.Entry(category, name, reader));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, name, diffReader));
    }

    public IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    public static Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        LinkedHashMap<Class, AllocationDecider> deciders = new LinkedHashMap<Class, AllocationDecider>();
        ClusterModule.addAllocationDecider(deciders, new MaxRetryAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ResizeAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ReplicaAfterPrimaryActiveAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new RebalanceOnlyWhenActiveAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ClusterRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ConcurrentRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ConcurrentRecoveriesAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new EnableAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new NodeVersionAllocationDecider(settings));
        ClusterModule.addAllocationDecider(deciders, new SnapshotInProgressAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new RestoreInProgressAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new FilterAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new SameShardAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new DiskThresholdDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ThrottlingAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ShardsLimitAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new AwarenessAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new NodeLoadAwareAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new TargetPoolAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new RemoteStoreMigrationAllocationDecider(settings, clusterSettings));
        clusterPlugins.stream().flatMap(p -> p.createAllocationDeciders(settings, clusterSettings).stream()).forEach(d -> ClusterModule.addAllocationDecider(deciders, d));
        return deciders.values();
    }

    private static void addAllocationDecider(Map<Class, AllocationDecider> deciders, AllocationDecider decider) {
        if (deciders.put(decider.getClass(), decider) != null) {
            throw new IllegalArgumentException("Cannot specify allocation decider [" + decider.getClass().getName() + "] twice");
        }
    }

    private static ShardsAllocator createShardsAllocator(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        HashMap<String, Supplier<ShardsAllocator>> allocators = new HashMap<String, Supplier<ShardsAllocator>>();
        allocators.put(BALANCED_ALLOCATOR, () -> new BalancedShardsAllocator(settings, clusterSettings));
        for (ClusterPlugin plugin : clusterPlugins) {
            plugin.getShardsAllocators(settings, clusterSettings).forEach((k, v) -> {
                if (allocators.put((String)k, (Supplier<ShardsAllocator>)v) != null) {
                    throw new IllegalArgumentException("ShardsAllocator [" + k + "] already defined");
                }
            });
        }
        String allocatorName = SHARDS_ALLOCATOR_TYPE_SETTING.get(settings);
        Supplier allocatorSupplier = (Supplier)allocators.get(allocatorName);
        if (allocatorSupplier == null) {
            throw new IllegalArgumentException("Unknown ShardsAllocator [" + allocatorName + "]");
        }
        return Objects.requireNonNull((ShardsAllocator)allocatorSupplier.get(), "ShardsAllocator factory for [" + allocatorName + "] returned null");
    }

    public AllocationService getAllocationService() {
        return this.allocationService;
    }

    @Override
    protected void configure() {
        this.bind(GatewayAllocator.class).asEagerSingleton();
        this.bind(ShardsBatchGatewayAllocator.class).asEagerSingleton();
        this.bind(AllocationService.class).toInstance(this.allocationService);
        this.bind(ClusterService.class).toInstance(this.clusterService);
        this.bind(NodeConnectionsService.class).asEagerSingleton();
        this.bind(MetadataDeleteIndexService.class).asEagerSingleton();
        this.bind(MetadataIndexStateService.class).asEagerSingleton();
        this.bind(MetadataMappingService.class).asEagerSingleton();
        this.bind(MetadataIndexAliasesService.class).asEagerSingleton();
        this.bind(MetadataUpdateSettingsService.class).asEagerSingleton();
        this.bind(MetadataIndexTemplateService.class).asEagerSingleton();
        this.bind(IndexNameExpressionResolver.class).toInstance(this.indexNameExpressionResolver);
        this.bind(DelayedAllocationService.class).asEagerSingleton();
        this.bind(ShardStateAction.class).asEagerSingleton();
        this.bind(NodeMappingRefreshAction.class).asEagerSingleton();
        this.bind(MappingUpdatedAction.class).asEagerSingleton();
        this.bind(TaskResultsService.class).asEagerSingleton();
        this.bind(AllocationDeciders.class).toInstance(this.allocationDeciders);
        this.bind(ShardsAllocator.class).toInstance(this.shardsAllocator);
    }

    public void setExistingShardsAllocators(GatewayAllocator gatewayAllocator, ShardsBatchGatewayAllocator shardsBatchGatewayAllocator) {
        HashMap<String, ExistingShardsAllocator> existingShardsAllocators = new HashMap<String, ExistingShardsAllocator>();
        existingShardsAllocators.put("gateway_allocator", gatewayAllocator);
        existingShardsAllocators.put("shards_batch_gateway_allocator", shardsBatchGatewayAllocator);
        for (ClusterPlugin clusterPlugin : this.clusterPlugins) {
            for (Map.Entry<String, ExistingShardsAllocator> existingShardsAllocatorEntry : clusterPlugin.getExistingShardsAllocators().entrySet()) {
                String allocatorName = existingShardsAllocatorEntry.getKey();
                if (existingShardsAllocators.put(allocatorName, existingShardsAllocatorEntry.getValue()) == null) continue;
                throw new IllegalArgumentException("ExistingShardsAllocator [" + allocatorName + "] from [" + clusterPlugin.getClass().getName() + "] was already defined");
            }
        }
        this.allocationService.setExistingShardsAllocators(existingShardsAllocators);
    }
}

