/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.ClusterStateDiffManifest;
import org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.opensearch.gateway.remote.RemoteStateTransferException;
import org.opensearch.gateway.remote.model.RemoteClusterMetadataManifest;
import org.opensearch.gateway.remote.model.RemoteClusterStateBlobStore;
import org.opensearch.gateway.remote.model.RemoteClusterStateManifestInfo;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class RemoteManifestManager {
    public static final TimeValue METADATA_MANIFEST_UPLOAD_TIMEOUT_DEFAULT = TimeValue.timeValueMillis((long)20000L);
    public static final Setting<TimeValue> METADATA_MANIFEST_UPLOAD_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.metadata_manifest.upload_timeout", METADATA_MANIFEST_UPLOAD_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(RemoteManifestManager.class);
    private volatile TimeValue metadataManifestUploadTimeout;
    private final String nodeId;
    private final RemoteClusterStateBlobStore<ClusterMetadataManifest, RemoteClusterMetadataManifest> manifestBlobStore;
    private final Compressor compressor;
    private final NamedXContentRegistry namedXContentRegistry;
    private final BlobStoreRepository blobStoreRepository;

    RemoteManifestManager(ClusterSettings clusterSettings, String clusterName, String nodeId, BlobStoreRepository blobStoreRepository, BlobStoreTransferService blobStoreTransferService, ThreadPool threadpool) {
        this.metadataManifestUploadTimeout = clusterSettings.get(METADATA_MANIFEST_UPLOAD_TIMEOUT_SETTING);
        this.nodeId = nodeId;
        this.manifestBlobStore = new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read");
        clusterSettings.addSettingsUpdateConsumer(METADATA_MANIFEST_UPLOAD_TIMEOUT_SETTING, this::setMetadataManifestUploadTimeout);
        this.compressor = blobStoreRepository.getCompressor();
        this.namedXContentRegistry = blobStoreRepository.getNamedXContentRegistry();
        this.blobStoreRepository = blobStoreRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteClusterStateManifestInfo uploadManifest(ClusterState clusterState, RemoteClusterStateUtils.UploadedMetadataResults uploadedMetadataResult, String previousClusterUUID, ClusterStateDiffManifest clusterDiffManifest, boolean committed) {
        RemoteManifestManager remoteManifestManager = this;
        synchronized (remoteManifestManager) {
            ClusterMetadataManifest.Builder manifestBuilder = ClusterMetadataManifest.builder();
            manifestBuilder.clusterTerm(clusterState.term()).stateVersion(clusterState.getVersion()).clusterUUID(clusterState.metadata().clusterUUID()).stateUUID(clusterState.stateUUID()).opensearchVersion(Version.CURRENT).nodeId(this.nodeId).committed(committed).codecVersion(2).indices(uploadedMetadataResult.uploadedIndexMetadata).previousClusterUUID(previousClusterUUID).clusterUUIDCommitted(clusterState.metadata().clusterUUIDCommitted()).coordinationMetadata(uploadedMetadataResult.uploadedCoordinationMetadata).settingMetadata(uploadedMetadataResult.uploadedSettingsMetadata).templatesMetadata(uploadedMetadataResult.uploadedTemplatesMetadata).customMetadataMap(uploadedMetadataResult.uploadedCustomMetadataMap).routingTableVersion(clusterState.getRoutingTable().version()).indicesRouting(uploadedMetadataResult.uploadedIndicesRoutingMetadata).discoveryNodesMetadata(uploadedMetadataResult.uploadedDiscoveryNodes).clusterBlocksMetadata(uploadedMetadataResult.uploadedClusterBlocks).diffManifest(clusterDiffManifest).metadataVersion(clusterState.metadata().version()).transientSettingsMetadata(uploadedMetadataResult.uploadedTransientSettingsMetadata).clusterStateCustomMetadataMap(uploadedMetadataResult.uploadedClusterStateCustomMetadataMap).hashesOfConsistentSettings(uploadedMetadataResult.uploadedHashesOfConsistentSettings);
            ClusterMetadataManifest manifest = manifestBuilder.build();
            String manifestFileName = this.writeMetadataManifest(clusterState.metadata().clusterUUID(), manifest);
            return new RemoteClusterStateManifestInfo(manifest, manifestFileName);
        }
    }

    private String writeMetadataManifest(String clusterUUID, ClusterMetadataManifest uploadManifest) {
        AtomicReference result = new AtomicReference();
        AtomicReference exceptionReference = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        LatchedActionListener<Void> completionListener = new LatchedActionListener<Void>(ActionListener.wrap(resp -> logger.trace(String.format(Locale.ROOT, "Manifest file uploaded successfully.", new Object[0])), ex -> exceptionReference.set(ex)), latch);
        RemoteClusterMetadataManifest remoteClusterMetadataManifest = new RemoteClusterMetadataManifest(uploadManifest, clusterUUID, this.compressor, this.namedXContentRegistry);
        this.manifestBlobStore.writeAsync(remoteClusterMetadataManifest, completionListener);
        try {
            if (!latch.await(this.getMetadataManifestUploadTimeout().millis(), TimeUnit.MILLISECONDS)) {
                RemoteStateTransferException ex2 = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of manifest file to complete", new Object[0]));
                throw ex2;
            }
        }
        catch (InterruptedException ex3) {
            RemoteStateTransferException exception = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of manifest file to complete - %s", new Object[0]), ex3);
            Thread.currentThread().interrupt();
            throw exception;
        }
        if (exceptionReference.get() != null) {
            throw new RemoteStateTransferException(((Exception)exceptionReference.get()).getMessage(), (Throwable)exceptionReference.get());
        }
        logger.debug("Metadata manifest file [{}] written during [{}] phase. ", (Object)remoteClusterMetadataManifest.getBlobFileName(), (Object)(uploadManifest.isCommitted() ? "commit" : "publish"));
        return remoteClusterMetadataManifest.getUploadedMetadata().getUploadedFilename();
    }

    public Optional<ClusterMetadataManifest> getLatestClusterMetadataManifest(String clusterName, String clusterUUID) {
        Optional<String> latestManifestFileName = this.getLatestManifestFileName(clusterName, clusterUUID);
        return latestManifestFileName.map(s -> this.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, (String)s));
    }

    public ClusterMetadataManifest getRemoteClusterMetadataManifestByFileName(String clusterUUID, String filename) throws IllegalStateException {
        try {
            RemoteClusterMetadataManifest remoteClusterMetadataManifest = new RemoteClusterMetadataManifest(filename, clusterUUID, this.compressor, this.namedXContentRegistry);
            return this.manifestBlobStore.read(remoteClusterMetadataManifest);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading cluster metadata - %s", filename), e);
        }
    }

    ClusterMetadataManifest fetchRemoteClusterMetadataManifest(String clusterName, String clusterUUID, String filename) throws IllegalStateException {
        try {
            String fullBlobName = this.getManifestFolderPath(clusterName, clusterUUID).buildAsString() + filename;
            RemoteClusterMetadataManifest remoteClusterMetadataManifest = new RemoteClusterMetadataManifest(fullBlobName, clusterUUID, this.compressor, this.namedXContentRegistry);
            return this.manifestBlobStore.read(remoteClusterMetadataManifest);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading cluster metadata - %s", filename), e);
        }
    }

    Map<String, ClusterMetadataManifest> getLatestManifestForAllClusterUUIDs(String clusterName, Set<String> clusterUUIDs) {
        HashMap<String, ClusterMetadataManifest> manifestsByClusterUUID = new HashMap<String, ClusterMetadataManifest>();
        for (String clusterUUID : clusterUUIDs) {
            try {
                Optional<ClusterMetadataManifest> manifest = this.getLatestClusterMetadataManifest(clusterName, clusterUUID);
                manifest.ifPresent(clusterMetadataManifest -> manifestsByClusterUUID.put(clusterUUID, (ClusterMetadataManifest)clusterMetadataManifest));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Exception in fetching manifest for clusterUUID: %s", clusterUUID), e);
            }
        }
        return manifestsByClusterUUID;
    }

    private BlobContainer manifestContainer(String clusterName, String clusterUUID) {
        return this.blobStoreRepository.blobStore().blobContainer(this.getManifestFolderPath(clusterName, clusterUUID));
    }

    BlobPath getManifestFolderPath(String clusterName, String clusterUUID) {
        return RemoteClusterStateUtils.getClusterMetadataBasePath(this.blobStoreRepository, clusterName, clusterUUID).add("manifest");
    }

    public TimeValue getMetadataManifestUploadTimeout() {
        return this.metadataManifestUploadTimeout;
    }

    private void setMetadataManifestUploadTimeout(TimeValue newMetadataManifestUploadTimeout) {
        this.metadataManifestUploadTimeout = newMetadataManifestUploadTimeout;
    }

    private List<BlobMetadata> getManifestFileNames(String clusterName, String clusterUUID, String filePrefix, int limit) throws IllegalStateException {
        try {
            return this.manifestContainer(clusterName, clusterUUID).listBlobsByPrefixInSortedOrder(filePrefix, limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while fetching latest manifest file for remote cluster state", e);
        }
    }

    static String getManifestFilePrefixForTermVersion(long term, long version) {
        return String.join((CharSequence)"__", "manifest", RemoteStoreUtils.invertLong(term), RemoteStoreUtils.invertLong(version)) + "__";
    }

    private Optional<String> getLatestManifestFileName(String clusterName, String clusterUUID) throws IllegalStateException {
        List<BlobMetadata> manifestFilesMetadata = this.getManifestFileNames(clusterName, clusterUUID, "manifest__", 1);
        if (manifestFilesMetadata != null && !manifestFilesMetadata.isEmpty()) {
            return Optional.of(manifestFilesMetadata.get(0).name());
        }
        logger.info("No manifest file present in remote store for cluster name: {}, cluster UUID: {}", (Object)clusterName, (Object)clusterUUID);
        return Optional.empty();
    }
}

