/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.routingtable;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.Index;
import org.opensearch.gateway.remote.routingtable.IndexRoutingTableHeader;
import org.opensearch.index.translog.BufferedChecksumStreamInput;
import org.opensearch.index.translog.BufferedChecksumStreamOutput;

public class RemoteIndexRoutingTable
implements Writeable {
    private final IndexRoutingTable indexRoutingTable;

    public RemoteIndexRoutingTable(IndexRoutingTable indexRoutingTable) {
        this.indexRoutingTable = indexRoutingTable;
    }

    public RemoteIndexRoutingTable(InputStream inputStream, Index index) throws IOException {
        try (BufferedChecksumStreamInput in = new BufferedChecksumStreamInput((StreamInput)new InputStreamStreamInput(inputStream), "assertion");){
            IndexRoutingTableHeader indexRoutingTableHeader = new IndexRoutingTableHeader((StreamInput)in);
            assert (indexRoutingTableHeader.getIndexName().equals(index.getName()));
            int numberOfShardRouting = in.readVInt();
            IndexRoutingTable.Builder indicesRoutingTable = IndexRoutingTable.builder(index);
            for (int idx = 0; idx < numberOfShardRouting; ++idx) {
                IndexShardRoutingTable indexShardRoutingTable = IndexShardRoutingTable.Builder.readFrom((StreamInput)in);
                indicesRoutingTable.addIndexShard(indexShardRoutingTable);
            }
            this.verifyCheckSum(in);
            this.indexRoutingTable = indicesRoutingTable.build();
        }
        catch (EOFException e) {
            throw new IOException("Indices Routing table is corrupted", e);
        }
    }

    public IndexRoutingTable getIndexRoutingTable() {
        return this.indexRoutingTable;
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        try {
            BufferedChecksumStreamOutput out = new BufferedChecksumStreamOutput(streamOutput);
            IndexRoutingTableHeader indexRoutingTableHeader = new IndexRoutingTableHeader(this.indexRoutingTable.getIndex().getName());
            indexRoutingTableHeader.writeTo(out);
            out.writeVInt(this.indexRoutingTable.shards().size());
            for (IndexShardRoutingTable next : this.indexRoutingTable) {
                IndexShardRoutingTable.Builder.writeTo(next, out);
            }
            out.writeLong(out.getChecksum());
            out.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed to write IndexRoutingTable to stream", e);
        }
    }

    private void verifyCheckSum(BufferedChecksumStreamInput in) throws IOException {
        long expectedChecksum = in.getChecksum();
        long readChecksum = in.readLong();
        if (readChecksum != expectedChecksum) {
            throw new IOException("checksum verification failed - expected: 0x" + Long.toHexString(expectedChecksum) + ", got: 0x" + Long.toHexString(readChecksum));
        }
    }
}

