/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.fuzzy;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.index.codec.fuzzy.BloomFilter;
import org.opensearch.index.codec.fuzzy.FuzzySet;
import org.opensearch.index.codec.fuzzy.FuzzySetParameters;

public class FuzzySetFactory {
    private final Map<String, FuzzySetParameters> setTypeForField;

    public FuzzySetFactory(Map<String, FuzzySetParameters> setTypeForField) {
        this.setTypeForField = setTypeForField;
    }

    public FuzzySet createFuzzySet(int maxDocs, String fieldName, CheckedSupplier<Iterator<BytesRef>, IOException> iteratorProvider) throws IOException {
        FuzzySetParameters params = this.setTypeForField.get(fieldName);
        if (params == null) {
            throw new IllegalArgumentException("No fuzzy set defined for field: " + fieldName);
        }
        switch (params.getSetType()) {
            case BLOOM_FILTER_V1: {
                return new BloomFilter(maxDocs, params.getFalsePositiveProbability(), iteratorProvider);
            }
        }
        throw new IllegalArgumentException("No Implementation for set type: " + params.getSetType());
    }

    public static FuzzySet deserializeFuzzySet(IndexInput in) throws IOException {
        FuzzySet.SetType setType = FuzzySet.SetType.from(in.readString());
        return (FuzzySet)setType.getDeserializer().apply((Object)in);
    }
}

