/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.util.set.Sets;

@PublicApi(since="1.0.0")
public class ReplicationGroup {
    private final IndexShardRoutingTable routingTable;
    private final Set<String> inSyncAllocationIds;
    private final Set<String> trackedAllocationIds;
    private final long version;
    private final Set<String> unavailableInSyncShards;
    private final List<ShardRouting> replicationTargets;
    private final List<ShardRouting> skippedShards;

    public ReplicationGroup(IndexShardRoutingTable routingTable, Set<String> inSyncAllocationIds, Set<String> trackedAllocationIds, long version) {
        this.routingTable = routingTable;
        this.inSyncAllocationIds = inSyncAllocationIds;
        this.trackedAllocationIds = trackedAllocationIds;
        this.version = version;
        this.unavailableInSyncShards = Sets.difference(inSyncAllocationIds, routingTable.getAllAllocationIds());
        this.replicationTargets = new ArrayList<ShardRouting>();
        this.skippedShards = new ArrayList<ShardRouting>();
        for (ShardRouting shard : routingTable) {
            if (shard.unassigned()) {
                assert (!shard.primary()) : "primary shard should not be unassigned in a replication group: " + shard;
                this.skippedShards.add(shard);
                continue;
            }
            if (trackedAllocationIds.contains(shard.allocationId().getId())) {
                this.replicationTargets.add(shard);
            } else {
                assert (!inSyncAllocationIds.contains(shard.allocationId().getId())) : "in-sync shard copy but not tracked: " + shard;
                this.skippedShards.add(shard);
            }
            if (!shard.relocating()) continue;
            ShardRouting relocationTarget = shard.getTargetRelocatingShard();
            if (trackedAllocationIds.contains(relocationTarget.allocationId().getId())) {
                this.replicationTargets.add(relocationTarget);
                continue;
            }
            this.skippedShards.add(relocationTarget);
            assert (!inSyncAllocationIds.contains(relocationTarget.allocationId().getId())) : "in-sync shard copy but not tracked: " + shard;
        }
    }

    public long getVersion() {
        return this.version;
    }

    public IndexShardRoutingTable getRoutingTable() {
        return this.routingTable;
    }

    public Set<String> getInSyncAllocationIds() {
        return this.inSyncAllocationIds;
    }

    public Set<String> getTrackedAllocationIds() {
        return this.trackedAllocationIds;
    }

    public Set<String> getUnavailableInSyncShards() {
        return this.unavailableInSyncShards;
    }

    public List<ShardRouting> getReplicationTargets() {
        return this.replicationTargets;
    }

    public List<ShardRouting> getSkippedShards() {
        return this.skippedShards;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationGroup that = (ReplicationGroup)o;
        if (!this.routingTable.equals(that.routingTable)) {
            return false;
        }
        if (!this.inSyncAllocationIds.equals(that.inSyncAllocationIds)) {
            return false;
        }
        return this.trackedAllocationIds.equals(that.trackedAllocationIds);
    }

    public int hashCode() {
        int result = this.routingTable.hashCode();
        result = 31 * result + this.inSyncAllocationIds.hashCode();
        result = 31 * result + this.trackedAllocationIds.hashCode();
        return result;
    }

    public String toString() {
        return "ReplicationGroup{routingTable=" + this.routingTable + ", inSyncAllocationIds=" + this.inSyncAllocationIds + ", trackedAllocationIds=" + this.trackedAllocationIds + "}";
    }
}

