/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.client.Requests;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class RestBulkAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    public RestBulkAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/_bulk"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_bulk")));
    }

    @Override
    public String getName() {
        return "bulk_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        BulkRequest bulkRequest = Requests.bulkRequest();
        String defaultIndex = request.param("index");
        String defaultRouting = request.param("routing");
        FetchSourceContext defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest(request);
        String defaultPipeline = request.param("pipeline");
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            bulkRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        Boolean defaultRequireAlias = request.paramAsBoolean("require_alias", null);
        bulkRequest.timeout(request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT));
        bulkRequest.setRefreshPolicy(request.param("refresh"));
        bulkRequest.batchSize(request.paramAsInt("batch_size", 1));
        bulkRequest.add(request.requiredContent(), defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, this.allowExplicitIndex, request.getMediaType());
        return channel -> client.bulk(bulkRequest, new RestStatusToXContentListener<BulkResponse>((RestChannel)channel));
    }

    @Override
    public boolean supportsContentStream() {
        return true;
    }

    @Override
    public boolean allowsUnsafeBuffers() {
        return true;
    }
}

