/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import org.opensearch.Version;
import org.opensearch.common.bytes.ReleasableBytesReference;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.transport.Header;
import org.opensearch.transport.TcpHeader;
import org.opensearch.transport.TcpTransport;
import org.opensearch.transport.TransportDecompressor;

public class InboundDecoder
implements Releasable {
    public static final Object PING = new Object();
    public static final Object END_CONTENT = new Object();
    private final Version version;
    private final PageCacheRecycler recycler;
    private TransportDecompressor decompressor;
    private int totalNetworkSize = -1;
    private int bytesConsumed = 0;
    private boolean isClosed = false;

    public InboundDecoder(Version version, PageCacheRecycler recycler) {
        this.version = version;
        this.recycler = recycler;
    }

    public int decode(ReleasableBytesReference reference, Consumer<Object> fragmentConsumer) throws IOException {
        this.ensureOpen();
        try {
            return this.internalDecode(reference, fragmentConsumer);
        }
        catch (Exception e) {
            this.cleanDecodeState();
            throw e;
        }
    }

    public int internalDecode(ReleasableBytesReference reference, Consumer<Object> fragmentConsumer) throws IOException {
        if (this.isOnHeader()) {
            int messageLength = TcpTransport.readMessageLength(reference);
            if (messageLength == -1) {
                return 0;
            }
            if (messageLength == 0) {
                fragmentConsumer.accept(PING);
                return 6;
            }
            int headerBytesToRead = this.headerBytesToRead(reference);
            if (headerBytesToRead == 0) {
                return 0;
            }
            this.totalNetworkSize = messageLength + 6;
            Header header = InboundDecoder.readHeader(this.version, messageLength, reference);
            this.bytesConsumed += headerBytesToRead;
            if (header.isCompressed()) {
                this.decompressor = new TransportDecompressor(this.recycler);
            }
            fragmentConsumer.accept(header);
            if (this.isDone()) {
                this.finishMessage(fragmentConsumer);
            }
            return headerBytesToRead;
        }
        if (this.decompressor != null && !this.decompressor.canDecompress(reference.length())) {
            return 0;
        }
        int bytesToConsume = Math.min(reference.length(), this.totalNetworkSize - this.bytesConsumed);
        this.bytesConsumed += bytesToConsume;
        ReleasableBytesReference retainedContent = this.isDone() ? reference.retainedSlice(0, bytesToConsume) : reference.retain();
        if (this.decompressor != null) {
            ReleasableBytesReference decompressed;
            this.decompress(retainedContent);
            while ((decompressed = this.decompressor.pollDecompressedPage()) != null) {
                fragmentConsumer.accept(decompressed);
            }
        } else {
            fragmentConsumer.accept(retainedContent);
        }
        if (this.isDone()) {
            this.finishMessage(fragmentConsumer);
        }
        return bytesToConsume;
    }

    public void close() {
        this.isClosed = true;
        this.cleanDecodeState();
    }

    private void finishMessage(Consumer<Object> fragmentConsumer) {
        this.cleanDecodeState();
        fragmentConsumer.accept(END_CONTENT);
    }

    private void cleanDecodeState() {
        IOUtils.closeWhileHandlingException((Closeable)this.decompressor);
        this.decompressor = null;
        this.totalNetworkSize = -1;
        this.bytesConsumed = 0;
    }

    private void decompress(ReleasableBytesReference content) throws IOException {
        try (ReleasableBytesReference toRelease = content;){
            int consumed = this.decompressor.decompress(content);
            assert (consumed == content.length());
        }
    }

    private boolean isDone() {
        return this.bytesConsumed == this.totalNetworkSize;
    }

    private int headerBytesToRead(BytesReference reference) {
        if (reference.length() < 19) {
            return 0;
        }
        Version remoteVersion = Version.fromId((int)reference.getInt(15));
        int fixedHeaderSize = TcpHeader.headerSize(remoteVersion);
        if (fixedHeaderSize > reference.length()) {
            return 0;
        }
        if (remoteVersion.before(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
            return fixedHeaderSize;
        }
        int variableHeaderSize = reference.getInt(19);
        int totalHeaderSize = fixedHeaderSize + variableHeaderSize;
        if (totalHeaderSize > reference.length()) {
            return 0;
        }
        return totalHeaderSize;
    }

    static Header readHeader(Version version, int networkMessageSize, BytesReference bytesReference) throws IOException {
        try (StreamInput streamInput = bytesReference.streamInput();){
            streamInput.skip(6L);
            long requestId = streamInput.readLong();
            byte status = streamInput.readByte();
            Version remoteVersion = Version.fromId((int)streamInput.readInt());
            Header header = new Header(networkMessageSize, requestId, status, remoteVersion);
            IllegalStateException invalidVersion = InboundDecoder.ensureVersionCompatibility(remoteVersion, version, header.isHandshake());
            if (invalidVersion != null) {
                throw invalidVersion;
            }
            if (remoteVersion.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
                streamInput.readInt();
                header.finishParsingHeader(streamInput);
            }
            Header header2 = header;
            return header2;
        }
    }

    private boolean isOnHeader() {
        return this.totalNetworkSize == -1;
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("Decoder is already closed");
        }
    }

    static IllegalStateException ensureVersionCompatibility(Version remoteVersion, Version currentVersion, boolean isHandshake) {
        Version compatibilityVersion = isHandshake ? currentVersion.minimumCompatibilityVersion() : currentVersion;
        if (!(currentVersion.onOrAfter(Version.V_2_0_0) && remoteVersion.equals((Object)Version.fromId((int)0x5CC5FF))) && !remoteVersion.isCompatible(compatibilityVersion)) {
            Version minCompatibilityVersion = isHandshake ? compatibilityVersion : compatibilityVersion.minimumCompatibilityVersion();
            String msg = "Received " + (isHandshake ? "handshake " : "") + "message from unsupported version: [";
            return new IllegalStateException(msg + remoteVersion + "] minimal compatible version is: [" + minCompatibilityVersion + "]");
        }
        return null;
    }
}

