/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache.common.tier;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;

public class TieredSpilloverCacheSettings {
    public static final Setting.AffixSetting<String> TIERED_SPILLOVER_ONHEAP_STORE_NAME = Setting.suffixKeySetting((String)"tiered_spillover.onheap.store.name", key -> Setting.simpleString((String)key, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<String> TIERED_SPILLOVER_DISK_STORE_NAME = Setting.suffixKeySetting((String)"tiered_spillover.disk.store.name", key -> Setting.simpleString((String)key, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Boolean> TIERED_SPILLOVER_DISK_CACHE_SETTING = Setting.suffixKeySetting((String)"tiered_spillover.disk.store.enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
    private static final Setting.AffixSetting<TimeValue> TIERED_SPILLOVER_DISK_TOOK_TIME_THRESHOLD = Setting.suffixKeySetting((String)"tiered_spillover.disk.store.policies.took_time.threshold", key -> Setting.timeSetting((String)key, (TimeValue)new TimeValue(10L, TimeUnit.MILLISECONDS), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
    public static final Map<CacheType, Setting<TimeValue>> TOOK_TIME_POLICY_CONCRETE_SETTINGS_MAP;
    public static final Map<CacheType, Setting<Boolean>> DISK_CACHE_ENABLED_SETTING_MAP;

    TieredSpilloverCacheSettings() {
    }

    static {
        HashMap<CacheType, Setting<TimeValue>> concreteTookTimePolicySettingMap = new HashMap<CacheType, Setting<TimeValue>>();
        HashMap<CacheType, Setting<Boolean>> diskCacheSettingMap = new HashMap<CacheType, Setting<Boolean>>();
        for (CacheType cacheType : CacheType.values()) {
            concreteTookTimePolicySettingMap.put(cacheType, (Setting<TimeValue>)TIERED_SPILLOVER_DISK_TOOK_TIME_THRESHOLD.getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
            diskCacheSettingMap.put(cacheType, (Setting<Boolean>)TIERED_SPILLOVER_DISK_CACHE_SETTING.getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
        }
        TOOK_TIME_POLICY_CONCRETE_SETTINGS_MAP = concreteTookTimePolicySettingMap;
        DISK_CACHE_ENABLED_SETTING_MAP = diskCacheSettingMap;
    }
}

